/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigRational;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.Element;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ANumGenPolynomialTest
extends TestCase {
    GenPolynomialRing<AlgebraicNumber<BigRational>> fac;
    AlgebraicNumberRing<BigRational> cfac;
    GenPolynomial<AlgebraicNumber<BigRational>> a;
    GenPolynomial<AlgebraicNumber<BigRational>> b;
    GenPolynomial<AlgebraicNumber<BigRational>> c;
    GenPolynomial<AlgebraicNumber<BigRational>> d;
    GenPolynomial<AlgebraicNumber<BigRational>> e;
    int rl = 3;
    int kl = 10;
    int ll = 5;
    int el = 5;
    float q = 0.5f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ANumGenPolynomialTest.suite());
    }

    public ANumGenPolynomialTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ANumGenPolynomialTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        BigRational bigRational = new BigRational(1L);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 1);
        GenPolynomial<Element> genPolynomial = genPolynomialRing.random(3);
        while (genPolynomial.isZERO() || genPolynomial.isUnit() || genPolynomial.isConstant()) {
            genPolynomial = genPolynomialRing.random(3);
        }
        genPolynomial = genPolynomial.sum(genPolynomialRing.fromInteger(3L));
        this.cfac = new AlgebraicNumberRing<Element>(genPolynomial.monic());
        this.fac = new GenPolynomialRing<BigRational>(this.cfac, this.rl);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        ANumGenPolynomialTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        ANumGenPolynomialTest.assertTrue((String)("isZERO( c )c" + this.c), (!this.c.isZERO() ? 1 : 0) != 0);
        ANumGenPolynomialTest.assertTrue((String)("isONE( c ) " + this.c), (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        ANumGenPolynomialTest.assertTrue((String)"length( d ) = 0", (this.d.length() == 0 ? 1 : 0) != 0);
        ANumGenPolynomialTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        ANumGenPolynomialTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        for (int i = 0; i < 7; ++i) {
            this.a = this.fac.random(this.ll + i);
            ANumGenPolynomialTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            ANumGenPolynomialTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            ANumGenPolynomialTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.a.sum((AlgebraicNumber<BigRational>)((Object)this.b));
        this.d = this.c.subtract((AlgebraicNumber<BigRational>)((Object)this.b));
        ANumGenPolynomialTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.fac.random(this.ll);
        ExpVector expVector = ExpVector.random(this.rl, this.el, this.q);
        Element element = this.cfac.random(this.kl);
        this.b = new GenPolynomial<Element>(this.fac, element, expVector);
        this.c = this.a.sum((AlgebraicNumber<BigRational>)((Object)this.b));
        this.d = this.a.sum((AlgebraicNumber<BigRational>)element, expVector);
        ANumGenPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = this.a.subtract((AlgebraicNumber<BigRational>)((Object)this.b));
        this.d = this.a.subtract((AlgebraicNumber<BigRational>)element, expVector);
        ANumGenPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.a = new GenPolynomial<AlgebraicNumber<BigRational>>(this.fac);
        this.b = new GenPolynomial<Element>(this.fac, element, expVector);
        this.c = this.b.sum((AlgebraicNumber<BigRational>)((Object)this.a));
        this.d = this.a.sum((AlgebraicNumber<BigRational>)element, expVector);
        ANumGenPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = this.a.subtract((AlgebraicNumber<BigRational>)((Object)this.b));
        this.d = this.a.subtract((AlgebraicNumber<BigRational>)element, expVector);
        ANumGenPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.c = this.fac.random(this.ll);
        this.d = this.c.sum((AlgebraicNumber<BigRational>)((Object)this.a.sum((AlgebraicNumber<BigRational>)((Object)this.b))));
        this.e = this.c.sum((AlgebraicNumber<BigRational>)((Object)this.a)).sum(this.b);
        ANumGenPolynomialTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
        this.c = this.a.sum((AlgebraicNumber<BigRational>)this.fac.getZERO());
        this.d = this.a.subtract((AlgebraicNumber<BigRational>)this.fac.getZERO());
        ANumGenPolynomialTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((GenPolynomial)this.fac.getZERO()).sum(this.a);
        this.d = ((GenPolynomial)this.fac.getZERO()).subtract(this.a.negate());
        ANumGenPolynomialTest.assertEquals((String)"0+a = 0+(-a)", this.c, this.d);
    }

    public void testMultiplication() {
        MonoidElem monoidElem;
        this.a = this.fac.random(this.ll);
        ANumGenPolynomialTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.ll);
        ANumGenPolynomialTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply((AlgebraicNumber<BigRational>)((Object)this.a));
        this.d = this.a.multiply((AlgebraicNumber<BigRational>)((Object)this.b));
        ANumGenPolynomialTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        ANumGenPolynomialTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract((AlgebraicNumber<BigRational>)((Object)this.c));
        ANumGenPolynomialTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        ANumGenPolynomialTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        ANumGenPolynomialTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply((AlgebraicNumber<BigRational>)((Object)this.b.multiply((AlgebraicNumber<BigRational>)((Object)this.c))));
        this.e = this.a.multiply((AlgebraicNumber<BigRational>)((Object)this.b)).multiply(this.c);
        ANumGenPolynomialTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        ANumGenPolynomialTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        AlgebraicNumber<BigRational> algebraicNumber = this.a.leadingBaseCoefficient();
        if (algebraicNumber.isUnit()) {
            monoidElem = algebraicNumber.inverse();
            this.c = this.a.monic();
            this.d = this.a.multiply((AlgebraicNumber<BigRational>)monoidElem);
            ANumGenPolynomialTest.assertEquals((String)"a.monic() = a(1/ldcf(a))", this.c, this.d);
        }
        if ((monoidElem = this.b.leadingBaseCoefficient()).isUnit()) {
            monoidElem = monoidElem.inverse();
            this.c = this.b.monic();
            this.d = this.b.multiply((AlgebraicNumber<BigRational>)monoidElem);
            ANumGenPolynomialTest.assertEquals((String)"b.monic() = b(1/ldcf(b))", this.c, this.d);
            this.e = new GenPolynomial<AlgebraicNumber<BigRational>>(this.fac, (AlgebraicNumber<BigRational>)monoidElem);
            this.d = this.b.multiply((AlgebraicNumber<BigRational>)((Object)this.e));
            ANumGenPolynomialTest.assertEquals((String)"b.monic() = b(1/ldcf(b))", this.c, this.d);
            this.d = this.e.multiply((AlgebraicNumber<BigRational>)((Object)this.b));
            ANumGenPolynomialTest.assertEquals((String)"b.monic() = (1/ldcf(b))*b", this.c, this.d);
        }
    }

    public void testDistributive() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply((AlgebraicNumber<BigRational>)((Object)this.b.sum((AlgebraicNumber<BigRational>)((Object)this.c))));
        this.e = this.a.multiply((AlgebraicNumber<BigRational>)((Object)this.b)).sum((GenPolynomial<AlgebraicNumber<BigRational>>)this.a.multiply((AlgebraicNumber<BigRational>)((Object)this.c)));
        ANumGenPolynomialTest.assertEquals((String)"a(b+c) = ab+ac", this.d, this.e);
    }

    public void testQuotRem1() {
        this.fac = new GenPolynomialRing<BigRational>(this.cfac, 1);
        this.a = this.fac.random(2);
        if (this.a.isZERO()) {
            return;
        }
        ANumGenPolynomialTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(2);
        if (this.b.isZERO()) {
            return;
        }
        ANumGenPolynomialTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        GenPolynomial genPolynomial = ((GenPolynomial)this.fac.random(1)).monic();
        if (genPolynomial.isZERO()) {
            return;
        }
        ANumGenPolynomialTest.assertTrue((String)"not isZERO( g )", (!genPolynomial.isZERO() ? 1 : 0) != 0);
        this.a = this.a.multiply((AlgebraicNumber<BigRational>)((Object)genPolynomial));
        this.b = this.b.multiply((AlgebraicNumber<BigRational>)((Object)genPolynomial));
        GenPolynomial<AlgebraicNumber<BigRational>>[] genPolynomialArray = this.b.quotientRemainder(this.a);
        this.c = genPolynomialArray[0];
        this.d = genPolynomialArray[1];
        this.e = this.c.multiply((AlgebraicNumber<BigRational>)((Object)this.a)).sum(this.d);
        ANumGenPolynomialTest.assertEquals((String)"b = q a + r", this.b, this.e);
        genPolynomialArray = this.a.quotientRemainder(this.b);
        this.c = genPolynomialArray[0];
        this.d = genPolynomialArray[1];
        this.e = this.c.multiply((AlgebraicNumber<BigRational>)((Object)this.b)).sum(this.d);
        ANumGenPolynomialTest.assertEquals((String)"a = q b + r", this.a, this.e);
        this.c = this.a.gcd(this.b);
        ANumGenPolynomialTest.assertTrue((String)"a mod gcd(a,b) = 0", (boolean)this.a.remainder(this.c).isZERO());
        ANumGenPolynomialTest.assertTrue((String)"b mod gcd(a,b) = 0", (boolean)this.b.remainder(this.c).isZERO());
        GenPolynomial<AlgebraicNumber<BigRational>>[] genPolynomialArray2 = this.a.egcd(this.b);
        this.c = genPolynomialArray2[0];
        this.d = genPolynomialArray2[1];
        this.e = genPolynomialArray2[2];
        ANumGenPolynomialTest.assertTrue((String)"a mod gcd(a,b) = 0", (boolean)this.a.remainder(this.c).isZERO());
        ANumGenPolynomialTest.assertTrue((String)"b mod gcd(a,b) = 0", (boolean)this.b.remainder(this.c).isZERO());
        GenPolynomial<RingElem<GenPolynomial<AlgebraicNumber<BigRational>>>> genPolynomial2 = this.a.multiply((AlgebraicNumber<BigRational>)((Object)this.d)).sum((GenPolynomial<AlgebraicNumber<BigRational>>)this.b.multiply((AlgebraicNumber<BigRational>)((Object)this.e))).monic();
        ANumGenPolynomialTest.assertEquals((String)"gcd(a,b) = a s + b t", this.c, genPolynomial2);
        if (this.a.isZERO() || this.b.isZERO()) {
            return;
        }
        try {
            this.c = this.a.modInverse(this.b);
            genPolynomial2 = this.c.multiply((AlgebraicNumber<BigRational>)((Object)this.a)).remainder((GenPolynomial<GenPolynomial<AlgebraicNumber<BigRational>>>)this.b).monic();
            ANumGenPolynomialTest.assertTrue((String)("a invertible mod b " + genPolynomial2), (boolean)genPolynomial2.isUnit());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

