/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.StringUtil;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComplexRing<C extends RingElem<C>>
implements RingFactory<Complex<C>> {
    private static final Random random = new Random();
    private static final Logger logger = LogManager.getLogger(ComplexRing.class);
    public final RingFactory<C> ring;

    public ComplexRing(RingFactory<C> ringFactory) {
        this.ring = ringFactory;
    }

    @Override
    public List<Complex<C>> generators() {
        List list = this.ring.generators();
        ArrayList<Complex<C>> arrayList = new ArrayList<Complex<C>>(list.size() + 1);
        for (RingElem ringElem : list) {
            Complex<RingElem> complex = new Complex<RingElem>(this, ringElem);
            arrayList.add(complex);
        }
        arrayList.add(this.getIMAG());
        return arrayList;
    }

    public AlgebraicNumberRing<C> algebraicRing() {
        GenPolynomialRing<C> genPolynomialRing = new GenPolynomialRing<C>(this.ring, 1, new TermOrder(2), new String[]{"I"});
        GenPolynomial<MonoidElem> genPolynomial = genPolynomialRing.univariate(0, 2L).sum(genPolynomialRing.getONE());
        AlgebraicNumberRing<MonoidElem> algebraicNumberRing = new AlgebraicNumberRing<MonoidElem>(genPolynomial, this.ring.isField());
        return algebraicNumberRing;
    }

    @Override
    public boolean isFinite() {
        return this.ring.isFinite();
    }

    @Override
    public Complex<C> copy(Complex<C> complex) {
        return new Complex(this, complex.re, complex.im);
    }

    @Override
    public Complex<C> getZERO() {
        return new Complex(this);
    }

    @Override
    public Complex<C> getONE() {
        return new Complex<RingElem>(this, (RingElem)this.ring.getONE());
    }

    public Complex<C> getIMAG() {
        return new Complex<RingElem>(this, (RingElem)this.ring.getZERO(), (RingElem)this.ring.getONE());
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.ring.isAssociative();
    }

    @Override
    public boolean isField() {
        return this.ring.isField();
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    @Override
    public Complex<C> fromInteger(BigInteger bigInteger) {
        return new Complex<RingElem>(this, (RingElem)this.ring.fromInteger(bigInteger));
    }

    @Override
    public Complex<C> fromInteger(long l) {
        return new Complex<RingElem>(this, (RingElem)this.ring.fromInteger(l));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Complex[");
        if (this.ring instanceof RingElem) {
            RingElem ringElem = (RingElem)((Object)this.ring);
            stringBuffer.append(ringElem.toScriptFactory());
        } else {
            stringBuffer.append(this.ring.toString());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CR(");
        if (this.ring instanceof RingElem) {
            RingElem ringElem = (RingElem)((Object)this.ring);
            stringBuffer.append(ringElem.toScriptFactory());
        } else {
            stringBuffer.append(this.ring.toScript());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ComplexRing)) {
            return false;
        }
        ComplexRing complexRing = (ComplexRing)object;
        return this.ring.equals(complexRing.ring);
    }

    public int hashCode() {
        return this.ring.hashCode();
    }

    @Override
    public Complex<C> random(int n) {
        return this.random(n, random);
    }

    @Override
    public Complex<C> random(int n, Random random) {
        RingElem ringElem = (RingElem)this.ring.random(n, random);
        RingElem ringElem2 = (RingElem)this.ring.random(n, random);
        return new Complex<RingElem>(this, ringElem, ringElem2);
    }

    @Override
    public Complex<C> parse(String string) {
        return new Complex(this, string);
    }

    @Override
    public Complex<C> parse(Reader reader) {
        return this.parse(StringUtil.nextString(reader));
    }
}

