/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.PrettyPrint;
import edu.jas.kern.Scripting;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.poly.RelationGenerator;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.poly.TermOrderOptimization;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GenSolvablePolynomialRing<C extends RingElem<C>>
extends GenPolynomialRing<C> {
    public final RelationTable<C> table;
    public final GenSolvablePolynomial<C> ZERO;
    public final GenSolvablePolynomial<C> ONE;
    private static final Logger logger = LogManager.getLogger(GenSolvablePolynomialRing.class);
    private static final boolean debug = logger.isDebugEnabled();

    public GenSolvablePolynomialRing(RingFactory<C> ringFactory, int n) {
        this(ringFactory, n, new TermOrder(), null, null);
    }

    public GenSolvablePolynomialRing(RingFactory<C> ringFactory, int n, RelationTable<C> relationTable) {
        this(ringFactory, n, new TermOrder(), null, relationTable);
    }

    public GenSolvablePolynomialRing(RingFactory<C> ringFactory, int n, TermOrder termOrder) {
        this(ringFactory, n, termOrder, null, null);
    }

    public GenSolvablePolynomialRing(RingFactory<C> ringFactory, int n, TermOrder termOrder, RelationTable<C> relationTable) {
        this(ringFactory, n, termOrder, null, relationTable);
    }

    public GenSolvablePolynomialRing(RingFactory<C> ringFactory, int n, TermOrder termOrder, String[] stringArray) {
        this(ringFactory, n, termOrder, stringArray, null);
    }

    public GenSolvablePolynomialRing(RingFactory<C> ringFactory, TermOrder termOrder, String[] stringArray) {
        this(ringFactory, stringArray.length, termOrder, stringArray, null);
    }

    public GenSolvablePolynomialRing(RingFactory<C> ringFactory, String[] stringArray) {
        this(ringFactory, stringArray.length, new TermOrder(), stringArray, null);
    }

    public GenSolvablePolynomialRing(RingFactory<C> ringFactory, int n, TermOrder termOrder, String[] stringArray, RelationTable<C> relationTable) {
        super(ringFactory, n, termOrder, stringArray);
        this.table = relationTable == null ? new RelationTable(this) : relationTable;
        this.ZERO = new GenSolvablePolynomial(this);
        RingElem ringElem = (RingElem)this.coFac.getONE();
        this.ONE = new GenSolvablePolynomial<RingElem>(this, ringElem, this.evzero);
    }

    public GenSolvablePolynomialRing(RingFactory<C> ringFactory, GenPolynomialRing genPolynomialRing) {
        this(ringFactory, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.getVars(), null);
    }

    public void addRelations(RelationGenerator<C> relationGenerator) {
        relationGenerator.generate(this);
    }

    public void addRelations(List<GenPolynomial<C>> list) {
        this.table.addRelations(list);
    }

    public void addSolvRelations(List<GenSolvablePolynomial<C>> list) {
        this.table.addSolvRelations(list);
    }

    @Override
    public String toString() {
        String string = super.toString();
        string = PrettyPrint.isTrue() ? string + "\n" + this.table.toString(this.vars) : string + ", #rel = " + this.table.size();
        return string;
    }

    @Override
    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (Scripting.getLang()) {
            case Ruby: {
                stringBuffer.append("SolvPolyRing.new(");
                break;
            }
            default: {
                stringBuffer.append("SolvPolyRing(");
            }
        }
        if (this.coFac instanceof RingElem) {
            stringBuffer.append(((RingElem)((Object)this.coFac)).toScriptFactory());
        } else {
            stringBuffer.append(this.coFac.toScript().trim());
        }
        stringBuffer.append(",\"" + this.varsToString() + "\",");
        String string = this.tord.toScript();
        stringBuffer.append(string);
        if (this.table.size() > 0) {
            String string2 = this.table.toScript();
            stringBuffer.append(",rel=");
            stringBuffer.append(string2);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof GenSolvablePolynomialRing)) {
            return false;
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = (GenSolvablePolynomialRing)object;
        if (!super.equals(object)) {
            return false;
        }
        return this.table.equals(genSolvablePolynomialRing.table);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 37 * n + this.table.hashCode();
        return n;
    }

    @Override
    public GenSolvablePolynomial<C> getZERO() {
        return this.ZERO;
    }

    @Override
    public GenSolvablePolynomial<C> getONE() {
        return this.ONE;
    }

    @Override
    public boolean isCommutative() {
        if (this.table.isEmpty()) {
            return super.isCommutative();
        }
        return false;
    }

    @Override
    public boolean isAssociative() {
        for (int i = 0; i < this.nvar; ++i) {
            GenPolynomial genPolynomial = this.univariate(i);
            for (int j = i + 1; j < this.nvar; ++j) {
                GenPolynomial genPolynomial2 = this.univariate(j);
                for (int k = j + 1; k < this.nvar; ++k) {
                    GenSolvablePolynomial<GenSolvablePolynomial<GenPolynomial>> genSolvablePolynomial;
                    GenPolynomial genPolynomial3 = this.univariate(k);
                    GenSolvablePolynomial<GenPolynomial> genSolvablePolynomial2 = ((GenSolvablePolynomial)genPolynomial3).multiply(genPolynomial2).multiply(genPolynomial);
                    if (genSolvablePolynomial2.equals(genSolvablePolynomial = ((GenSolvablePolynomial)genPolynomial3).multiply(((GenSolvablePolynomial)genPolynomial2).multiply(genPolynomial)))) continue;
                    logger.info("Xi = " + genPolynomial + ", Xj = " + genPolynomial2 + ", Xk = " + genPolynomial3);
                    logger.info("p = ( Xk * Xj ) * Xi = " + genSolvablePolynomial2);
                    logger.info("q = Xk * ( Xj * Xi ) = " + genSolvablePolynomial);
                    return false;
                }
            }
        }
        return this.coFac.isAssociative();
    }

    @Override
    public GenSolvablePolynomial<C> valueOf(C c) {
        return new GenSolvablePolynomial<C>(this, c);
    }

    @Override
    public GenSolvablePolynomial<C> valueOf(ExpVector expVector) {
        return new GenSolvablePolynomial<RingElem>(this, (RingElem)this.coFac.getONE(), expVector);
    }

    @Override
    public GenSolvablePolynomial<C> valueOf(C c, ExpVector expVector) {
        return new GenSolvablePolynomial<C>(this, c, expVector);
    }

    @Override
    public GenSolvablePolynomial<C> fromInteger(long l) {
        return new GenSolvablePolynomial<RingElem>(this, (RingElem)this.coFac.fromInteger(l), this.evzero);
    }

    @Override
    public GenSolvablePolynomial<C> fromInteger(BigInteger bigInteger) {
        return new GenSolvablePolynomial<RingElem>(this, (RingElem)this.coFac.fromInteger(bigInteger), this.evzero);
    }

    @Override
    public GenSolvablePolynomial<C> random(int n) {
        return this.random(n, random);
    }

    @Override
    public GenSolvablePolynomial<C> random(int n, Random random) {
        if (this.nvar == 1) {
            return this.random(5, n, n, 0.7f, random);
        }
        return this.random(5, n, 3, 0.3f, random);
    }

    @Override
    public GenSolvablePolynomial<C> random(int n, int n2, int n3, float f) {
        return this.random(n, n2, n3, f, random);
    }

    @Override
    public GenSolvablePolynomial<C> random(int n, int n2, int n3, float f, Random random) {
        GenPolynomial genPolynomial = this.getZERO();
        for (int i = 0; i < n2; ++i) {
            ExpVector expVector = ExpVector.random(this.nvar, n3, f, random);
            RingElem ringElem = (RingElem)this.coFac.random(n, random);
            genPolynomial = (GenSolvablePolynomial)genPolynomial.sum(ringElem, expVector);
        }
        return genPolynomial;
    }

    @Override
    public GenSolvablePolynomial<C> copy(GenSolvablePolynomial<C> genSolvablePolynomial) {
        return new GenSolvablePolynomial(this, genSolvablePolynomial.val);
    }

    @Override
    public GenSolvablePolynomial<C> parse(String string) {
        return this.parse(new StringReader(string));
    }

    @Override
    public GenSolvablePolynomial<C> parse(Reader reader) {
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(this, reader);
        GenSolvablePolynomial<C> genSolvablePolynomial = null;
        try {
            genSolvablePolynomial = genPolynomialTokenizer.nextSolvablePolynomial();
        }
        catch (IOException iOException) {
            logger.error(iOException.toString() + " parse " + this);
            genSolvablePolynomial = this.ZERO;
        }
        return genSolvablePolynomial;
    }

    @Override
    public GenSolvablePolynomial<C> univariate(int n) {
        return (GenSolvablePolynomial)super.univariate(n);
    }

    @Override
    public GenSolvablePolynomial<C> univariate(int n, long l) {
        return (GenSolvablePolynomial)super.univariate(n, l);
    }

    @Override
    public GenSolvablePolynomial<C> univariate(int n, int n2, long l) {
        return (GenSolvablePolynomial)super.univariate(n, n2, l);
    }

    @Override
    public List<? extends GenSolvablePolynomial<C>> univariateList() {
        return this.univariateList(0, 1L);
    }

    @Override
    public List<? extends GenSolvablePolynomial<C>> univariateList(int n) {
        return this.univariateList(n, 1L);
    }

    @Override
    public List<? extends GenSolvablePolynomial<C>> univariateList(int n, long l) {
        ArrayList<GenPolynomial> arrayList = new ArrayList<GenPolynomial>(this.nvar);
        int n2 = this.nvar - n;
        for (int i = 0; i < n2; ++i) {
            GenPolynomial genPolynomial = this.univariate(n, n2 - 1 - i, l);
            arrayList.add(genPolynomial);
        }
        return arrayList;
    }

    @Override
    public GenSolvablePolynomialRing<C> extend(int n) {
        return this.extend(n, false);
    }

    @Override
    public GenSolvablePolynomialRing<C> extend(int n, boolean bl) {
        GenPolynomialRing genPolynomialRing = super.extend(n, bl);
        GenSolvablePolynomialRing genSolvablePolynomialRing = new GenSolvablePolynomialRing(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.vars);
        genSolvablePolynomialRing.table.extend(this.table);
        return genSolvablePolynomialRing;
    }

    @Override
    public GenSolvablePolynomialRing<C> extend(String[] stringArray) {
        return this.extend(stringArray, false);
    }

    @Override
    public GenSolvablePolynomialRing<C> extend(String[] stringArray, boolean bl) {
        GenPolynomialRing genPolynomialRing = super.extend(stringArray, bl);
        GenSolvablePolynomialRing genSolvablePolynomialRing = new GenSolvablePolynomialRing(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.vars);
        genSolvablePolynomialRing.table.extend(this.table);
        return genSolvablePolynomialRing;
    }

    @Override
    public GenSolvablePolynomialRing<C> contract(int n) {
        GenPolynomialRing genPolynomialRing = super.contract(n);
        GenSolvablePolynomialRing genSolvablePolynomialRing = new GenSolvablePolynomialRing(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.vars);
        genSolvablePolynomialRing.table.contract(this.table);
        return genSolvablePolynomialRing;
    }

    @Override
    public GenSolvablePolynomialRing<C> reverse() {
        return this.reverse(false);
    }

    @Override
    public GenSolvablePolynomialRing<C> reverse(boolean bl) {
        GenPolynomialRing genPolynomialRing = super.reverse(bl);
        GenSolvablePolynomialRing genSolvablePolynomialRing = new GenSolvablePolynomialRing(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.vars);
        genSolvablePolynomialRing.partial = bl;
        genSolvablePolynomialRing.table.reverse(this.table);
        return genSolvablePolynomialRing;
    }

    @Override
    public GenSolvablePolynomialRing<GenPolynomial<C>> recursive(int n) {
        if (n <= 0 || n >= this.nvar) {
            throw new IllegalArgumentException("wrong: 0 < " + n + " < " + this.nvar);
        }
        GenPolynomialRing genPolynomialRing = this.contract(n);
        String[] stringArray = null;
        if (this.vars != null) {
            stringArray = new String[n];
            int n2 = 0;
            for (int i = this.nvar - n; i < this.nvar; ++i) {
                stringArray[n2++] = this.vars[i];
            }
        }
        TermOrder termOrder = this.tord.contract(0, n);
        RecSolvablePolynomialRing recSolvablePolynomialRing = new RecSolvablePolynomialRing(genPolynomialRing, n, termOrder, stringArray);
        recSolvablePolynomialRing.table.recursive(this.table);
        recSolvablePolynomialRing.coeffTable.recursive(this.table);
        return recSolvablePolynomialRing;
    }

    @Override
    public GenSolvablePolynomialRing<C> distribute() {
        List list;
        Iterable<GenPolynomial<C>> iterable;
        RingFactory ringFactory;
        if (!(this.coFac instanceof GenPolynomialRing)) {
            return this;
        }
        RingFactory ringFactory2 = ringFactory = this.coFac;
        GenPolynomialRing genPolynomialRing = (GenPolynomialRing)ringFactory2;
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.vars != null ? genPolynomialRing.extend(this.vars) : genPolynomialRing.extend(this.nvar);
        GenSolvablePolynomialRing genSolvablePolynomialRing = new GenSolvablePolynomialRing(genPolynomialRing2.coFac, genPolynomialRing2.nvar, this.tord, genPolynomialRing2.vars);
        if (genPolynomialRing2 instanceof GenSolvablePolynomialRing) {
            iterable = (GenSolvablePolynomialRing)genPolynomialRing2;
            list = iterable.table.relationList();
            genSolvablePolynomialRing.table.addSolvRelations(list);
        }
        iterable = PolynomialList.castToList(this.table.relationList());
        list = PolyUtil.distribute(genSolvablePolynomialRing, iterable);
        genSolvablePolynomialRing.table.addRelations(list);
        return genSolvablePolynomialRing;
    }

    @Override
    public GenPolynomialRing<C> permutation(List<Integer> list) {
        GenPolynomialRing genPolynomialRing = super.permutation(list);
        GenSolvablePolynomialRing genSolvablePolynomialRing = new GenSolvablePolynomialRing(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.vars);
        List<GenSolvablePolynomial<C>> list2 = this.table.relationList();
        PolynomialList polynomialList = new PolynomialList(genSolvablePolynomialRing, list2);
        List list3 = polynomialList.getList();
        list3 = TermOrderOptimization.permutation(list, genSolvablePolynomialRing, list3);
        genSolvablePolynomialRing.table.addRelations(list3);
        return genSolvablePolynomialRing;
    }
}

