/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.PrettyPrint;
import edu.jas.kern.Scripting;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.QLRSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPair;
import edu.jas.structure.QuotPairFactory;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QLRSolvablePolynomialRing<C extends GcdRingElem<C> & QuotPair<GenPolynomial<D>>, D extends GcdRingElem<D>>
extends GenSolvablePolynomialRing<C> {
    private static final Logger logger = LogManager.getLogger(QLRSolvablePolynomialRing.class);
    public final RecSolvablePolynomialRing<D> polCoeff;
    public final QLRSolvablePolynomial<C, D> ZERO;
    public final QLRSolvablePolynomial<C, D> ONE;
    public final QuotPairFactory<GenPolynomial<D>, C> qpfac;

    public QLRSolvablePolynomialRing(RingFactory<C> ringFactory, int n) {
        this(ringFactory, n, new TermOrder(), null, null);
    }

    public QLRSolvablePolynomialRing(RingFactory<C> ringFactory, int n, RelationTable<C> relationTable) {
        this(ringFactory, n, new TermOrder(), null, relationTable);
    }

    public QLRSolvablePolynomialRing(RingFactory<C> ringFactory, int n, TermOrder termOrder) {
        this(ringFactory, n, termOrder, null, null);
    }

    public QLRSolvablePolynomialRing(RingFactory<C> ringFactory, int n, TermOrder termOrder, RelationTable<C> relationTable) {
        this(ringFactory, n, termOrder, null, relationTable);
    }

    public QLRSolvablePolynomialRing(RingFactory<C> ringFactory, int n, TermOrder termOrder, String[] stringArray) {
        this(ringFactory, n, termOrder, stringArray, null);
    }

    public QLRSolvablePolynomialRing(RingFactory<C> ringFactory, TermOrder termOrder, String[] stringArray) {
        this(ringFactory, stringArray.length, termOrder, stringArray, null);
    }

    public QLRSolvablePolynomialRing(RingFactory<C> ringFactory, String[] stringArray) {
        this(ringFactory, stringArray.length, new TermOrder(), stringArray, null);
    }

    public QLRSolvablePolynomialRing(RingFactory<C> ringFactory, GenSolvablePolynomialRing genSolvablePolynomialRing) {
        this(ringFactory, genSolvablePolynomialRing.nvar, genSolvablePolynomialRing.tord, genSolvablePolynomialRing.getVars(), null);
    }

    public QLRSolvablePolynomialRing(RingFactory<C> ringFactory, QLRSolvablePolynomialRing qLRSolvablePolynomialRing) {
        this(ringFactory, (GenSolvablePolynomialRing)qLRSolvablePolynomialRing);
    }

    public QLRSolvablePolynomialRing(RingFactory<C> ringFactory, int n, TermOrder termOrder, String[] stringArray, RelationTable<C> relationTable) {
        super(ringFactory, n, termOrder, stringArray, relationTable);
        this.qpfac = (QuotPairFactory)((Object)ringFactory);
        RingFactory ringFactory2 = this.qpfac.pairFactory();
        this.polCoeff = new RecSolvablePolynomialRing(ringFactory2, n, termOrder, stringArray);
        if (this.table.size() > 0) {
            ExpVector expVector = null;
            ExpVector expVector2 = null;
            GenSolvablePolynomial genSolvablePolynomial = null;
            this.polCoeff.table.update(expVector, expVector2, genSolvablePolynomial);
            throw new RuntimeException("TODO");
        }
        this.ZERO = new QLRSolvablePolynomial(this);
        GcdRingElem gcdRingElem = (GcdRingElem)this.coFac.getONE();
        this.ONE = new QLRSolvablePolynomial(this, gcdRingElem, this.evzero);
    }

    @Override
    public String toString() {
        String string = super.toString();
        if (PrettyPrint.isTrue()) {
            string = string + "\n" + this.polCoeff.coeffTable.toString(this.vars);
            string = string + "\n" + this.polCoeff.table.toString(this.vars);
        } else {
            string = string + ", #rel = " + this.table.size() + " + " + this.polCoeff.coeffTable.size() + " + " + this.polCoeff.table.size();
        }
        return string;
    }

    @Override
    public String toScript() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        switch (Scripting.getLang()) {
            case Ruby: {
                stringBuffer.append("SolvPolyRing.new(");
                break;
            }
            default: {
                stringBuffer.append("SolvPolyRing(");
            }
        }
        if (this.coFac instanceof RingElem) {
            stringBuffer.append(((RingElem)((Object)this.coFac)).toScriptFactory());
        } else {
            stringBuffer.append(this.coFac.toScript().trim());
        }
        stringBuffer.append(",\"" + this.varsToString() + "\",");
        String string2 = this.tord.toScript();
        stringBuffer.append(string2);
        String string3 = "";
        if (this.table.size() > 0) {
            string3 = this.table.toScript();
            stringBuffer.append(",rel=");
            stringBuffer.append(string3);
        }
        if (this.polCoeff.coeffTable.size() > 0) {
            string = this.polCoeff.coeffTable.toScript();
            stringBuffer.append(",coeffrel=");
            stringBuffer.append(string);
        }
        if (this.polCoeff.table.size() > 0 && !string3.equals(string = this.polCoeff.table.toScript())) {
            stringBuffer.append(",polrel=");
            stringBuffer.append(string);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof QLRSolvablePolynomialRing)) {
            return false;
        }
        QLRSolvablePolynomialRing qLRSolvablePolynomialRing = null;
        try {
            qLRSolvablePolynomialRing = (QLRSolvablePolynomialRing)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (qLRSolvablePolynomialRing == null) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        return this.polCoeff.coeffTable.equals(qLRSolvablePolynomialRing.polCoeff.coeffTable);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 37 * n + this.table.hashCode();
        n = 37 * n + this.polCoeff.coeffTable.hashCode();
        return n;
    }

    @Override
    public QLRSolvablePolynomial<C, D> getZERO() {
        return this.ZERO;
    }

    @Override
    public QLRSolvablePolynomial<C, D> getONE() {
        return this.ONE;
    }

    @Override
    public boolean isCommutative() {
        if (this.polCoeff.isCommutative()) {
            return super.isCommutative();
        }
        return false;
    }

    @Override
    public boolean isAssociative() {
        if (!this.coFac.isAssociative()) {
            return false;
        }
        if (!this.polCoeff.isAssociative()) {
            return false;
        }
        List list = this.generators();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            GcdRingElem gcdRingElem;
            QLRSolvablePolynomial qLRSolvablePolynomial = (QLRSolvablePolynomial)list.get(i);
            if (qLRSolvablePolynomial.degree() == 0L && ((GenPolynomial)((QuotPair)((Object)(gcdRingElem = (GcdRingElem)qLRSolvablePolynomial.leadingBaseCoefficient()))).numerator()).degree() == 0L && ((GenPolynomial)((QuotPair)((Object)gcdRingElem)).denominator()).degree() == 0L) continue;
            for (int j = i + 1; j < n; ++j) {
                GcdRingElem gcdRingElem2;
                QLRSolvablePolynomial qLRSolvablePolynomial2 = (QLRSolvablePolynomial)list.get(j);
                if (qLRSolvablePolynomial2.degree() == 0L && ((GenPolynomial)((QuotPair)((Object)(gcdRingElem2 = (GcdRingElem)qLRSolvablePolynomial.leadingBaseCoefficient()))).numerator()).degree() == 0L && ((GenPolynomial)((QuotPair)((Object)gcdRingElem2)).denominator()).degree() == 0L) continue;
                for (int k = j + 1; k < n; ++k) {
                    QLRSolvablePolynomial qLRSolvablePolynomial3;
                    QLRSolvablePolynomial qLRSolvablePolynomial4;
                    QLRSolvablePolynomial qLRSolvablePolynomial5 = (QLRSolvablePolynomial)list.get(k);
                    if (qLRSolvablePolynomial.degree() == 0L && qLRSolvablePolynomial2.degree() == 0L && qLRSolvablePolynomial5.degree() == 0L) continue;
                    try {
                        qLRSolvablePolynomial4 = qLRSolvablePolynomial5.multiply(qLRSolvablePolynomial2).multiply(qLRSolvablePolynomial);
                        qLRSolvablePolynomial3 = qLRSolvablePolynomial5.multiply(qLRSolvablePolynomial2.multiply(qLRSolvablePolynomial));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        System.out.println("qlr assoc: Xi = " + qLRSolvablePolynomial);
                        System.out.println("qlr assoc: Xj = " + qLRSolvablePolynomial2);
                        System.out.println("qlr assoc: Xk = " + qLRSolvablePolynomial5);
                        illegalArgumentException.printStackTrace();
                        continue;
                    }
                    if (qLRSolvablePolynomial4.equals(qLRSolvablePolynomial3)) continue;
                    if (logger.isInfoEnabled()) {
                        logger.info("Xk = " + qLRSolvablePolynomial5 + ", Xj = " + qLRSolvablePolynomial2 + ", Xi = " + qLRSolvablePolynomial);
                        logger.info("p = ( Xk * Xj ) * Xi = " + qLRSolvablePolynomial4);
                        logger.info("q = Xk * ( Xj * Xi ) = " + qLRSolvablePolynomial3);
                        logger.info("q-p = " + qLRSolvablePolynomial4.subtract(qLRSolvablePolynomial3));
                    }
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public QLRSolvablePolynomial<C, D> fromInteger(long l) {
        return new QLRSolvablePolynomial(this, (GcdRingElem)this.coFac.fromInteger(l), this.evzero);
    }

    @Override
    public QLRSolvablePolynomial<C, D> fromInteger(BigInteger bigInteger) {
        return new QLRSolvablePolynomial(this, (GcdRingElem)this.coFac.fromInteger(bigInteger), this.evzero);
    }

    @Override
    public QLRSolvablePolynomial<C, D> random(int n) {
        return this.random(n, random);
    }

    @Override
    public QLRSolvablePolynomial<C, D> random(int n, Random random) {
        if (this.nvar == 1) {
            return this.random(5, n, n, 0.7f, random);
        }
        return this.random(5, n, 3, 0.3f, random);
    }

    @Override
    public QLRSolvablePolynomial<C, D> random(int n, int n2, int n3, float f) {
        return this.random(n, n2, n3, f, random);
    }

    @Override
    public QLRSolvablePolynomial<C, D> random(int n, int n2, int n3, float f, Random random) {
        GenSolvablePolynomial genSolvablePolynomial = this.getZERO();
        for (int i = 0; i < n2; ++i) {
            ExpVector expVector = ExpVector.random(this.nvar, n3, f, random);
            GcdRingElem gcdRingElem = (GcdRingElem)this.coFac.random(n, random);
            genSolvablePolynomial = (QLRSolvablePolynomial)genSolvablePolynomial.sum(gcdRingElem, expVector);
        }
        return genSolvablePolynomial;
    }

    @Override
    public QLRSolvablePolynomial<C, D> copy(QLRSolvablePolynomial<C, D> qLRSolvablePolynomial) {
        return new QLRSolvablePolynomial(this, qLRSolvablePolynomial.getMap());
    }

    @Override
    public QLRSolvablePolynomial<C, D> parse(String string) {
        return this.parse(new StringReader(string));
    }

    @Override
    public QLRSolvablePolynomial<C, D> parse(Reader reader) {
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(this, reader);
        QLRSolvablePolynomial qLRSolvablePolynomial = null;
        try {
            GenSolvablePolynomial genSolvablePolynomial = genPolynomialTokenizer.nextSolvablePolynomial();
            qLRSolvablePolynomial = new QLRSolvablePolynomial(this, genSolvablePolynomial);
        }
        catch (IOException iOException) {
            logger.error(iOException.toString() + " parse " + this);
            qLRSolvablePolynomial = this.ZERO;
        }
        return qLRSolvablePolynomial;
    }

    @Override
    public QLRSolvablePolynomial<C, D> univariate(int n) {
        return (QLRSolvablePolynomial)super.univariate(n);
    }

    @Override
    public QLRSolvablePolynomial<C, D> univariate(int n, long l) {
        return (QLRSolvablePolynomial)super.univariate(n, l);
    }

    @Override
    public QLRSolvablePolynomial<C, D> univariate(int n, int n2, long l) {
        return (QLRSolvablePolynomial)super.univariate(n, n2, l);
    }

    @Override
    public List<QLRSolvablePolynomial<C, D>> univariateList() {
        return this.univariateList(0, 1L);
    }

    @Override
    public List<QLRSolvablePolynomial<C, D>> univariateList(int n) {
        return this.univariateList(n, 1L);
    }

    @Override
    public List<QLRSolvablePolynomial<C, D>> univariateList(int n, long l) {
        ArrayList<QLRSolvablePolynomial<C, D>> arrayList = new ArrayList<QLRSolvablePolynomial<C, D>>(this.nvar);
        int n2 = this.nvar - n;
        for (int i = 0; i < n2; ++i) {
            GenSolvablePolynomial genSolvablePolynomial = this.univariate(n, n2 - 1 - i, l);
            arrayList.add((QLRSolvablePolynomial<C, D>)genSolvablePolynomial);
        }
        return arrayList;
    }

    @Override
    public QLRSolvablePolynomialRing<C, D> extend(int n) {
        return this.extend(n, false);
    }

    @Override
    public QLRSolvablePolynomialRing<C, D> extend(int n, boolean bl) {
        GenPolynomialRing genPolynomialRing = super.extend(n, bl);
        QLRSolvablePolynomialRing qLRSolvablePolynomialRing = new QLRSolvablePolynomialRing(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.getVars());
        qLRSolvablePolynomialRing.table.extend(this.table);
        qLRSolvablePolynomialRing.polCoeff.coeffTable.extend(this.polCoeff.coeffTable);
        return qLRSolvablePolynomialRing;
    }

    @Override
    public QLRSolvablePolynomialRing<C, D> extend(String[] stringArray) {
        return this.extend(stringArray, false);
    }

    @Override
    public QLRSolvablePolynomialRing<C, D> extend(String[] stringArray, boolean bl) {
        GenPolynomialRing genPolynomialRing = super.extend(stringArray, bl);
        QLRSolvablePolynomialRing qLRSolvablePolynomialRing = new QLRSolvablePolynomialRing(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.vars);
        qLRSolvablePolynomialRing.table.extend(this.table);
        qLRSolvablePolynomialRing.polCoeff.coeffTable.extend(this.polCoeff.coeffTable);
        return qLRSolvablePolynomialRing;
    }

    @Override
    public QLRSolvablePolynomialRing<C, D> contract(int n) {
        GenPolynomialRing genPolynomialRing = super.contract(n);
        QLRSolvablePolynomialRing qLRSolvablePolynomialRing = new QLRSolvablePolynomialRing(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.getVars());
        qLRSolvablePolynomialRing.table.contract(this.table);
        qLRSolvablePolynomialRing.polCoeff.coeffTable.contract(this.polCoeff.coeffTable);
        return qLRSolvablePolynomialRing;
    }

    @Override
    public QLRSolvablePolynomialRing<C, D> reverse() {
        return this.reverse(false);
    }

    @Override
    public QLRSolvablePolynomialRing<C, D> reverse(boolean bl) {
        GenPolynomialRing genPolynomialRing = super.reverse(bl);
        QLRSolvablePolynomialRing qLRSolvablePolynomialRing = new QLRSolvablePolynomialRing(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.getVars());
        qLRSolvablePolynomialRing.partial = bl;
        qLRSolvablePolynomialRing.table.reverse(this.table);
        qLRSolvablePolynomialRing.polCoeff.coeffTable.reverse(this.polCoeff.coeffTable);
        return qLRSolvablePolynomialRing;
    }

    public QLRSolvablePolynomial<C, D> fromPolyCoefficients(GenSolvablePolynomial<GenPolynomial<D>> genSolvablePolynomial) {
        GenSolvablePolynomial genSolvablePolynomial2 = ((QLRSolvablePolynomial)this.getZERO()).copy();
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial2;
        }
        for (Map.Entry entry : genSolvablePolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)entry.getValue();
            GcdRingElem gcdRingElem = (GcdRingElem)this.qpfac.create(genSolvablePolynomial3);
            if (gcdRingElem.isZERO()) continue;
            genSolvablePolynomial2.doPutToMap(expVector, gcdRingElem);
        }
        return genSolvablePolynomial2;
    }

    public RecSolvablePolynomial<D> toPolyCoefficients(QLRSolvablePolynomial<C, D> qLRSolvablePolynomial) {
        GenSolvablePolynomial genSolvablePolynomial = ((RecSolvablePolynomial)this.polCoeff.getZERO()).copy();
        if (qLRSolvablePolynomial == null || qLRSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        for (Map.Entry entry : qLRSolvablePolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            GcdRingElem gcdRingElem = (GcdRingElem)entry.getValue();
            if (!((GenPolynomial)((QuotPair)((Object)gcdRingElem)).denominator()).isONE()) {
                throw new IllegalArgumentException("den != 1 not supported: " + gcdRingElem);
            }
            GenPolynomial genPolynomial = (GenPolynomial)((QuotPair)((Object)gcdRingElem)).numerator();
            if (genPolynomial.isZERO()) continue;
            genSolvablePolynomial.doPutToMap(expVector, genPolynomial);
        }
        return genSolvablePolynomial;
    }

    public RecSolvablePolynomial<D> toPolyCoefficients(GenPolynomial<C> genPolynomial) {
        GenSolvablePolynomial genSolvablePolynomial = ((RecSolvablePolynomial)this.polCoeff.getZERO()).copy();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        for (Map.Entry<ExpVector, C> entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            GcdRingElem gcdRingElem = (GcdRingElem)entry.getValue();
            if (!((GenPolynomial)((QuotPair)((Object)gcdRingElem)).denominator()).isONE()) {
                throw new IllegalArgumentException("den != 1 not supported: " + gcdRingElem);
            }
            GenPolynomial genPolynomial2 = (GenPolynomial)((QuotPair)((Object)gcdRingElem)).numerator();
            if (genPolynomial2.isZERO()) continue;
            genSolvablePolynomial.doPutToMap(expVector, genPolynomial2);
        }
        return genSolvablePolynomial;
    }
}

