/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.root.ComplexAlgebraicNumber;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.root.RootFactory;
import edu.jas.root.RootUtil;
import edu.jas.structure.Power;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class RootUtilTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<BigRational> dfac;
    BigRational ai;
    BigRational bi;
    BigRational ci;
    BigRational di;
    BigRational ei;
    BigRational eps;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    int rl = 1;
    int kl = 3;
    int ll = 5;
    int el = 7;
    float q = 0.7f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)RootUtilTest.suite());
    }

    public RootUtilTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(RootUtilTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        String[] stringArray = new String[]{"x"};
        this.dfac = new GenPolynomialRing<BigRational>(new BigRational(1L), this.rl, this.to, stringArray);
        this.eps = Power.positivePower(new BigRational(1L, 10L), BigDecimal.DEFAULT_PRECISION);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.dfac = null;
        this.eps = null;
        ComputerThreads.terminate();
    }

    public void testSignVar() {
        int[] nArray = new int[]{1, 0, 0, -1, 2, 3, 0, 1, 0, 0, 0, -1};
        ArrayList<BigRational> arrayList = new ArrayList<BigRational>();
        this.ai = new BigRational();
        for (int i = 0; i < nArray.length; ++i) {
            this.bi = this.ai.fromInteger(nArray[i]);
            arrayList.add(this.bi);
        }
        long l = RootUtil.signVar(arrayList);
        RootUtilTest.assertEquals((String)"varSign(Li)", (long)l, (long)3L);
        ArrayList<BigRational> arrayList2 = new ArrayList<BigRational>();
        for (int i = 0; i < 7; ++i) {
            this.bi = this.ai.random(this.kl);
            arrayList2.add(this.bi);
        }
        long l2 = l = RootUtil.signVar(arrayList2);
        RootUtilTest.assertTrue((String)"varSign(Mi)>=0", (l >= 0L ? 1 : 0) != 0);
        ArrayList<BigRational> arrayList3 = new ArrayList<BigRational>(arrayList2);
        arrayList3.addAll(arrayList);
        l = RootUtil.signVar(arrayList3);
        RootUtilTest.assertTrue((String)"varSign(Mi)>=3", (l >= 3L + l2 ? 1 : 0) != 0);
        arrayList3 = new ArrayList(arrayList3);
        arrayList3.addAll(arrayList2);
        l = RootUtil.signVar(arrayList3);
        RootUtilTest.assertTrue((String)"varSign(Mi)>=3", (l >= 3L + l2 ? 1 : 0) != 0);
    }

    public void testRealAlgebraicFactory() {
        this.a = this.dfac.random(this.kl, this.ll * 2, this.el * 2, this.q);
        List<RealAlgebraicNumber<BigRational>> list = RootFactory.realAlgebraicNumbers(this.a);
        RootUtilTest.assertTrue((String)"#roots >= 0 ", (list != null ? 1 : 0) != 0);
        for (RealAlgebraicNumber<BigRational> realAlgebraicNumber : list) {
            RootUtilTest.assertTrue((String)("f(r) == 0: " + realAlgebraicNumber), (boolean)RootFactory.isRoot(this.a, realAlgebraicNumber));
        }
        list = RootFactory.realAlgebraicNumbersField(this.a);
        RootUtilTest.assertTrue((String)"#roots >= 0 ", (list != null ? 1 : 0) != 0);
        for (RealAlgebraicNumber<BigRational> realAlgebraicNumber : list) {
            RootUtilTest.assertTrue((String)("f(r) == 0: " + realAlgebraicNumber), (boolean)RootFactory.isRoot(this.a, realAlgebraicNumber));
        }
    }

    public void testComplexAlgebraicFactory() {
        this.a = this.dfac.random(this.kl, this.ll, this.el, this.q);
        ComplexRing<BigRational> complexRing = new ComplexRing<BigRational>(new BigRational());
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(complexRing, this.dfac);
        GenPolynomial genPolynomial = PolyUtil.toComplex(genPolynomialRing, this.a);
        List list = RootFactory.complexAlgebraicNumbersComplex(genPolynomial);
        RootUtilTest.assertTrue((String)("#roots == deg(a): " + this.a), ((long)list.size() == this.a.degree(0) ? 1 : 0) != 0);
        for (ComplexAlgebraicNumber complexAlgebraicNumber : list) {
            RootUtilTest.assertTrue((String)("f(r) == 0: " + complexAlgebraicNumber), (boolean)RootFactory.isRoot(this.a, complexAlgebraicNumber));
        }
    }

    public void testComplexRationalFactory() {
        this.a = this.dfac.random(this.kl, this.ll, this.el, this.q);
        List<ComplexAlgebraicNumber<BigRational>> list = RootFactory.complexAlgebraicNumbers(this.a);
        RootUtilTest.assertTrue((String)("#roots == deg(a): " + this.a), ((long)list.size() == this.a.degree(0) ? 1 : 0) != 0);
        for (ComplexAlgebraicNumber<BigRational> complexAlgebraicNumber : list) {
            RootUtilTest.assertTrue((String)("f(r) == 0: " + complexAlgebraicNumber), (boolean)RootFactory.isRoot(this.a, complexAlgebraicNumber));
        }
    }
}

