/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInt;
import edu.jas.arith.ModIntRing;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorAlgebraic;
import edu.jas.ufd.FactorComplex;
import edu.jas.ufd.FactorInteger;
import edu.jas.ufd.FactorModular;
import edu.jas.ufd.FactorQuotient;
import edu.jas.ufd.FactorRational;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FactorFactory {
    private static final Logger logger = LogManager.getLogger(FactorFactory.class);

    protected FactorFactory() {
    }

    public static FactorAbstract<ModInteger> getImplementation(ModIntegerRing modIntegerRing) {
        return new FactorModular<ModInteger>(modIntegerRing);
    }

    public static FactorAbstract<ModLong> getImplementation(ModLongRing modLongRing) {
        return new FactorModular<ModLong>(modLongRing);
    }

    public static FactorAbstract<ModInt> getImplementation(ModIntRing modIntRing) {
        return new FactorModular<ModInt>(modIntRing);
    }

    public static FactorAbstract<BigInteger> getImplementation(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("fac == null not supported");
        }
        return new FactorInteger();
    }

    public static FactorAbstract<BigRational> getImplementation(BigRational bigRational) {
        if (bigRational == null) {
            throw new IllegalArgumentException("fac == null not supported");
        }
        return new FactorRational();
    }

    public static <C extends GcdRingElem<C>> FactorAbstract<AlgebraicNumber<C>> getImplementation(AlgebraicNumberRing<C> algebraicNumberRing) {
        return new FactorAlgebraic<C>(algebraicNumberRing);
    }

    public static <C extends GcdRingElem<C>> FactorAbstract<Complex<C>> getImplementation(ComplexRing<C> complexRing) {
        return new FactorComplex<C>(complexRing);
    }

    public static <C extends GcdRingElem<C>> FactorAbstract<Quotient<C>> getImplementation(QuotientRing<C> quotientRing) {
        return new FactorQuotient<C>(quotientRing);
    }

    public static <C extends GcdRingElem<C>> FactorAbstract<C> getImplementation(GenPolynomialRing<C> genPolynomialRing) {
        return FactorFactory.getImplementation(genPolynomialRing.coFac);
    }

    public static <C extends GcdRingElem<C>> FactorAbstract<C> getImplementation(RingFactory<C> ringFactory) {
        logger.info("factor factory = " + ringFactory.getClass().getName());
        FactorAbstract factorAbstract = null;
        AlgebraicNumberRing algebraicNumberRing = null;
        ComplexRing complexRing = null;
        QuotientRing quotientRing = null;
        GenPolynomialRing genPolynomialRing = null;
        RingFactory<C> ringFactory2 = ringFactory;
        if (ringFactory2 instanceof BigInteger) {
            factorAbstract = new FactorInteger();
        } else if (ringFactory2 instanceof BigRational) {
            factorAbstract = new FactorRational();
        } else if (ringFactory2 instanceof ModIntegerRing) {
            factorAbstract = new FactorModular<C>(ringFactory);
        } else if (ringFactory2 instanceof ModLongRing) {
            factorAbstract = new FactorModular<C>(ringFactory);
        } else if (ringFactory2 instanceof ModIntRing) {
            factorAbstract = new FactorModular<C>(ringFactory);
        } else if (ringFactory2 instanceof ComplexRing) {
            complexRing = (ComplexRing)ringFactory2;
            factorAbstract = new FactorComplex(complexRing);
        } else if (ringFactory2 instanceof AlgebraicNumberRing) {
            algebraicNumberRing = (AlgebraicNumberRing)ringFactory2;
            factorAbstract = new FactorAlgebraic(algebraicNumberRing);
        } else if (ringFactory2 instanceof QuotientRing) {
            quotientRing = (QuotientRing)ringFactory2;
            factorAbstract = new FactorQuotient(quotientRing);
        } else if (ringFactory2 instanceof GenPolynomialRing) {
            genPolynomialRing = (GenPolynomialRing)ringFactory2;
            factorAbstract = FactorFactory.getImplementation(genPolynomialRing.coFac);
        } else {
            throw new IllegalArgumentException("no factorization implementation for " + ringFactory.getClass().getName());
        }
        return factorAbstract;
    }
}

