/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.Factors;
import java.io.Serializable;
import java.util.Map;
import java.util.SortedMap;

public class FactorsMap<C extends GcdRingElem<C>>
implements Serializable {
    public final GenPolynomial<C> poly;
    public final SortedMap<GenPolynomial<C>, Long> factors;
    public final SortedMap<Factors<C>, Long> afactors;

    public FactorsMap(GenPolynomial<C> genPolynomial, SortedMap<GenPolynomial<C>, Long> sortedMap) {
        this(genPolynomial, sortedMap, null);
    }

    public FactorsMap(GenPolynomial<C> genPolynomial, SortedMap<GenPolynomial<C>, Long> sortedMap, SortedMap<Factors<C>, Long> sortedMap2) {
        this.poly = genPolynomial;
        this.factors = sortedMap;
        this.afactors = sortedMap2;
    }

    public String toString() {
        Comparable<GenPolynomial<C>> comparable;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.poly.toString());
        stringBuffer.append(" =\n");
        boolean bl = true;
        for (Map.Entry<GenPolynomial<C>, Long> entry : this.factors.entrySet()) {
            comparable = entry.getKey();
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",\n ");
            }
            stringBuffer.append(((GenPolynomial)comparable).toString());
            long l = entry.getValue();
            if (l <= 1L) continue;
            stringBuffer.append("**" + l);
        }
        if (this.afactors == null) {
            return stringBuffer.toString();
        }
        for (Map.Entry<Comparable<GenPolynomial<C>>, Long> entry : this.afactors.entrySet()) {
            comparable = (Factors)entry.getKey();
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",\n ");
            }
            stringBuffer.append(((Factors)comparable).toString());
            Long l = entry.getValue();
            if (l == null || l <= 1L) continue;
            stringBuffer.append("**" + l);
        }
        return stringBuffer.toString();
    }

    public String toScript() {
        Comparable<GenPolynomial<C>> comparable;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (Map.Entry<GenPolynomial<C>, Long> entry : this.factors.entrySet()) {
            comparable = entry.getKey();
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("\n * ");
            }
            stringBuffer.append(((GenPolynomial)comparable).toScript());
            long l = entry.getValue();
            if (l <= 1L) continue;
            stringBuffer.append("**" + l);
        }
        if (this.afactors == null) {
            return stringBuffer.toString();
        }
        for (Map.Entry<Comparable<GenPolynomial<C>>, Long> entry : this.afactors.entrySet()) {
            comparable = (Factors)entry.getKey();
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("\n * ");
            }
            Long l = entry.getValue();
            if (l == null) {
                System.out.println("f = " + comparable);
                System.out.println("afactors = " + this.afactors);
                throw new RuntimeException("this should not happen");
            }
            if (l == 1L) {
                stringBuffer.append(((Factors)comparable).toScript());
                continue;
            }
            stringBuffer.append("(\n");
            stringBuffer.append(((Factors)comparable).toScript());
            stringBuffer.append("\n)**" + l);
        }
        return stringBuffer.toString();
    }

    public int length() {
        int n = this.factors.keySet().size();
        if (this.afactors == null) {
            return n;
        }
        for (Factors<C> factors : this.afactors.keySet()) {
            n += factors.length();
        }
        return n;
    }

    public AlgebraicNumberRing<C> findExtensionField() {
        if (this.afactors == null) {
            return null;
        }
        AlgebraicNumberRing<C> algebraicNumberRing = null;
        int n = 0;
        for (Factors<C> factors : this.afactors.keySet()) {
            int n2;
            AlgebraicNumberRing<C> algebraicNumberRing2 = factors.findExtensionField();
            if (algebraicNumberRing2 == null || (n2 = algebraicNumberRing2.depth()) <= n) continue;
            n = n2;
            algebraicNumberRing = algebraicNumberRing2;
        }
        return algebraicNumberRing;
    }
}

