/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.PrimeList;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.HenselMultUtil;
import edu.jas.ufd.NoLiftingException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class HenselMultUtilTest
extends TestCase {
    TermOrder tord = new TermOrder(2);
    GenPolynomialRing<BigInteger> dfac;
    GenPolynomialRing<BigInteger> cfac;
    GenPolynomialRing<GenPolynomial<BigInteger>> rfac;
    BigInteger ai;
    BigInteger bi;
    BigInteger ci;
    BigInteger di;
    BigInteger ei;
    GenPolynomial<BigInteger> a;
    GenPolynomial<BigInteger> b;
    GenPolynomial<BigInteger> c;
    GenPolynomial<BigInteger> d;
    GenPolynomial<BigInteger> e;
    int rl = 2;
    int kl = 5;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)HenselMultUtilTest.suite());
        ComputerThreads.terminate();
    }

    public HenselMultUtilTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(HenselMultUtilTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.tord);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl - 1, this.tord);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.tord);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
        ComputerThreads.terminate();
    }

    protected static java.math.BigInteger getPrime1() {
        return PrimeList.getLongPrime(60, 93);
    }

    protected static java.math.BigInteger getPrime2() {
        return PrimeList.getLongPrime(30, 35);
    }

    /*
     * Could not resolve type clashes
     */
    public void testHenselLiftingMonicList() {
        java.math.BigInteger bigInteger = new java.math.BigInteger("19");
        BigInteger bigInteger2 = new BigInteger(bigInteger);
        ModIntegerRing modIntegerRing = new ModIntegerRing(bigInteger, false);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 4, this.tord, new String[]{"w", "x", "y", "z"});
        BigInteger bigInteger3 = bigInteger2;
        long l = 5L;
        java.math.BigInteger bigInteger4 = bigInteger.pow((int)l);
        ModIntegerRing modIntegerRing2 = new ModIntegerRing(bigInteger4, false);
        GenPolynomialRing<ModInteger> genPolynomialRing2 = new GenPolynomialRing<ModInteger>(modIntegerRing2, genPolynomialRing);
        this.dfac = new GenPolynomialRing<BigInteger>(bigInteger3, genPolynomialRing);
        GreatestCommonDivisorAbstract<BigInteger> greatestCommonDivisorAbstract = GCDFactory.getImplementation(bigInteger3);
        ModInteger modInteger = modIntegerRing2.fromInteger(3L);
        ArrayList<BigInteger> arrayList = new ArrayList<BigInteger>(1);
        arrayList.add(new BigInteger(3L));
        if (genPolynomialRing2.nvar > 2) {
            arrayList.add(new BigInteger(5L));
        }
        if (genPolynomialRing2.nvar > 3) {
            arrayList.add(new BigInteger(7L));
        }
        List list = new ArrayList();
        for (int i = 1; i < 2; ++i) {
            GenPolynomial<ModInteger> genPolynomial;
            GenPolynomial genPolynomial22;
            Object object2;
            ArrayList arrayList22;
            this.a = this.dfac.parse(" ( z^2 + y^2 + 4 x^3 - x + 1 + w ) ");
            this.b = this.dfac.parse(" ( z + y + x^2 + 10 + w ) ");
            list.add(this.a);
            list.add(this.b);
            list = greatestCommonDivisorAbstract.coPrime(list);
            if (list.size() == 0) continue;
            this.c = list.get(0).multiply(list.get(1));
            GenPolynomial<ModInteger> genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, this.c);
            ArrayList<GenPolynomial<ModInteger>> arrayList3 = new ArrayList<GenPolynomial<ModInteger>>(list.size());
            for (ArrayList arrayList22 : list) {
                GenPolynomial<ModInteger> genPolynomial4 = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, arrayList22);
                arrayList3.add(genPolynomial4);
            }
            GenPolynomialRing genPolynomialRing3 = genPolynomialRing2.contract(1);
            modInteger = modIntegerRing2.fromInteger(((BigInteger)arrayList.get(2)).getVal());
            arrayList22 = new ArrayList(list.size());
            for (Object object2 : arrayList3) {
                genPolynomial22 = PolyUtil.evaluateMain(genPolynomialRing3, object2, modInteger);
                arrayList22.add(genPolynomial22);
            }
            genPolynomialRing3 = genPolynomialRing3.contract(1);
            modInteger = modIntegerRing2.fromInteger(((BigInteger)arrayList.get(1)).getVal());
            ArrayList arrayList4 = new ArrayList(list.size());
            for (GenPolynomial genPolynomial22 : arrayList22) {
                genPolynomial = PolyUtil.evaluateMain(genPolynomialRing3, genPolynomial22, modInteger);
                arrayList4.add(genPolynomial);
            }
            arrayList22 = arrayList4;
            genPolynomialRing3 = genPolynomialRing3.contract(1);
            modInteger = modIntegerRing2.fromInteger(((BigInteger)arrayList.get(0)).getVal());
            arrayList4 = new ArrayList(list.size());
            object2 = arrayList22.iterator();
            while (object2.hasNext()) {
                genPolynomial22 = (GenPolynomial)object2.next();
                genPolynomial = PolyUtil.evaluateMain(genPolynomialRing3, genPolynomial22, modInteger);
                arrayList4.add(genPolynomial);
            }
            arrayList22 = arrayList4;
            try {
                object2 = HenselMultUtil.liftHenselMonic(this.c, genPolynomial3, arrayList22, arrayList, l);
                boolean bl = HenselMultUtil.isHenselLift(this.c, genPolynomial3, arrayList22, object2);
                HenselMultUtilTest.assertTrue((String)"isHenselLift: ", (boolean)bl);
                continue;
            }
            catch (ArithmeticException arithmeticException) {
                continue;
            }
            catch (NoLiftingException noLiftingException) {
                System.out.println("e = " + noLiftingException);
            }
        }
    }

    public void testHenselLifting2List() {
        java.math.BigInteger bigInteger = new java.math.BigInteger("19");
        BigInteger bigInteger2 = new BigInteger(bigInteger);
        ModIntegerRing modIntegerRing = new ModIntegerRing(bigInteger, false);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 2, this.tord, new String[]{"x", "y"});
        GenPolynomialRing<BigInteger> genPolynomialRing2 = new GenPolynomialRing<BigInteger>(new BigInteger(), genPolynomialRing);
        GenPolynomialRing genPolynomialRing3 = genPolynomialRing2.recursive(genPolynomialRing2.nvar - 1);
        BigInteger bigInteger3 = bigInteger2;
        long l = 5L;
        java.math.BigInteger bigInteger4 = bigInteger.pow((int)l);
        ModIntegerRing modIntegerRing2 = new ModIntegerRing(bigInteger4, false);
        GenPolynomialRing<ModInteger> genPolynomialRing4 = new GenPolynomialRing<ModInteger>(modIntegerRing2, genPolynomialRing);
        this.dfac = new GenPolynomialRing<BigInteger>(bigInteger3, genPolynomialRing);
        GreatestCommonDivisorAbstract<BigInteger> greatestCommonDivisorAbstract = GCDFactory.getImplementation(bigInteger3);
        ModInteger modInteger = modIntegerRing2.fromInteger(3L);
        ArrayList<BigInteger> arrayList = new ArrayList<BigInteger>(1);
        arrayList.add(new BigInteger(3L));
        List list = new ArrayList();
        for (int i = 1; i < 2; ++i) {
            this.a = this.dfac.parse(" ( x^3 y - 1 ) ");
            this.b = this.dfac.parse(" ( 1 + y ) ");
            this.e = this.dfac.parse(" ( y^2 - x ) ");
            list.add(this.a);
            list.add(this.b);
            list.add(this.e);
            list = greatestCommonDivisorAbstract.coPrime(list);
            if (list.size() == 0) continue;
            this.c = list.get(0).multiply(list.get(1)).multiply(list.get(2));
            GenPolynomial<ModInteger> genPolynomial = PolyUtil.fromIntegerCoefficients(genPolynomialRing4, this.c);
            GenPolynomial genPolynomial2 = PolyUtil.recursive(genPolynomialRing3, this.c);
            GenPolynomial genPolynomial3 = PolyUtil.switchVariables(genPolynomial2);
            GenPolynomial genPolynomial4 = genPolynomial3.leadingBaseCoefficient();
            FactorAbstract<BigInteger> factorAbstract = FactorFactory.getImplementation(new BigInteger());
            List<GenPolynomial<BigInteger>> list2 = factorAbstract.factorsRadical(genPolynomial4);
            ArrayList<GenPolynomial<BigInteger>> arrayList2 = new ArrayList<GenPolynomial<BigInteger>>(2);
            arrayList2.add(list2.get(0));
            arrayList2.add(list2.get(2));
            arrayList2.add(list2.get(1));
            ArrayList<GenPolynomial<ModInteger>> arrayList3 = new ArrayList<GenPolynomial<ModInteger>>(list.size());
            for (GenPolynomial<BigInteger> genPolynomial5 : list) {
                GenPolynomial<ModInteger> genPolynomial52 = PolyUtil.fromIntegerCoefficients(genPolynomialRing4, genPolynomial5);
                arrayList3.add(genPolynomial52);
            }
            GenPolynomialRing<ModInteger> genPolynomialRing5 = genPolynomialRing4.contract(1);
            modInteger = modIntegerRing2.fromInteger(((BigInteger)arrayList.get(0)).getVal());
            ArrayList iterable2 = new ArrayList(list.size());
            for (GenPolynomial genPolynomial6 : arrayList3) {
                GenPolynomial<ModInteger> genPolynomial7 = PolyUtil.evaluateMain(genPolynomialRing5, genPolynomial6, modInteger);
                iterable2.add(genPolynomial7);
            }
            try {
                List<GenPolynomial<ModInteger>> noLiftingException = HenselMultUtil.liftHensel(this.c, genPolynomial, iterable2, arrayList, l, arrayList2);
                boolean bl = HenselMultUtil.isHenselLift(this.c, genPolynomial, iterable2, noLiftingException);
                HenselMultUtilTest.assertTrue((String)"isHenselLift: ", (boolean)bl);
                continue;
            }
            catch (ArithmeticException arithmeticException) {
                System.out.println("e = " + arithmeticException);
                continue;
            }
            catch (NoLiftingException noLiftingException) {
                HenselMultUtilTest.fail((String)("" + noLiftingException));
                System.out.println("e = " + noLiftingException);
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    public void xtestHenselLifting3List() {
        java.math.BigInteger bigInteger = new java.math.BigInteger("19");
        BigInteger bigInteger2 = new BigInteger(bigInteger);
        ModIntegerRing modIntegerRing = new ModIntegerRing(bigInteger, false);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 3, this.tord, new String[]{"x", "y", "z"});
        GenPolynomialRing<BigInteger> genPolynomialRing2 = new GenPolynomialRing<BigInteger>(new BigInteger(), genPolynomialRing);
        GenPolynomialRing genPolynomialRing3 = genPolynomialRing2.recursive(genPolynomialRing2.nvar - 1);
        BigInteger bigInteger3 = bigInteger2;
        long l = 3L;
        java.math.BigInteger bigInteger4 = bigInteger.pow((int)l);
        ModIntegerRing modIntegerRing2 = new ModIntegerRing(bigInteger4, false);
        GenPolynomialRing<ModInteger> genPolynomialRing4 = new GenPolynomialRing<ModInteger>(modIntegerRing2, genPolynomialRing);
        this.dfac = new GenPolynomialRing<BigInteger>(bigInteger3, genPolynomialRing);
        GreatestCommonDivisorAbstract<BigInteger> greatestCommonDivisorAbstract = GCDFactory.getImplementation(bigInteger3);
        ModInteger modInteger = modIntegerRing2.fromInteger(3L);
        ArrayList<BigInteger> arrayList = new ArrayList<BigInteger>(1);
        arrayList.add(new BigInteger(3L));
        if (genPolynomialRing4.nvar > 2) {
            arrayList.add(new BigInteger(5L));
        }
        if (genPolynomialRing4.nvar > 3) {
            arrayList.add(new BigInteger(7L));
        }
        List list = new ArrayList();
        for (int i = 1; i < 2; ++i) {
            GenPolynomial<ModInteger> genPolynomial;
            Iterable<Monomial<Object>> iterable2;
            this.a = this.dfac.parse(" ( x^3 z - y ) ");
            this.b = this.dfac.parse(" ( 1 + y + z ) ");
            this.e = this.dfac.parse(" ( z^2 y - x ) ");
            list.add(this.a);
            list.add(this.b);
            list.add(this.e);
            list = greatestCommonDivisorAbstract.coPrime(list);
            if (list.size() == 0) continue;
            this.c = list.get(0).multiply(list.get(1)).multiply(list.get(2));
            GenPolynomial<ModInteger> genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing4, this.c);
            GenPolynomial genPolynomial3 = PolyUtil.recursive(genPolynomialRing3, this.c);
            GenPolynomial genPolynomial4 = PolyUtil.switchVariables(genPolynomial3);
            GenPolynomial genPolynomial5 = genPolynomial4.leadingBaseCoefficient();
            FactorAbstract<BigInteger> factorAbstract = FactorFactory.getImplementation(new BigInteger());
            List<GenPolynomial<BigInteger>> list2 = factorAbstract.factorsRadical(genPolynomial5);
            ArrayList<GenPolynomial<BigInteger>> arrayList2 = new ArrayList<GenPolynomial<BigInteger>>(2);
            arrayList2.add(list2.get(0));
            arrayList2.add(list2.get(2));
            arrayList2.add(list2.get(1));
            ArrayList<GenPolynomial<ModInteger>> arrayList3 = new ArrayList<GenPolynomial<ModInteger>>(list.size());
            for (Iterable<Monomial<Object>> iterable2 : list) {
                GenPolynomial<ModInteger> genPolynomial6 = PolyUtil.fromIntegerCoefficients(genPolynomialRing4, iterable2);
                arrayList3.add(genPolynomial6);
            }
            GenPolynomialRing genPolynomialRing5 = genPolynomialRing4.contract(1);
            Iterable<Monomial<Object>> iterable2 = new ArrayList(list.size());
            iterable2 = arrayList3;
            modInteger = modIntegerRing2.fromInteger(((BigInteger)arrayList.get(1)).getVal());
            ArrayList<GenPolynomial<ModInteger>> arrayList4 = new ArrayList<GenPolynomial<ModInteger>>(list.size());
            for (GenPolynomial genPolynomial7 : iterable2) {
                genPolynomial = PolyUtil.evaluateMain(genPolynomialRing5, genPolynomial7, modInteger);
                arrayList4.add(genPolynomial);
            }
            iterable2 = arrayList4;
            genPolynomialRing5 = genPolynomialRing5.contract(1);
            modInteger = modIntegerRing2.fromInteger(((BigInteger)arrayList.get(0)).getVal());
            arrayList4 = new ArrayList(list.size());
            for (GenPolynomial genPolynomial7 : iterable2) {
                genPolynomial = PolyUtil.evaluateMain(genPolynomialRing5, genPolynomial7, modInteger);
                arrayList4.add(genPolynomial);
            }
            iterable2 = arrayList4;
            try {
                List<GenPolynomial<Object>> list3 = HenselMultUtil.liftHensel(this.c, genPolynomial2, iterable2, arrayList, l, arrayList2);
                boolean bl = HenselMultUtil.isHenselLift(this.c, genPolynomial2, iterable2, list3);
                HenselMultUtilTest.assertTrue((String)"isHenselLift: ", (boolean)bl);
                continue;
            }
            catch (ArithmeticException arithmeticException) {
                System.out.println("e = " + arithmeticException);
                continue;
            }
            catch (NoLiftingException noLiftingException) {
                HenselMultUtilTest.fail((String)("" + noLiftingException));
                System.out.println("e = " + noLiftingException);
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    public void xtestHenselLifting4List() {
        java.math.BigInteger bigInteger = new java.math.BigInteger("19");
        BigInteger bigInteger2 = new BigInteger(bigInteger);
        ModIntegerRing modIntegerRing = new ModIntegerRing(bigInteger, false);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 4, this.tord, new String[]{"x", "y", "z", "w"});
        GenPolynomialRing<BigInteger> genPolynomialRing2 = new GenPolynomialRing<BigInteger>(new BigInteger(), genPolynomialRing);
        GenPolynomialRing genPolynomialRing3 = genPolynomialRing2.recursive(genPolynomialRing2.nvar - 1);
        BigInteger bigInteger3 = bigInteger2;
        long l = 3L;
        java.math.BigInteger bigInteger4 = bigInteger.pow((int)l);
        ModIntegerRing modIntegerRing2 = new ModIntegerRing(bigInteger4, false);
        GenPolynomialRing<ModInteger> genPolynomialRing4 = new GenPolynomialRing<ModInteger>(modIntegerRing2, genPolynomialRing);
        this.dfac = new GenPolynomialRing<BigInteger>(bigInteger3, genPolynomialRing);
        GreatestCommonDivisorAbstract<BigInteger> greatestCommonDivisorAbstract = GCDFactory.getImplementation(bigInteger3);
        ModInteger modInteger = modIntegerRing2.fromInteger(3L);
        ArrayList<BigInteger> arrayList = new ArrayList<BigInteger>(1);
        arrayList.add(new BigInteger(3L));
        if (genPolynomialRing4.nvar > 2) {
            arrayList.add(new BigInteger(5L));
        }
        if (genPolynomialRing4.nvar > 3) {
            arrayList.add(new BigInteger(7L));
        }
        List list = new ArrayList();
        for (int i = 1; i < 2; ++i) {
            GenPolynomial<ModInteger> genPolynomial;
            GenPolynomial genPolynomial22;
            Object object2;
            ArrayList arrayList22;
            this.a = this.dfac.parse(" ( x^3 w - y ) ");
            this.b = this.dfac.parse(" ( 1 + y + z + w ) ");
            this.e = this.dfac.parse(" ( z^2 y w - x ) ");
            list.add(this.a);
            list.add(this.b);
            list.add(this.e);
            list = greatestCommonDivisorAbstract.coPrime(list);
            if (list.size() == 0) continue;
            this.c = list.get(0).multiply(list.get(1)).multiply(list.get(2));
            GenPolynomial<ModInteger> genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing4, this.c);
            GenPolynomial genPolynomial4 = PolyUtil.recursive(genPolynomialRing3, this.c);
            GenPolynomial genPolynomial5 = PolyUtil.switchVariables(genPolynomial4);
            GenPolynomial genPolynomial6 = genPolynomial5.leadingBaseCoefficient();
            FactorAbstract<BigInteger> factorAbstract = FactorFactory.getImplementation(new BigInteger());
            List<GenPolynomial<BigInteger>> list2 = factorAbstract.factorsRadical(genPolynomial6);
            ArrayList<GenPolynomial<BigInteger>> arrayList3 = new ArrayList<GenPolynomial<BigInteger>>(2);
            arrayList3.add(list2.get(0));
            arrayList3.add(list2.get(2));
            arrayList3.add(list2.get(1));
            ArrayList<GenPolynomial<ModInteger>> arrayList4 = new ArrayList<GenPolynomial<ModInteger>>(list.size());
            for (ArrayList arrayList22 : list) {
                GenPolynomial<ModInteger> genPolynomial7 = PolyUtil.fromIntegerCoefficients(genPolynomialRing4, arrayList22);
                arrayList4.add(genPolynomial7);
            }
            GenPolynomialRing genPolynomialRing5 = genPolynomialRing4.contract(1);
            modInteger = modIntegerRing2.fromInteger(((BigInteger)arrayList.get(2)).getVal());
            arrayList22 = new ArrayList(list.size());
            for (Object object2 : arrayList4) {
                genPolynomial22 = PolyUtil.evaluateMain(genPolynomialRing5, object2, modInteger);
                arrayList22.add(genPolynomial22);
            }
            genPolynomialRing5 = genPolynomialRing5.contract(1);
            modInteger = modIntegerRing2.fromInteger(((BigInteger)arrayList.get(1)).getVal());
            ArrayList arrayList5 = new ArrayList(list.size());
            for (GenPolynomial genPolynomial22 : arrayList22) {
                genPolynomial = PolyUtil.evaluateMain(genPolynomialRing5, genPolynomial22, modInteger);
                arrayList5.add(genPolynomial);
            }
            arrayList22 = arrayList5;
            genPolynomialRing5 = genPolynomialRing5.contract(1);
            modInteger = modIntegerRing2.fromInteger(((BigInteger)arrayList.get(0)).getVal());
            arrayList5 = new ArrayList(list.size());
            object2 = arrayList22.iterator();
            while (object2.hasNext()) {
                genPolynomial22 = (GenPolynomial)object2.next();
                genPolynomial = PolyUtil.evaluateMain(genPolynomialRing5, genPolynomial22, modInteger);
                arrayList5.add(genPolynomial);
            }
            arrayList22 = arrayList5;
            try {
                object2 = HenselMultUtil.liftHensel(this.c, genPolynomial3, arrayList22, arrayList, l, arrayList3);
                boolean bl = HenselMultUtil.isHenselLift(this.c, genPolynomial3, arrayList22, object2);
                HenselMultUtilTest.assertTrue((String)"isHenselLift: ", (boolean)bl);
                continue;
            }
            catch (ArithmeticException arithmeticException) {
                System.out.println("e = " + arithmeticException);
                continue;
            }
            catch (NoLiftingException noLiftingException) {
                HenselMultUtilTest.fail((String)("" + noLiftingException));
                System.out.println("e = " + noLiftingException);
            }
        }
    }

    public void testHenselLifting2FullList() {
        java.math.BigInteger bigInteger = new java.math.BigInteger("19");
        BigInteger bigInteger2 = new BigInteger(bigInteger);
        ModLongRing modLongRing = new ModLongRing(bigInteger, false);
        GenPolynomialRing<ModLong> genPolynomialRing = new GenPolynomialRing<ModLong>(modLongRing, 2, this.tord, new String[]{"x", "y"});
        GenPolynomialRing<BigInteger> genPolynomialRing2 = new GenPolynomialRing<BigInteger>(new BigInteger(), genPolynomialRing);
        GenPolynomialRing genPolynomialRing3 = genPolynomialRing2.recursive(genPolynomialRing2.nvar - 1);
        GenPolynomialRing<BigInteger> genPolynomialRing4 = genPolynomialRing2.contract(genPolynomialRing2.nvar - 1);
        GenPolynomialRing<ModLong> genPolynomialRing5 = genPolynomialRing.contract(genPolynomialRing.nvar - 1);
        BigInteger bigInteger3 = bigInteger2;
        long l = 5L;
        java.math.BigInteger bigInteger4 = bigInteger.pow((int)l);
        ModLongRing modLongRing2 = new ModLongRing(bigInteger4, false);
        GenPolynomialRing<ModLong> genPolynomialRing6 = new GenPolynomialRing<ModLong>(modLongRing2, genPolynomialRing);
        this.dfac = new GenPolynomialRing<BigInteger>(bigInteger3, genPolynomialRing);
        GreatestCommonDivisorAbstract<BigInteger> greatestCommonDivisorAbstract = GCDFactory.getImplementation(bigInteger3);
        ModLong modLong = modLongRing2.fromInteger(3L);
        ArrayList<BigInteger> arrayList = new ArrayList<BigInteger>(1);
        arrayList.add(new BigInteger(3L));
        List list = new ArrayList();
        for (int i = 1; i < 2; ++i) {
            GenPolynomial<ModLong> genPolynomial2;
            this.a = this.dfac.parse(" ( x^3 y - 1 ) ");
            this.b = this.dfac.parse(" ( 1 + y ) ");
            this.e = this.dfac.parse(" ( y^2 - x ) ");
            list.add(this.a);
            list.add(this.b);
            list.add(this.e);
            list = greatestCommonDivisorAbstract.coPrime(list);
            if (list.size() == 0) continue;
            this.c = list.get(0).multiply(list.get(1)).multiply(list.get(2));
            GenPolynomial<ModLong> genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing6, this.c);
            GenPolynomial genPolynomial4 = PolyUtil.recursive(genPolynomialRing3, this.c);
            GenPolynomial genPolynomial5 = PolyUtil.switchVariables(genPolynomial4);
            GenPolynomial genPolynomial6 = genPolynomial5.leadingBaseCoefficient();
            FactorAbstract<BigInteger> factorAbstract = FactorFactory.getImplementation(new BigInteger());
            List<GenPolynomial<BigInteger>> list3 = factorAbstract.factorsRadical(genPolynomial6);
            ArrayList<GenPolynomial<BigInteger>> arrayList2 = new ArrayList<GenPolynomial<BigInteger>>(2);
            arrayList2.add(list3.get(0));
            arrayList2.add(list3.get(2));
            arrayList2.add(list3.get(1));
            ArrayList<GenPolynomial<ModLong>> arrayList3 = new ArrayList<GenPolynomial<ModLong>>(list.size());
            for (GenPolynomial<BigInteger> genPolynomial : list) {
                genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing6, genPolynomial);
                arrayList3.add(genPolynomial2);
            }
            GenPolynomialRing<ModLong> genPolynomialRing7 = genPolynomialRing6.contract(1);
            modLong = modLongRing2.fromInteger(((BigInteger)arrayList.get(0)).getVal());
            ArrayList iterable2 = new ArrayList(list.size());
            for (GenPolynomial genPolynomial : arrayList3) {
                GenPolynomial<GcdRingElem<ModLong>> genPolynomial7 = PolyUtil.evaluateMain(genPolynomialRing7, genPolynomial, modLong);
                iterable2.add(genPolynomial7);
            }
            ArrayList arrayList4 = new ArrayList(list.size());
            for (GenPolynomial<GcdRingElem<ModLong>> genPolynomial7 : PolyUtil.integerFromModularCoefficients(genPolynomialRing4, iterable2)) {
                genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing5, genPolynomial7);
                arrayList4.add(genPolynomial2);
            }
            try {
                List list2 = HenselMultUtil.liftHenselFull(this.c, arrayList4, arrayList, l, arrayList2);
                boolean bl = HenselMultUtil.isHenselLift(this.c, genPolynomial3, arrayList4, list2);
                HenselMultUtilTest.assertTrue((String)"isHenselLift: ", (boolean)bl);
                continue;
            }
            catch (ArithmeticException arithmeticException) {
                System.out.println("e = " + arithmeticException);
                continue;
            }
            catch (NoLiftingException noLiftingException) {
                HenselMultUtilTest.fail((String)("" + noLiftingException));
                System.out.println("e = " + noLiftingException);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void testHenselLifting3FullList() {
        java.math.BigInteger bigInteger = new java.math.BigInteger("19");
        BigInteger bigInteger2 = new BigInteger(bigInteger);
        ModLongRing modLongRing = new ModLongRing(bigInteger, false);
        GenPolynomialRing<ModLong> genPolynomialRing = new GenPolynomialRing<ModLong>(modLongRing, 3, this.tord, new String[]{"x", "y", "z"});
        GenPolynomialRing<BigInteger> genPolynomialRing2 = new GenPolynomialRing<BigInteger>(new BigInteger(), genPolynomialRing);
        GenPolynomialRing genPolynomialRing3 = genPolynomialRing2.recursive(genPolynomialRing2.nvar - 1);
        GenPolynomialRing<BigInteger> genPolynomialRing4 = genPolynomialRing2.contract(genPolynomialRing2.nvar - 1);
        GenPolynomialRing<ModLong> genPolynomialRing5 = genPolynomialRing.contract(genPolynomialRing.nvar - 1);
        BigInteger bigInteger3 = bigInteger2;
        long l = 5L;
        java.math.BigInteger bigInteger4 = bigInteger.pow((int)l);
        ModLongRing modLongRing2 = new ModLongRing(bigInteger4, false);
        GenPolynomialRing<ModLong> genPolynomialRing6 = new GenPolynomialRing<ModLong>(modLongRing2, genPolynomialRing);
        this.dfac = new GenPolynomialRing<BigInteger>(bigInteger3, genPolynomialRing);
        GreatestCommonDivisorAbstract<BigInteger> greatestCommonDivisorAbstract = GCDFactory.getImplementation(bigInteger3);
        ModLong modLong = modLongRing2.fromInteger(3L);
        ArrayList<BigInteger> arrayList = new ArrayList<BigInteger>(1);
        arrayList.add(new BigInteger(3L));
        if (genPolynomialRing6.nvar > 2) {
            arrayList.add(new BigInteger(5L));
        }
        List list = new ArrayList();
        for (int i = 1; i < 2; ++i) {
            void var36_47;
            GenPolynomial<ModLong> genPolynomial;
            GenPolynomial<ModLong> genPolynomial3;
            this.a = this.dfac.parse(" ( x^3 z - y ) ");
            this.b = this.dfac.parse(" ( 1 + y + z ) ");
            this.e = this.dfac.parse(" ( z^2 y - x ) ");
            list.add(this.a);
            list.add(this.b);
            list.add(this.e);
            list = greatestCommonDivisorAbstract.coPrime(list);
            if (list.size() == 0) continue;
            this.c = list.get(0).multiply(list.get(1)).multiply(list.get(2));
            GenPolynomial<ModLong> genPolynomial4 = PolyUtil.fromIntegerCoefficients(genPolynomialRing6, this.c);
            GenPolynomial genPolynomial5 = PolyUtil.recursive(genPolynomialRing3, this.c);
            GenPolynomial genPolynomial6 = PolyUtil.switchVariables(genPolynomial5);
            GenPolynomial genPolynomial7 = genPolynomial6.leadingBaseCoefficient();
            FactorAbstract<BigInteger> factorAbstract = FactorFactory.getImplementation(new BigInteger());
            List<GenPolynomial<BigInteger>> list2 = factorAbstract.factorsRadical(genPolynomial7);
            ArrayList<GenPolynomial<BigInteger>> arrayList2 = new ArrayList<GenPolynomial<BigInteger>>(2);
            arrayList2.add(list2.get(0));
            arrayList2.add(list2.get(2));
            arrayList2.add(list2.get(1));
            ArrayList<GenPolynomial<ModLong>> arrayList3 = new ArrayList<GenPolynomial<ModLong>>(list.size());
            for (GenPolynomial<BigInteger> genPolynomial2 : list) {
                genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing6, genPolynomial2);
                arrayList3.add(genPolynomial3);
            }
            GenPolynomialRing genPolynomialRing7 = genPolynomialRing6.contract(1);
            ArrayList arrayList4 = new ArrayList(list.size());
            ArrayList<GenPolynomial<ModLong>> arrayList5 = arrayList3;
            modLong = modLongRing2.fromInteger(((BigInteger)arrayList.get(0)).getVal());
            ArrayList arrayList6 = new ArrayList(list.size());
            for (GenPolynomial genPolynomial8 : arrayList5) {
                GenPolynomial<ModLong> genPolynomial9 = PolyUtil.evaluateMain(genPolynomialRing7, genPolynomial8, modLong);
                arrayList6.add(genPolynomial9);
            }
            ArrayList arrayList7 = arrayList6;
            GenPolynomial<ModLong> genPolynomial10 = PolyUtil.evaluateMain(genPolynomialRing7, genPolynomial4, modLong);
            genPolynomialRing7 = genPolynomialRing7.contract(1);
            modLong = modLongRing2.fromInteger(((BigInteger)arrayList.get(1)).getVal());
            arrayList6 = new ArrayList(list.size());
            for (GenPolynomial genPolynomial11 : arrayList7) {
                genPolynomial = PolyUtil.evaluateMain(genPolynomialRing7, genPolynomial11, modLong);
                arrayList6.add(genPolynomial);
            }
            ArrayList iterable22 = arrayList6;
            GenPolynomial<ModLong> genPolynomial12 = PolyUtil.evaluateMain(genPolynomialRing7, genPolynomial10, modLong);
            ArrayList arrayList8 = new ArrayList(list.size());
            for (GenPolynomial genPolynomial13 : PolyUtil.integerFromModularCoefficients(genPolynomialRing4, iterable22)) {
                genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing5, genPolynomial13);
                arrayList8.add(genPolynomial3);
            }
            genPolynomial = PolyUtil.fromIntegerCoefficients(genPolynomialRing5, PolyUtil.integerFromModularCoefficients(genPolynomialRing4, genPolynomial12));
            MonoidElem monoidElem = genPolynomialRing5.getONE();
            for (GenPolynomial genPolynomial14 : arrayList8) {
                GenPolynomial<GenPolynomial> genPolynomial15 = var36_47.multiply(genPolynomial14);
            }
            HenselMultUtilTest.assertTrue((String)("prod(A(v,v)) mod p = " + var36_47 + ", cpppp = " + genPolynomial + ", aa != cpppp: "), (boolean)genPolynomial.equals(var36_47));
            try {
                List list3 = HenselMultUtil.liftHenselFull(this.c, arrayList8, arrayList, l, arrayList2);
                boolean bl = HenselMultUtil.isHenselLift(this.c, genPolynomial4, arrayList8, list3);
                HenselMultUtilTest.assertTrue((String)"isHenselLift: ", (boolean)bl);
                continue;
            }
            catch (ArithmeticException arithmeticException) {
                System.out.println("e = " + arithmeticException);
                continue;
            }
            catch (NoLiftingException noLiftingException) {
                HenselMultUtilTest.fail((String)("" + noLiftingException));
                System.out.println("e = " + noLiftingException);
            }
        }
    }

    public void testHenselLifting4FullList() {
        java.math.BigInteger bigInteger = new java.math.BigInteger("19");
        BigInteger bigInteger2 = new BigInteger(bigInteger);
        ModLongRing modLongRing = new ModLongRing(bigInteger, false);
        GenPolynomialRing<ModLong> genPolynomialRing = new GenPolynomialRing<ModLong>(modLongRing, 4, this.tord, new String[]{"x", "y", "z", "w"});
        GenPolynomialRing<BigInteger> genPolynomialRing2 = new GenPolynomialRing<BigInteger>(new BigInteger(), genPolynomialRing);
        GenPolynomialRing genPolynomialRing3 = genPolynomialRing2.recursive(genPolynomialRing2.nvar - 1);
        GenPolynomialRing<BigInteger> genPolynomialRing4 = genPolynomialRing2.contract(genPolynomialRing2.nvar - 1);
        GenPolynomialRing<ModLong> genPolynomialRing5 = genPolynomialRing.contract(genPolynomialRing.nvar - 1);
        BigInteger bigInteger3 = bigInteger2;
        long l = 5L;
        java.math.BigInteger bigInteger4 = bigInteger.pow((int)l);
        ModLongRing modLongRing2 = new ModLongRing(bigInteger4, false);
        GenPolynomialRing<ModLong> genPolynomialRing6 = new GenPolynomialRing<ModLong>(modLongRing2, genPolynomialRing);
        this.dfac = new GenPolynomialRing<BigInteger>(bigInteger3, genPolynomialRing);
        GreatestCommonDivisorAbstract<BigInteger> greatestCommonDivisorAbstract = GCDFactory.getImplementation(bigInteger3);
        ModLong modLong = modLongRing2.fromInteger(3L);
        ArrayList<BigInteger> arrayList = new ArrayList<BigInteger>(1);
        arrayList.add(new BigInteger(3L));
        if (genPolynomialRing6.nvar > 2) {
            arrayList.add(new BigInteger(5L));
        }
        if (genPolynomialRing6.nvar > 3) {
            arrayList.add(new BigInteger(7L));
        }
        List list = new ArrayList();
        for (int i = 1; i < 2; ++i) {
            GenPolynomial<GcdRingElem<ModLong>> genPolynomial12;
            GenPolynomial<ModLong> genPolynomial2;
            this.a = this.dfac.parse(" ( x^3 w - y ) ");
            this.b = this.dfac.parse(" ( 1 + y + z + w ) ");
            this.e = this.dfac.parse(" ( z^2 y w - x ) ");
            list.add(this.a);
            list.add(this.b);
            list.add(this.e);
            list = greatestCommonDivisorAbstract.coPrime(list);
            if (list.size() == 0) continue;
            this.c = list.get(0).multiply(list.get(1)).multiply(list.get(2));
            GenPolynomial<ModLong> genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing6, this.c);
            GenPolynomial genPolynomial4 = PolyUtil.recursive(genPolynomialRing3, this.c);
            GenPolynomial genPolynomial5 = PolyUtil.switchVariables(genPolynomial4);
            GenPolynomial genPolynomial6 = genPolynomial5.leadingBaseCoefficient();
            FactorAbstract<BigInteger> factorAbstract = FactorFactory.getImplementation(new BigInteger());
            List<GenPolynomial<BigInteger>> list3 = factorAbstract.factorsRadical(genPolynomial6);
            ArrayList<GenPolynomial<BigInteger>> arrayList3 = new ArrayList<GenPolynomial<BigInteger>>(2);
            arrayList3.add(list3.get(0));
            arrayList3.add(list3.get(2));
            arrayList3.add(list3.get(1));
            ArrayList<GenPolynomial<ModLong>> arrayList4 = new ArrayList<GenPolynomial<ModLong>>(list.size());
            for (GenPolynomial<BigInteger> genPolynomial7 : list) {
                genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing6, genPolynomial7);
                arrayList4.add(genPolynomial2);
            }
            GenPolynomialRing genPolynomialRing7 = genPolynomialRing6.contract(1);
            modLong = modLongRing2.fromInteger(((BigInteger)arrayList.get(0)).getVal());
            ArrayList<GenPolynomial<ModLong>> arrayList2 = new ArrayList<GenPolynomial<ModLong>>(list.size());
            for (GenPolynomial genPolynomial8 : arrayList4) {
                GenPolynomial<ModLong> genPolynomial9 = PolyUtil.evaluateMain(genPolynomialRing7, genPolynomial8, modLong);
                arrayList2.add(genPolynomial9);
            }
            genPolynomialRing7 = genPolynomialRing7.contract(1);
            modLong = modLongRing2.fromInteger(((BigInteger)arrayList.get(1)).getVal());
            ArrayList arrayList5 = new ArrayList(list.size());
            for (GenPolynomial genPolynomial10 : arrayList2) {
                genPolynomial12 = PolyUtil.evaluateMain(genPolynomialRing7, genPolynomial10, modLong);
                arrayList5.add(genPolynomial12);
            }
            ArrayList arrayList6 = arrayList5;
            genPolynomialRing7 = genPolynomialRing7.contract(1);
            modLong = modLongRing2.fromInteger(((BigInteger)arrayList.get(2)).getVal());
            arrayList5 = new ArrayList(list.size());
            for (GenPolynomial genPolynomial11 : arrayList6) {
                genPolynomial12 = PolyUtil.evaluateMain(genPolynomialRing7, genPolynomial11, modLong);
                arrayList5.add(genPolynomial12);
            }
            ArrayList arrayList22 = arrayList5;
            ArrayList arrayList7 = new ArrayList(list.size());
            for (GenPolynomial<GcdRingElem<ModLong>> genPolynomial12 : PolyUtil.integerFromModularCoefficients(genPolynomialRing4, arrayList22)) {
                genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing5, genPolynomial12);
                arrayList7.add(genPolynomial2);
            }
            try {
                List list2 = HenselMultUtil.liftHenselFull(this.c, arrayList7, arrayList, l, arrayList3);
                boolean bl = HenselMultUtil.isHenselLift(this.c, genPolynomial3, arrayList7, list2);
                HenselMultUtilTest.assertTrue((String)"isHenselLift: ", (boolean)bl);
                continue;
            }
            catch (ArithmeticException arithmeticException) {
                System.out.println("e = " + arithmeticException);
                continue;
            }
            catch (NoLiftingException noLiftingException) {
                HenselMultUtilTest.fail((String)("" + noLiftingException));
                System.out.println("e = " + noLiftingException);
            }
        }
    }
}

