/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.ResidueSolvableWordPolynomial;
import edu.jas.application.WordResidue;
import edu.jas.application.WordResidueRing;
import edu.jas.kern.PrettyPrint;
import edu.jas.kern.Scripting;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.RecSolvableWordPolynomial;
import edu.jas.poly.RecSolvableWordPolynomialRing;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResidueSolvableWordPolynomialRing<C extends GcdRingElem<C>>
extends GenSolvablePolynomialRing<WordResidue<C>> {
    public final RecSolvableWordPolynomialRing<C> polCoeff;
    public final ResidueSolvableWordPolynomial<C> ZERO;
    public final ResidueSolvableWordPolynomial<C> ONE;
    private static final Logger logger = LogManager.getLogger(ResidueSolvableWordPolynomialRing.class);
    private static final boolean debug = logger.isDebugEnabled();

    public ResidueSolvableWordPolynomialRing(RingFactory<WordResidue<C>> ringFactory, int n) {
        this(ringFactory, n, new TermOrder(), (String[])null, (RelationTable<WordResidue<C>>)null);
    }

    public ResidueSolvableWordPolynomialRing(RingFactory<WordResidue<C>> ringFactory, int n, RelationTable<WordResidue<C>> relationTable) {
        this(ringFactory, n, new TermOrder(), (String[])null, relationTable);
    }

    public ResidueSolvableWordPolynomialRing(RingFactory<WordResidue<C>> ringFactory, int n, TermOrder termOrder) {
        this(ringFactory, n, termOrder, (String[])null, (RelationTable<WordResidue<C>>)null);
    }

    public ResidueSolvableWordPolynomialRing(RingFactory<WordResidue<C>> ringFactory, int n, TermOrder termOrder, RelationTable<WordResidue<C>> relationTable) {
        this(ringFactory, n, termOrder, (String[])null, relationTable);
    }

    public ResidueSolvableWordPolynomialRing(RingFactory<WordResidue<C>> ringFactory, int n, TermOrder termOrder, String[] stringArray) {
        this(ringFactory, n, termOrder, stringArray, (RelationTable<WordResidue<C>>)null);
    }

    public ResidueSolvableWordPolynomialRing(RingFactory<WordResidue<C>> ringFactory, TermOrder termOrder, String[] stringArray) {
        this(ringFactory, stringArray.length, termOrder, stringArray, (RelationTable<WordResidue<C>>)null);
    }

    public ResidueSolvableWordPolynomialRing(RingFactory<WordResidue<C>> ringFactory, String[] stringArray) {
        this(ringFactory, stringArray.length, new TermOrder(), stringArray, (RelationTable<WordResidue<C>>)null);
    }

    public ResidueSolvableWordPolynomialRing(RingFactory<WordResidue<C>> ringFactory, int n, TermOrder termOrder, String[] stringArray, RelationTable<WordResidue<C>> relationTable) {
        super(ringFactory, n, termOrder, stringArray, relationTable);
        WordResidue wordResidue;
        WordResidueRing wordResidueRing = (WordResidueRing)ringFactory;
        this.polCoeff = new RecSolvableWordPolynomialRing(wordResidueRing.ring, n, termOrder, stringArray);
        if (this.table.size() > 0) {
            wordResidue = null;
            ExpVector expVector = null;
            GenSolvablePolynomial genSolvablePolynomial = null;
            this.polCoeff.table.update((ExpVector)((Object)wordResidue), expVector, genSolvablePolynomial);
        }
        this.ZERO = new ResidueSolvableWordPolynomial(this);
        wordResidue = (WordResidue)this.coFac.getONE();
        this.ONE = new ResidueSolvableWordPolynomial(this, wordResidue, this.evzero);
    }

    public ResidueSolvableWordPolynomialRing(RingFactory<WordResidue<C>> ringFactory, ResidueSolvableWordPolynomialRing residueSolvableWordPolynomialRing) {
        this(ringFactory, residueSolvableWordPolynomialRing.nvar, residueSolvableWordPolynomialRing.tord, residueSolvableWordPolynomialRing.getVars(), (RelationTable<WordResidue<C>>)null);
    }

    @Override
    public String toString() {
        String string = super.toString();
        string = PrettyPrint.isTrue() ? string + "\n" + this.polCoeff.coeffTable.toString(this.vars) : string + ", #rel = " + this.table.size() + " + " + this.polCoeff.coeffTable.size();
        return string;
    }

    @Override
    public String toScript() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        switch (Scripting.getLang()) {
            case Ruby: {
                stringBuffer.append("SolvPolyRing.new(");
                break;
            }
            default: {
                stringBuffer.append("SolvPolyRing(");
            }
        }
        if (this.coFac instanceof RingElem) {
            stringBuffer.append(((RingElem)((Object)this.coFac)).toScriptFactory());
        } else {
            stringBuffer.append(this.coFac.toScript().trim());
        }
        stringBuffer.append(",\"" + this.varsToString() + "\",");
        String string2 = this.tord.toScript();
        stringBuffer.append(string2);
        if (this.table.size() > 0) {
            string = this.table.toScript();
            stringBuffer.append(",rel=");
            stringBuffer.append(string);
        }
        if (this.polCoeff.coeffTable.size() > 0) {
            string = this.polCoeff.coeffTable.toScript();
            stringBuffer.append(",coeffrel=");
            stringBuffer.append(string);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ResidueSolvableWordPolynomialRing)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ResidueSolvableWordPolynomialRing residueSolvableWordPolynomialRing = (ResidueSolvableWordPolynomialRing)object;
        return this.polCoeff.coeffTable.equals(residueSolvableWordPolynomialRing.polCoeff.coeffTable);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 37 * n + this.table.hashCode();
        n = 37 * n + this.polCoeff.coeffTable.hashCode();
        return n;
    }

    @Override
    public ResidueSolvableWordPolynomial<C> getZERO() {
        return this.ZERO;
    }

    @Override
    public ResidueSolvableWordPolynomial<C> getONE() {
        return this.ONE;
    }

    @Override
    public boolean isCommutative() {
        if (this.polCoeff.coeffTable.isEmpty()) {
            return super.isCommutative();
        }
        return false;
    }

    @Override
    public boolean isAssociative() {
        if (!this.coFac.isAssociative()) {
            return false;
        }
        List list = this.generators();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ResidueSolvableWordPolynomial residueSolvableWordPolynomial = (ResidueSolvableWordPolynomial)list.get(i);
            if (residueSolvableWordPolynomial.isONE()) continue;
            for (int j = i + 1; j < n; ++j) {
                ResidueSolvableWordPolynomial residueSolvableWordPolynomial2 = (ResidueSolvableWordPolynomial)list.get(j);
                for (int k = j + 1; k < n; ++k) {
                    ResidueSolvableWordPolynomial residueSolvableWordPolynomial3 = (ResidueSolvableWordPolynomial)list.get(k);
                    try {
                        ResidueSolvableWordPolynomial residueSolvableWordPolynomial4 = residueSolvableWordPolynomial3.multiply(residueSolvableWordPolynomial2).multiply(residueSolvableWordPolynomial);
                        ResidueSolvableWordPolynomial residueSolvableWordPolynomial5 = residueSolvableWordPolynomial3.multiply(residueSolvableWordPolynomial2.multiply(residueSolvableWordPolynomial));
                        if (residueSolvableWordPolynomial4.equals(residueSolvableWordPolynomial5)) continue;
                        logger.info("Xk = " + residueSolvableWordPolynomial3 + ", Xj = " + residueSolvableWordPolynomial2 + ", Xi = " + residueSolvableWordPolynomial);
                        logger.info("p = ( Xk * Xj ) * Xi = " + residueSolvableWordPolynomial4);
                        logger.info("q = Xk * ( Xj * Xi ) = " + residueSolvableWordPolynomial5);
                        return false;
                    }
                    catch (RuntimeException runtimeException) {
                        runtimeException.printStackTrace();
                        System.out.println("Xk = " + residueSolvableWordPolynomial3 + ", Xj = " + residueSolvableWordPolynomial2 + ", Xi = " + residueSolvableWordPolynomial);
                    }
                }
            }
        }
        return true;
    }

    @Override
    public ResidueSolvableWordPolynomial<C> valueOf(WordResidue<C> wordResidue) {
        return new ResidueSolvableWordPolynomial<C>(this, wordResidue, this.evzero);
    }

    @Override
    public ResidueSolvableWordPolynomial<C> valueOf(ExpVector expVector) {
        return this.valueOf((WordResidue)this.coFac.getONE(), expVector);
    }

    @Override
    public ResidueSolvableWordPolynomial<C> valueOf(WordResidue<C> wordResidue, ExpVector expVector) {
        return new ResidueSolvableWordPolynomial<C>(this, wordResidue, expVector);
    }

    @Override
    public ResidueSolvableWordPolynomial<C> fromInteger(long l) {
        return new ResidueSolvableWordPolynomial(this, (WordResidue)this.coFac.fromInteger(l), this.evzero);
    }

    @Override
    public ResidueSolvableWordPolynomial<C> fromInteger(BigInteger bigInteger) {
        return new ResidueSolvableWordPolynomial(this, (WordResidue)this.coFac.fromInteger(bigInteger), this.evzero);
    }

    @Override
    public ResidueSolvableWordPolynomial<C> random(int n) {
        return this.random(n, random);
    }

    @Override
    public ResidueSolvableWordPolynomial<C> random(int n, Random random) {
        if (this.nvar == 1) {
            return this.random(5, n, n, 0.7f, random);
        }
        return this.random(5, n, 3, 0.3f, random);
    }

    @Override
    public ResidueSolvableWordPolynomial<C> random(int n, int n2, int n3, float f) {
        return this.random(n, n2, n3, f, random);
    }

    @Override
    public ResidueSolvableWordPolynomial<C> random(int n, int n2, int n3, float f, Random random) {
        GenSolvablePolynomial genSolvablePolynomial = this.getZERO();
        for (int i = 0; i < n2; ++i) {
            ExpVector expVector = ExpVector.random(this.nvar, n3, f, random);
            WordResidue wordResidue = (WordResidue)this.coFac.random(n, random);
            genSolvablePolynomial = (ResidueSolvableWordPolynomial)genSolvablePolynomial.sum(wordResidue, expVector);
        }
        return genSolvablePolynomial;
    }

    @Override
    public ResidueSolvableWordPolynomial<C> copy(ResidueSolvableWordPolynomial<C> residueSolvableWordPolynomial) {
        return new ResidueSolvableWordPolynomial(this, residueSolvableWordPolynomial.getMap());
    }

    @Override
    public ResidueSolvableWordPolynomial<C> parse(String string) {
        return this.parse(new StringReader(string));
    }

    @Override
    public ResidueSolvableWordPolynomial<C> parse(Reader reader) {
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(this, reader);
        ResidueSolvableWordPolynomial residueSolvableWordPolynomial = null;
        try {
            GenSolvablePolynomial genSolvablePolynomial = genPolynomialTokenizer.nextSolvablePolynomial();
            residueSolvableWordPolynomial = new ResidueSolvableWordPolynomial(this, genSolvablePolynomial);
        }
        catch (IOException iOException) {
            logger.error(iOException.toString() + " parse " + this);
            residueSolvableWordPolynomial = this.ZERO;
        }
        return residueSolvableWordPolynomial;
    }

    @Override
    public ResidueSolvableWordPolynomial<C> univariate(int n) {
        return (ResidueSolvableWordPolynomial)super.univariate(n);
    }

    @Override
    public ResidueSolvableWordPolynomial<C> univariate(int n, long l) {
        return (ResidueSolvableWordPolynomial)super.univariate(n, l);
    }

    @Override
    public ResidueSolvableWordPolynomial<C> univariate(int n, int n2, long l) {
        return (ResidueSolvableWordPolynomial)super.univariate(n, n2, l);
    }

    @Override
    public List<ResidueSolvableWordPolynomial<C>> univariateList() {
        return this.univariateList(0, 1L);
    }

    @Override
    public List<ResidueSolvableWordPolynomial<C>> univariateList(int n) {
        return this.univariateList(n, 1L);
    }

    @Override
    public List<ResidueSolvableWordPolynomial<C>> univariateList(int n, long l) {
        ArrayList<ResidueSolvableWordPolynomial<C>> arrayList = new ArrayList<ResidueSolvableWordPolynomial<C>>(this.nvar);
        int n2 = this.nvar - n;
        for (int i = 0; i < n2; ++i) {
            GenSolvablePolynomial genSolvablePolynomial = this.univariate(n, n2 - 1 - i, l);
            arrayList.add((ResidueSolvableWordPolynomial<C>)genSolvablePolynomial);
        }
        return arrayList;
    }

    @Override
    public ResidueSolvableWordPolynomialRing<C> extend(int n) {
        return this.extend(n, false);
    }

    @Override
    public ResidueSolvableWordPolynomialRing<C> extend(int n, boolean bl) {
        GenPolynomialRing genPolynomialRing = super.extend(n, bl);
        ResidueSolvableWordPolynomialRing<C> residueSolvableWordPolynomialRing = new ResidueSolvableWordPolynomialRing<C>(((GenSolvablePolynomialRing)genPolynomialRing).coFac, ((GenSolvablePolynomialRing)genPolynomialRing).nvar, ((GenSolvablePolynomialRing)genPolynomialRing).tord, genPolynomialRing.getVars());
        residueSolvableWordPolynomialRing.table.extend(this.table);
        residueSolvableWordPolynomialRing.polCoeff.coeffTable.extend(this.polCoeff.coeffTable);
        return residueSolvableWordPolynomialRing;
    }

    @Override
    public ResidueSolvableWordPolynomialRing<C> extend(String[] stringArray) {
        return this.extend(stringArray, false);
    }

    @Override
    public ResidueSolvableWordPolynomialRing<C> extend(String[] stringArray, boolean bl) {
        GenPolynomialRing genPolynomialRing = super.extend(stringArray, bl);
        ResidueSolvableWordPolynomialRing<C> residueSolvableWordPolynomialRing = new ResidueSolvableWordPolynomialRing<C>(((GenSolvablePolynomialRing)genPolynomialRing).coFac, ((GenSolvablePolynomialRing)genPolynomialRing).nvar, ((GenSolvablePolynomialRing)genPolynomialRing).tord, genPolynomialRing.getVars());
        residueSolvableWordPolynomialRing.table.extend(this.table);
        residueSolvableWordPolynomialRing.polCoeff.coeffTable.extend(this.polCoeff.coeffTable);
        return residueSolvableWordPolynomialRing;
    }

    @Override
    public ResidueSolvableWordPolynomialRing<C> contract(int n) {
        GenPolynomialRing genPolynomialRing = super.contract(n);
        ResidueSolvableWordPolynomialRing<C> residueSolvableWordPolynomialRing = new ResidueSolvableWordPolynomialRing<C>(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.getVars());
        residueSolvableWordPolynomialRing.table.contract(this.table);
        residueSolvableWordPolynomialRing.polCoeff.coeffTable.contract(this.polCoeff.coeffTable);
        return residueSolvableWordPolynomialRing;
    }

    @Override
    public ResidueSolvableWordPolynomialRing<C> reverse() {
        return this.reverse(false);
    }

    @Override
    public ResidueSolvableWordPolynomialRing<C> reverse(boolean bl) {
        GenPolynomialRing genPolynomialRing = super.reverse(bl);
        ResidueSolvableWordPolynomialRing<C> residueSolvableWordPolynomialRing = new ResidueSolvableWordPolynomialRing<C>(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.getVars());
        residueSolvableWordPolynomialRing.partial = bl;
        residueSolvableWordPolynomialRing.table.reverse(this.table);
        residueSolvableWordPolynomialRing.polCoeff.coeffTable.reverse(this.polCoeff.coeffTable);
        return residueSolvableWordPolynomialRing;
    }

    @Override
    public GenSolvablePolynomialRing<WordResidue<C>> permutation(List<Integer> list) {
        if (!this.polCoeff.coeffTable.isEmpty()) {
            throw new UnsupportedOperationException("permutation with coeff relations: " + this);
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = (GenSolvablePolynomialRing)super.permutation(list);
        return genSolvablePolynomialRing;
    }

    public ResidueSolvableWordPolynomial<C> fromPolyCoefficients(GenSolvablePolynomial<GenWordPolynomial<C>> genSolvablePolynomial) {
        GenSolvablePolynomial genSolvablePolynomial2 = ((ResidueSolvableWordPolynomial)this.getZERO()).copy();
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial2;
        }
        RingFactory ringFactory = this.coFac;
        WordResidueRing wordResidueRing = (WordResidueRing)ringFactory;
        for (Map.Entry entry : genSolvablePolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            GenWordPolynomial genWordPolynomial = (GenWordPolynomial)entry.getValue();
            WordResidue wordResidue = new WordResidue(wordResidueRing, genWordPolynomial);
            if (wordResidue.isZERO()) continue;
            genSolvablePolynomial2.doPutToMap(expVector, wordResidue);
        }
        return genSolvablePolynomial2;
    }

    public RecSolvableWordPolynomial<C> toPolyCoefficients(ResidueSolvableWordPolynomial<C> residueSolvableWordPolynomial) {
        GenSolvablePolynomial genSolvablePolynomial = ((RecSolvableWordPolynomial)this.polCoeff.getZERO()).copy();
        if (residueSolvableWordPolynomial == null || residueSolvableWordPolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        for (Map.Entry entry : residueSolvableWordPolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            WordResidue wordResidue = (WordResidue)entry.getValue();
            GenWordPolynomial genWordPolynomial = wordResidue.val;
            if (genWordPolynomial.isZERO()) continue;
            genSolvablePolynomial.doPutToMap(expVector, genWordPolynomial);
        }
        return genSolvablePolynomial;
    }

    public RecSolvableWordPolynomial<C> toPolyCoefficients(GenPolynomial<WordResidue<C>> genPolynomial) {
        GenSolvablePolynomial genSolvablePolynomial = ((RecSolvableWordPolynomial)this.polCoeff.getZERO()).copy();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        for (Map.Entry<ExpVector, WordResidue<C>> entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            WordResidue<C> wordResidue = entry.getValue();
            GenWordPolynomial genWordPolynomial = wordResidue.val;
            if (genWordPolynomial.isZERO()) continue;
            genSolvablePolynomial.doPutToMap(expVector, genWordPolynomial);
        }
        return genSolvablePolynomial;
    }
}

