/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.ResidueSolvableWordPolynomial;
import edu.jas.application.ResidueSolvableWordPolynomialRing;
import edu.jas.application.WordIdeal;
import edu.jas.application.WordResidue;
import edu.jas.application.WordResidueRing;
import edu.jas.arith.BigRational;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.GenWordPolynomialRing;
import edu.jas.poly.RecSolvableWordPolynomial;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import edu.jas.structure.Element;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ResidueSolvableWordPolynomialTest
extends TestCase {
    ResidueSolvableWordPolynomial<BigRational> a;
    ResidueSolvableWordPolynomial<BigRational> b;
    ResidueSolvableWordPolynomial<BigRational> c;
    ResidueSolvableWordPolynomial<BigRational> d;
    ResidueSolvableWordPolynomial<BigRational> e;
    ResidueSolvableWordPolynomial<BigRational> f;
    ResidueSolvableWordPolynomial<BigRational> x1;
    ResidueSolvableWordPolynomial<BigRational> x2;
    int rl = 4;
    int kl = 2;
    int ll = 3;
    int el = 2;
    float q = 0.3f;
    String[] cvars = new String[]{"a", "b"};
    String[] vars = new String[]{"w", "x", "y", "z"};
    WordResidueRing<BigRational> rring;
    WordIdeal<BigRational> wideal;
    ResidueSolvableWordPolynomialRing<BigRational> ring;
    BigRational cfac;
    GenWordPolynomialRing<BigRational> wring;
    GenPolynomialRing<BigRational> cring;
    TermOrder tord = new TermOrder(2);

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ResidueSolvableWordPolynomialTest.suite());
    }

    public ResidueSolvableWordPolynomialTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ResidueSolvableWordPolynomialTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.cfac = new BigRational(1L);
        this.wring = new GenWordPolynomialRing<BigRational>(this.cfac, this.cvars);
        ArrayList arrayList = new ArrayList();
        Element element = this.wring.parse("b a - 1");
        arrayList.add(element);
        this.wideal = new WordIdeal<BigRational>(this.wring, arrayList);
        this.wideal = this.wideal.GB();
        if (this.wideal.isONE()) {
            System.out.println("twosided wideal = " + this.wideal.toScript());
            throw new IllegalArgumentException("ideal is one");
        }
        this.rring = new WordResidueRing<BigRational>(this.wideal);
        this.ring = new ResidueSolvableWordPolynomialRing(this.rring, this.tord, this.vars);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.ring);
        List list = this.ring.table.relationList();
        ArrayList arrayList2 = new ArrayList();
        for (GenSolvablePolynomial genSolvablePolynomial : list) {
            RecSolvableWordPolynomial<BigRational> recSolvableWordPolynomial = this.ring.toPolyCoefficients(genSolvablePolynomial);
            arrayList2.add(recSolvableWordPolynomial);
        }
        this.ring.polCoeff.table.addSolvRelations(arrayList2);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.ring = null;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    public void testConstructor() {
        ResidueSolvableWordPolynomialTest.assertFalse((String)"not commutative", (boolean)this.ring.isCommutative());
        ResidueSolvableWordPolynomialTest.assertTrue((String)"associative", (boolean)this.ring.isAssociative());
        this.a = new ResidueSolvableWordPolynomial<BigRational>(this.ring);
        ResidueSolvableWordPolynomialTest.assertTrue((String)"length( a ) = 0", (this.a.length() == 0 ? 1 : 0) != 0);
        ResidueSolvableWordPolynomialTest.assertTrue((String)"isZERO( a )", (boolean)this.a.isZERO());
        ResidueSolvableWordPolynomialTest.assertTrue((String)"isONE( a )", (!this.a.isONE() ? 1 : 0) != 0);
        this.c = this.ring.getONE();
        ResidueSolvableWordPolynomialTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        ResidueSolvableWordPolynomialTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        ResidueSolvableWordPolynomialTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.ring.getZERO();
        ResidueSolvableWordPolynomialTest.assertTrue((String)"length( d ) = 0", (this.d.length() == 0 ? 1 : 0) != 0);
        ResidueSolvableWordPolynomialTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        ResidueSolvableWordPolynomialTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
        for (GenPolynomial genPolynomial : this.ring.generators()) {
            ResidueSolvableWordPolynomialTest.assertFalse((String)"not isZERO( g )", (boolean)genPolynomial.isZERO());
        }
    }

    public void testRandom() {
        for (int i = 0; i < 3; ++i) {
            this.a = this.ring.random(this.kl * (i + 1), this.ll + 2 * i, this.el + i, this.q);
            ResidueSolvableWordPolynomialTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            ResidueSolvableWordPolynomialTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            ResidueSolvableWordPolynomialTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
            RecSolvableWordPolynomial<BigRational> recSolvableWordPolynomial = this.ring.toPolyCoefficients(this.a);
            this.c = this.ring.fromPolyCoefficients(recSolvableWordPolynomial);
            ResidueSolvableWordPolynomialTest.assertEquals((String)"res(poly(a)) == a", this.a, this.c);
        }
    }

    public void testAddition() {
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = (ResidueSolvableWordPolynomial)this.a.subtract((BigRational)((Object)this.a));
        ResidueSolvableWordPolynomialTest.assertTrue((String)"a-a = 0", (boolean)this.c.isZERO());
        this.b = (ResidueSolvableWordPolynomial)this.a.sum((BigRational)((Object)this.a));
        this.c = (ResidueSolvableWordPolynomial)this.b.subtract((BigRational)((Object)this.a));
        ResidueSolvableWordPolynomialTest.assertEquals((String)"a+a-a = a", this.c, this.a);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = (ResidueSolvableWordPolynomial)this.b.sum((BigRational)((Object)this.a));
        this.d = (ResidueSolvableWordPolynomial)this.a.sum((BigRational)((Object)this.b));
        ResidueSolvableWordPolynomialTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = (ResidueSolvableWordPolynomial)this.a.sum((BigRational)((Object)this.b.sum((BigRational)((Object)this.c))));
        this.e = (ResidueSolvableWordPolynomial)this.a.sum((BigRational)((Object)this.b)).sum(this.c);
        ResidueSolvableWordPolynomialTest.assertEquals((String)"a+(b+c) = (a+b)+c", this.d, this.e);
        ExpVector expVector = ExpVector.random(this.rl, this.el, this.q);
        Element element = this.rring.random(this.kl);
        this.b = ((ResidueSolvableWordPolynomial)this.ring.getONE()).multiply(element, expVector);
        this.c = (ResidueSolvableWordPolynomial)this.a.sum((BigRational)((Object)this.b));
        this.d = (ResidueSolvableWordPolynomial)this.a.sum((BigRational)element, expVector);
        ResidueSolvableWordPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = (ResidueSolvableWordPolynomial)this.a.subtract((BigRational)((Object)this.b));
        this.d = (ResidueSolvableWordPolynomial)this.a.subtract((BigRational)element, expVector);
        ResidueSolvableWordPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.a = this.ring.getZERO();
        this.b = ((ResidueSolvableWordPolynomial)this.ring.getONE()).multiply(element, expVector);
        this.c = (ResidueSolvableWordPolynomial)this.b.sum((BigRational)((Object)this.a));
        this.d = (ResidueSolvableWordPolynomial)this.a.sum((BigRational)element, expVector);
        ResidueSolvableWordPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = (ResidueSolvableWordPolynomial)this.a.subtract((BigRational)((Object)this.b));
        this.d = (ResidueSolvableWordPolynomial)this.a.subtract((BigRational)element, expVector);
        ResidueSolvableWordPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        ResidueSolvableWordPolynomialTest.assertTrue((String)"a*b != b*a", (this.c.equals(this.d) || this.c.leadingExpVector().equals(this.d.leadingExpVector()) ? 1 : 0) != 0);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply(this.b.multiply(this.c));
        this.e = this.a.multiply(this.b).multiply(this.c);
        ResidueSolvableWordPolynomialTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        this.d = (ResidueSolvableWordPolynomial)this.a.monic();
        ResidueSolvableWordPolynomialTest.assertTrue((String)("a.monic(): " + this.d), (((WordResidue)this.d.leadingBaseCoefficient()).isONE() || ((WordResidue)((WordResidue)this.d.leadingBaseCoefficient()).abs()).equals(((WordResidue)this.a.leadingBaseCoefficient()).abs()) ? 1 : 0) != 0);
    }

    public void testDistributive() {
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((ResidueSolvableWordPolynomial)this.b.sum((BigRational)((Object)this.c)));
        this.e = (ResidueSolvableWordPolynomial)this.a.multiply(this.b).sum((BigRational)((Object)this.a.multiply(this.c)));
        ResidueSolvableWordPolynomialTest.assertEquals((String)"a(b+c) = ab+ac", this.d, this.e);
    }

    public void testWordCoeffsRelations() {
        ResidueSolvableWordPolynomialTest.assertTrue((String)"# relations == 2", (this.ring.table.size() == 2 ? 1 : 0) != 0);
        ResidueSolvableWordPolynomialTest.assertFalse((String)"isCommutative()", (boolean)this.ring.isCommutative());
        ResidueSolvableWordPolynomialTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        GenSolvablePolynomial genSolvablePolynomial = this.ring.parse("x");
        Element element = this.wring.parse("a");
        GenSolvablePolynomial genSolvablePolynomial2 = this.ring.parse("a x + b");
        RecSolvableWordPolynomial<BigRational> recSolvableWordPolynomial = this.ring.toPolyCoefficients((ResidueSolvableWordPolynomial<BigRational>)genSolvablePolynomial2);
        this.ring.polCoeff.coeffTable.update(genSolvablePolynomial.leadingExpVector(), ((GenWordPolynomial)element).leadingWord().leadingExpVector(), (GenSolvablePolynomial<GenWordPolynomial<BigRational>>)recSolvableWordPolynomial);
        ResidueSolvableWordPolynomialTest.assertFalse((String)"isCommutative()", (boolean)this.ring.isCommutative());
        ResidueSolvableWordPolynomialTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        List list = this.ring.generators();
        for (GenPolynomial genPolynomial : list) {
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)genPolynomial;
            this.a = new ResidueSolvableWordPolynomial<BigRational>(this.ring, genSolvablePolynomial3);
            for (GenPolynomial genPolynomial2 : list) {
                GenSolvablePolynomial genSolvablePolynomial4 = (GenSolvablePolynomial)genPolynomial2;
                this.b = new ResidueSolvableWordPolynomial<BigRational>(this.ring, genSolvablePolynomial4);
                this.c = this.a.multiply(this.b);
                ExpVector expVector = this.a.leadingExpVector().sum(this.b.leadingExpVector());
                ResidueSolvableWordPolynomialTest.assertTrue((String)"LT(a)*LT(b) == LT(c)", (boolean)this.c.leadingExpVector().equals(expVector));
            }
        }
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        ResidueSolvableWordPolynomialTest.assertTrue((String)"a*b != b*a", (this.c.equals(this.d) || this.c.leadingExpVector().equals(this.d.leadingExpVector()) ? 1 : 0) != 0);
    }

    public void testExtendContractWeyl() {
        GenSolvablePolynomial genSolvablePolynomial = this.ring.parse("x");
        Element element = this.wring.parse("a");
        GenSolvablePolynomial genSolvablePolynomial2 = this.ring.parse("a x + b");
        this.ring.polCoeff.coeffTable.update(genSolvablePolynomial.leadingExpVector(), ((GenWordPolynomial)element).leadingWord().leadingExpVector(), (GenSolvablePolynomial<GenWordPolynomial<BigRational>>)this.ring.toPolyCoefficients((ResidueSolvableWordPolynomial<BigRational>)genSolvablePolynomial2));
        int n = this.rl;
        GenSolvablePolynomialRing genSolvablePolynomialRing = this.ring.extend(n);
        GenSolvablePolynomialRing genSolvablePolynomialRing2 = ((ResidueSolvableWordPolynomialRing)genSolvablePolynomialRing).contract(n);
        ResidueSolvableWordPolynomialTest.assertEquals((String)"ring == pfec", this.ring, (Object)genSolvablePolynomialRing2);
        GenSolvablePolynomial genSolvablePolynomial3 = this.ring.random(this.kl, this.ll, this.el, this.q);
        ResidueSolvableWordPolynomial residueSolvableWordPolynomial = (ResidueSolvableWordPolynomial)genSolvablePolynomial3.extend(genSolvablePolynomialRing, 0, 0L);
        Map map = residueSolvableWordPolynomial.contract(genSolvablePolynomialRing2);
        ArrayList arrayList = new ArrayList(map.values());
        GenPolynomial genPolynomial = (GenPolynomial)arrayList.get(0);
        ResidueSolvableWordPolynomialTest.assertEquals((String)"a == aec", (Object)genSolvablePolynomial3, (Object)genPolynomial);
    }

    public void testReverseWeyl() {
        GenSolvablePolynomial genSolvablePolynomial = this.ring.parse("x");
        Element element = this.wring.parse("a");
        GenSolvablePolynomial genSolvablePolynomial2 = this.ring.parse("a x + b");
        this.ring.polCoeff.coeffTable.update(genSolvablePolynomial.leadingExpVector(), ((GenWordPolynomial)element).leadingWord().leadingExpVector(), (GenSolvablePolynomial<GenWordPolynomial<BigRational>>)this.ring.toPolyCoefficients((ResidueSolvableWordPolynomial<BigRational>)genSolvablePolynomial2));
        GenSolvablePolynomialRing genSolvablePolynomialRing = this.ring.reverse();
        GenSolvablePolynomialRing genSolvablePolynomialRing2 = ((ResidueSolvableWordPolynomialRing)genSolvablePolynomialRing).reverse();
        ResidueSolvableWordPolynomialTest.assertEquals((String)"pf == pfrr", this.ring, (Object)genSolvablePolynomialRing2);
        GenSolvablePolynomial genSolvablePolynomial3 = this.ring.random(this.kl, this.ll, this.el, this.q);
        ResidueSolvableWordPolynomial residueSolvableWordPolynomial = (ResidueSolvableWordPolynomial)genSolvablePolynomial3.reverse(genSolvablePolynomialRing);
        ResidueSolvableWordPolynomial residueSolvableWordPolynomial2 = (ResidueSolvableWordPolynomial)residueSolvableWordPolynomial.reverse(genSolvablePolynomialRing2);
        ResidueSolvableWordPolynomialTest.assertEquals((String)"a == arr", (Object)genSolvablePolynomial3, (Object)residueSolvableWordPolynomial2);
    }
}

