/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Dimension;
import edu.jas.application.Ideal;
import edu.jas.gb.SolvableExtendedGB;
import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.gb.SolvableReduction;
import edu.jas.gb.SolvableReductionSeq;
import edu.jas.gbufd.PolyGBUtil;
import edu.jas.gbufd.SGBFactory;
import edu.jas.gbufd.SolvableSyzygySeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.NotInvertibleException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SolvableIdeal<C extends GcdRingElem<C>>
implements Comparable<SolvableIdeal<C>>,
Serializable {
    private static final Logger logger = LogManager.getLogger(SolvableIdeal.class);
    private static final boolean debug = logger.isDebugEnabled();
    protected PolynomialList<C> list;
    protected boolean isGB;
    protected Side sided;
    protected boolean testGB;
    protected boolean isTopt;
    protected final SolvableGroebnerBaseAbstract<C> bb;
    protected final SolvableReduction<C> red;

    public SolvableIdeal(GenSolvablePolynomialRing<C> genSolvablePolynomialRing) {
        this(genSolvablePolynomialRing, new ArrayList<GenSolvablePolynomial<C>>());
    }

    public SolvableIdeal(GenSolvablePolynomialRing<C> genSolvablePolynomialRing, List<GenSolvablePolynomial<C>> list) {
        this(new PolynomialList<C>(genSolvablePolynomialRing, list));
    }

    public SolvableIdeal(GenSolvablePolynomialRing<C> genSolvablePolynomialRing, List<GenSolvablePolynomial<C>> list, boolean bl) {
        this(new PolynomialList<C>(genSolvablePolynomialRing, list), bl);
    }

    public SolvableIdeal(GenSolvablePolynomialRing<C> genSolvablePolynomialRing, List<GenSolvablePolynomial<C>> list, boolean bl, boolean bl2) {
        this(new PolynomialList<C>(genSolvablePolynomialRing, list), bl, bl2);
    }

    public SolvableIdeal(GenSolvablePolynomialRing<C> genSolvablePolynomialRing, List<GenSolvablePolynomial<C>> list, Side side) {
        this(new PolynomialList<C>(genSolvablePolynomialRing, list), false, false, side);
    }

    public SolvableIdeal(GenSolvablePolynomialRing<C> genSolvablePolynomialRing, List<GenSolvablePolynomial<C>> list, boolean bl, Side side) {
        this(new PolynomialList<C>(genSolvablePolynomialRing, list), bl, false, side);
    }

    public SolvableIdeal(PolynomialList<C> polynomialList) {
        this(polynomialList, false);
    }

    public SolvableIdeal(PolynomialList<C> polynomialList, SolvableGroebnerBaseAbstract<C> solvableGroebnerBaseAbstract, SolvableReduction<C> solvableReduction) {
        this(polynomialList, false, solvableGroebnerBaseAbstract, solvableReduction);
    }

    public SolvableIdeal(PolynomialList<C> polynomialList, boolean bl) {
        this(polynomialList, bl, SGBFactory.getImplementation(polynomialList.ring.coFac), new SolvableReductionSeq());
    }

    public SolvableIdeal(PolynomialList<C> polynomialList, boolean bl, boolean bl2) {
        this(polynomialList, bl, bl2, SGBFactory.getImplementation(polynomialList.ring.coFac), new SolvableReductionSeq());
    }

    public SolvableIdeal(PolynomialList<C> polynomialList, boolean bl, Side side) {
        this(polynomialList, bl, false, SGBFactory.getImplementation(polynomialList.ring.coFac), new SolvableReductionSeq(), side);
    }

    public SolvableIdeal(PolynomialList<C> polynomialList, boolean bl, boolean bl2, Side side) {
        this(polynomialList, bl, bl2, SGBFactory.getImplementation(polynomialList.ring.coFac), new SolvableReductionSeq(), side);
    }

    public SolvableIdeal(PolynomialList<C> polynomialList, boolean bl, SolvableGroebnerBaseAbstract<C> solvableGroebnerBaseAbstract, SolvableReduction<C> solvableReduction) {
        this(polynomialList, bl, false, solvableGroebnerBaseAbstract, solvableReduction);
    }

    public SolvableIdeal(PolynomialList<C> polynomialList, boolean bl, SolvableGroebnerBaseAbstract<C> solvableGroebnerBaseAbstract) {
        this(polynomialList, bl, false, solvableGroebnerBaseAbstract, solvableGroebnerBaseAbstract.sred);
    }

    public SolvableIdeal(PolynomialList<C> polynomialList, boolean bl, boolean bl2, SolvableGroebnerBaseAbstract<C> solvableGroebnerBaseAbstract) {
        this(polynomialList, bl, bl2, solvableGroebnerBaseAbstract, solvableGroebnerBaseAbstract.sred);
    }

    public SolvableIdeal(PolynomialList<C> polynomialList, boolean bl, boolean bl2, SolvableGroebnerBaseAbstract<C> solvableGroebnerBaseAbstract, SolvableReduction<C> solvableReduction) {
        this(polynomialList, bl, bl2, solvableGroebnerBaseAbstract, solvableReduction, Side.left);
    }

    public SolvableIdeal(PolynomialList<C> polynomialList, boolean bl, boolean bl2, SolvableGroebnerBaseAbstract<C> solvableGroebnerBaseAbstract, SolvableReduction<C> solvableReduction, Side side) {
        if (polynomialList == null || polynomialList.list == null) {
            throw new IllegalArgumentException("list and list.list may not be null");
        }
        this.list = polynomialList;
        this.isGB = bl;
        this.isTopt = bl2;
        this.testGB = bl;
        this.bb = solvableGroebnerBaseAbstract;
        this.red = solvableReduction;
        if (side == null) {
            side = Side.left;
        }
        this.sided = side;
    }

    public SolvableIdeal<C> copy() {
        return new SolvableIdeal<C>(this.list.copy(), this.isGB, this.isTopt, this.bb, this.red, this.sided);
    }

    public List<GenSolvablePolynomial<C>> getList() {
        return this.list.getSolvableList();
    }

    public GenSolvablePolynomialRing<C> getRing() {
        return this.list.getSolvableRing();
    }

    public SolvableIdeal<C> getZERO() {
        ArrayList arrayList = new ArrayList(0);
        PolynomialList<C> polynomialList = new PolynomialList<C>(this.getRing(), arrayList);
        return new SolvableIdeal<C>(polynomialList, true, this.isTopt, this.bb, this.red, this.sided);
    }

    public SolvableIdeal<C> getONE() {
        ArrayList arrayList = new ArrayList(1);
        arrayList.add(this.getRing().getONE());
        PolynomialList<C> polynomialList = new PolynomialList<C>(this.getRing(), arrayList);
        return new SolvableIdeal<C>(polynomialList, true, this.isTopt, this.bb, this.red, this.sided);
    }

    public String toString() {
        return this.list.toString() + " # " + (Object)((Object)this.sided);
    }

    public String toScript() {
        return this.list.toScript() + " # " + (Object)((Object)this.sided);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SolvableIdeal)) {
            logger.warn("equals no Ideal");
            return false;
        }
        SolvableIdeal solvableIdeal = null;
        try {
            solvableIdeal = (SolvableIdeal)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return this.contains(solvableIdeal) && solvableIdeal.contains(this);
    }

    @Override
    public int compareTo(SolvableIdeal<C> solvableIdeal) {
        return this.list.compareTo(solvableIdeal.list);
    }

    public int hashCode() {
        int n = this.list.hashCode();
        if (this.isGB) {
            n <<= 1;
        }
        if (this.testGB) {
            ++n;
        }
        return n;
    }

    public boolean isZERO() {
        return this.list.isZERO();
    }

    public boolean isONE() {
        return this.list.isONE();
    }

    public boolean isGB() {
        if (this.testGB && this.sided == Side.left) {
            return this.isGB;
        }
        logger.warn("isLeftGB computing");
        boolean bl = this.bb.isLeftGB(this.getList());
        if (this.sided != Side.left) {
            logger.warn("wrong usage for is left sided GB: " + (Object)((Object)this.sided));
        } else {
            this.isGB = bl;
            this.testGB = true;
        }
        return bl;
    }

    public void doGB() {
        if (this.isGB && this.sided == Side.left) {
            return;
        }
        if (this.isGB && this.sided == Side.twosided) {
            return;
        }
        if (this.sided == Side.right) {
            logger.warn("wrong usage for left sided GB: " + (Object)((Object)this.sided));
            throw new IllegalArgumentException("wrong usage for left sided GB: " + (Object)((Object)this.sided));
        }
        List<GenSolvablePolynomial<C>> list = this.getList();
        if (this.sided == Side.left) {
            logger.info("leftGB computing = " + list);
            list = this.bb.leftGB(list);
        }
        if (this.sided == Side.twosided) {
            logger.info("twosidedGB computing = " + list);
            list = this.bb.twosidedGB(list);
        }
        this.list = new PolynomialList<C>(this.getRing(), list);
        this.isGB = true;
        this.testGB = true;
    }

    public SolvableIdeal<C> GB() {
        if (this.isGB && this.sided == Side.left) {
            return this;
        }
        this.doGB();
        return this;
    }

    public boolean isTwosidedGB() {
        if (this.testGB && this.sided == Side.twosided) {
            return this.isGB;
        }
        logger.warn("isTwosidedGB computing");
        this.isGB = this.bb.isTwosidedGB(this.getList());
        this.testGB = true;
        this.sided = Side.twosided;
        return this.isGB;
    }

    public SolvableIdeal<C> twosidedGB() {
        if (this.isGB && this.sided == Side.twosided) {
            return this;
        }
        List<GenSolvablePolynomial<C>> list = this.getList();
        logger.info("twosidedGB computing = " + list);
        list = this.bb.twosidedGB(list);
        PolynomialList<C> polynomialList = new PolynomialList<C>(this.getRing(), list);
        SolvableIdeal<C> solvableIdeal = new SolvableIdeal<C>(polynomialList, true, true, this.bb, this.red, Side.twosided);
        return solvableIdeal;
    }

    public boolean isRightGB() {
        if (this.testGB && this.sided == Side.right) {
            return this.isGB;
        }
        if (this.isGB && this.sided == Side.twosided) {
            return true;
        }
        logger.warn("isRightGB computing");
        this.isGB = this.bb.isRightGB(this.getList());
        this.testGB = true;
        this.sided = Side.right;
        return this.isGB;
    }

    public SolvableIdeal<C> rightGB() {
        if (this.isGB && this.sided == Side.twosided) {
            return this;
        }
        if (this.isGB && this.sided == Side.right) {
            return this;
        }
        List<GenSolvablePolynomial<C>> list = this.getList();
        logger.info("rightGB computing = " + list);
        list = this.bb.rightGB(list);
        PolynomialList<C> polynomialList = new PolynomialList<C>(this.getRing(), list);
        SolvableIdeal<C> solvableIdeal = new SolvableIdeal<C>(polynomialList, true, true, this.bb, this.red, Side.right);
        return solvableIdeal;
    }

    public boolean contains(SolvableIdeal<C> solvableIdeal) {
        if (solvableIdeal == null || solvableIdeal.isZERO()) {
            return true;
        }
        return this.contains(solvableIdeal.getList());
    }

    public boolean contains(GenSolvablePolynomial<C> genSolvablePolynomial) {
        GenSolvablePolynomial<C> genSolvablePolynomial2;
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return true;
        }
        if (this.isONE()) {
            return true;
        }
        if (this.isZERO()) {
            return false;
        }
        if (!this.isGB) {
            this.doGB();
        }
        return (genSolvablePolynomial2 = this.red.leftNormalform(this.getList(), genSolvablePolynomial)) == null || genSolvablePolynomial2.isZERO();
    }

    public boolean contains(List<GenSolvablePolynomial<C>> list) {
        if (list == null || list.size() == 0) {
            return true;
        }
        if (this.isONE()) {
            return true;
        }
        if (!this.isGB) {
            this.doGB();
        }
        List<GenSolvablePolynomial<C>> list2 = this.getList();
        for (GenSolvablePolynomial<C> genSolvablePolynomial : list) {
            GenSolvablePolynomial<C> genSolvablePolynomial2;
            if (genSolvablePolynomial == null || (genSolvablePolynomial2 = this.red.leftNormalform(list2, genSolvablePolynomial)).isZERO()) continue;
            logger.info("contains nf(b) != 0: " + genSolvablePolynomial2 + " of " + genSolvablePolynomial);
            return false;
        }
        return true;
    }

    public SolvableIdeal<C> sum(SolvableIdeal<C> solvableIdeal) {
        if (solvableIdeal == null || solvableIdeal.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return solvableIdeal;
        }
        int n = this.getList().size() + solvableIdeal.getList().size();
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>(n);
        arrayList.addAll(this.getList());
        arrayList.addAll(solvableIdeal.getList());
        SolvableIdeal<C> solvableIdeal2 = new SolvableIdeal<C>(this.getRing(), arrayList, false, this.sided);
        if (this.isGB && solvableIdeal.isGB) {
            solvableIdeal2.doGB();
        }
        return solvableIdeal2;
    }

    public SolvableIdeal<C> sum(GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return this;
        }
        int n = this.getList().size() + 1;
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>(n);
        arrayList.addAll(this.getList());
        arrayList.add(genSolvablePolynomial);
        SolvableIdeal<C> solvableIdeal = new SolvableIdeal<C>(this.getRing(), arrayList, false, this.sided);
        if (this.isGB) {
            solvableIdeal.doGB();
        }
        return solvableIdeal;
    }

    public SolvableIdeal<C> sum(List<GenSolvablePolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return this;
        }
        int n = this.getList().size() + list.size();
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>(n);
        arrayList.addAll(this.getList());
        arrayList.addAll(list);
        SolvableIdeal<C> solvableIdeal = new SolvableIdeal<C>(this.getRing(), arrayList, false, this.sided);
        if (this.isGB) {
            solvableIdeal.doGB();
        }
        return solvableIdeal;
    }

    public SolvableIdeal<C> product(SolvableIdeal<C> solvableIdeal) {
        if (solvableIdeal == null || solvableIdeal.isZERO()) {
            return solvableIdeal;
        }
        if (this.isZERO()) {
            return this;
        }
        int n = this.getList().size() * solvableIdeal.getList().size();
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>(n);
        for (GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial : this.getList()) {
            for (GenSolvablePolynomial<Object> genSolvablePolynomial2 : solvableIdeal.getList()) {
                genSolvablePolynomial2 = genSolvablePolynomial.multiply(genSolvablePolynomial2);
                arrayList.add(genSolvablePolynomial2);
            }
        }
        SolvableIdeal<C> solvableIdeal2 = new SolvableIdeal<C>(this.getRing(), arrayList, false, this.sided);
        if (this.isGB && solvableIdeal.isGB) {
            solvableIdeal2.doGB();
        }
        return solvableIdeal2;
    }

    public SolvableIdeal<C> product(GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return this.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>(this.getList().size());
        for (GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial2 : this.getList()) {
            GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial3 = genSolvablePolynomial2.multiply(genSolvablePolynomial);
            arrayList.add(genSolvablePolynomial3);
        }
        SolvableIdeal<C> solvableIdeal = new SolvableIdeal<C>(this.getRing(), arrayList, false, this.sided);
        if (this.isGB) {
            solvableIdeal.doGB();
        }
        return solvableIdeal;
    }

    public SolvableIdeal<C> intersect(List<SolvableIdeal<C>> list) {
        if (list == null || list.size() == 0) {
            return this.getZERO();
        }
        SolvableIdeal<C> solvableIdeal = null;
        for (SolvableIdeal<C> solvableIdeal2 : list) {
            if (solvableIdeal == null) {
                solvableIdeal = solvableIdeal2;
                continue;
            }
            if (solvableIdeal.isONE()) {
                return solvableIdeal;
            }
            solvableIdeal = solvableIdeal.intersect(solvableIdeal2);
        }
        return solvableIdeal;
    }

    public SolvableIdeal<C> intersect(SolvableIdeal<C> solvableIdeal) {
        if (solvableIdeal == null || solvableIdeal.isZERO()) {
            return solvableIdeal;
        }
        if (this.isZERO()) {
            return this;
        }
        List<GenSolvablePolynomial<C>> list = PolyGBUtil.intersect(this.getRing(), this.getList(), solvableIdeal.getList());
        SolvableIdeal<C> solvableIdeal2 = new SolvableIdeal<C>(this.getRing(), list, true, this.sided);
        return solvableIdeal2;
    }

    public SolvableIdeal<C> intersect(GenSolvablePolynomialRing<C> genSolvablePolynomialRing) {
        if (genSolvablePolynomialRing == null) {
            throw new IllegalArgumentException("R may not be null");
        }
        String[] stringArray = genSolvablePolynomialRing.getVars();
        String[] stringArray2 = this.getRing().getVars();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(stringArray2[i])) continue;
            throw new IllegalArgumentException("no contraction: " + genSolvablePolynomialRing.toScript() + " of " + this.getRing().toScript());
        }
        List<GenSolvablePolynomial<C>> list = PolyUtil.intersect(genSolvablePolynomialRing, this.getList());
        return new SolvableIdeal<C>(genSolvablePolynomialRing, list, this.isGB, this.sided);
    }

    public SolvableIdeal<C> eliminate(GenSolvablePolynomialRing<C> genSolvablePolynomialRing) {
        if (genSolvablePolynomialRing == null) {
            throw new IllegalArgumentException("R may not be null");
        }
        if (this.getRing().equals(genSolvablePolynomialRing)) {
            return this;
        }
        return this.intersect(genSolvablePolynomialRing);
    }

    public SolvableIdeal<C> quotient(GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (genSolvablePolynomial == null) {
            return this;
        }
        if (genSolvablePolynomial.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>(1);
        arrayList.add(genSolvablePolynomial);
        SolvableIdeal<C> solvableIdeal = new SolvableIdeal<C>(this.getRing(), arrayList, true, this.sided);
        SolvableIdeal<C> solvableIdeal2 = this.intersect(solvableIdeal);
        ArrayList<GenSolvablePolynomial<C>> arrayList2 = new ArrayList<GenSolvablePolynomial<C>>(solvableIdeal2.getList().size());
        for (GenSolvablePolynomial<C> genSolvablePolynomial2 : solvableIdeal2.getList()) {
            GenSolvablePolynomial<C> genSolvablePolynomial3;
            GenPolynomial genPolynomial = genSolvablePolynomial2.divide(genSolvablePolynomial);
            if (!genPolynomial.isZERO()) {
                genPolynomial = genPolynomial.monic();
                arrayList2.add((GenSolvablePolynomial<C>)genPolynomial);
            }
            if (!debug || (genSolvablePolynomial3 = genSolvablePolynomial2.remainder(genSolvablePolynomial)).isZERO()) continue;
            System.out.println("error remainder !=0: " + genSolvablePolynomial3 + ", q = " + genSolvablePolynomial2 + ", h = " + genSolvablePolynomial);
            throw new RuntimeException("remainder !=0");
        }
        return new SolvableIdeal<C>(this.getRing(), arrayList2, true, this.sided);
    }

    public SolvableIdeal<C> quotient(SolvableIdeal<C> solvableIdeal) {
        if (solvableIdeal == null || solvableIdeal.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        SolvableIdeal<C> solvableIdeal2 = null;
        for (GenSolvablePolynomial<C> genSolvablePolynomial : solvableIdeal.getList()) {
            SolvableIdeal<C> solvableIdeal3 = this.quotient(genSolvablePolynomial);
            if (solvableIdeal2 == null) {
                solvableIdeal2 = solvableIdeal3;
                continue;
            }
            solvableIdeal2 = solvableIdeal2.intersect(solvableIdeal3);
        }
        return solvableIdeal2;
    }

    public SolvableIdeal<C> infiniteQuotientRab(GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return this.getONE();
        }
        if (genSolvablePolynomial.isONE()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        if (!this.getRing().isCommutative()) {
            throw new UnsupportedOperationException("Rabinowich trick only for commutative polynomial rings");
        }
        SolvableIdeal<C> solvableIdeal = this.GB();
        List<GenSolvablePolynomial<C>> list = solvableIdeal.getList();
        ArrayList arrayList = new ArrayList(list.size() + 1);
        GenPolynomialRing genPolynomialRing = this.getRing().extend(1);
        for (GenSolvablePolynomial<C> genSolvablePolynomial2 : list) {
            GenSolvablePolynomial genSolvablePolynomial22 = (GenSolvablePolynomial)genSolvablePolynomial2.extend(genPolynomialRing, 0, 0L);
            arrayList.add(genSolvablePolynomial22);
        }
        GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)genSolvablePolynomial.extend(genPolynomialRing, 0, 1L);
        GenPolynomial genPolynomial = ((GenSolvablePolynomialRing)genPolynomialRing).getONE();
        GenSolvablePolynomial genSolvablePolynomial4 = (GenSolvablePolynomial)genSolvablePolynomial3.subtract(genPolynomial);
        arrayList.add(genSolvablePolynomial4);
        logger.warn("infiniteQuotientRab computing GB ");
        List<GenSolvablePolynomial<C>> list2 = this.bb.leftGB(arrayList);
        if (debug) {
            logger.info("infiniteQuotientRab    = " + genPolynomialRing + ", c = " + arrayList);
            logger.info("infiniteQuotientRab GB = " + list2);
        }
        SolvableIdeal<C> solvableIdeal2 = new SolvableIdeal<C>(genPolynomialRing, list2, true, this.sided);
        SolvableIdeal<C> solvableIdeal3 = solvableIdeal2.intersect(this.getRing());
        return solvableIdeal3;
    }

    public int infiniteQuotientExponent(GenSolvablePolynomial<C> genSolvablePolynomial, SolvableIdeal<C> solvableIdeal) {
        int n = 0;
        if (genSolvablePolynomial == null) {
            return n;
        }
        if (genSolvablePolynomial.isZERO() || genSolvablePolynomial.isONE()) {
            return n;
        }
        if (this.isZERO() || this.isONE()) {
            return n;
        }
        GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>> genSolvablePolynomial2 = this.getRing().getONE();
        for (GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>>> genSolvablePolynomial3 : solvableIdeal.getList()) {
            if (this.contains(genSolvablePolynomial3)) continue;
            GenSolvablePolynomial<GenPolynomial> genSolvablePolynomial4 = genSolvablePolynomial3.multiply(genSolvablePolynomial2);
            while (!this.contains(genSolvablePolynomial4)) {
                genSolvablePolynomial2 = genSolvablePolynomial2.multiply((GenSolvablePolynomial<GenSolvablePolynomial<C>>)genSolvablePolynomial);
                ++n;
                genSolvablePolynomial4 = genSolvablePolynomial3.multiply(genSolvablePolynomial2);
            }
        }
        return n;
    }

    public SolvableIdeal<C> infiniteQuotient(GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (genSolvablePolynomial == null) {
            return this;
        }
        if (genSolvablePolynomial.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        int n = 0;
        SolvableIdeal<C> solvableIdeal = this.GB();
        GenSolvablePolynomial<C> genSolvablePolynomial2 = genSolvablePolynomial;
        SolvableIdeal<C> solvableIdeal2 = null;
        logger.info("infiniteQuotient hs = " + genSolvablePolynomial2);
        long l = -1L;
        boolean bl = false;
        while (!bl) {
            solvableIdeal2 = solvableIdeal.quotient(genSolvablePolynomial2);
            solvableIdeal2 = solvableIdeal2.GB();
            logger.info("infiniteQuotient s = " + n);
            if (solvableIdeal2.isZERO()) {
                logger.warn("infiniteQuotient does not exist");
                return solvableIdeal;
            }
            bl = solvableIdeal2.contains(solvableIdeal);
            if (bl) continue;
            long l2 = PolyUtil.totalDegree(solvableIdeal2.list.getList());
            if (l < 0L) {
                l = l2;
            }
            if (l2 > l) {
                logger.warn("no convergence in infiniteQuotient (dm,ds): " + l + " < " + l2);
                return solvableIdeal;
            }
            solvableIdeal = solvableIdeal2;
            ++n;
        }
        return solvableIdeal2;
    }

    public boolean isRadicalMember(GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (genSolvablePolynomial == null) {
            return true;
        }
        if (genSolvablePolynomial.isZERO()) {
            return true;
        }
        if (this.isZERO()) {
            return true;
        }
        SolvableIdeal<C> solvableIdeal = this.infiniteQuotientRab(genSolvablePolynomial);
        if (debug) {
            logger.debug("infiniteQuotientRab = " + solvableIdeal);
        }
        return solvableIdeal.isONE();
    }

    public SolvableIdeal<C> infiniteQuotient(SolvableIdeal<C> solvableIdeal) {
        if (solvableIdeal == null) {
            return this;
        }
        if (solvableIdeal.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        SolvableIdeal<C> solvableIdeal2 = null;
        for (GenSolvablePolynomial<C> genSolvablePolynomial : solvableIdeal.getList()) {
            SolvableIdeal<C> solvableIdeal3 = this.infiniteQuotient(genSolvablePolynomial);
            if (solvableIdeal2 == null) {
                solvableIdeal2 = solvableIdeal3;
                continue;
            }
            solvableIdeal2 = solvableIdeal2.intersect(solvableIdeal3);
        }
        return solvableIdeal2;
    }

    public SolvableIdeal<C> infiniteQuotientRab(SolvableIdeal<C> solvableIdeal) {
        if (solvableIdeal == null) {
            return this;
        }
        if (solvableIdeal.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        SolvableIdeal<C> solvableIdeal2 = null;
        for (GenSolvablePolynomial<C> genSolvablePolynomial : solvableIdeal.getList()) {
            SolvableIdeal<C> solvableIdeal3 = this.infiniteQuotientRab(genSolvablePolynomial);
            if (solvableIdeal2 == null) {
                solvableIdeal2 = solvableIdeal3;
                continue;
            }
            solvableIdeal2 = solvableIdeal2.intersect(solvableIdeal3);
        }
        return solvableIdeal2;
    }

    public SolvableIdeal<C> power(int n) {
        if (n <= 0) {
            return this.getONE();
        }
        if (this.isZERO() || this.isONE()) {
            return this;
        }
        SolvableIdeal<C> solvableIdeal = this;
        for (int i = 1; i < n; ++i) {
            solvableIdeal = solvableIdeal.product(this);
        }
        return solvableIdeal;
    }

    public GenSolvablePolynomial<C> normalform(GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (genSolvablePolynomial == null) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        if (this.isZERO()) {
            return genSolvablePolynomial;
        }
        GenSolvablePolynomial<C> genSolvablePolynomial2 = this.red.leftNormalform(this.getList(), genSolvablePolynomial);
        return genSolvablePolynomial2;
    }

    public List<GenSolvablePolynomial<C>> normalform(List<GenSolvablePolynomial<C>> list) {
        if (list == null) {
            return list;
        }
        if (list.size() == 0) {
            return list;
        }
        if (this.isZERO()) {
            return list;
        }
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>(list.size());
        for (GenSolvablePolynomial<C> genSolvablePolynomial : list) {
            GenSolvablePolynomial<C> genSolvablePolynomial2 = this.normalform(genSolvablePolynomial);
            if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) continue;
            arrayList.add(genSolvablePolynomial2);
        }
        return arrayList;
    }

    public SolvableIdeal<C> annihilator(GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return this.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        this.doGB();
        ArrayList arrayList = new ArrayList(1 + this.getList().size());
        arrayList.add(genSolvablePolynomial);
        arrayList.addAll(this.getList());
        SolvableSyzygySeq solvableSyzygySeq = new SolvableSyzygySeq(this.getRing().coFac);
        List list = solvableSyzygySeq.leftZeroRelationsArbitrary(arrayList);
        ArrayList<GenSolvablePolynomial<C>> arrayList2 = new ArrayList<GenSolvablePolynomial<C>>(list.size());
        for (List list2 : list) {
            GenSolvablePolynomial genSolvablePolynomial2;
            if (list2 == null || list2.isEmpty() || (genSolvablePolynomial2 = list2.get(0)) == null || genSolvablePolynomial2.isZERO()) continue;
            arrayList2.add(genSolvablePolynomial2);
        }
        SolvableIdeal<C> solvableIdeal = new SolvableIdeal<C>(this.getRing(), arrayList2, false, this.sided);
        return solvableIdeal;
    }

    public boolean isAnnihilator(GenSolvablePolynomial<C> genSolvablePolynomial, SolvableIdeal<C> solvableIdeal) {
        SolvableIdeal<C> solvableIdeal2 = solvableIdeal.product(genSolvablePolynomial);
        return this.contains(solvableIdeal2);
    }

    public SolvableIdeal<C> annihilator(SolvableIdeal<C> solvableIdeal) {
        if (solvableIdeal == null || solvableIdeal.isZERO()) {
            return this.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        SolvableIdeal<C> solvableIdeal2 = null;
        for (GenSolvablePolynomial<C> genSolvablePolynomial : solvableIdeal.getList()) {
            SolvableIdeal<C> solvableIdeal3 = this.annihilator(genSolvablePolynomial);
            if (solvableIdeal2 == null) {
                solvableIdeal2 = solvableIdeal3;
                continue;
            }
            solvableIdeal2 = solvableIdeal2.intersect(solvableIdeal3);
        }
        return solvableIdeal2;
    }

    public boolean isAnnihilator(SolvableIdeal<C> solvableIdeal, SolvableIdeal<C> solvableIdeal2) {
        SolvableIdeal<C> solvableIdeal3 = solvableIdeal2.product(solvableIdeal);
        return this.contains(solvableIdeal3);
    }

    /*
     * WARNING - void declaration
     */
    public GenSolvablePolynomial<C> inverse(GenSolvablePolynomial<C> genSolvablePolynomial) {
        void var8_11;
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            throw new NotInvertibleException("zero not invertible");
        }
        if (this.isZERO()) {
            throw new NotInvertibleException("zero ideal");
        }
        if (genSolvablePolynomial.isUnit()) {
            return (GenSolvablePolynomial)genSolvablePolynomial.inverse();
        }
        this.doGB();
        ArrayList arrayList = new ArrayList(1 + this.list.list.size());
        arrayList.add(genSolvablePolynomial);
        arrayList.addAll(this.getList());
        SolvableExtendedGB<C> solvableExtendedGB = this.bb.extLeftGB(arrayList);
        List list = solvableExtendedGB.G;
        GenSolvablePolynomial genSolvablePolynomial2 = null;
        int n = -1;
        for (GenSolvablePolynomial genPolynomial2 : list) {
            ++n;
            if (genPolynomial2 == null || !genPolynomial2.isUnit()) continue;
            genSolvablePolynomial2 = genPolynomial2;
            break;
        }
        if (genSolvablePolynomial2 == null) {
            throw new NotInvertibleException("one == null: h = " + genSolvablePolynomial);
        }
        List list2 = solvableExtendedGB.G2F.get(n);
        GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)list2.get(0);
        if (genSolvablePolynomial3 == null || genSolvablePolynomial3.isZERO()) {
            throw new NotInvertibleException("g == 0: h = " + genSolvablePolynomial);
        }
        GenSolvablePolynomial<C> genSolvablePolynomial4 = this.red.leftNormalform(this.getList(), genSolvablePolynomial3);
        if (genSolvablePolynomial4.isZERO()) {
            throw new NotInvertibleException("solv|gp == 0: h = " + genSolvablePolynomial + ", g = " + genSolvablePolynomial3);
        }
        GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial5 = genSolvablePolynomial3.multiply(genSolvablePolynomial);
        GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial6 = this.red.leftNormalform(this.getList(), genSolvablePolynomial5);
        if (!genSolvablePolynomial6.isONE()) {
            GcdRingElem gcdRingElem = (GcdRingElem)genSolvablePolynomial6.leadingBaseCoefficient();
            gcdRingElem = (GcdRingElem)gcdRingElem.inverse();
            GenPolynomial genPolynomial = genSolvablePolynomial3.multiply(gcdRingElem);
        }
        if (debug) {
            genSolvablePolynomial5 = var8_11.multiply(genSolvablePolynomial);
            genSolvablePolynomial6 = this.red.leftNormalform(this.getList(), genSolvablePolynomial5);
            logger.debug("inv k = " + genSolvablePolynomial6);
            if (!genSolvablePolynomial6.isUnit()) {
                throw new NotInvertibleException(" k = " + genSolvablePolynomial6);
            }
        }
        return var8_11;
    }

    public boolean isUnit(GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return false;
        }
        if (this.isZERO()) {
            return false;
        }
        ArrayList arrayList = new ArrayList(1 + this.list.list.size());
        arrayList.add(genSolvablePolynomial);
        arrayList.addAll(this.getList());
        List<GenSolvablePolynomial<C>> list = this.bb.leftGB(arrayList);
        for (GenSolvablePolynomial<C> genSolvablePolynomial2 : list) {
            if (genSolvablePolynomial2 == null || !genSolvablePolynomial2.isUnit()) continue;
            return true;
        }
        return false;
    }

    public int commonZeroTest() {
        if (this.isZERO()) {
            return 1;
        }
        if (!this.isGB) {
            this.doGB();
        }
        if (this.isONE()) {
            return -1;
        }
        return this.bb.commonZeroTest(this.getList());
    }

    public boolean isMaximal() {
        if (this.commonZeroTest() != 0) {
            return false;
        }
        for (Long l : this.univariateDegrees()) {
            if (l <= 1L) continue;
            return false;
        }
        return true;
    }

    public List<Long> univariateDegrees() {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (this.isZERO()) {
            return arrayList;
        }
        if (!this.isGB) {
            this.doGB();
        }
        if (this.isONE()) {
            return arrayList;
        }
        return this.bb.univariateDegrees(this.getList());
    }

    public Dimension dimension() {
        Ideal<C> ideal = new Ideal<C>(this.list);
        return ideal.dimension();
    }

    public List<GenSolvablePolynomial<C>> constructUnivariate() {
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>();
        for (int i = this.getRing().nvar - 1; i >= 0; --i) {
            GenSolvablePolynomial<C> genSolvablePolynomial = this.constructUnivariate(i);
            arrayList.add(genSolvablePolynomial);
        }
        return arrayList;
    }

    public GenSolvablePolynomial<C> constructUnivariate(int n) {
        this.doGB();
        return this.bb.constructUnivariate(n, this.getList());
    }

    public static enum Side {
        left,
        right,
        twosided;

    }
}

