/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModIntRing;
import edu.jas.arith.Modular;
import edu.jas.arith.ModularNotInvertibleException;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.NotInvertibleException;

public final class ModInt
implements GcdRingElem<ModInt>,
Modular {
    public final ModIntRing ring;
    public final int val;

    public ModInt(ModIntRing modIntRing, java.math.BigInteger bigInteger) {
        this(modIntRing, bigInteger.mod(modIntRing.getModul()).intValue());
    }

    public ModInt(ModIntRing modIntRing, int n) {
        this.ring = modIntRing;
        int n2 = n % this.ring.modul;
        this.val = n2 >= 0 ? n2 : n2 + this.ring.modul;
    }

    public ModInt(ModIntRing modIntRing, long l) {
        this.ring = modIntRing;
        int n = (int)l % this.ring.modul;
        this.val = n >= 0 ? n : n + this.ring.modul;
    }

    public ModInt(ModIntRing modIntRing, Integer n) {
        this(modIntRing, (int)n);
    }

    public ModInt(ModIntRing modIntRing, Long l) {
        this(modIntRing, l.intValue());
    }

    public ModInt(ModIntRing modIntRing, String string) {
        this(modIntRing, Integer.valueOf(string.trim()));
    }

    public ModInt(ModIntRing modIntRing) {
        this(modIntRing, 0);
    }

    public int getVal() {
        return this.val;
    }

    public int getModul() {
        return this.ring.modul;
    }

    public ModIntRing factory() {
        return this.ring;
    }

    public int getSymmetricVal() {
        if (this.val + this.val > this.ring.modul) {
            return this.val - this.ring.modul;
        }
        return this.val;
    }

    @Override
    public BigInteger getInteger() {
        return new BigInteger(this.val);
    }

    @Override
    public BigInteger getSymmetricInteger() {
        int n = this.val;
        if (this.val + this.val > this.ring.modul) {
            n = this.val - this.ring.modul;
        }
        return new BigInteger(n);
    }

    @Override
    public ModInt copy() {
        return new ModInt(this.ring, this.val);
    }

    @Override
    public boolean isZERO() {
        return this.val == 0;
    }

    @Override
    public boolean isONE() {
        return (long)this.val == 1L;
    }

    @Override
    public boolean isUnit() {
        if (this.isZERO()) {
            return false;
        }
        if (this.ring.isField()) {
            return true;
        }
        int n = this.gcd(this.ring.modul, this.val);
        return (long)n == 1L || (long)n == -1L;
    }

    public String toString() {
        return Integer.toString(this.val);
    }

    @Override
    public String toScript() {
        return this.toString();
    }

    @Override
    public String toScriptFactory() {
        return this.factory().toScript();
    }

    @Override
    public int compareTo(ModInt modInt) {
        int n = modInt.val;
        if (this.ring != modInt.ring) {
            n %= this.ring.modul;
        }
        if (this.val > n) {
            return 1;
        }
        return this.val < n ? -1 : 0;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ModInt)) {
            return false;
        }
        return 0 == this.compareTo((ModInt)object);
    }

    @Override
    public int hashCode() {
        return this.val;
    }

    @Override
    public ModInt abs() {
        return new ModInt(this.ring, this.val < 0 ? -this.val : this.val);
    }

    @Override
    public ModInt negate() {
        return new ModInt(this.ring, -this.val);
    }

    @Override
    public int signum() {
        if (this.val > 0) {
            return 1;
        }
        return this.val < 0 ? -1 : 0;
    }

    @Override
    public ModInt subtract(ModInt modInt) {
        return new ModInt(this.ring, this.val - modInt.val);
    }

    @Override
    public ModInt divide(ModInt modInt) {
        try {
            return this.multiply(modInt.inverse());
        }
        catch (NotInvertibleException notInvertibleException) {
            try {
                if (this.val % modInt.val == 0) {
                    return new ModInt(this.ring, this.val / modInt.val);
                }
                throw new NotInvertibleException(notInvertibleException.getCause());
            }
            catch (ArithmeticException arithmeticException) {
                throw new NotInvertibleException(arithmeticException.getCause());
            }
        }
    }

    @Override
    public ModInt inverse() {
        try {
            return new ModInt(this.ring, this.modInverse(this.val, this.ring.modul));
        }
        catch (ArithmeticException arithmeticException) {
            int n = this.gcd(this.val, this.ring.modul);
            int n2 = this.ring.modul / n;
            throw new ModularNotInvertibleException(arithmeticException, (GcdRingElem)new BigInteger(this.ring.modul), (GcdRingElem)new BigInteger(n), (GcdRingElem)new BigInteger(n2));
        }
    }

    @Override
    public ModInt remainder(ModInt modInt) {
        if (modInt == null || modInt.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        if (modInt.isONE()) {
            return this.ring.getZERO();
        }
        if (modInt.isUnit()) {
            return this.ring.getZERO();
        }
        return new ModInt(this.ring, this.val % modInt.val);
    }

    @Override
    public ModInt multiply(ModInt modInt) {
        return new ModInt(this.ring, this.val * modInt.val);
    }

    @Override
    public ModInt sum(ModInt modInt) {
        return new ModInt(this.ring, this.val + modInt.val);
    }

    @Override
    public ModInt gcd(ModInt modInt) {
        if (modInt.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return modInt;
        }
        if (this.isUnit() || modInt.isUnit()) {
            return this.ring.getONE();
        }
        return new ModInt(this.ring, this.gcd(this.val, modInt.val));
    }

    public ModInt[] egcd(ModInt modInt) {
        ModInt[] modIntArray = new ModInt[]{null, null, null};
        if (modInt == null || modInt.isZERO()) {
            modIntArray[0] = this;
            return modIntArray;
        }
        if (this.isZERO()) {
            modIntArray[0] = modInt;
            return modIntArray;
        }
        if (this.isUnit() || modInt.isUnit()) {
            modIntArray[0] = this.ring.getONE();
            if (this.isUnit() && modInt.isUnit()) {
                modIntArray[1] = this.ring.getONE();
                ModInt modInt2 = modIntArray[0].subtract(modIntArray[1].multiply(this));
                modIntArray[2] = modInt2.divide(modInt);
                return modIntArray;
            }
            if (this.isUnit()) {
                modIntArray[1] = this.inverse();
                modIntArray[2] = this.ring.getZERO();
                return modIntArray;
            }
            modIntArray[1] = this.ring.getZERO();
            modIntArray[2] = modInt.inverse();
            return modIntArray;
        }
        int n = this.val;
        int n2 = modInt.val;
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 1;
        while (n2 != 0) {
            int n7 = n / n2;
            int n8 = n % n2;
            n = n7;
            int n9 = n3 - n * n4;
            int n10 = n5 - n * n6;
            n3 = n4;
            n5 = n6;
            n4 = n9;
            n6 = n10;
            n = n2;
            n2 = n8;
        }
        modIntArray[0] = new ModInt(this.ring, n);
        modIntArray[1] = new ModInt(this.ring, n3);
        modIntArray[2] = new ModInt(this.ring, n5);
        return modIntArray;
    }

    public int gcd(int n, int n2) {
        if (n2 == 0) {
            return n;
        }
        if (n == 0) {
            return n2;
        }
        int n3 = n;
        int n4 = n2;
        while (n4 != 0) {
            int n5 = n3 % n4;
            n3 = n4;
            n4 = n5;
        }
        return n3;
    }

    public int[] hegcd(int n, int n2) {
        int[] nArray = new int[2];
        if (n2 == 0) {
            nArray[0] = n;
            nArray[1] = 1;
            return nArray;
        }
        if (n == 0) {
            nArray[0] = n2;
            nArray[1] = 0;
            return nArray;
        }
        int n3 = n;
        int n4 = n2;
        int n5 = 1;
        int n6 = 0;
        while (n4 != 0) {
            int n7 = n3 / n4;
            int n8 = n3 % n4;
            n3 = n4;
            n4 = n8;
            int n9 = n5 - n7 * n6;
            n5 = n6;
            n6 = n9;
        }
        if (n5 < 0) {
            n5 += n2;
        }
        nArray[0] = n3;
        nArray[1] = n5;
        return nArray;
    }

    public int modInverse(int n, int n2) {
        if (n == 0) {
            throw new NotInvertibleException("zero is not invertible");
        }
        int[] nArray = this.hegcd(n, n2);
        int n3 = nArray[0];
        if ((long)n3 != 1L && (long)n3 != -1L) {
            throw new ModularNotInvertibleException("element not invertible, gcd != 1", (GcdRingElem)new BigInteger(n2), (GcdRingElem)new BigInteger(n3), (GcdRingElem)new BigInteger(n2 / n3));
        }
        int n4 = nArray[1];
        if (n4 == 0) {
            throw new NotInvertibleException("element not invertible, divisible by modul");
        }
        if (n4 < 0) {
            n4 += n2;
        }
        return n4;
    }

    public int bitLength() {
        return (int)BigInteger.bitLength(this.val);
    }
}

