/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.fd;

import edu.jas.arith.BigRational;
import edu.jas.fd.FDUtil;
import edu.jas.fd.GreatestCommonDivisorAbstract;
import edu.jas.fd.GreatestCommonDivisorFake;
import edu.jas.fd.QuotSolvablePolynomialRing;
import edu.jas.fd.SolvableQuotient;
import edu.jas.fd.SolvableQuotientRing;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelationsIterated;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GCDFakeTest
extends TestCase {
    GreatestCommonDivisorAbstract<BigRational> fd;
    TermOrder to = new TermOrder(2);
    GenSolvablePolynomialRing<BigRational> dfac;
    RecSolvablePolynomialRing<BigRational> rfac;
    GenSolvablePolynomial<BigRational> a;
    GenSolvablePolynomial<BigRational> b;
    GenSolvablePolynomial<BigRational> a0;
    GenSolvablePolynomial<BigRational> b0;
    GenSolvablePolynomial<BigRational> c;
    GenSolvablePolynomial<BigRational> d;
    GenSolvablePolynomial<BigRational> e;
    GenSolvablePolynomial<GenPolynomial<BigRational>> ar;
    GenSolvablePolynomial<GenPolynomial<BigRational>> br;
    GenSolvablePolynomial<GenPolynomial<BigRational>> cr;
    GenSolvablePolynomial<GenPolynomial<BigRational>> dr;
    GenSolvablePolynomial<GenPolynomial<BigRational>> er;
    GenSolvablePolynomial<GenPolynomial<BigRational>> ar0;
    GenSolvablePolynomial<GenPolynomial<BigRational>> br0;
    int rl = 4;
    int kl = 2;
    int ll = 2;
    int el = 3;
    float q = 0.25f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GCDFakeTest.suite());
        ComputerThreads.terminate();
    }

    public GCDFakeTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GCDFakeTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        String[] stringArray = new String[]{"a", "b", "c", "d"};
        BigRational bigRational = new BigRational(1L);
        this.fd = new GreatestCommonDivisorFake<BigRational>(bigRational);
        this.dfac = new GenSolvablePolynomialRing<BigRational>(bigRational, this.rl, this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.dfac.addRelations(weylRelationsIterated);
        this.rfac = (RecSolvablePolynomialRing)this.dfac.recursive(1);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.fd = null;
        this.dfac = null;
        this.rfac = null;
    }

    public void testBaseGcdFake() {
        String[] stringArray = new String[]{"x"};
        this.dfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), 1, this.to, stringArray);
        for (int i = 0; i < 3; ++i) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2, this.q);
            this.b = this.dfac.random(this.kl * (i + 1), this.ll + i, this.el + 2, this.q);
            this.c = this.dfac.random(this.kl * (i + 1), this.ll + 1, this.el + 1, this.q);
            this.c = this.c.multiply((BigRational)((Object)this.dfac.univariate(0)));
            if (this.c.isZERO()) continue;
            this.a = this.a.multiply((BigRational)((Object)this.c));
            this.b = this.b.multiply((BigRational)((Object)this.c));
            this.d = this.fd.leftBaseGcd(this.a, this.b);
            this.e = (GenSolvablePolynomial)PolyUtil.baseSparsePseudoRemainder(this.d, this.c);
            GCDFakeTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (this.e.isZERO() || this.d.isONE() ? 1 : 0) != 0);
            this.e = (GenSolvablePolynomial)PolyUtil.baseSparsePseudoRemainder(this.a, this.d);
            GCDFakeTest.assertTrue((String)("gcd(a,b) | a " + this.e), (boolean)this.e.isZERO());
            this.e = (GenSolvablePolynomial)PolyUtil.baseSparsePseudoRemainder(this.b, this.d);
            GCDFakeTest.assertTrue((String)("gcd(a,b) | b " + this.e), (boolean)this.e.isZERO());
        }
    }

    public void testRecursiveLeftGCDFake() {
        String[] stringArray = new String[]{"a", "b"};
        this.dfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.dfac.addRelations(weylRelationsIterated);
        this.rfac = (RecSolvablePolynomialRing)this.dfac.recursive(1);
        RecSolvablePolynomialRing<BigRational> recSolvablePolynomialRing = this.rfac;
        RecSolvablePolynomialRing<BigRational> recSolvablePolynomialRing2 = this.rfac;
        GenSolvablePolynomialRing genSolvablePolynomialRing = (GenSolvablePolynomialRing)this.rfac.coFac;
        SolvableQuotientRing solvableQuotientRing = new SolvableQuotientRing(genSolvablePolynomialRing);
        QuotSolvablePolynomialRing quotSolvablePolynomialRing = new QuotSolvablePolynomialRing(solvableQuotientRing, recSolvablePolynomialRing2);
        List list = recSolvablePolynomialRing.coeffTable.relationList();
        List list2 = PolynomialList.castToList(list);
        quotSolvablePolynomialRing.polCoeff.coeffTable.addRelations(list2);
        this.ll = 3;
        this.el = 3;
        this.ar = this.rfac.random(this.kl, this.ll, this.el + 1, this.q);
        this.br = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.cr = (RecSolvablePolynomial)PolyUtil.monic(this.cr);
        if (this.cr.isZERO()) {
            this.cr = this.rfac.getONE();
        }
        this.ar = this.ar.multiply((GenPolynomial<BigRational>)this.cr);
        this.br = this.br.multiply((GenPolynomial<BigRational>)this.cr);
        this.dr = this.fd.leftRecursiveUnivariateGcd(this.ar, this.br);
        this.er = (RecSolvablePolynomial)FDUtil.recursiveSparsePseudoRemainder(this.dr, this.cr);
        GCDFakeTest.assertTrue((String)("c | gcd(ac,bc) " + this.er), (this.er.isZERO() || this.dr.isONE() ? 1 : 0) != 0);
        this.er = (RecSolvablePolynomial)FDUtil.recursiveSparsePseudoRemainder(this.ar, this.dr);
        GCDFakeTest.assertTrue((String)("gcd(a,b) | a " + this.er), (boolean)this.er.isZERO());
        this.er = (RecSolvablePolynomial)FDUtil.recursiveSparsePseudoRemainder(this.br, this.dr);
        GCDFakeTest.assertTrue((String)("gcd(a,b) | b " + this.er), (boolean)this.er.isZERO());
        GenSolvablePolynomial genSolvablePolynomial = FDUtil.quotientFromIntegralCoefficients(quotSolvablePolynomialRing, this.ar);
        GenSolvablePolynomial genSolvablePolynomial2 = FDUtil.quotientFromIntegralCoefficients(quotSolvablePolynomialRing, this.br);
        GenSolvablePolynomial genSolvablePolynomial3 = FDUtil.quotientFromIntegralCoefficients(quotSolvablePolynomialRing, this.cr);
        GenSolvablePolynomial genSolvablePolynomial4 = FDUtil.quotientFromIntegralCoefficients(quotSolvablePolynomialRing, this.dr);
        GenPolynomial genPolynomial = genSolvablePolynomial.monic();
        GenPolynomial genPolynomial2 = genSolvablePolynomial2.monic();
        GenPolynomial genPolynomial3 = genSolvablePolynomial3.monic();
        GenPolynomial genPolynomial4 = genSolvablePolynomial4.monic();
        GCDFakeTest.assertTrue((String)"", (boolean)((SolvableQuotient)genPolynomial.leadingBaseCoefficient()).isONE());
        GCDFakeTest.assertTrue((String)"", (boolean)((SolvableQuotient)genPolynomial2.leadingBaseCoefficient()).isONE());
        GCDFakeTest.assertTrue((String)"", (boolean)((SolvableQuotient)genPolynomial3.leadingBaseCoefficient()).isONE());
        GCDFakeTest.assertTrue((String)"", (boolean)((SolvableQuotient)genPolynomial4.leadingBaseCoefficient()).isONE());
        GreatestCommonDivisorFake greatestCommonDivisorFake = new GreatestCommonDivisorFake(solvableQuotientRing);
        GenSolvablePolynomial genSolvablePolynomial5 = ((GreatestCommonDivisorAbstract)greatestCommonDivisorFake).leftBaseGcd(genSolvablePolynomial, genSolvablePolynomial2);
        GenPolynomial genPolynomial5 = genSolvablePolynomial5.monic();
        GCDFakeTest.assertTrue((String)"", (boolean)((SolvableQuotient)genPolynomial5.leadingBaseCoefficient()).isONE());
        GenSolvablePolynomial genSolvablePolynomial6 = FDUtil.leftBaseSparsePseudoRemainder(genSolvablePolynomial5, genSolvablePolynomial4);
        GCDFakeTest.assertTrue((String)("c | gcd(ac,bc): " + genSolvablePolynomial6), (boolean)genSolvablePolynomial6.isZERO());
        genSolvablePolynomial6 = FDUtil.leftBaseSparsePseudoRemainder(genSolvablePolynomial, genSolvablePolynomial5);
        GCDFakeTest.assertTrue((String)("gcd(ac,bc)| ac): " + genSolvablePolynomial6), (boolean)genSolvablePolynomial6.isZERO());
        genSolvablePolynomial6 = FDUtil.leftBaseSparsePseudoRemainder(genSolvablePolynomial2, genSolvablePolynomial5);
        GCDFakeTest.assertTrue((String)("gcd(ac,bc)| bc): " + genSolvablePolynomial6), (boolean)genSolvablePolynomial6.isZERO());
    }

    public void testRecursiveRightGCDFake() {
        String[] stringArray = new String[]{"a", "b"};
        this.dfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.dfac.addRelations(weylRelationsIterated);
        this.rfac = (RecSolvablePolynomialRing)this.dfac.recursive(1);
        RecSolvablePolynomialRing<BigRational> recSolvablePolynomialRing = this.rfac;
        RecSolvablePolynomialRing<BigRational> recSolvablePolynomialRing2 = this.rfac;
        GenSolvablePolynomialRing genSolvablePolynomialRing = (GenSolvablePolynomialRing)this.rfac.coFac;
        SolvableQuotientRing solvableQuotientRing = new SolvableQuotientRing(genSolvablePolynomialRing);
        QuotSolvablePolynomialRing quotSolvablePolynomialRing = new QuotSolvablePolynomialRing(solvableQuotientRing, recSolvablePolynomialRing2);
        List list = recSolvablePolynomialRing.coeffTable.relationList();
        List list2 = PolynomialList.castToList(list);
        quotSolvablePolynomialRing.polCoeff.coeffTable.addRelations(list2);
        int n = 3;
        int n2 = 3;
        this.ar = this.rfac.random(this.kl, n, n2 + 1, this.q);
        this.br = this.rfac.random(this.kl, n, n2, this.q);
        this.cr = this.rfac.random(this.kl, n, n2, this.q);
        this.cr = (RecSolvablePolynomial)PolyUtil.monic(this.cr);
        if (this.cr.isZERO()) {
            this.cr = this.rfac.getONE();
        }
        this.ar = this.cr.multiply((GenPolynomial<BigRational>)this.ar);
        this.br = this.cr.multiply((GenPolynomial<BigRational>)this.br);
        this.dr = this.fd.rightRecursiveUnivariateGcd(this.ar, this.br);
        this.er = (RecSolvablePolynomial)FDUtil.recursiveRightSparsePseudoRemainder(this.dr, this.cr);
        GCDFakeTest.assertTrue((String)("c | gcd(ac,bc) " + this.er), (this.er.isZERO() || this.dr.isONE() ? 1 : 0) != 0);
        this.er = (RecSolvablePolynomial)FDUtil.recursiveRightSparsePseudoRemainder(this.ar, this.dr);
        GCDFakeTest.assertTrue((String)("gcd(a,b) | a " + this.er), (boolean)this.er.isZERO());
        this.er = (RecSolvablePolynomial)FDUtil.recursiveRightSparsePseudoRemainder(this.br, this.dr);
        GCDFakeTest.assertTrue((String)("gcd(a,b) | b " + this.er), (boolean)this.er.isZERO());
    }

    public void testArbitraryRecursiveGCDFake() {
        String[] stringArray = new String[]{"a", "b"};
        String[] stringArray2 = new String[]{"c"};
        this.dfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.dfac.addRelations(weylRelationsIterated);
        this.rfac = new RecSolvablePolynomialRing(this.dfac, this.to, stringArray2);
        int n = 2;
        this.ar0 = this.rfac.random(this.kl, this.ll, n + 1, this.q);
        this.br0 = this.rfac.random(this.kl, this.ll, n, this.q);
        this.cr = this.rfac.random(this.kl, this.ll, n, this.q);
        this.cr = (RecSolvablePolynomial)this.cr.monic();
        if (this.cr.isZERO()) {
            this.cr = this.rfac.getONE();
        }
        this.ar = this.ar0.multiply((GenPolynomial<BigRational>)this.cr);
        this.br = this.br0.multiply((GenPolynomial<BigRational>)this.cr);
        this.dr = this.fd.leftRecursiveGcd(this.ar, this.br);
        this.er = (RecSolvablePolynomial)FDUtil.recursiveSparsePseudoRemainder(this.dr, this.cr);
        GCDFakeTest.assertTrue((String)("c | gcd(ac,bc) " + this.er), (this.er.isZERO() || this.dr.isONE() ? 1 : 0) != 0);
        this.er = (RecSolvablePolynomial)FDUtil.recursiveSparsePseudoRemainder(this.ar, this.dr);
        GCDFakeTest.assertTrue((String)("gcd(ac,bc) | ac " + this.er), (boolean)this.er.isZERO());
        this.er = (RecSolvablePolynomial)FDUtil.recursiveSparsePseudoRemainder(this.br, this.dr);
        GCDFakeTest.assertTrue((String)("gcd(ac,bc) | bc " + this.er), (boolean)this.er.isZERO());
        this.ar = this.cr.multiply((GenPolynomial<BigRational>)this.ar0);
        this.br = this.cr.multiply((GenPolynomial<BigRational>)this.br0);
        this.dr = this.fd.rightRecursiveGcd(this.ar, this.br);
        this.er = (RecSolvablePolynomial)FDUtil.recursiveRightSparsePseudoRemainder(this.dr, this.cr);
        GCDFakeTest.assertTrue((String)("c | gcd(ca,cb) " + this.er), (this.er.isZERO() || this.dr.isONE() ? 1 : 0) != 0);
        this.er = (RecSolvablePolynomial)FDUtil.recursiveRightSparsePseudoRemainder(this.ar, this.dr);
        GCDFakeTest.assertTrue((String)("gcd(ca,cb) | ca " + this.er), (boolean)this.er.isZERO());
        this.er = (RecSolvablePolynomial)FDUtil.recursiveRightSparsePseudoRemainder(this.br, this.dr);
        GCDFakeTest.assertTrue((String)("gcd(ca,cb) | cb " + this.er), (boolean)this.er.isZERO());
    }

    public void testGCDFake() {
        String[] stringArray = new String[]{"a", "b", "c", "d"};
        this.dfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.dfac.addRelations(weylRelationsIterated);
        this.ll = 4;
        this.el = 4;
        this.a0 = this.dfac.parse("b^3 - 1/6 + d");
        this.b0 = this.dfac.parse("b + 3 a^2 + d");
        this.c = this.dfac.parse("c - a - b");
        this.c = this.c.monic();
        if (this.c.isZERO()) {
            this.c = this.dfac.getONE();
        }
        this.a = this.a0.multiply((BigRational)((Object)this.c));
        this.b = this.b0.multiply((BigRational)((Object)this.c));
        ArrayList arrayList = new ArrayList();
        arrayList.add(this.a);
        arrayList.add(this.b);
        SolvableGroebnerBaseSeq solvableGroebnerBaseSeq = new SolvableGroebnerBaseSeq();
        List list = solvableGroebnerBaseSeq.leftGB(arrayList);
        this.d = this.fd.leftGcd(this.a, this.b);
        GCDFakeTest.assertTrue((String)"d in leftGB", (solvableGroebnerBaseSeq.sred.leftNormalform(list, this.d).isZERO() || this.d.isONE() ? 1 : 0) != 0);
        this.e = FDUtil.leftBaseSparsePseudoRemainder(this.d, this.c);
        GCDFakeTest.assertTrue((String)("c | gcd(ac,bc): " + this.e), (this.e.isZERO() || this.d.isONE() ? 1 : 0) != 0);
        this.e = FDUtil.leftBaseSparsePseudoRemainder(this.a, this.c);
        GCDFakeTest.assertTrue((String)("c | ac: " + this.e), (boolean)this.e.isZERO());
        this.e = FDUtil.leftBaseSparsePseudoRemainder(this.b, this.c);
        GCDFakeTest.assertTrue((String)("c | bc: " + this.e), (boolean)this.e.isZERO());
        this.e = FDUtil.leftBaseSparsePseudoRemainder(this.a, this.d);
        GCDFakeTest.assertTrue((String)("gcd(a,b) | a: " + this.e), (boolean)this.e.isZERO());
        this.e = FDUtil.leftBaseSparsePseudoRemainder(this.b, this.d);
        GCDFakeTest.assertTrue((String)("gcd(a,b) | b: " + this.e), (boolean)this.e.isZERO());
        this.a = this.c.multiply((BigRational)((Object)this.a0));
        this.b = this.c.multiply((BigRational)((Object)this.b0));
        this.d = this.fd.rightGcd(this.a, this.b);
        this.e = FDUtil.rightBaseSparsePseudoRemainder(this.d, this.c);
        GCDFakeTest.assertTrue((String)("c | gcd(ac,bc): " + this.e), (this.e.isZERO() || this.d.isONE() ? 1 : 0) != 0);
        this.e = FDUtil.rightBaseSparsePseudoRemainder(this.a, this.c);
        GCDFakeTest.assertTrue((String)("c | ac: " + this.e), (boolean)this.e.isZERO());
        this.e = FDUtil.rightBaseSparsePseudoRemainder(this.b, this.c);
        GCDFakeTest.assertTrue((String)("c | bc: " + this.e), (boolean)this.e.isZERO());
        this.e = FDUtil.rightBaseSparsePseudoRemainder(this.a, this.d);
        GCDFakeTest.assertTrue((String)("gcd(a,b) | a: " + this.e), (boolean)this.e.isZERO());
        this.e = FDUtil.rightBaseSparsePseudoRemainder(this.b, this.d);
        GCDFakeTest.assertTrue((String)("gcd(a,b) | b: " + this.e), (boolean)this.e.isZERO());
    }
}

