/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.fd;

import edu.jas.fd.FDUtil;
import edu.jas.fd.GreatestCommonDivisorAbstract;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GreatestCommonDivisorPrimitive<C extends GcdRingElem<C>>
extends GreatestCommonDivisorAbstract<C> {
    private static final Logger logger = LogManager.getLogger(GreatestCommonDivisorPrimitive.class);
    private static final boolean debug = logger.isDebugEnabled();

    public GreatestCommonDivisorPrimitive(RingFactory<C> ringFactory) {
        super(ringFactory);
    }

    @Override
    public GenSolvablePolynomial<C> leftBaseGcd(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        Object object;
        GcdRingElem gcdRingElem;
        GenSolvablePolynomial genSolvablePolynomial3;
        GenPolynomial genPolynomial;
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial2;
        }
        if (genSolvablePolynomial.ring.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " no univariate polynomial");
        }
        boolean bl = genSolvablePolynomial.ring.coFac.isField();
        long l = genSolvablePolynomial.degree(0);
        long l2 = genSolvablePolynomial2.degree(0);
        if (l2 > l) {
            genPolynomial = genSolvablePolynomial;
            genSolvablePolynomial3 = genSolvablePolynomial2;
            long l3 = l2;
            l2 = l;
            l = l3;
        } else {
            genSolvablePolynomial3 = genSolvablePolynomial;
            genPolynomial = genSolvablePolynomial2;
        }
        if (debug) {
            logger.debug("degrees: e = " + l + ", f = " + l2);
        }
        if (bl) {
            genPolynomial = genPolynomial.monic();
            genSolvablePolynomial3 = genSolvablePolynomial3.monic();
            gcdRingElem = (GcdRingElem)genSolvablePolynomial.ring.getONECoefficient();
        } else {
            genPolynomial = (GenSolvablePolynomial)genPolynomial.abs();
            genSolvablePolynomial3 = (GenSolvablePolynomial)genSolvablePolynomial3.abs();
            object = this.rightBaseContent(genPolynomial);
            Object c = this.rightBaseContent(genSolvablePolynomial3);
            genPolynomial = this.divide(genPolynomial, object);
            genSolvablePolynomial3 = this.divide(genSolvablePolynomial3, c);
            gcdRingElem = this.gcd(object, c);
        }
        if (genPolynomial.isONE()) {
            return genPolynomial.multiply(gcdRingElem);
        }
        if (genSolvablePolynomial3.isONE()) {
            return genSolvablePolynomial3.multiply(gcdRingElem);
        }
        while (!genPolynomial.isZERO()) {
            object = FDUtil.leftBaseSparsePseudoRemainder(genSolvablePolynomial3, genPolynomial);
            genSolvablePolynomial3 = genPolynomial;
            if (bl) {
                genPolynomial = ((GenSolvablePolynomial)object).monic();
                continue;
            }
            genPolynomial = this.leftBasePrimitivePart(object);
        }
        return (GenSolvablePolynomial)genSolvablePolynomial3.multiply(gcdRingElem).abs();
    }

    @Override
    public GenSolvablePolynomial<C> rightBaseGcd(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        Object object;
        GcdRingElem gcdRingElem;
        GenSolvablePolynomial genSolvablePolynomial3;
        GenPolynomial genPolynomial;
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial2;
        }
        if (genSolvablePolynomial.ring.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " no univariate polynomial");
        }
        boolean bl = genSolvablePolynomial.ring.coFac.isField();
        long l = genSolvablePolynomial.degree(0);
        long l2 = genSolvablePolynomial2.degree(0);
        if (l2 > l) {
            genPolynomial = genSolvablePolynomial;
            genSolvablePolynomial3 = genSolvablePolynomial2;
            long l3 = l2;
            l2 = l;
            l = l3;
        } else {
            genSolvablePolynomial3 = genSolvablePolynomial;
            genPolynomial = genSolvablePolynomial2;
        }
        if (debug) {
            logger.debug("degrees: e = " + l + ", f = " + l2);
        }
        if (bl) {
            genPolynomial = genPolynomial.monic();
            genSolvablePolynomial3 = genSolvablePolynomial3.monic();
            gcdRingElem = (GcdRingElem)genSolvablePolynomial.ring.getONECoefficient();
        } else {
            genPolynomial = (GenSolvablePolynomial)genPolynomial.abs();
            genSolvablePolynomial3 = (GenSolvablePolynomial)genSolvablePolynomial3.abs();
            object = this.leftBaseContent(genPolynomial);
            Object c = this.leftBaseContent(genSolvablePolynomial3);
            genPolynomial = this.divide(genPolynomial, object);
            genSolvablePolynomial3 = this.divide(genSolvablePolynomial3, c);
            gcdRingElem = this.gcd(object, c);
        }
        if (genPolynomial.isONE()) {
            return genPolynomial.multiply(gcdRingElem);
        }
        if (genSolvablePolynomial3.isONE()) {
            return genSolvablePolynomial3.multiply(gcdRingElem);
        }
        while (!genPolynomial.isZERO()) {
            object = FDUtil.rightBaseSparsePseudoRemainder(genSolvablePolynomial3, genPolynomial);
            genSolvablePolynomial3 = genPolynomial;
            if (bl) {
                genPolynomial = ((GenSolvablePolynomial)object).monic();
                continue;
            }
            genPolynomial = this.rightBasePrimitivePart(object);
        }
        return (GenSolvablePolynomial)genSolvablePolynomial3.multiplyLeft(gcdRingElem).abs();
    }

    @Override
    public GenSolvablePolynomial<GenPolynomial<C>> leftRecursiveUnivariateGcd(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2) {
        GenSolvablePolynomial genSolvablePolynomial3;
        GenSolvablePolynomial genSolvablePolynomial4;
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial2;
        }
        if (genSolvablePolynomial.ring.nvar > 1) {
            throw new IllegalArgumentException("no univariate polynomial");
        }
        boolean bl = ((GenPolynomial)genSolvablePolynomial.leadingBaseCoefficient()).ring.coFac.isField();
        long l = genSolvablePolynomial.degree(0);
        long l2 = genSolvablePolynomial2.degree(0);
        if (l2 > l) {
            genSolvablePolynomial4 = genSolvablePolynomial;
            genSolvablePolynomial3 = genSolvablePolynomial2;
            long l3 = l2;
            l2 = l;
            l = l3;
        } else if (l2 < l) {
            genSolvablePolynomial3 = genSolvablePolynomial;
            genSolvablePolynomial4 = genSolvablePolynomial2;
        } else if (((GenPolynomial)genSolvablePolynomial.leadingBaseCoefficient()).degree() > ((GenPolynomial)genSolvablePolynomial2.leadingBaseCoefficient()).degree()) {
            genSolvablePolynomial3 = genSolvablePolynomial;
            genSolvablePolynomial4 = genSolvablePolynomial2;
        } else {
            genSolvablePolynomial4 = genSolvablePolynomial;
            genSolvablePolynomial3 = genSolvablePolynomial2;
        }
        if (debug) {
            logger.debug("degrees: e = " + l + ", f = " + l2);
        }
        if (bl) {
            genSolvablePolynomial4 = PolyUtil.monic(genSolvablePolynomial4);
            genSolvablePolynomial3 = PolyUtil.monic(genSolvablePolynomial3);
        } else {
            genSolvablePolynomial4 = (GenSolvablePolynomial<GenPolynomial<GenPolynomial<GenPolynomial>>>)genSolvablePolynomial4.abs();
            genSolvablePolynomial3 = (GenSolvablePolynomial)genSolvablePolynomial3.abs();
        }
        GenSolvablePolynomial genSolvablePolynomial5 = this.rightRecursiveContent(genSolvablePolynomial4);
        GenSolvablePolynomial genSolvablePolynomial6 = FDUtil.recursiveLeftDivide(genSolvablePolynomial4, genSolvablePolynomial5);
        if (debug) {
            logger.info("recCont a = " + genSolvablePolynomial5 + ", r = " + genSolvablePolynomial4);
            logger.info("recCont r/a = " + genSolvablePolynomial6 + ", r%a = " + genSolvablePolynomial4.subtract(genSolvablePolynomial6.multiply((RingElem)genSolvablePolynomial5)));
            if (!genSolvablePolynomial4.equals(genSolvablePolynomial6.multiply((RingElem)genSolvablePolynomial5))) {
                System.out.println("recGcd, r         = " + genSolvablePolynomial4);
                System.out.println("recGcd, cont(r)   = " + genSolvablePolynomial5);
                System.out.println("recGcd, pp(r)     = " + genSolvablePolynomial6);
                System.out.println("recGcd, pp(r)c(r) = " + genSolvablePolynomial6.multiply((RingElem)genSolvablePolynomial5));
                System.out.println("recGcd, c(r)pp(r) = " + genSolvablePolynomial6.multiplyLeft(genSolvablePolynomial5));
                throw new RuntimeException("recGcd, pp: not divisible");
            }
        }
        genSolvablePolynomial4 = genSolvablePolynomial6;
        GenSolvablePolynomial genSolvablePolynomial7 = this.rightRecursiveContent(genSolvablePolynomial3);
        GenSolvablePolynomial genSolvablePolynomial8 = FDUtil.recursiveLeftDivide(genSolvablePolynomial3, genSolvablePolynomial7);
        if (debug) {
            logger.info("recCont b = " + genSolvablePolynomial7 + ", q = " + genSolvablePolynomial3);
            logger.info("recCont q/b = " + genSolvablePolynomial8 + ", q%b = " + genSolvablePolynomial3.subtract(genSolvablePolynomial8.multiply((RingElem)genSolvablePolynomial7)));
            if (!genSolvablePolynomial3.equals(genSolvablePolynomial8.multiply((RingElem)genSolvablePolynomial7))) {
                System.out.println("recGcd, q         = " + genSolvablePolynomial3);
                System.out.println("recGcd, cont(q)   = " + genSolvablePolynomial7);
                System.out.println("recGcd, pp(q)     = " + genSolvablePolynomial8);
                System.out.println("recGcd, pp(q)c(q) = " + genSolvablePolynomial8.multiply((RingElem)genSolvablePolynomial7));
                System.out.println("recGcd, c(q)pp(q) = " + genSolvablePolynomial8.multiplyLeft(genSolvablePolynomial7));
                throw new RuntimeException("recGcd, pp: not divisible");
            }
        }
        genSolvablePolynomial3 = genSolvablePolynomial8;
        GenSolvablePolynomial genSolvablePolynomial9 = this.rightGcd(genSolvablePolynomial5, genSolvablePolynomial7);
        logger.info("Gcd(contents) c = " + genSolvablePolynomial9 + ", a = " + genSolvablePolynomial5 + ", b = " + genSolvablePolynomial7);
        if (genSolvablePolynomial4.isONE()) {
            return genSolvablePolynomial4.multiply((RingElem)genSolvablePolynomial9);
        }
        if (genSolvablePolynomial3.isONE()) {
            return genSolvablePolynomial3.multiply((RingElem)genSolvablePolynomial9);
        }
        if (debug) {
            logger.info("r.ring = " + genSolvablePolynomial4.ring.toScript());
        }
        while (!genSolvablePolynomial4.isZERO()) {
            GenSolvablePolynomial genSolvablePolynomial10 = FDUtil.recursiveSparsePseudoRemainder(genSolvablePolynomial3, genSolvablePolynomial4);
            genSolvablePolynomial3 = genSolvablePolynomial4;
            genSolvablePolynomial4 = this.rightRecursivePrimitivePart(genSolvablePolynomial10);
            if (!bl) continue;
            genSolvablePolynomial4 = PolyUtil.monic(genSolvablePolynomial4);
        }
        if (debug) {
            logger.info("gcd(pp) = " + genSolvablePolynomial3 + ", ring = " + genSolvablePolynomial.ring.toScript());
        }
        genSolvablePolynomial3 = (GenSolvablePolynomial)genSolvablePolynomial3.multiply((RingElem)genSolvablePolynomial9).abs();
        return genSolvablePolynomial3;
    }

    @Override
    public GenSolvablePolynomial<GenPolynomial<C>> rightRecursiveUnivariateGcd(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2) {
        GenSolvablePolynomial genSolvablePolynomial3;
        GenSolvablePolynomial genSolvablePolynomial4;
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial2;
        }
        if (genSolvablePolynomial.ring.nvar > 1) {
            throw new IllegalArgumentException("no univariate polynomial");
        }
        boolean bl = ((GenPolynomial)genSolvablePolynomial.leadingBaseCoefficient()).ring.coFac.isField();
        long l = genSolvablePolynomial.degree(0);
        long l2 = genSolvablePolynomial2.degree(0);
        if (l2 > l) {
            genSolvablePolynomial4 = genSolvablePolynomial;
            genSolvablePolynomial3 = genSolvablePolynomial2;
            long l3 = l2;
            l2 = l;
            l = l3;
        } else if (l2 < l) {
            genSolvablePolynomial3 = genSolvablePolynomial;
            genSolvablePolynomial4 = genSolvablePolynomial2;
        } else if (((GenPolynomial)genSolvablePolynomial.leadingBaseCoefficient()).degree() > ((GenPolynomial)genSolvablePolynomial2.leadingBaseCoefficient()).degree()) {
            genSolvablePolynomial3 = genSolvablePolynomial;
            genSolvablePolynomial4 = genSolvablePolynomial2;
        } else {
            genSolvablePolynomial4 = genSolvablePolynomial;
            genSolvablePolynomial3 = genSolvablePolynomial2;
        }
        if (debug) {
            logger.debug("RI-degrees: e = " + l + ", f = " + l2);
        }
        if (bl) {
            genSolvablePolynomial4 = PolyUtil.monic(genSolvablePolynomial4);
            genSolvablePolynomial3 = PolyUtil.monic(genSolvablePolynomial3);
        } else {
            genSolvablePolynomial4 = (GenSolvablePolynomial<GenPolynomial<GenPolynomial<GenPolynomial>>>)genSolvablePolynomial4.abs();
            genSolvablePolynomial3 = (GenSolvablePolynomial)genSolvablePolynomial3.abs();
        }
        GenSolvablePolynomial genSolvablePolynomial5 = this.leftRecursiveContent(genSolvablePolynomial4);
        GenSolvablePolynomial genSolvablePolynomial6 = FDUtil.recursiveRightDivide(genSolvablePolynomial4, genSolvablePolynomial5);
        if (debug) {
            logger.info("RI-recCont a = " + genSolvablePolynomial5 + ", r = " + genSolvablePolynomial4);
            logger.info("RI-recCont r/a = " + genSolvablePolynomial4 + ", r%a = " + genSolvablePolynomial4.subtract(genSolvablePolynomial6.multiplyLeft(genSolvablePolynomial5)));
            if (!genSolvablePolynomial4.equals(genSolvablePolynomial6.multiplyLeft(genSolvablePolynomial5))) {
                System.out.println("RI-recGcd, r         = " + genSolvablePolynomial4);
                System.out.println("RI-recGcd, cont(r)   = " + genSolvablePolynomial5);
                System.out.println("RI-recGcd, pp(r)     = " + genSolvablePolynomial6);
                System.out.println("RI-recGcd, c(r)pp(r) = " + genSolvablePolynomial6.multiplyLeft(genSolvablePolynomial5));
                throw new RuntimeException("RI-recGcd, pp: not divisible");
            }
        }
        genSolvablePolynomial4 = genSolvablePolynomial6;
        GenSolvablePolynomial genSolvablePolynomial7 = this.leftRecursiveContent(genSolvablePolynomial3);
        GenSolvablePolynomial genSolvablePolynomial8 = FDUtil.recursiveRightDivide(genSolvablePolynomial3, genSolvablePolynomial7);
        if (debug) {
            logger.info("RI-recCont b = " + genSolvablePolynomial7 + ", q = " + genSolvablePolynomial3);
            logger.info("RI-recCont q/b = " + genSolvablePolynomial8 + ", q%b = " + genSolvablePolynomial3.subtract(genSolvablePolynomial8.multiplyLeft(genSolvablePolynomial7)));
            if (!genSolvablePolynomial3.equals(genSolvablePolynomial8.multiplyLeft(genSolvablePolynomial7))) {
                System.out.println("RI-recGcd, q         = " + genSolvablePolynomial3);
                System.out.println("RI-recGcd, cont(q)   = " + genSolvablePolynomial7);
                System.out.println("RI-recGcd, pp(q)     = " + genSolvablePolynomial8);
                System.out.println("RI-recGcd, c(q)pp(q) = " + genSolvablePolynomial8.multiplyLeft(genSolvablePolynomial7));
                throw new RuntimeException("RI-recGcd, pp: not divisible");
            }
        }
        genSolvablePolynomial3 = genSolvablePolynomial8;
        GenSolvablePolynomial genSolvablePolynomial9 = this.leftGcd(genSolvablePolynomial5, genSolvablePolynomial7);
        logger.info("RI-Gcd(contents) c = " + genSolvablePolynomial9 + ", a = " + genSolvablePolynomial5 + ", b = " + genSolvablePolynomial7);
        if (genSolvablePolynomial4.isONE()) {
            return genSolvablePolynomial4.multiplyLeft(genSolvablePolynomial9);
        }
        if (genSolvablePolynomial3.isONE()) {
            return genSolvablePolynomial3.multiplyLeft(genSolvablePolynomial9);
        }
        if (debug) {
            logger.info("RI-r.ring = " + genSolvablePolynomial4.ring.toScript());
        }
        while (!genSolvablePolynomial4.isZERO()) {
            GenSolvablePolynomial genSolvablePolynomial10 = FDUtil.recursiveRightSparsePseudoRemainder(genSolvablePolynomial3, genSolvablePolynomial4);
            genSolvablePolynomial3 = genSolvablePolynomial4;
            genSolvablePolynomial4 = this.leftRecursivePrimitivePart(genSolvablePolynomial10);
            if (!bl) continue;
            genSolvablePolynomial4 = PolyUtil.monic(genSolvablePolynomial4);
        }
        if (debug) {
            logger.info("RI-gcd(pp) = " + genSolvablePolynomial3 + ", ring = " + genSolvablePolynomial.ring.toScript());
        }
        genSolvablePolynomial3 = (GenSolvablePolynomial)genSolvablePolynomial3.multiplyLeft(genSolvablePolynomial9).abs();
        return genSolvablePolynomial3;
    }
}

