/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigRational;
import edu.jas.gbufd.CharacteristicSet;
import edu.jas.gbufd.CharacteristicSetSimple;
import edu.jas.gbufd.CharacteristicSetWu;
import edu.jas.gbufd.PolyGBUtil;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.Element;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class CharSetTest
extends TestCase {
    CharacteristicSet<BigRational> cs;
    TermOrder to = new TermOrder(4);
    int rl = 3;
    int kl = 3;
    int ll = 4;
    int el = 3;
    float q = 0.29f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)CharSetTest.suite());
        ComputerThreads.terminate();
    }

    public CharSetTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(CharSetTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.cs = new CharacteristicSetWu<BigRational>();
    }

    protected void tearDown() {
        this.cs = null;
    }

    public void testCharacteristicSet() {
        CharacteristicSetSimple characteristicSetSimple = new CharacteristicSetSimple();
        BigRational bigRational = new BigRational();
        this.to = new TermOrder(2);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.to);
        ArrayList arrayList = new ArrayList();
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q * 1.1f);
        GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll + 2, this.el, this.q);
        GenPolynomial<BigRational> genPolynomial3 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        arrayList.add(genPolynomial);
        arrayList.add(genPolynomial2);
        arrayList.add(genPolynomial3);
        while (arrayList.size() <= this.rl) {
            arrayList.add(genPolynomialRing.getZERO());
        }
        CharSetTest.assertFalse((String)("isCharacteristicSet: " + arrayList), (boolean)characteristicSetSimple.isCharacteristicSet(arrayList));
        List list = characteristicSetSimple.characteristicSet(arrayList);
        CharSetTest.assertTrue((String)("isCharacteristicSet: " + list), (boolean)characteristicSetSimple.isCharacteristicSet(list));
        GenPolynomial<BigRational> genPolynomial4 = PolyGBUtil.topPseudoRemainder(list, genPolynomial);
        CharSetTest.assertTrue((String)("a rem G: " + genPolynomial4), (genPolynomial4.isZERO() || genPolynomial4.degree(this.rl - 1) < genPolynomial.degree(this.rl - 1) ? 1 : 0) != 0);
        genPolynomial4 = PolyGBUtil.topPseudoRemainder(list, list.get(0));
        CharSetTest.assertTrue((String)("a rem G: " + genPolynomial4 + ", G = " + list), (boolean)genPolynomial4.isZERO());
        genPolynomial4 = characteristicSetSimple.characteristicSetReduction(list, genPolynomial);
        CharSetTest.assertTrue((String)("a mod G: " + genPolynomial4), (genPolynomial4.isZERO() || genPolynomial4.degree(this.rl - 1) < genPolynomial.degree(this.rl - 1) ? 1 : 0) != 0);
        GenPolynomial<BigRational> genPolynomial5 = genPolynomialRing.getONE();
        if (!list.contains(genPolynomial5)) {
            genPolynomial5 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q).sum((BigRational)((Object)genPolynomial5));
            genPolynomial4 = PolyGBUtil.topPseudoRemainder(list, genPolynomial5);
            CharSetTest.assertFalse((String)("a rem G: " + genPolynomial4), (boolean)genPolynomial4.isZERO());
            genPolynomial4 = characteristicSetSimple.characteristicSetReduction(list, genPolynomial5);
            CharSetTest.assertFalse((String)("a mod G: " + genPolynomial4), (boolean)genPolynomial4.isZERO());
        }
        List list2 = this.cs.characteristicSet(arrayList);
        CharSetTest.assertTrue((String)("isCharacteristicSet: " + list2), (boolean)this.cs.isCharacteristicSet(list2));
        genPolynomial4 = PolyGBUtil.topPseudoRemainder(list2, genPolynomial);
        CharSetTest.assertTrue((String)("a rem W: " + genPolynomial4), (genPolynomial4.isZERO() || genPolynomial4.degree(this.rl - 1) < genPolynomial.degree(this.rl - 1) ? 1 : 0) != 0);
        genPolynomial4 = PolyGBUtil.topPseudoRemainder(list2, list2.get(0));
        CharSetTest.assertTrue((String)("a rem G: " + genPolynomial4 + ", W = " + list2), (boolean)genPolynomial4.isZERO());
        genPolynomial4 = this.cs.characteristicSetReduction(list2, list2.get(list2.size() - 1));
        CharSetTest.assertTrue((String)("a mod W: " + genPolynomial4), (boolean)genPolynomial4.isZERO());
        genPolynomial4 = this.cs.characteristicSetReduction(list2, genPolynomial);
        CharSetTest.assertTrue((String)("a mod W: " + genPolynomial4), (genPolynomial4.isZERO() || genPolynomial4.degree(this.rl - 1) < genPolynomial.degree(this.rl - 1) ? 1 : 0) != 0);
    }

    public void testCharacteristicSetWu() {
        BigRational bigRational = new BigRational();
        this.to = new TermOrder(2);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.to);
        ArrayList arrayList = new ArrayList();
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q * 1.1f);
        GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll + 2, this.el, this.q);
        GenPolynomial<BigRational> genPolynomial3 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        arrayList.add(genPolynomial);
        arrayList.add(genPolynomial2);
        arrayList.add(genPolynomial3);
        while (arrayList.size() <= this.rl) {
            arrayList.add(genPolynomialRing.getZERO());
        }
        CharSetTest.assertFalse((String)("isCharacteristicSet: " + arrayList), (boolean)this.cs.isCharacteristicSet(arrayList));
        List list = this.cs.characteristicSet(arrayList);
        CharSetTest.assertTrue((String)("isCharacteristicSet: " + list), (boolean)this.cs.isCharacteristicSet(list));
        GenPolynomial<BigRational> genPolynomial4 = PolyGBUtil.topPseudoRemainder(list, genPolynomial);
        CharSetTest.assertTrue((String)("a rem G: " + genPolynomial4), (genPolynomial4.isZERO() || genPolynomial4.degree(this.rl - 1) < genPolynomial.degree(this.rl - 1) ? 1 : 0) != 0);
        genPolynomial4 = this.cs.characteristicSetReduction(list, list.get(list.size() - 1));
        CharSetTest.assertTrue((String)("a mod G: " + genPolynomial4), (boolean)genPolynomial4.isZERO());
        genPolynomial4 = this.cs.characteristicSetReduction(list, list.get(0));
        CharSetTest.assertTrue((String)("a mod G: " + genPolynomial4), (boolean)genPolynomial4.isZERO());
        genPolynomial4 = this.cs.characteristicSetReduction(list, genPolynomial);
        CharSetTest.assertTrue((String)("a mod G: " + genPolynomial4 + ", G = " + list), (genPolynomial4.isZERO() || genPolynomial4.degree(this.rl - 1) < genPolynomial.degree(this.rl - 1) ? 1 : 0) != 0);
        GenPolynomial<BigRational> genPolynomial5 = genPolynomialRing.getONE();
        if (!list.contains(genPolynomial5)) {
            genPolynomial5 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q).sum((BigRational)((Object)genPolynomial5));
            genPolynomial4 = PolyGBUtil.topPseudoRemainder(list, genPolynomial5);
            CharSetTest.assertFalse((String)("a rem G: " + genPolynomial4), (boolean)genPolynomial4.isZERO());
            genPolynomial4 = this.cs.characteristicSetReduction(list, genPolynomial5);
            CharSetTest.assertFalse((String)("a mod G: " + genPolynomial4), (boolean)genPolynomial4.isZERO());
        }
    }

    public void testCharacteristicSetExample() {
        BigRational bigRational = new BigRational();
        this.to = new TermOrder(2);
        String[] stringArray = new String[]{"u1", "u2", "x1", "x2", "x3", "x4", "x5", "x6", "x7", "x8"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.to, stringArray);
        ArrayList arrayList = new ArrayList();
        Element element = genPolynomialRing.parse(" 2 x1 - u1 ");
        Element element2 = genPolynomialRing.parse(" 2 x2 - u2 ");
        Element element3 = genPolynomialRing.parse(" 2 x3 - u1 ");
        Element element4 = genPolynomialRing.parse(" 2 x4 - u2 ");
        Element element5 = genPolynomialRing.parse(" u2 x5 + u1 x6 - u1 u2 ");
        Element element6 = genPolynomialRing.parse(" u1 x5 - u2 x6 ");
        Element element7 = genPolynomialRing.parse(" x1^2 - x2^2 - 2 x1 x7 + 2 x2 x8 ");
        Element element8 = genPolynomialRing.parse(" x1^2 - 2 x1 x7 - x3^2 + 2 x3 x7 - x4^2 + 2 x4 x8 ");
        arrayList.add(element);
        arrayList.add(element2);
        arrayList.add(element3);
        arrayList.add(element4);
        arrayList.add(element5);
        arrayList.add(element6);
        arrayList.add(element7);
        arrayList.add(element8);
        CharSetTest.assertFalse((String)("isCharacteristicSet: " + arrayList), (boolean)this.cs.isCharacteristicSet(arrayList));
        List list = this.cs.characteristicSet(arrayList);
        CharSetTest.assertTrue((String)("isCharacteristicSet: " + list), (boolean)this.cs.isCharacteristicSet(list));
        Element element9 = genPolynomialRing.parse("( ( x5 - x7 )**2 + ( x6 - x8 )**2 - ( x1 - x7 )**2 - x8^2 )");
        GenPolynomial<BigRational> genPolynomial = this.cs.characteristicSetReduction(list, (GenPolynomial<BigRational>)element9);
        CharSetTest.assertTrue((String)("g mod G: " + genPolynomial), (boolean)genPolynomial.isZERO());
    }

    public void ytestCharacteristicSetExampleCC() {
        BigRational bigRational = new BigRational();
        this.to = new TermOrder(2);
        String[] stringArray = new String[]{"u1", "u2", "u3", "x1", "x2", "x3"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.to, stringArray);
        ArrayList arrayList = new ArrayList();
        Element element = genPolynomialRing.parse(" 2 u1 x2 - u1^2 ");
        Element element2 = genPolynomialRing.parse(" 2 u2 x2 + 2 u3 x1 - u2^2 - u3^2 ");
        Element element3 = genPolynomialRing.parse(" 2 u3 x3 - 2 ( u2 - u1 ) x2 - u2^2 - u3^2 + u1^2 ");
        arrayList.add(element);
        arrayList.add(element2);
        arrayList.add(element3);
        System.out.println("F = " + arrayList);
        CharSetTest.assertFalse((String)("isCharacteristicSet: " + arrayList), (boolean)this.cs.isCharacteristicSet(arrayList));
        List list = this.cs.characteristicSet(arrayList);
        System.out.println("G = " + list);
        CharSetTest.assertTrue((String)("isCharacteristicSet: " + list), (boolean)this.cs.isCharacteristicSet(list));
        Element element4 = genPolynomialRing.parse(" x3^2 - 2 x3 x1 + x1^2  ");
        System.out.println("g = " + element4);
        GenPolynomial<BigRational> genPolynomial = this.cs.characteristicSetReduction(list, (GenPolynomial<BigRational>)element4);
        System.out.println("e = " + genPolynomial);
        CharSetTest.assertTrue((String)("g mod G: " + genPolynomial), (genPolynomial.isZERO() || genPolynomial.degree(this.rl - 1) < ((GenPolynomial)element4).degree(this.rl - 1) ? 1 : 0) != 0);
    }

    public void testCharacteristicSetExampleSec() {
        BigRational bigRational = new BigRational();
        this.to = new TermOrder(2);
        String[] stringArray = new String[]{"u1", "u2", "u3", "u4", "y1", "y2", "y3"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.to, stringArray);
        ArrayList arrayList = new ArrayList();
        Element element = genPolynomialRing.parse(" 2 u3 y1 - u2^2 + u1^2 - u3^2 ");
        Element element2 = genPolynomialRing.parse(" - y2^2 + 2 y1 y2 + u1^2 - u4^2 ");
        Element element3 = genPolynomialRing.parse(" - y2 y3 + u3 y3 + y2 u2 - u4 u3 ");
        arrayList.add(element);
        arrayList.add(element2);
        arrayList.add(element3);
        CharSetTest.assertTrue((String)("isCharacteristicSet: " + arrayList), (boolean)this.cs.isCharacteristicSet(arrayList));
        List list = this.cs.characteristicSet(arrayList);
        CharSetTest.assertTrue((String)("isCharacteristicSet: " + list), (boolean)this.cs.isCharacteristicSet(list));
        Element element4 = genPolynomialRing.parse("( (y3 + u1)^2 (y3 - u1)^2 - ( (y3 - u2)^2 + u3^2 ) ( (y3 - u4)^2 + y2^2 ) )");
        GenPolynomial<BigRational> genPolynomial = this.cs.characteristicSetReduction(list, (GenPolynomial<BigRational>)element4);
        CharSetTest.assertTrue((String)("g mod G: " + genPolynomial), (boolean)genPolynomial.isZERO());
    }

    public void testCharacteristicSetExampleT() {
        BigRational bigRational = new BigRational();
        this.to = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.to, stringArray);
        ArrayList arrayList = new ArrayList();
        Element element = genPolynomialRing.parse(" x^2 + y + z - 1 ");
        Element element2 = genPolynomialRing.parse(" x + y^2 + z - 1 ");
        Element element3 = genPolynomialRing.parse(" x + y + z^2 - 1 ");
        arrayList.add(element);
        arrayList.add(element2);
        arrayList.add(element3);
        CharSetTest.assertFalse((String)("isCharacteristicSet: " + arrayList), (boolean)this.cs.isCharacteristicSet(arrayList));
        List list = this.cs.characteristicSet(arrayList);
        CharSetTest.assertTrue((String)("isCharacteristicSet: " + list), (boolean)this.cs.isCharacteristicSet(list));
    }
}

