/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.ReductionAbstract;
import edu.jas.gbufd.GBFactory;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.poly.TermOrderByName;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GroebnerBaseWalk<C extends GcdRingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = LogManager.getLogger(GroebnerBaseWalk.class);
    private static final boolean debug = logger.isDebugEnabled();
    protected GroebnerBaseAbstract<C> sgb;
    protected TermOrder startTO = TermOrderByName.IGRLEX;
    int iterPrint = 100;

    public GroebnerBaseWalk() {
        this.sgb = null;
    }

    public GroebnerBaseWalk(RingFactory<C> ringFactory) {
        this(GBFactory.getImplementation(ringFactory));
    }

    public GroebnerBaseWalk(RingFactory<C> ringFactory, TermOrder termOrder) {
        this(GBFactory.getImplementation(ringFactory), termOrder);
    }

    public GroebnerBaseWalk(GroebnerBaseAbstract<C> groebnerBaseAbstract) {
        super(groebnerBaseAbstract.red, groebnerBaseAbstract.strategy);
        this.sgb = groebnerBaseAbstract;
    }

    public GroebnerBaseWalk(GroebnerBaseAbstract<C> groebnerBaseAbstract, TermOrder termOrder) {
        this(groebnerBaseAbstract);
        this.startTO = termOrder;
    }

    @Override
    public String toString() {
        if (this.sgb == null) {
            return "GroebnerBaseWalk(" + this.startTO.toScript() + ")";
        }
        return "GroebnerBaseWalk( " + this.sgb.toString() + ", " + this.startTO.toScript() + " )";
    }

    @Override
    public List<GenPolynomial<C>> GB(int n, List<GenPolynomial<C>> list) {
        List<GenPolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if ((list2 = PolyUtil.monic(list2)) == null || list2.size() == 0) {
            return list2;
        }
        GenPolynomialRing genPolynomialRing = list2.get((int)0).ring;
        if (!genPolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("coefficients not from a field: " + genPolynomialRing.coFac);
        }
        if (list2.size() <= 1) {
            GenPolynomial genPolynomial = genPolynomialRing.copy(list2.get(0));
            list2.clear();
            list2.add(genPolynomial);
            return list2;
        }
        TermOrder termOrder = this.startTO;
        GenPolynomialRing<C> genPolynomialRing2 = new GenPolynomialRing<C>(genPolynomialRing, termOrder);
        if (debug) {
            logger.info("gfac = " + genPolynomialRing2.toScript());
        }
        List list3 = genPolynomialRing2.copy(list);
        logger.info("Term order: graded = " + termOrder + ", target = " + genPolynomialRing.tord);
        if (this.sgb == null) {
            this.sgb = GBFactory.getImplementation(genPolynomialRing.coFac, this.strategy);
        }
        List list4 = this.sgb.GB(n, list3);
        logger.info("graded / start GB = " + list4);
        if (termOrder.equals(genPolynomialRing.tord)) {
            return list4;
        }
        if (list4.size() == 1) {
            GenPolynomial genPolynomial = genPolynomialRing.copy(list4.get(0));
            list2.clear();
            list2.add(genPolynomial);
            return list2;
        }
        int n2 = this.commonZeroTest(list4);
        if (n2 == 0) {
            logger.info("ideal zero dimensional, can use also FGLM algorithm");
        }
        list2 = this.walkGroebnerToTarget(n, list4, genPolynomialRing);
        return list2;
    }

    public List<GenPolynomial<C>> walkGroebnerToTarget(int n, List<GenPolynomial<C>> list, GenPolynomialRing<C> genPolynomialRing) {
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("G may not be null or empty");
        }
        GenPolynomialRing genPolynomialRing2 = list.get((int)0).ring;
        if (debug) {
            logger.info("ring = " + genPolynomialRing2.toScript());
        }
        logger.info("G walk from ev1 = " + genPolynomialRing2.tord.toScript() + " to ev2 = " + genPolynomialRing.tord.toScript());
        List<GenPolynomial<C>> list2 = list;
        ArrayList<ExpVector> arrayList = new ArrayList<ExpVector>();
        ArrayList<Monomial<C>> arrayList2 = new ArrayList<Monomial<C>>();
        for (GenPolynomial<C> object2 : list2) {
            arrayList.add(object2.leadingExpVector());
            arrayList2.add(new Monomial<C>(object2.leadingMonomial()));
        }
        logger.info("marks = " + arrayList);
        ArrayList arrayList3 = new ArrayList(arrayList2);
        long[][] lArray = TermOrderByName.weightForOrder(genPolynomialRing.tord, genPolynomialRing2.nvar);
        TermOrder termOrder = new TermOrder(lArray);
        logger.info("weight order: " + termOrder);
        long[][] lArray2 = termOrder.getWeight();
        ExpVector expVector = null;
        int n2 = 0;
        boolean bl = false;
        while (!bl) {
            List<GenPolynomial<C>> list3;
            ++n2;
            PolynomialList polynomialList = new PolynomialList(genPolynomialRing2, list2);
            SortedSet<ExpVector> sortedSet = polynomialList.deltaExpVectors(arrayList);
            logger.info("w_old = " + expVector);
            ExpVector expVector2 = this.facetNormal(genPolynomialRing2.tord, genPolynomialRing.tord, sortedSet, genPolynomialRing2.evzero, lArray2);
            logger.info("minimal v = " + expVector2);
            if (expVector2 == null) {
                bl = true;
                break;
            }
            expVector = expVector2;
            ArrayList arrayList4 = new ArrayList();
            int n3 = 0;
            for (GenPolynomial<C> genPolynomial : list2) {
                list3 = (ExpVector)arrayList.get(n3++);
                GenPolynomial<C> genPolynomial2 = genPolynomial.leadingFacetPolynomial((ExpVector)((Object)list3), expVector);
                if (debug) {
                    logger.info("ing_g = [" + genPolynomial2 + "], lt(ing) = " + genPolynomial2.ring.toScript(genPolynomial2.leadingExpVector()) + ", f = " + genPolynomial.ring.toScript(genPolynomial.leadingExpVector()));
                }
                arrayList4.add(genPolynomial2);
            }
            List<GenPolynomial<C>> list4 = genPolynomialRing.copy(arrayList4);
            if (debug) {
                logger.info("inOmega = " + list4);
                logger.info("inOmega.ring: " + ((GenPolynomial)list4.get((int)0)).ring.toScript());
            }
            List list5 = this.sgb.GB(n, list4);
            if (debug) {
                logger.info("GB(inOmega) = " + list5);
            }
            arrayList.clear();
            arrayList2.clear();
            for (GenPolynomial genPolynomial : list5) {
                arrayList.add(genPolynomial.leadingExpVector());
                arrayList2.add(new Monomial(genPolynomial.leadingMonomial()));
            }
            logger.info("new marks/M = " + arrayList);
            list3 = this.liftReductas(arrayList2, arrayList3, list2, list5);
            if (debug || n2 % this.iterPrint == 0) {
                logger.info("lift(" + n2 + ") inOG, new GB: " + list3);
            }
            if (list3.size() == 1) {
                GenPolynomial<C> genPolynomial = genPolynomialRing.copy(list3.get(0));
                list3.clear();
                list3.add(genPolynomial);
                return list3;
            }
            list2 = list3;
            arrayList3.clear();
            arrayList3.addAll(arrayList2);
        }
        return list2;
    }

    public ExpVector facetNormal(TermOrder termOrder, TermOrder termOrder2, Set<ExpVector> set, ExpVector expVector, long[][] lArray) {
        TermOrder.EVComparator eVComparator = termOrder.getAscendComparator();
        TermOrder.EVComparator eVComparator2 = termOrder2.getAscendComparator();
        ExpVector expVector2 = null;
        long l = 0L;
        block0: for (ExpVector expVector3 : set) {
            if (eVComparator.compare(expVector, expVector3) >= 0 || eVComparator2.compare(expVector, expVector3) <= 0) continue;
            int n = 0;
            long l2 = 0L;
            ExpVector expVector4 = null;
            ExpVector expVector5 = null;
            if (expVector2 == null) {
                expVector2 = expVector3;
                logger.info("init v = " + expVector2);
                continue;
            }
            for (long[] lArray2 : lArray) {
                l = expVector2.weightDeg(lArray2);
                l2 = expVector3.weightDeg(lArray2);
                expVector4 = expVector2.scalarMultiply(l2);
                expVector5 = expVector3.scalarMultiply(l);
                n = eVComparator.compare(expVector5, expVector4);
                if (n == 0) continue;
                if (n <= 0) continue block0;
                expVector2 = expVector3;
                continue block0;
            }
        }
        return expVector2;
    }

    @Override
    public void terminate() {
        if (this.sgb == null) {
            return;
        }
        this.sgb.terminate();
    }

    @Override
    public int cancel() {
        if (this.sgb == null) {
            return 0;
        }
        return this.sgb.cancel();
    }

    public List<GenPolynomial<C>> liftReductas(List<Monomial<C>> list, List<Monomial<C>> list2, List<GenPolynomial<C>> list3, List<GenPolynomial<C>> list4) {
        Element element;
        GenPolynomial<Object> genPolynomial;
        Iterable<Monomial<Object>> iterable;
        Serializable serializable;
        Object object;
        if (list3 == null || list == null || list2 == null || list3.isEmpty()) {
            throw new IllegalArgumentException("null or empty lists not allowed");
        }
        if (list4 == null || list4.isEmpty()) {
            return list4;
        }
        if (list3.size() != list2.size() || list4.size() != list.size()) {
            throw new IllegalArgumentException("equal sized lists required");
        }
        GenPolynomial<C> genPolynomial2 = list3.get(0);
        if (genPolynomial2 == null) {
            throw new IllegalArgumentException("null polynomial not allowed");
        }
        ArrayList arrayList = new ArrayList(list3.size());
        int n = 0;
        int n2 = list3.size();
        for (n = 0; n < n2; ++n) {
            object = list2.get(n);
            serializable = list3.get(n).subtract((Monomial<C>)object);
            arrayList.add(serializable);
        }
        if (debug) {
            logger.info("lifter GB: Gp  = " + arrayList + ", Mp = " + list2);
        }
        logger.info("liftReductas: G = " + list3.size() + ", Mp = " + list2.size());
        object = list4;
        serializable = (ReductionAbstract)this.sgb.red;
        ArrayList<GenPolynomial<Object>> arrayList2 = new ArrayList<GenPolynomial<Object>>();
        GenPolynomialRing<C> genPolynomialRing = list4.get((int)0).ring;
        n2 = object.size();
        for (n = 0; n < n2; ++n) {
            iterable = (GenPolynomial)object.get(n);
            genPolynomial = ((ReductionAbstract)serializable).normalformMarked(list2, arrayList, iterable);
            arrayList2.add(genPolynomial);
        }
        logger.info("liftReductas: red(A) = " + arrayList2.size());
        if (debug) {
            logger.info("tring = " + genPolynomialRing.toScript());
        }
        iterable = new ArrayList(arrayList2.size());
        for (n = 0; n < list4.size(); ++n) {
            genPolynomial = genPolynomialRing.copy(list4.get(n));
            element = genPolynomialRing.copy((GenPolynomial)arrayList2.get(n));
            GenPolynomial<GenPolynomial<RingElem>> genPolynomial3 = genPolynomial.subtract(element);
            Monomial<C> monomial = list.get(n);
            genPolynomial3.doAddTo((GenPolynomial<RingElem>)((RingElem)((GcdRingElem)monomial.coefficient()).negate()), monomial.exponent());
            if (!((GcdRingElem)((Object)genPolynomial3.coefficient(monomial.exponent()))).isZERO()) {
                System.out.println("L-M: x = " + genPolynomial + ", r = " + element);
                throw new IllegalArgumentException("mark not removed: " + genPolynomial3 + ", m = " + monomial);
            }
            iterable.add(genPolynomial3);
        }
        if (debug) {
            logger.info("lifted-M, nb = " + iterable.size());
        }
        n2 = iterable.size();
        for (n = 0; n < n2; ++n) {
            genPolynomial = (GenPolynomial<Object>)iterable.remove(0);
            element = list.remove(0);
            if (debug) {
                logger.info("doing " + genPolynomial + ", lt = " + genPolynomialRing.toScript(((Monomial)element).exponent()));
            }
            genPolynomial = ((ReductionAbstract)serializable).normalformMarked(list, iterable, genPolynomial);
            if (debug) {
                logger.info("done, a = " + genPolynomial + ", lt = " + genPolynomialRing.toScript(genPolynomial.leadingExpVector()));
            }
            iterable.add(genPolynomial);
            list.add((Monomial<C>)element);
        }
        for (n = 0; n < n2; ++n) {
            genPolynomial = (GenPolynomial)iterable.get(n);
            element = list.get(n);
            genPolynomial.doAddTo(((Monomial)element).coefficient(), ((Monomial)element).exponent());
            iterable.set(n, genPolynomial);
        }
        logger.info("liftReductas: nb = " + iterable.size() + ", M = " + list.size());
        return iterable;
    }
}

