/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionSeq;
import edu.jas.gb.SolvableReduction;
import edu.jas.gb.SolvableReductionSeq;
import edu.jas.gbufd.SolvableSyzygy;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.ModuleList;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.GcdRingElem;
import edu.jas.vector.BasicLinAlg;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SolvableSyzygyAbstract<C extends GcdRingElem<C>>
implements SolvableSyzygy<C> {
    private static final Logger logger = LogManager.getLogger(SolvableSyzygyAbstract.class);
    private static final boolean debug = logger.isDebugEnabled();
    public final SolvableReduction<C> sred;
    protected Reduction<C> red = new ReductionSeq();
    protected BasicLinAlg<GenPolynomial<C>> blas;

    public SolvableSyzygyAbstract() {
        this.sred = new SolvableReductionSeq();
        this.blas = new BasicLinAlg();
    }

    @Override
    public List<List<GenSolvablePolynomial<C>>> leftZeroRelations(List<GenSolvablePolynomial<C>> list) {
        return this.leftZeroRelations(0, list);
    }

    @Override
    public List<List<GenSolvablePolynomial<C>>> leftZeroRelations(int n, List<GenSolvablePolynomial<C>> list) {
        ArrayList<List<GenSolvablePolynomial<C>>> arrayList = new ArrayList<List<GenSolvablePolynomial<C>>>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList2.add(null);
        }
        GenPolynomial genPolynomial = null;
        for (int i = 0; i < list.size(); ++i) {
            GenSolvablePolynomial<C> genSolvablePolynomial = list.get(i);
            if (genPolynomial == null) {
                genPolynomial = genSolvablePolynomial.ring.getZERO();
            }
            for (int j = i + 1; j < list.size(); ++j) {
                GenSolvablePolynomial<C> genSolvablePolynomial2 = list.get(j);
                if (!this.red.moduleCriterion(n, genSolvablePolynomial, genSolvablePolynomial2)) continue;
                ArrayList arrayList3 = new ArrayList(arrayList2);
                GenSolvablePolynomial<C> genSolvablePolynomial3 = this.sred.leftSPolynomial(arrayList3, i, genSolvablePolynomial, j, genSolvablePolynomial2);
                if (genSolvablePolynomial3.isZERO()) {
                    arrayList.add(arrayList3);
                    continue;
                }
                GenSolvablePolynomial<C> genSolvablePolynomial4 = this.sred.leftNormalform(arrayList3, list, genSolvablePolynomial3);
                if (!genSolvablePolynomial4.isZERO()) {
                    throw new ArithmeticException("Syzygy no leftGB");
                }
                if (logger.isDebugEnabled()) {
                    logger.info("row = " + arrayList3);
                }
                arrayList.add(arrayList3);
            }
        }
        for (List list2 : arrayList) {
            for (int i = 0; i < list2.size(); ++i) {
                if (list2.get(i) != null) continue;
                list2.set(i, genPolynomial);
            }
        }
        return arrayList;
    }

    @Override
    public ModuleList<C> leftZeroRelations(ModuleList<C> moduleList) {
        ModuleList moduleList2 = null;
        if (moduleList == null || moduleList.list == null) {
            return moduleList2;
        }
        if (moduleList.rows == 0 || moduleList.cols == 0) {
            return moduleList2;
        }
        GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)moduleList.ring.getZERO();
        PolynomialList<C> polynomialList = moduleList.getPolynomialList();
        int n = moduleList.cols;
        logger.info("modv = " + n);
        List<List<GenSolvablePolynomial<C>>> list = this.leftZeroRelations(n, polynomialList.castToSolvableList());
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            List<GenSolvablePolynomial<C>> list2 = list.get(i);
            ArrayList<GenSolvablePolynomial> arrayList2 = new ArrayList<GenSolvablePolynomial>();
            for (int j = 0; j < list2.size(); ++j) {
                GenSolvablePolynomial genSolvablePolynomial2 = list2.get(j);
                if (genSolvablePolynomial2 == null) continue;
                Map map = genSolvablePolynomial2.contract(moduleList.ring);
                if (map.size() == 0) {
                    arrayList2.add(genSolvablePolynomial);
                    continue;
                }
                if (map.size() == 1) {
                    GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)map.values().toArray()[0];
                    arrayList2.add(genSolvablePolynomial3);
                    continue;
                }
                throw new RuntimeException("Map.size() > 1 = " + map.size());
            }
            arrayList.add(arrayList2);
        }
        moduleList2 = new ModuleList((GenSolvablePolynomialRing)moduleList.ring, arrayList);
        return moduleList2;
    }

    public List<List<GenSolvablePolynomial<C>>> rightZeroRelations(List<GenSolvablePolynomial<C>> list) {
        return this.rightZeroRelations(0, list);
    }

    public List<List<GenSolvablePolynomial<C>>> rightZeroRelations(int n, List<GenSolvablePolynomial<C>> list) {
        PolynomialList<C> polynomialList;
        GenSolvablePolynomial genSolvablePolynomial;
        ArrayList<List<GenSolvablePolynomial<C>>> arrayList;
        GenPolynomialRing genPolynomialRing = null;
        for (GenSolvablePolynomial<C> iterable2 : list) {
            if (iterable2 == null) continue;
            genPolynomialRing = iterable2.ring;
            break;
        }
        if (genPolynomialRing == null) {
            arrayList = new ArrayList(1);
            arrayList.add(list);
            return arrayList;
        }
        GenPolynomialRing genPolynomialRing2 = ((GenSolvablePolynomialRing)genPolynomialRing).reverse(true);
        ArrayList<GenSolvablePolynomial<C>> arrayList2 = new ArrayList<GenSolvablePolynomial<C>>(list.size());
        for (GenSolvablePolynomial<C> bl : list) {
            if (bl == null) continue;
            genSolvablePolynomial = (GenSolvablePolynomial)bl.reverse(genPolynomialRing2);
            arrayList2.add(genSolvablePolynomial);
        }
        if (debug) {
            polynomialList = new PolynomialList<C>(genPolynomialRing2, arrayList2);
            logger.info("reversed problem = " + polynomialList.toScript());
        }
        polynomialList = this.leftZeroRelations(n, arrayList2);
        if (debug) {
            boolean genPolynomialRing22 = this.isLeftZeroRelation((List<List<GenSolvablePolynomial<C>>>)((Object)polynomialList), (List<GenSolvablePolynomial<C>>)arrayList2);
            logger.debug("isLeftZeroRelation = " + genPolynomialRing22);
        }
        GenPolynomialRing genPolynomialRing3 = ((GenSolvablePolynomialRing)genPolynomialRing2).reverse(true);
        if (debug) {
            logger.debug("ring == oring: " + ((GenSolvablePolynomialRing)genPolynomialRing).equals(genPolynomialRing3));
        }
        genPolynomialRing = genPolynomialRing3;
        arrayList = new ArrayList<List<GenSolvablePolynomial<C>>>(polynomialList.size());
        Iterator iterator = polynomialList.iterator();
        while (iterator.hasNext()) {
            List list2 = (List)iterator.next();
            if (list2 == null) continue;
            ArrayList<GenSolvablePolynomial> arrayList3 = new ArrayList<GenSolvablePolynomial>(list2.size());
            for (GenSolvablePolynomial genSolvablePolynomial2 : list2) {
                if (genSolvablePolynomial2 == null) continue;
                genSolvablePolynomial = (GenSolvablePolynomial)genSolvablePolynomial2.reverse(genPolynomialRing);
                arrayList3.add(genSolvablePolynomial);
            }
            arrayList.add(arrayList3);
        }
        return arrayList;
    }

    public ModuleList<C> rightZeroRelations(ModuleList<C> moduleList) {
        ModuleList moduleList2 = null;
        if (moduleList == null || moduleList.list == null) {
            return moduleList2;
        }
        if (moduleList.rows == 0 || moduleList.cols == 0) {
            return moduleList2;
        }
        GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)moduleList.ring.getZERO();
        PolynomialList<C> polynomialList = moduleList.getPolynomialList();
        int n = moduleList.cols;
        logger.info("modv = " + n);
        List<List<GenSolvablePolynomial<C>>> list = this.rightZeroRelations(n, polynomialList.castToSolvableList());
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            List<GenSolvablePolynomial<C>> list2 = list.get(i);
            ArrayList<GenSolvablePolynomial> arrayList2 = new ArrayList<GenSolvablePolynomial>();
            for (int j = 0; j < list2.size(); ++j) {
                GenSolvablePolynomial genSolvablePolynomial2 = list2.get(j);
                if (genSolvablePolynomial2 == null) continue;
                Map map = genSolvablePolynomial2.contract(moduleList.ring);
                if (map.size() == 0) {
                    arrayList2.add(genSolvablePolynomial);
                    continue;
                }
                if (map.size() == 1) {
                    GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)map.values().toArray()[0];
                    arrayList2.add(genSolvablePolynomial3);
                    continue;
                }
                throw new RuntimeException("Map.size() > 1 = " + map.size());
            }
            arrayList.add(arrayList2);
        }
        moduleList2 = new ModuleList((GenSolvablePolynomialRing)moduleList.ring, arrayList);
        return moduleList2;
    }

    @Override
    public boolean isLeftZeroRelation(List<List<GenSolvablePolynomial<C>>> list, List<GenSolvablePolynomial<C>> list2) {
        List<GenPolynomial<C>> list3 = PolynomialList.castToList(list2);
        for (List<GenSolvablePolynomial<C>> list4 : list) {
            GenPolynomial<C> genPolynomial = this.blas.scalarProduct(PolynomialList.castToList(list4), list3);
            if (genPolynomial == null || genPolynomial.isZERO()) continue;
            logger.info("is not ZeroRelation = " + genPolynomial);
            return false;
        }
        return true;
    }

    @Override
    public boolean isRightZeroRelation(List<List<GenSolvablePolynomial<C>>> list, List<GenSolvablePolynomial<C>> list2) {
        List<GenPolynomial<C>> list3 = PolynomialList.castToList(list2);
        for (List<GenSolvablePolynomial<C>> list4 : list) {
            List<GenPolynomial<C>> list5 = PolynomialList.castToList(list4);
            GenPolynomial<C> genPolynomial = this.blas.scalarProduct(list3, list5);
            if (genPolynomial == null || genPolynomial.isZERO()) continue;
            logger.info("is not ZeroRelation = " + genPolynomial);
            return false;
        }
        return true;
    }

    @Override
    public boolean isLeftZeroRelation(ModuleList<C> moduleList, ModuleList<C> moduleList2) {
        if (moduleList == null || moduleList.list == null) {
            return true;
        }
        for (List list : moduleList.list) {
            List list2 = this.blas.leftScalarProduct(list, moduleList2.list);
            if (this.blas.isZero(list2)) continue;
            logger.info("is not ZeroRelation (" + list2.size() + ") = " + list2);
            return false;
        }
        return true;
    }

    @Override
    public boolean isRightZeroRelation(ModuleList<C> moduleList, ModuleList<C> moduleList2) {
        if (moduleList == null || moduleList.list == null) {
            return true;
        }
        for (List list : moduleList.list) {
            List list2 = this.blas.rightScalarProduct(list, moduleList2.list);
            if (this.blas.isZero(list2)) continue;
            logger.info("is not ZeroRelation (" + list2.size() + ") = " + list2);
            return false;
        }
        return true;
    }

    @Override
    public List<List<GenSolvablePolynomial<C>>> leftZeroRelationsArbitrary(List<GenSolvablePolynomial<C>> list) {
        return this.leftZeroRelationsArbitrary(0, list);
    }

    @Override
    public ModuleList<C> leftZeroRelationsArbitrary(ModuleList<C> moduleList) {
        ModuleList moduleList2 = null;
        if (moduleList == null || moduleList.list == null) {
            return moduleList2;
        }
        if (moduleList.rows == 0 || moduleList.cols == 0) {
            return moduleList2;
        }
        GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)moduleList.ring.getZERO();
        PolynomialList<C> polynomialList = moduleList.getPolynomialList();
        int n = moduleList.cols;
        logger.info("modv = " + n);
        List<List<GenSolvablePolynomial<C>>> list = this.leftZeroRelationsArbitrary(n, polynomialList.castToSolvableList());
        if (list == null) {
            return moduleList2;
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            List<GenSolvablePolynomial<C>> list2 = list.get(i);
            ArrayList<GenSolvablePolynomial> arrayList2 = new ArrayList<GenSolvablePolynomial>();
            for (int j = 0; j < list2.size(); ++j) {
                GenSolvablePolynomial genSolvablePolynomial2 = list2.get(j);
                if (genSolvablePolynomial2 == null) continue;
                Map map = genSolvablePolynomial2.contract(moduleList.ring);
                if (map.size() == 0) {
                    arrayList2.add(genSolvablePolynomial);
                    continue;
                }
                if (map.size() == 1) {
                    GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)map.values().toArray()[0];
                    arrayList2.add(genSolvablePolynomial3);
                    continue;
                }
                throw new RuntimeException("Map.size() > 1 = " + map.size());
            }
            arrayList.add(arrayList2);
        }
        moduleList2 = new ModuleList((GenSolvablePolynomialRing)moduleList.ring, arrayList);
        return moduleList2;
    }

    @Override
    public List<List<GenSolvablePolynomial<C>>> rightZeroRelationsArbitrary(List<GenSolvablePolynomial<C>> list) {
        return this.rightZeroRelationsArbitrary(0, list);
    }

    @Override
    public List<List<GenSolvablePolynomial<C>>> rightZeroRelationsArbitrary(int n, List<GenSolvablePolynomial<C>> list) {
        PolynomialList polynomialList;
        GenSolvablePolynomial genSolvablePolynomial;
        ArrayList<List<GenSolvablePolynomial<C>>> arrayList;
        GenPolynomialRing serializable2 = null;
        for (GenSolvablePolynomial<C> iterable2 : list) {
            if (iterable2 == null) continue;
            serializable2 = iterable2.ring;
            break;
        }
        if (serializable2 == null) {
            arrayList = new ArrayList(1);
            arrayList.add(list);
            return arrayList;
        }
        GenPolynomialRing genPolynomialRing = ((GenSolvablePolynomialRing)serializable2).reverse(true);
        ArrayList arrayList2 = new ArrayList(list.size());
        for (GenSolvablePolynomial<C> genSolvablePolynomial2 : list) {
            if (genSolvablePolynomial2 == null) continue;
            genSolvablePolynomial = (GenSolvablePolynomial)genSolvablePolynomial2.reverse(genPolynomialRing);
            arrayList2.add(genSolvablePolynomial);
        }
        if (debug) {
            polynomialList = new PolynomialList(genPolynomialRing, arrayList2);
            logger.info("reversed problem = " + polynomialList.toScript());
        }
        polynomialList = this.leftZeroRelationsArbitrary(n, arrayList2);
        if (debug) {
            ModuleList moduleList = new ModuleList(genPolynomialRing, polynomialList);
            logger.info("reversed syzygies = " + moduleList.toScript());
            boolean bl = this.isLeftZeroRelation((List<List<GenSolvablePolynomial<C>>>)((Object)polynomialList), arrayList2);
            logger.info("isLeftZeroRelation = " + bl);
        }
        GenPolynomialRing genPolynomialRing2 = ((GenSolvablePolynomialRing)genPolynomialRing).reverse(true);
        if (debug) {
            logger.info("ring == oring: " + ((GenSolvablePolynomialRing)serializable2).equals(genPolynomialRing2));
        }
        serializable2 = genPolynomialRing2;
        arrayList = new ArrayList<List<GenSolvablePolynomial<C>>>(polynomialList.size());
        Iterator iterator = polynomialList.iterator();
        while (iterator.hasNext()) {
            List list2 = (List)iterator.next();
            if (list2 == null) continue;
            ArrayList<GenSolvablePolynomial> arrayList3 = new ArrayList<GenSolvablePolynomial>(list2.size());
            for (GenSolvablePolynomial genSolvablePolynomial3 : list2) {
                if (genSolvablePolynomial3 == null) continue;
                genSolvablePolynomial = (GenSolvablePolynomial)genSolvablePolynomial3.reverse(serializable2);
                arrayList3.add(genSolvablePolynomial);
            }
            arrayList.add(arrayList3);
        }
        return arrayList;
    }

    public ModuleList<C> rightZeroRelationsArbitrary(ModuleList<C> moduleList) {
        ModuleList moduleList2 = null;
        if (moduleList == null || moduleList.list == null) {
            return moduleList2;
        }
        if (moduleList.rows == 0 || moduleList.cols == 0) {
            return moduleList2;
        }
        GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)moduleList.ring.getZERO();
        PolynomialList<C> polynomialList = moduleList.getPolynomialList();
        int n = moduleList.cols;
        logger.info("modv = " + n);
        List<List<GenSolvablePolynomial<C>>> list = this.rightZeroRelationsArbitrary(n, polynomialList.castToSolvableList());
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            List<GenSolvablePolynomial<C>> list2 = list.get(i);
            ArrayList<GenSolvablePolynomial> arrayList2 = new ArrayList<GenSolvablePolynomial>();
            for (int j = 0; j < list2.size(); ++j) {
                GenSolvablePolynomial genSolvablePolynomial2 = list2.get(j);
                if (genSolvablePolynomial2 == null) continue;
                Map map = genSolvablePolynomial2.contract(moduleList.ring);
                if (map.size() == 0) {
                    arrayList2.add(genSolvablePolynomial);
                    continue;
                }
                if (map.size() == 1) {
                    GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)map.values().toArray()[0];
                    arrayList2.add(genSolvablePolynomial3);
                    continue;
                }
                logger.error("p = " + genSolvablePolynomial2 + ", r = " + map);
                throw new RuntimeException("Map.size() > 1 = " + map.size());
            }
            arrayList.add(arrayList2);
        }
        moduleList2 = new ModuleList((GenSolvablePolynomialRing)moduleList.ring, arrayList);
        return moduleList2;
    }

    @Override
    public boolean isLeftOreCond(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2, GenSolvablePolynomial<C>[] genSolvablePolynomialArray) {
        GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial3 = genSolvablePolynomialArray[0].multiply(genSolvablePolynomial);
        GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial4 = genSolvablePolynomialArray[1].multiply(genSolvablePolynomial2);
        return genSolvablePolynomial3.equals(genSolvablePolynomial4);
    }

    @Override
    public boolean isRightOreCond(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2, GenSolvablePolynomial<C>[] genSolvablePolynomialArray) {
        GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial3 = genSolvablePolynomial.multiply(genSolvablePolynomialArray[0]);
        GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial4 = genSolvablePolynomial2.multiply(genSolvablePolynomialArray[1]);
        return genSolvablePolynomial3.equals(genSolvablePolynomial4);
    }

    public abstract GenSolvablePolynomial<C>[] leftSimplifier(GenSolvablePolynomial<C> var1, GenSolvablePolynomial<C> var2);

    public int compare(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2, GenSolvablePolynomial<C> genSolvablePolynomial3, GenSolvablePolynomial<C> genSolvablePolynomial4) {
        int n;
        if (genSolvablePolynomial3 == null || genSolvablePolynomial3.isZERO()) {
            return genSolvablePolynomial.signum();
        }
        if (genSolvablePolynomial.isZERO()) {
            return -genSolvablePolynomial3.signum();
        }
        int n2 = genSolvablePolynomial.signum();
        int n3 = (n2 - (n = genSolvablePolynomial3.signum())) / 2;
        if (n3 != 0) {
            System.out.println("compareTo: t = " + n3);
        }
        if (genSolvablePolynomial2.compareTo(genSolvablePolynomial4) == 0) {
            return genSolvablePolynomial.compareTo(genSolvablePolynomial3);
        }
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray = this.leftOreCond(genSolvablePolynomial2, genSolvablePolynomial4);
        if (debug) {
            System.out.println("oc[0] den =<>= oc[1] d: (" + genSolvablePolynomialArray[0] + ") (" + genSolvablePolynomial2 + ") = (" + genSolvablePolynomialArray[1] + ") (" + genSolvablePolynomial4 + ")");
        }
        GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>> genSolvablePolynomial5 = genSolvablePolynomialArray[0].multiply(genSolvablePolynomial);
        GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial6 = genSolvablePolynomialArray[1].multiply(genSolvablePolynomial3);
        logger.info("compare: r = " + genSolvablePolynomial5 + ", s = " + genSolvablePolynomial6);
        return genSolvablePolynomial5.compareTo((GenPolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>>)genSolvablePolynomial6);
    }
}

