/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.Scripting;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberIterator;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.Element;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlgebraicNumberRing<C extends RingElem<C>>
implements RingFactory<AlgebraicNumber<C>>,
Iterable<AlgebraicNumber<C>> {
    public final GenPolynomialRing<C> ring;
    public final GenPolynomial<C> modul;
    protected int isField = -1;
    private static final Logger logger = LogManager.getLogger(AlgebraicNumberRing.class);

    public AlgebraicNumberRing(GenPolynomial<C> genPolynomial) {
        this.ring = genPolynomial.ring;
        this.modul = genPolynomial;
        if (this.ring.nvar > 1) {
            throw new IllegalArgumentException("only univariate polynomials allowed");
        }
    }

    public AlgebraicNumberRing(GenPolynomial<C> genPolynomial, boolean bl) {
        this.ring = genPolynomial.ring;
        this.modul = genPolynomial;
        int n = this.isField = bl ? 1 : 0;
        if (this.ring.nvar > 1) {
            throw new IllegalArgumentException("only univariate polynomials allowed");
        }
    }

    public GenPolynomial<C> getModul() {
        return this.modul;
    }

    @Override
    public AlgebraicNumber<C> copy(AlgebraicNumber<C> algebraicNumber) {
        return new AlgebraicNumber(this, algebraicNumber.val);
    }

    @Override
    public AlgebraicNumber<C> getZERO() {
        return new AlgebraicNumber(this, this.ring.getZERO());
    }

    @Override
    public AlgebraicNumber<C> getONE() {
        return new AlgebraicNumber(this, this.ring.getONE());
    }

    public AlgebraicNumber<C> getGenerator() {
        return new AlgebraicNumber<C>(this, this.ring.univariate(0));
    }

    @Override
    public List<AlgebraicNumber<C>> generators() {
        List<GenPolynomial<C>> list = this.ring.generators();
        ArrayList<AlgebraicNumber<C>> arrayList = new ArrayList<AlgebraicNumber<C>>(list.size());
        for (GenPolynomial<C> genPolynomial : list) {
            arrayList.add(new AlgebraicNumber<C>(this, genPolynomial));
        }
        return arrayList;
    }

    @Override
    public boolean isFinite() {
        return this.ring.coFac.isFinite();
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.ring.isAssociative();
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        if (!this.ring.coFac.isField()) {
            this.isField = 0;
            return false;
        }
        return false;
    }

    public void setField(boolean bl) {
        if (this.isField > 0 && bl) {
            return;
        }
        if (this.isField == 0 && !bl) {
            return;
        }
        this.isField = bl ? 1 : 0;
    }

    public int getField() {
        return this.isField;
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    public AlgebraicNumber<C> fillFromInteger(BigInteger bigInteger) {
        Object object;
        BigInteger bigInteger2;
        if (this.characteristic().signum() == 0) {
            return new AlgebraicNumber(this, this.ring.fromInteger(bigInteger));
        }
        BigInteger bigInteger3 = this.characteristic();
        BigInteger bigInteger4 = bigInteger;
        GenPolynomial<GenPolynomial<Element>> genPolynomial = this.ring.getZERO();
        GenPolynomial<C> genPolynomial2 = this.ring.univariate(0, 1L);
        GenPolynomial<GenPolynomial<Element>> genPolynomial3 = this.ring.getONE();
        do {
            object = bigInteger4.divideAndRemainder(bigInteger3);
            bigInteger2 = object[0];
            BigInteger bigInteger5 = object[1];
            Element element = this.ring.fromInteger(bigInteger5);
            genPolynomial = genPolynomial.sum(genPolynomial3.multiply((GenPolynomial<Element>)element));
            genPolynomial3 = genPolynomial3.multiply((GenPolynomial<Element>)genPolynomial2);
        } while (!(bigInteger4 = bigInteger2).equals(BigInteger.ZERO));
        object = new AlgebraicNumber<GenPolynomial<Element>>(this, genPolynomial);
        logger.info("fill(" + bigInteger + ") = " + genPolynomial + ", mod: " + object);
        return object;
    }

    public AlgebraicNumber<C> fillFromInteger(long l) {
        return this.fillFromInteger(new BigInteger("" + l));
    }

    @Override
    public AlgebraicNumber<C> fromInteger(BigInteger bigInteger) {
        return new AlgebraicNumber(this, this.ring.fromInteger(bigInteger));
    }

    @Override
    public AlgebraicNumber<C> fromInteger(long l) {
        return new AlgebraicNumber(this, this.ring.fromInteger(l));
    }

    public String toString() {
        return "AlgebraicNumberRing[ " + this.modul.toString() + " | isField=" + this.isField + " :: " + this.ring.toString() + " ]";
    }

    @Override
    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AN(");
        stringBuffer.append(this.modul.toScript());
        switch (Scripting.getLang()) {
            case Ruby: {
                stringBuffer.append(this.isField() ? ",true" : ",false");
                break;
            }
            default: {
                stringBuffer.append(this.isField() ? ",True" : ",False");
            }
        }
        stringBuffer.append(",");
        stringBuffer.append(this.ring.toScript());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof AlgebraicNumberRing)) {
            return false;
        }
        AlgebraicNumberRing algebraicNumberRing = (AlgebraicNumberRing)object;
        return this.modul.equals(algebraicNumberRing.modul);
    }

    public int hashCode() {
        return 37 * this.modul.hashCode() + this.ring.hashCode();
    }

    @Override
    public AlgebraicNumber<C> random(int n) {
        GenPolynomial genPolynomial = ((GenPolynomial)this.ring.random(n)).monic();
        return new AlgebraicNumber(this, genPolynomial);
    }

    @Override
    public AlgebraicNumber<C> random(int n, Random random) {
        GenPolynomial genPolynomial = ((GenPolynomial)this.ring.random(n, random)).monic();
        return new AlgebraicNumber(this, genPolynomial);
    }

    @Override
    public AlgebraicNumber<C> parse(String string) {
        Element element = this.ring.parse(string);
        return new AlgebraicNumber(this, element);
    }

    @Override
    public AlgebraicNumber<C> parse(Reader reader) {
        Element element = this.ring.parse(reader);
        return new AlgebraicNumber(this, element);
    }

    public AlgebraicNumber<C> chineseRemainder(AlgebraicNumber<C> algebraicNumber, AlgebraicNumber<C> algebraicNumber2, AlgebraicNumber<C> algebraicNumber3) {
        AlgebraicNumber<Object> algebraicNumber4;
        AlgebraicNumber<AlgebraicNumber<C>> algebraicNumber5;
        if (algebraicNumber.ring.modul.compareTo(algebraicNumber3.ring.modul) < 1) {
            System.out.println("AlgebraicNumber error " + algebraicNumber + ", " + algebraicNumber3);
        }
        if ((algebraicNumber5 = algebraicNumber3.subtract(algebraicNumber4 = new AlgebraicNumber(algebraicNumber3.ring, algebraicNumber.val))).isZERO()) {
            return new AlgebraicNumber(this, algebraicNumber.val);
        }
        algebraicNumber4 = algebraicNumber5.multiply(algebraicNumber2);
        GenPolynomial genPolynomial = algebraicNumber.ring.modul.multiply(algebraicNumber4.val);
        genPolynomial = genPolynomial.sum(algebraicNumber.val);
        return new AlgebraicNumber(this, genPolynomial);
    }

    public AlgebraicNumber<C> interpolate(AlgebraicNumber<C> algebraicNumber, C c, C c2, C c3) {
        Object object = PolyUtil.evaluateMain(this.ring.coFac, algebraicNumber.val, c2);
        RingElem ringElem = (RingElem)c3.subtract(object);
        if (ringElem.isZERO()) {
            return new AlgebraicNumber(this, algebraicNumber.val);
        }
        object = (RingElem)ringElem.multiply(c);
        GenPolynomial genPolynomial = algebraicNumber.ring.modul.multiply(object);
        genPolynomial = genPolynomial.sum(algebraicNumber.val);
        return new AlgebraicNumber<C>(this, genPolynomial);
    }

    public int depth() {
        AlgebraicNumberRing algebraicNumberRing = this;
        int n = 1;
        RingFactory ringFactory = algebraicNumberRing.ring.coFac;
        if (ringFactory instanceof AlgebraicNumberRing) {
            algebraicNumberRing = (AlgebraicNumberRing)ringFactory;
            n += algebraicNumberRing.depth();
        }
        return n;
    }

    public long extensionDegree() {
        long l = this.modul.degree(0);
        return l;
    }

    public long totalExtensionDegree() {
        long l = this.modul.degree(0);
        AlgebraicNumberRing algebraicNumberRing = this;
        RingFactory ringFactory = algebraicNumberRing.ring.coFac;
        if (ringFactory instanceof AlgebraicNumberRing) {
            algebraicNumberRing = (AlgebraicNumberRing)ringFactory;
            l = l == 0L ? algebraicNumberRing.totalExtensionDegree() : (l *= algebraicNumberRing.totalExtensionDegree());
        }
        return l;
    }

    @Override
    public Iterator<AlgebraicNumber<C>> iterator() {
        return new AlgebraicNumberIterator(this);
    }
}

