/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.UnaryFunctor;

class ComplToAlgeb<C extends GcdRingElem<C>>
implements UnaryFunctor<Complex<C>, AlgebraicNumber<C>> {
    protected final AlgebraicNumberRing<C> afac;
    protected final AlgebraicNumber<C> I;

    public ComplToAlgeb(AlgebraicNumberRing<C> algebraicNumberRing) {
        if (algebraicNumberRing == null) {
            throw new IllegalArgumentException("fac must not be null");
        }
        this.afac = algebraicNumberRing;
        this.I = this.afac.getGenerator();
    }

    @Override
    public AlgebraicNumber<C> eval(Complex<C> complex) {
        if (complex == null || complex.isZERO()) {
            return this.afac.getZERO();
        }
        if (complex.isONE()) {
            return this.afac.getONE();
        }
        if (complex.isIMAG()) {
            return this.I;
        }
        return this.I.multiply(complex.getIm()).sum(complex.getRe());
    }
}

