/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.QLRSolvablePolynomialRing;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.TableRelation;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPair;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QLRSolvablePolynomial<C extends GcdRingElem<C> & QuotPair<GenPolynomial<D>>, D extends GcdRingElem<D>>
extends GenSolvablePolynomial<C> {
    private static final Logger logger = LogManager.getLogger(QLRSolvablePolynomial.class);
    private static final boolean debug = logger.isDebugEnabled();
    public final QLRSolvablePolynomialRing<C, D> ring;

    public QLRSolvablePolynomial(QLRSolvablePolynomialRing<C, D> qLRSolvablePolynomialRing) {
        super(qLRSolvablePolynomialRing);
        this.ring = qLRSolvablePolynomialRing;
    }

    public QLRSolvablePolynomial(QLRSolvablePolynomialRing<C, D> qLRSolvablePolynomialRing, C c, ExpVector expVector) {
        this(qLRSolvablePolynomialRing);
        if (c != null && !c.isZERO()) {
            this.val.put(expVector, c);
        }
    }

    public QLRSolvablePolynomial(QLRSolvablePolynomialRing<C, D> qLRSolvablePolynomialRing, C c) {
        this(qLRSolvablePolynomialRing, c, qLRSolvablePolynomialRing.evzero);
    }

    public QLRSolvablePolynomial(QLRSolvablePolynomialRing<C, D> qLRSolvablePolynomialRing, GenSolvablePolynomial<C> genSolvablePolynomial) {
        this(qLRSolvablePolynomialRing, genSolvablePolynomial.getMap());
    }

    protected QLRSolvablePolynomial(QLRSolvablePolynomialRing<C, D> qLRSolvablePolynomialRing, SortedMap<ExpVector, C> sortedMap) {
        this(qLRSolvablePolynomialRing);
        this.val.putAll(sortedMap);
    }

    @Override
    public QLRSolvablePolynomialRing<C, D> factory() {
        return this.ring;
    }

    @Override
    public QLRSolvablePolynomial<C, D> copy() {
        return new QLRSolvablePolynomial<C, D>(this.ring, this.val);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof QLRSolvablePolynomial)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public QLRSolvablePolynomial<C, D> multiply(QLRSolvablePolynomial<C, D> qLRSolvablePolynomial) {
        if (qLRSolvablePolynomial == null || qLRSolvablePolynomial.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        if (qLRSolvablePolynomial.isONE()) {
            return this;
        }
        if (this.isONE()) {
            return qLRSolvablePolynomial;
        }
        assert (this.ring.nvar == qLRSolvablePolynomial.ring.nvar);
        if (debug) {
            logger.debug("ring = " + this.ring);
        }
        ExpVector expVector = this.ring.evzero;
        GenSolvablePolynomial genSolvablePolynomial = ((QLRSolvablePolynomial)this.ring.getZERO()).copy();
        GenSolvablePolynomial genSolvablePolynomial2 = ((QLRSolvablePolynomial)this.ring.getZERO()).copy();
        GcdRingElem gcdRingElem = (GcdRingElem)this.ring.getONECoefficient();
        SortedMap sortedMap = this.val;
        SortedMap sortedMap2 = qLRSolvablePolynomial.val;
        Set set = sortedMap2.entrySet();
        for (Map.Entry entry : sortedMap.entrySet()) {
            GcdRingElem gcdRingElem2 = (GcdRingElem)entry.getValue();
            ExpVector expVector2 = (ExpVector)entry.getKey();
            if (debug) {
                logger.info("e = " + expVector2 + ", a = " + gcdRingElem2);
            }
            for (Map.Entry entry2 : set) {
                Object object;
                AbelianGroupElem<ExpVector> abelianGroupElem;
                GcdRingElem gcdRingElem3;
                QLRSolvablePolynomial qLRSolvablePolynomial2;
                QLRSolvablePolynomial<Object, D> qLRSolvablePolynomial3;
                RingElem<GenPolynomial<GenPolynomial<Object>>> ringElem;
                GenSolvablePolynomial genSolvablePolynomial3;
                RecSolvablePolynomial recSolvablePolynomial;
                GcdRingElem gcdRingElem4 = (GcdRingElem)entry2.getValue();
                ExpVector expVector3 = (ExpVector)entry2.getKey();
                if (debug) {
                    logger.info("f = " + expVector3 + ", b = " + gcdRingElem4);
                }
                int[] nArray = expVector3.dependencyOnVariables();
                int n = 0;
                if (nArray.length > 0) {
                    n = nArray[nArray.length - 1];
                }
                int n2 = this.ring.nvar + 1 - n;
                QLRSolvablePolynomial<GcdRingElem<GcdRingElem>, D> qLRSolvablePolynomial4 = ((QLRSolvablePolynomial)this.ring.getZERO()).copy();
                if (this.ring.polCoeff.isCommutative() || ((QuotPair)((Object)gcdRingElem4)).isConstant() || expVector2.isZERO()) {
                    qLRSolvablePolynomial4 = new QLRSolvablePolynomial<GcdRingElem, D>(this.ring, gcdRingElem4, expVector2);
                    if (debug) {
                        logger.info("symmetric coeff: b = " + gcdRingElem4 + ", e = " + expVector2);
                    }
                } else {
                    if (debug) {
                        logger.info("unsymmetric coeff: b = " + gcdRingElem4 + ", e = " + expVector2);
                    }
                    if (((GenPolynomial)((QuotPair)((Object)gcdRingElem4)).denominator()).isONE()) {
                        recSolvablePolynomial = new RecSolvablePolynomial(this.ring.polCoeff, expVector2);
                        genSolvablePolynomial3 = new RecSolvablePolynomial(this.ring.polCoeff, (GenPolynomial)((QuotPair)((Object)gcdRingElem4)).numerator());
                        ringElem = recSolvablePolynomial.multiply(genSolvablePolynomial3);
                        qLRSolvablePolynomial3 = this.ring.fromPolyCoefficients((GenSolvablePolynomial<GenPolynomial<D>>)ringElem);
                        qLRSolvablePolynomial4 = qLRSolvablePolynomial3;
                    } else {
                        if (debug) {
                            logger.info("coeff-num: Cps = " + qLRSolvablePolynomial4 + ", num = " + ((QuotPair)((Object)gcdRingElem4)).numerator() + ", den = " + ((QuotPair)((Object)gcdRingElem4)).denominator());
                        }
                        recSolvablePolynomial = (RingFactory)gcdRingElem4.factory();
                        qLRSolvablePolynomial4 = new QLRSolvablePolynomial<GcdRingElem, D>(this.ring, (GcdRingElem)recSolvablePolynomial.getONE(), expVector2);
                        genSolvablePolynomial3 = qLRSolvablePolynomial4;
                        ringElem = (GcdRingElem)this.ring.qpfac.create(((QuotPair)((Object)gcdRingElem4)).denominator());
                        qLRSolvablePolynomial3 = ((QLRSolvablePolynomial)genSolvablePolynomial3).multiply((C)ringElem);
                        qLRSolvablePolynomial2 = ((QLRSolvablePolynomial)genSolvablePolynomial3).multiplyLeft((C)ringElem);
                        QLRSolvablePolynomial qLRSolvablePolynomial5 = (QLRSolvablePolynomial)qLRSolvablePolynomial3.subtract((Object)qLRSolvablePolynomial2);
                        gcdRingElem3 = (GcdRingElem)this.ring.qpfac.create((RingElem)this.ring.qpfac.pairFactory().getONE(), ((QuotPair)((Object)gcdRingElem4)).denominator());
                        if (genSolvablePolynomial3.leadingExpVector().equals(qLRSolvablePolynomial5.leadingExpVector())) {
                            throw new IllegalArgumentException("qr !> vr: qv = " + genSolvablePolynomial3 + ", vr = " + qLRSolvablePolynomial5);
                        }
                        abelianGroupElem = qLRSolvablePolynomial5.multiply((C)gcdRingElem3);
                        QLRSolvablePolynomial<GcdRingElem, D> qLRSolvablePolynomial52 = (QLRSolvablePolynomial<GcdRingElem, D>)genSolvablePolynomial3.subtract(abelianGroupElem);
                        qLRSolvablePolynomial52 = qLRSolvablePolynomial52.multiplyLeft(gcdRingElem3);
                        qLRSolvablePolynomial4 = qLRSolvablePolynomial52;
                        if (!((GenPolynomial)((QuotPair)((Object)gcdRingElem4)).numerator()).isONE()) {
                            object = (GcdRingElem)this.ring.qpfac.create(((QuotPair)((Object)gcdRingElem4)).numerator());
                            qLRSolvablePolynomial4 = qLRSolvablePolynomial4.multiply((GcdRingElem)object);
                        }
                    }
                }
                if (debug) {
                    logger.info("coeff-den: Cps = " + qLRSolvablePolynomial4);
                }
                recSolvablePolynomial = ((QLRSolvablePolynomial)this.ring.getZERO()).copy();
                genSolvablePolynomial3 = null;
                if (this.ring.isCommutative() || qLRSolvablePolynomial4.isConstant() || expVector3.isZERO()) {
                    if (debug) {
                        logger.info("symmetric poly: b = " + gcdRingElem4 + ", e = " + expVector2);
                    }
                    if (qLRSolvablePolynomial4.isConstant()) {
                        qLRSolvablePolynomial2 = expVector2.sum(expVector3);
                        genSolvablePolynomial3 = new QLRSolvablePolynomial<GcdRingElem, D>(this.ring, (GcdRingElem)qLRSolvablePolynomial4.leadingBaseCoefficient(), (ExpVector)((Object)qLRSolvablePolynomial2));
                    } else {
                        genSolvablePolynomial3 = qLRSolvablePolynomial4.shift(expVector3);
                    }
                } else {
                    if (debug) {
                        logger.info("unsymmetric poly: Cps = " + qLRSolvablePolynomial4 + ", f = " + expVector3);
                    }
                    for (Map.Entry entry3 : qLRSolvablePolynomial4.val.entrySet()) {
                        ExpVector expVector4;
                        int n3;
                        gcdRingElem3 = (GcdRingElem)entry3.getValue();
                        abelianGroupElem = (ExpVector)entry3.getKey();
                        if (debug) {
                            logger.info("g = " + abelianGroupElem + ", c = " + gcdRingElem3);
                        }
                        object = ((ExpVector)abelianGroupElem).dependencyOnVariables();
                        int n4 = this.ring.nvar + 1;
                        if (((int[])object).length > 0) {
                            n4 = object[0];
                        }
                        if ((n3 = this.ring.nvar + 1 - n4) <= n2) {
                            expVector4 = ((ExpVector)abelianGroupElem).sum(expVector3);
                            if (debug) {
                                logger.info("disjoint poly: g = " + abelianGroupElem + ", f = " + expVector3 + ", h = " + expVector4);
                            }
                            genSolvablePolynomial3 = (QLRSolvablePolynomial)genSolvablePolynomial2.sum(gcdRingElem, expVector4);
                        } else {
                            expVector4 = ((ExpVector)abelianGroupElem).subst(n4, 0L);
                            ExpVector expVector5 = expVector.subst(n4, ((ExpVector)abelianGroupElem).getVal(n4));
                            ExpVector expVector6 = expVector3.subst(n, 0L);
                            ExpVector expVector7 = expVector.subst(n, expVector3.getVal(n));
                            if (debug) {
                                logger.info("poly, g1 = " + expVector4 + ", f1 = " + expVector6 + ", Dps = " + recSolvablePolynomial);
                                logger.info("poly, g2 = " + expVector5 + ", f2 = " + expVector7);
                            }
                            TableRelation tableRelation = this.ring.table.lookup(expVector5, expVector7);
                            if (debug) {
                                logger.info("poly, g  = " + abelianGroupElem + ", f  = " + expVector3 + ", rel = " + tableRelation);
                            }
                            genSolvablePolynomial3 = new QLRSolvablePolynomial<C, D>(this.ring, tableRelation.p);
                            if (tableRelation.f != null) {
                                qLRSolvablePolynomial3 = new QLRSolvablePolynomial<GcdRingElem, D>(this.ring, gcdRingElem, tableRelation.f);
                                genSolvablePolynomial3 = ((QLRSolvablePolynomial)genSolvablePolynomial3).multiply((C)qLRSolvablePolynomial3);
                                ExpVector expVector8 = tableRelation.e == null ? expVector5 : expVector5.subtract(tableRelation.e);
                                this.ring.table.update(expVector8, expVector7, genSolvablePolynomial3);
                            }
                            if (tableRelation.e != null) {
                                ringElem = new QLRSolvablePolynomial<GcdRingElem, D>(this.ring, gcdRingElem, tableRelation.e);
                                genSolvablePolynomial3 = ((QLRSolvablePolynomial)ringElem).multiply((C)genSolvablePolynomial3);
                                this.ring.table.update(expVector5, expVector7, genSolvablePolynomial3);
                            }
                            if (!expVector6.isZERO()) {
                                qLRSolvablePolynomial3 = new QLRSolvablePolynomial<GcdRingElem, D>(this.ring, gcdRingElem, expVector6);
                                genSolvablePolynomial3 = ((QLRSolvablePolynomial)genSolvablePolynomial3).multiply((C)qLRSolvablePolynomial3);
                            }
                            if (!expVector4.isZERO()) {
                                ringElem = new QLRSolvablePolynomial<GcdRingElem, D>(this.ring, gcdRingElem, expVector4);
                                genSolvablePolynomial3 = ((QLRSolvablePolynomial)ringElem).multiply((C)genSolvablePolynomial3);
                            }
                        }
                        genSolvablePolynomial3 = ((QLRSolvablePolynomial)genSolvablePolynomial3).multiplyLeft((C)gcdRingElem3);
                        recSolvablePolynomial.doAddTo(genSolvablePolynomial3);
                    }
                    genSolvablePolynomial3 = recSolvablePolynomial;
                }
                genSolvablePolynomial3 = ((QLRSolvablePolynomial)genSolvablePolynomial3).multiplyLeft((C)gcdRingElem2);
                if (debug) {
                    logger.debug("Ds = " + genSolvablePolynomial3);
                }
                genSolvablePolynomial.doAddTo(genSolvablePolynomial3);
            }
        }
        return genSolvablePolynomial;
    }

    public QLRSolvablePolynomial<C, D> multiply(QLRSolvablePolynomial<C, D> qLRSolvablePolynomial, QLRSolvablePolynomial<C, D> qLRSolvablePolynomial2) {
        if (qLRSolvablePolynomial.isZERO() || qLRSolvablePolynomial2.isZERO() || this.isZERO()) {
            return this.ring.getZERO();
        }
        if (qLRSolvablePolynomial.isONE()) {
            return this.multiply((C)qLRSolvablePolynomial2);
        }
        if (qLRSolvablePolynomial2.isONE()) {
            return qLRSolvablePolynomial.multiply(this);
        }
        return qLRSolvablePolynomial.multiply(this).multiply(qLRSolvablePolynomial2);
    }

    @Override
    public QLRSolvablePolynomial<C, D> multiply(C c) {
        QLRSolvablePolynomial<C, D> qLRSolvablePolynomial = ((QLRSolvablePolynomial)this.ring.getZERO()).copy();
        if (c == null || c.isZERO()) {
            return qLRSolvablePolynomial;
        }
        if (c.isONE()) {
            return this;
        }
        qLRSolvablePolynomial = new QLRSolvablePolynomial<C, D>(this.ring, c, this.ring.evzero);
        return this.multiply((C)qLRSolvablePolynomial);
    }

    public QLRSolvablePolynomial<C, D> multiply(C c, C c2) {
        QLRSolvablePolynomial<C, D> qLRSolvablePolynomial = ((QLRSolvablePolynomial)this.ring.getZERO()).copy();
        if (c == null || c.isZERO()) {
            return qLRSolvablePolynomial;
        }
        if (c2 == null || c2.isZERO()) {
            return qLRSolvablePolynomial;
        }
        if (c.isONE() && c2.isONE()) {
            return this;
        }
        qLRSolvablePolynomial = new QLRSolvablePolynomial<C, D>(this.ring, c, this.ring.evzero);
        QLRSolvablePolynomial<C, D> qLRSolvablePolynomial2 = new QLRSolvablePolynomial<C, D>(this.ring, c2, this.ring.evzero);
        return this.multiply((C)qLRSolvablePolynomial, (C)qLRSolvablePolynomial2);
    }

    @Override
    public QLRSolvablePolynomial<C, D> multiply(ExpVector expVector) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        GcdRingElem gcdRingElem = (GcdRingElem)this.ring.getONECoefficient();
        return this.multiply((C)gcdRingElem, expVector);
    }

    public QLRSolvablePolynomial<C, D> multiply(ExpVector expVector, ExpVector expVector2) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        if (expVector2 == null || expVector2.isZERO()) {
            return this;
        }
        GcdRingElem gcdRingElem = (GcdRingElem)this.ring.getONECoefficient();
        return this.multiply((C)gcdRingElem, expVector, (C)gcdRingElem, expVector2);
    }

    public QLRSolvablePolynomial<C, D> multiply(C c, ExpVector expVector) {
        if (c == null || c.isZERO()) {
            return this.ring.getZERO();
        }
        if (c.isONE() && expVector.isZERO()) {
            return this;
        }
        QLRSolvablePolynomial<C, D> qLRSolvablePolynomial = new QLRSolvablePolynomial<C, D>(this.ring, c, expVector);
        return this.multiply((C)qLRSolvablePolynomial);
    }

    public QLRSolvablePolynomial<C, D> multiply(C c, ExpVector expVector, C c2, ExpVector expVector2) {
        if (c == null || c.isZERO()) {
            return this.ring.getZERO();
        }
        if (c2 == null || c2.isZERO()) {
            return this.ring.getZERO();
        }
        if (c.isONE() && expVector.isZERO() && c2.isONE() && expVector2.isZERO()) {
            return this;
        }
        QLRSolvablePolynomial<C, D> qLRSolvablePolynomial = new QLRSolvablePolynomial<C, D>(this.ring, c, expVector);
        QLRSolvablePolynomial<C, D> qLRSolvablePolynomial2 = new QLRSolvablePolynomial<C, D>(this.ring, c2, expVector2);
        return this.multiply((C)qLRSolvablePolynomial, (C)qLRSolvablePolynomial2);
    }

    public QLRSolvablePolynomial<C, D> multiplyLeft(C c, ExpVector expVector) {
        if (c == null || c.isZERO()) {
            return this.ring.getZERO();
        }
        QLRSolvablePolynomial<QLRSolvablePolynomial, D> qLRSolvablePolynomial = new QLRSolvablePolynomial<QLRSolvablePolynomial, D>(this.ring, (QLRSolvablePolynomial)c, expVector);
        return qLRSolvablePolynomial.multiply(this);
    }

    public QLRSolvablePolynomial<C, D> multiplyLeft(ExpVector expVector) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        GcdRingElem gcdRingElem = (GcdRingElem)this.ring.getONECoefficient();
        QLRSolvablePolynomial<GcdRingElem, D> qLRSolvablePolynomial = new QLRSolvablePolynomial<GcdRingElem, D>(this.ring, gcdRingElem, expVector);
        return qLRSolvablePolynomial.multiply((GcdRingElem)((Object)this));
    }

    public QLRSolvablePolynomial<C, D> multiplyLeft(C gcdRingElem) {
        GenSolvablePolynomial genSolvablePolynomial = ((QLRSolvablePolynomial)this.ring.getZERO()).copy();
        if (gcdRingElem == null || gcdRingElem.isZERO()) {
            return genSolvablePolynomial;
        }
        SortedMap sortedMap = ((QLRSolvablePolynomial)genSolvablePolynomial).val;
        SortedMap sortedMap2 = this.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            GcdRingElem gcdRingElem2 = (GcdRingElem)entry.getValue();
            GcdRingElem gcdRingElem3 = gcdRingElem.multiply((GcdRingElem)gcdRingElem2);
            if (gcdRingElem3.isZERO()) continue;
            sortedMap.put(expVector, gcdRingElem3);
        }
        return genSolvablePolynomial;
    }

    public QLRSolvablePolynomial<C, D> multiplyLeft(Map.Entry<ExpVector, C> entry) {
        if (entry == null) {
            return this.ring.getZERO();
        }
        return this.multiplyLeft((C)((GcdRingElem)entry.getValue()), entry.getKey());
    }

    @Override
    public QLRSolvablePolynomial<C, D> multiply(Map.Entry<ExpVector, C> entry) {
        if (entry == null) {
            return this.ring.getZERO();
        }
        return this.multiply((C)((GcdRingElem)entry.getValue()), entry.getKey());
    }

    protected QLRSolvablePolynomial<C, D> shift(ExpVector expVector) {
        GenSolvablePolynomial genSolvablePolynomial = ((QLRSolvablePolynomial)this.ring.getZERO()).copy();
        if (this.isZERO()) {
            return genSolvablePolynomial;
        }
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        SortedMap sortedMap = ((QLRSolvablePolynomial)genSolvablePolynomial).val;
        SortedMap sortedMap2 = this.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector2 = (ExpVector)entry.getKey();
            GcdRingElem gcdRingElem = (GcdRingElem)entry.getValue();
            ExpVector expVector3 = expVector2.sum(expVector);
            if (gcdRingElem.isZERO()) continue;
            sortedMap.put(expVector3, gcdRingElem);
        }
        return genSolvablePolynomial;
    }
}

