/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.poly.TableRelation;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecSolvablePolynomial<C extends RingElem<C>>
extends GenSolvablePolynomial<GenPolynomial<C>> {
    public final RecSolvablePolynomialRing<C> ring;
    private static final Logger logger = LogManager.getLogger(RecSolvablePolynomial.class);
    private static final boolean debug = logger.isDebugEnabled();

    public RecSolvablePolynomial(RecSolvablePolynomialRing<C> recSolvablePolynomialRing) {
        super(recSolvablePolynomialRing);
        this.ring = recSolvablePolynomialRing;
    }

    public RecSolvablePolynomial(RecSolvablePolynomialRing<C> recSolvablePolynomialRing, ExpVector expVector) {
        this(recSolvablePolynomialRing);
        this.val.put(expVector, this.ring.getONECoefficient());
    }

    public RecSolvablePolynomial(RecSolvablePolynomialRing<C> recSolvablePolynomialRing, GenPolynomial<C> genPolynomial, ExpVector expVector) {
        this(recSolvablePolynomialRing);
        if (genPolynomial != null && !genPolynomial.isZERO()) {
            this.val.put(expVector, genPolynomial);
        }
    }

    public RecSolvablePolynomial(RecSolvablePolynomialRing<C> recSolvablePolynomialRing, GenPolynomial<C> genPolynomial) {
        this(recSolvablePolynomialRing, genPolynomial, recSolvablePolynomialRing.evzero);
    }

    public RecSolvablePolynomial(RecSolvablePolynomialRing<C> recSolvablePolynomialRing, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial) {
        this(recSolvablePolynomialRing, genSolvablePolynomial.val);
    }

    protected RecSolvablePolynomial(RecSolvablePolynomialRing<C> recSolvablePolynomialRing, SortedMap<ExpVector, GenPolynomial<C>> sortedMap) {
        this(recSolvablePolynomialRing);
        this.val.putAll(sortedMap);
    }

    @Override
    public RecSolvablePolynomialRing<C> factory() {
        return this.ring;
    }

    @Override
    public RecSolvablePolynomial<C> copy() {
        return new RecSolvablePolynomial<C>(this.ring, this.val);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof RecSolvablePolynomial)) {
            return false;
        }
        return super.equals(object);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RecSolvablePolynomial<C> multiply(RecSolvablePolynomial<C> recSolvablePolynomial) {
        if (recSolvablePolynomial == null || recSolvablePolynomial.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        assert (this.ring.nvar == recSolvablePolynomial.ring.nvar);
        if (debug) {
            logger.info("ring = " + this.ring.toScript());
        }
        boolean bl = this.ring.table.isEmpty();
        boolean bl2 = this.ring.coeffTable.isEmpty();
        GenPolynomialRing genPolynomialRing = (GenPolynomialRing)this.ring.coFac;
        GenSolvablePolynomial genSolvablePolynomial = ((RecSolvablePolynomial)this.ring.getZERO()).copy();
        ExpVector expVector = this.ring.evzero;
        ExpVector expVector2 = genPolynomialRing.evzero;
        GenPolynomial genPolynomial = (GenPolynomial)this.ring.getONECoefficient();
        RecSolvablePolynomial<Object> recSolvablePolynomial2 = null;
        RecSolvablePolynomial<C> recSolvablePolynomial3 = null;
        SortedMap sortedMap = this.val;
        SortedMap sortedMap2 = recSolvablePolynomial.val;
        Set set = sortedMap2.entrySet();
        if (debug) {
            logger.info("input A = " + this);
        }
        for (Map.Entry entry : sortedMap.entrySet()) {
            GenPolynomial genPolynomial2 = (GenPolynomial)entry.getValue();
            ExpVector expVector3 = (ExpVector)entry.getKey();
            if (debug) {
                logger.info("e = " + expVector3 + ", a = " + genPolynomial2);
            }
            int[] nArray = expVector3.dependencyOnVariables();
            int n = this.ring.nvar + 1;
            if (nArray.length > 0) {
                n = nArray[0];
            }
            if (debug) {
                logger.info("input B = " + recSolvablePolynomial);
            }
            for (Map.Entry entry2 : set) {
                void var30_50;
                AbelianGroupElem<ExpVector> abelianGroupElem;
                Serializable serializable;
                ExpVector expVector4;
                Object object;
                Object object2;
                Object object3;
                GenSolvablePolynomial genSolvablePolynomial2;
                RingElem ringElem;
                GenPolynomial genPolynomial3 = (GenPolynomial)entry2.getValue();
                ExpVector expVector5 = (ExpVector)entry2.getKey();
                if (debug) {
                    logger.info("f = " + expVector5 + ", b = " + genPolynomial3);
                }
                int[] nArray2 = expVector5.dependencyOnVariables();
                int n2 = 0;
                if (nArray2.length > 0) {
                    n2 = nArray2[nArray2.length - 1];
                }
                int n3 = this.ring.nvar + 1 - n2;
                GenSolvablePolynomial genSolvablePolynomial4 = ((RecSolvablePolynomial)this.ring.getZERO()).copy();
                RecSolvablePolynomial<Object> recSolvablePolynomial4 = null;
                if (bl2 || genPolynomial3.isConstant() || expVector3.isZERO()) {
                    genSolvablePolynomial4.doAddTo(genPolynomial3, expVector3);
                    if (debug) {
                        logger.info("symmetric coeff, e*b: b = " + genPolynomial3 + ", e = " + expVector3);
                    }
                } else {
                    if (debug) {
                        logger.info("unsymmetric coeff, e*b: b = " + genPolynomial3 + ", e = " + expVector3);
                    }
                    for (Map.Entry entry3 : genPolynomial3.val.entrySet()) {
                        ringElem = (RingElem)entry3.getValue();
                        genSolvablePolynomial2 = genPolynomial3.ring.valueOf(ringElem);
                        object3 = (ExpVector)entry3.getKey();
                        if (debug) {
                            logger.info("g = " + object3 + ", c = " + ringElem);
                        }
                        int[] nArray3 = ((ExpVector)object3).dependencyOnVariables();
                        int n4 = 0;
                        if (nArray3.length > 0) {
                            n4 = nArray3[nArray3.length - 1];
                        }
                        int n5 = genPolynomial3.ring.nvar + 1 - n4;
                        if (debug) {
                            logger.info("gl1s = " + n5);
                        }
                        object2 = expVector3;
                        ExpVector expVector6 = expVector;
                        if (!expVector3.isZERO()) {
                            object2 = expVector3.subst(n, 0L);
                            expVector6 = expVector.subst(n, expVector3.getVal(n));
                        }
                        object = object3;
                        expVector4 = expVector2;
                        if (!((ExpVector)object3).isZERO()) {
                            object = ((ExpVector)object3).subst(n4, 0L);
                            expVector4 = expVector2.subst(n4, ((ExpVector)object3).getVal(n4));
                        }
                        if (debug) {
                            logger.info("coeff, e1 = " + object2 + ", e2 = " + expVector6 + ", Cps = " + genSolvablePolynomial4);
                            logger.info("coeff, g1 = " + object + ", g2 = " + expVector4);
                        }
                        serializable = this.ring.coeffTable.lookup(expVector6, expVector4);
                        if (debug) {
                            logger.info("coeff, crel = " + serializable.p);
                        }
                        recSolvablePolynomial4 = new RecSolvablePolynomial<C>(this.ring, serializable.p);
                        if (serializable.f != null) {
                            abelianGroupElem = genPolynomial3.ring.valueOf(serializable.f);
                            recSolvablePolynomial3 = new RecSolvablePolynomial<C>(this.ring, abelianGroupElem, expVector);
                            recSolvablePolynomial4 = recSolvablePolynomial4.multiply(recSolvablePolynomial3);
                            ExpVector expVector7 = serializable.e == null ? expVector6 : expVector6.subtract(serializable.e);
                            this.ring.coeffTable.update(expVector7, expVector4, (GenSolvablePolynomial<GenPolynomial<Object>>)recSolvablePolynomial4);
                        }
                        if (serializable.e != null) {
                            recSolvablePolynomial2 = new RecSolvablePolynomial<Object>(this.ring, genPolynomial, serializable.e);
                            recSolvablePolynomial4 = recSolvablePolynomial2.multiply(recSolvablePolynomial4);
                            this.ring.coeffTable.update(expVector6, expVector4, (GenSolvablePolynomial<GenPolynomial<Object>>)recSolvablePolynomial4);
                        }
                        if (!((ExpVector)object).isZERO()) {
                            abelianGroupElem = genPolynomial3.ring.valueOf((ExpVector)object);
                            recSolvablePolynomial3 = new RecSolvablePolynomial<C>(this.ring, abelianGroupElem, expVector);
                            recSolvablePolynomial4 = recSolvablePolynomial4.multiply(recSolvablePolynomial3);
                        }
                        if (!((ExpVector)object2).isZERO()) {
                            recSolvablePolynomial2 = new RecSolvablePolynomial<C>(this.ring, genPolynomial, (ExpVector)object2);
                            recSolvablePolynomial4 = recSolvablePolynomial2.multiply(recSolvablePolynomial4);
                        }
                        recSolvablePolynomial4 = recSolvablePolynomial4.multiplyLeft(genSolvablePolynomial2);
                        genSolvablePolynomial4.doAddTo(recSolvablePolynomial4);
                    }
                    if (debug) {
                        logger.info("coeff, Cs = " + recSolvablePolynomial4 + ", Cps = " + genSolvablePolynomial4);
                    }
                }
                if (debug) {
                    logger.info("coeff-poly: Cps = " + genSolvablePolynomial4);
                }
                GenSolvablePolynomial genSolvablePolynomial5 = ((RecSolvablePolynomial)this.ring.getZERO()).copy();
                Object var30_33 = null;
                if (bl || genSolvablePolynomial4.isConstant() || expVector5.isZERO()) {
                    if (debug) {
                        logger.info("symmetric poly, P_eb*f: Cps = " + genSolvablePolynomial4 + ", f = " + expVector5);
                    }
                    object3 = expVector3.sum(expVector5);
                    if (genSolvablePolynomial4.isConstant()) {
                        RecSolvablePolynomial<C> recSolvablePolynomial5 = new RecSolvablePolynomial<C>(this.ring, (GenPolynomial)genSolvablePolynomial4.leadingBaseCoefficient(), (ExpVector)object3);
                    } else {
                        RecSolvablePolynomial<C> recSolvablePolynomial6 = ((RecSolvablePolynomial)genSolvablePolynomial4).shift(expVector5);
                    }
                } else {
                    if (debug) {
                        logger.info("unsymmetric poly, P_eb*f: Cps = " + genSolvablePolynomial4 + ", f = " + expVector5);
                    }
                    for (Map.Entry entry4 : ((RecSolvablePolynomial)genSolvablePolynomial4).val.entrySet()) {
                        void var30_47;
                        int n6;
                        GenPolynomial genPolynomial4 = (GenPolynomial)entry4.getValue();
                        ExpVector expVector8 = (ExpVector)entry4.getKey();
                        if (debug) {
                            logger.info("g = " + expVector8 + ", c = " + genPolynomial4);
                        }
                        object2 = expVector8.dependencyOnVariables();
                        int n7 = this.ring.nvar + 1;
                        if (((int[])object2).length > 0) {
                            n7 = object2[0];
                        }
                        if ((n6 = this.ring.nvar + 1 - n7) <= n3) {
                            object = expVector8.sum(expVector5);
                            if (debug) {
                                logger.info("disjoint poly: g = " + expVector8 + ", f = " + expVector5 + ", h = " + object);
                            }
                            GenSolvablePolynomial genSolvablePolynomial3 = this.ring.valueOf((ExpVector)object);
                        } else {
                            object = expVector8.subst(n7, 0L);
                            expVector4 = expVector.subst(n7, expVector8.getVal(n7));
                            abelianGroupElem = expVector5.subst(n2, 0L);
                            ExpVector expVector9 = expVector.subst(n2, expVector5.getVal(n2));
                            if (debug) {
                                logger.info("poly, g1 = " + object + ", f1 = " + abelianGroupElem + ", Dps = " + genSolvablePolynomial5);
                                logger.info("poly, g2 = " + expVector4 + ", f2 = " + expVector9);
                            }
                            TableRelation tableRelation = this.ring.table.lookup(expVector4, expVector9);
                            if (debug) {
                                logger.info("poly, g  = " + expVector8 + ", f  = " + expVector5 + ", rel = " + tableRelation);
                            }
                            RecSolvablePolynomial<C> recSolvablePolynomial7 = new RecSolvablePolynomial<C>(this.ring, tableRelation.p);
                            if (tableRelation.f != null) {
                                genSolvablePolynomial2 = this.ring.valueOf(tableRelation.f);
                                RecSolvablePolynomial<C> recSolvablePolynomial8 = recSolvablePolynomial7.multiply((RecSolvablePolynomial<C>)genSolvablePolynomial2);
                                serializable = tableRelation.e == null ? expVector4 : expVector4.subtract(tableRelation.e);
                                this.ring.table.update((ExpVector)serializable, expVector9, recSolvablePolynomial8);
                            }
                            if (tableRelation.e != null) {
                                void var30_41;
                                ringElem = this.ring.valueOf(tableRelation.e);
                                RecSolvablePolynomial<C> recSolvablePolynomial9 = ((RecSolvablePolynomial)ringElem).multiply((RecSolvablePolynomial<C>)var30_41);
                                this.ring.table.update(expVector4, expVector9, recSolvablePolynomial9);
                            }
                            if (!((ExpVector)abelianGroupElem).isZERO()) {
                                void var30_43;
                                genSolvablePolynomial2 = this.ring.valueOf((ExpVector)abelianGroupElem);
                                RecSolvablePolynomial<C> recSolvablePolynomial10 = var30_43.multiply((RecSolvablePolynomial<C>)genSolvablePolynomial2);
                            }
                            if (!((ExpVector)object).isZERO()) {
                                void var30_45;
                                ringElem = this.ring.valueOf((ExpVector)object);
                                RecSolvablePolynomial<C> recSolvablePolynomial11 = ((RecSolvablePolynomial)ringElem).multiply((RecSolvablePolynomial<C>)var30_45);
                            }
                        }
                        RecSolvablePolynomial<C> recSolvablePolynomial12 = var30_47.multiplyLeft(genPolynomial4);
                        genSolvablePolynomial5.doAddTo(recSolvablePolynomial12);
                    }
                    Object object4 = genSolvablePolynomial5;
                }
                if (debug) {
                    logger.info("recursion+: Ds = " + var30_50 + ", a = " + genPolynomial2);
                }
                RecSolvablePolynomial<C> genSolvablePolynomial32 = var30_50.multiplyLeft(genPolynomial2);
                if (debug) {
                    logger.info("recursion-: Ds = " + genSolvablePolynomial32);
                }
                genSolvablePolynomial.doAddTo(genSolvablePolynomial32);
                if (!debug) continue;
                logger.info("end B loop: Dp = " + genSolvablePolynomial);
            }
            if (!debug) continue;
            logger.info("end A loop: Dp = " + genSolvablePolynomial);
        }
        return genSolvablePolynomial;
    }

    @Override
    public RecSolvablePolynomial<C> multiply(RecSolvablePolynomial<C> recSolvablePolynomial, RecSolvablePolynomial<C> recSolvablePolynomial2) {
        if (recSolvablePolynomial.isZERO() || recSolvablePolynomial2.isZERO() || this.isZERO()) {
            return this.ring.getZERO();
        }
        if (recSolvablePolynomial.isONE()) {
            return this.multiply(recSolvablePolynomial2);
        }
        if (recSolvablePolynomial2.isONE()) {
            return recSolvablePolynomial.multiply(this);
        }
        return recSolvablePolynomial.multiply(this).multiply(recSolvablePolynomial2);
    }

    public RecSolvablePolynomial<C> recMultiply(GenPolynomial<C> genPolynomial) {
        RecSolvablePolynomial<C> recSolvablePolynomial = ((RecSolvablePolynomial)this.ring.getZERO()).copy();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return recSolvablePolynomial;
        }
        recSolvablePolynomial = new RecSolvablePolynomial<C>(this.ring, genPolynomial, this.ring.evzero);
        return this.multiply(recSolvablePolynomial);
    }

    @Override
    public RecSolvablePolynomial<C> multiply(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        GenSolvablePolynomial genSolvablePolynomial = ((RecSolvablePolynomial)this.ring.getZERO()).copy();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return genSolvablePolynomial;
        }
        RecSolvablePolynomial<C> recSolvablePolynomial = this.ring.valueOf(genPolynomial);
        RecSolvablePolynomial<C> recSolvablePolynomial2 = this.ring.valueOf(genPolynomial2);
        return recSolvablePolynomial.multiply(this).multiply(recSolvablePolynomial2);
    }

    @Override
    public RecSolvablePolynomial<C> multiply(ExpVector expVector) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        GenPolynomial genPolynomial = (GenPolynomial)this.ring.getONECoefficient();
        return this.multiply(genPolynomial, expVector);
    }

    @Override
    public RecSolvablePolynomial<C> multiply(ExpVector expVector, ExpVector expVector2) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        if (expVector2 == null || expVector2.isZERO()) {
            return this;
        }
        GenPolynomial genPolynomial = (GenPolynomial)this.ring.getONECoefficient();
        return this.multiply(genPolynomial, expVector, genPolynomial, expVector2);
    }

    @Override
    public RecSolvablePolynomial<C> multiply(GenPolynomial<C> genPolynomial, ExpVector expVector) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return this.ring.getZERO();
        }
        RecSolvablePolynomial<C> recSolvablePolynomial = this.ring.valueOf(genPolynomial, expVector);
        return this.multiply(recSolvablePolynomial);
    }

    @Override
    public RecSolvablePolynomial<C> multiply(GenPolynomial<C> genPolynomial, ExpVector expVector, GenPolynomial<C> genPolynomial2, ExpVector expVector2) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return this.ring.getZERO();
        }
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return this.ring.getZERO();
        }
        RecSolvablePolynomial<C> recSolvablePolynomial = this.ring.valueOf(genPolynomial, expVector);
        RecSolvablePolynomial<C> recSolvablePolynomial2 = this.ring.valueOf(genPolynomial2, expVector2);
        return this.multiply(recSolvablePolynomial, recSolvablePolynomial2);
    }

    @Override
    public RecSolvablePolynomial<C> multiplyLeft(GenPolynomial<C> genPolynomial, ExpVector expVector) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return this.ring.getZERO();
        }
        RecSolvablePolynomial<C> recSolvablePolynomial = this.ring.valueOf(genPolynomial, expVector);
        return recSolvablePolynomial.multiply(this);
    }

    @Override
    public RecSolvablePolynomial<C> multiplyLeft(ExpVector expVector) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        GenSolvablePolynomial genSolvablePolynomial = this.ring.valueOf(expVector);
        return ((RecSolvablePolynomial)genSolvablePolynomial).multiply(this);
    }

    @Override
    public RecSolvablePolynomial<C> multiplyLeft(GenPolynomial<C> genPolynomial) {
        GenSolvablePolynomial genSolvablePolynomial = ((RecSolvablePolynomial)this.ring.getZERO()).copy();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        GenSolvablePolynomial genSolvablePolynomial2 = null;
        if (genPolynomial instanceof GenSolvablePolynomial) {
            logger.debug("warn: wrong method dispatch in JRE multiply(b) - trying to fix");
            genSolvablePolynomial2 = (GenSolvablePolynomial)genPolynomial;
        }
        SortedMap sortedMap = ((RecSolvablePolynomial)genSolvablePolynomial).val;
        SortedMap sortedMap2 = this.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            GenPolynomial<GenPolynomial> genPolynomial2;
            ExpVector expVector = (ExpVector)entry.getKey();
            GenPolynomial genPolynomial3 = (GenPolynomial)entry.getValue();
            if (genSolvablePolynomial2 != null) {
                GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)genPolynomial3;
                genPolynomial2 = genSolvablePolynomial2.multiply(genSolvablePolynomial3);
            } else {
                genPolynomial2 = genPolynomial.multiply(genPolynomial3);
            }
            if (genPolynomial2.isZERO()) continue;
            sortedMap.put(expVector, genPolynomial2);
        }
        return genSolvablePolynomial;
    }

    @Override
    public RecSolvablePolynomial<C> multiplyLeft(Map.Entry<ExpVector, GenPolynomial<C>> entry) {
        if (entry == null) {
            return this.ring.getZERO();
        }
        return this.multiplyLeft(entry.getValue(), entry.getKey());
    }

    @Override
    public RecSolvablePolynomial<C> multiply(Map.Entry<ExpVector, GenPolynomial<C>> entry) {
        if (entry == null) {
            return this.ring.getZERO();
        }
        return this.multiply(entry.getValue(), entry.getKey());
    }

    public RecSolvablePolynomial<C> shift(ExpVector expVector) {
        GenSolvablePolynomial genSolvablePolynomial = ((RecSolvablePolynomial)this.ring.getZERO()).copy();
        if (this.isZERO()) {
            return genSolvablePolynomial;
        }
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        SortedMap sortedMap = ((RecSolvablePolynomial)genSolvablePolynomial).val;
        SortedMap sortedMap2 = this.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector2 = (ExpVector)entry.getKey();
            GenPolynomial genPolynomial = (GenPolynomial)entry.getValue();
            ExpVector expVector3 = expVector2.sum(expVector);
            if (genPolynomial.isZERO()) continue;
            sortedMap.put(expVector3, genPolynomial);
        }
        return genSolvablePolynomial;
    }

    public RecSolvablePolynomial<C> multiplyRightComm(GenPolynomial<C> genPolynomial) {
        GenSolvablePolynomial genSolvablePolynomial = ((RecSolvablePolynomial)this.ring.getZERO()).copy();
        if (this.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return this;
        }
        SortedMap sortedMap = ((RecSolvablePolynomial)genSolvablePolynomial).val;
        SortedMap sortedMap2 = this.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial2 = (GenPolynomial<GenPolynomial<GenPolynomial<C>>>)entry.getValue();
            if ((genPolynomial2 = genPolynomial2.multiply((GenPolynomial<GenPolynomial<C>>)genPolynomial)).isZERO()) continue;
            sortedMap.put(expVector, genPolynomial2);
        }
        return genSolvablePolynomial;
    }

    @Override
    public GenSolvablePolynomial<GenPolynomial<C>> rightRecursivePolynomial() {
        if (this.isZERO()) {
            return this;
        }
        if (!(this instanceof RecSolvablePolynomial)) {
            return this;
        }
        RecSolvablePolynomialRing<C> recSolvablePolynomialRing = this.ring;
        if (recSolvablePolynomialRing.coeffTable.isEmpty()) {
            return this;
        }
        GenSolvablePolynomial genSolvablePolynomial = ((RecSolvablePolynomial)recSolvablePolynomialRing.getZERO()).copy();
        RecSolvablePolynomial recSolvablePolynomial = this;
        while (!recSolvablePolynomial.isZERO()) {
            ExpVector expVector = recSolvablePolynomial.leadingExpVector();
            GenPolynomial genPolynomial = (GenPolynomial)recSolvablePolynomial.leadingBaseCoefficient();
            RecSolvablePolynomial<C> recSolvablePolynomial2 = ((RecSolvablePolynomial)recSolvablePolynomialRing.valueOf(expVector)).multiply(recSolvablePolynomialRing.valueOf(genPolynomial));
            recSolvablePolynomial = (RecSolvablePolynomial)recSolvablePolynomial.subtract(recSolvablePolynomial2);
            genSolvablePolynomial = (RecSolvablePolynomial)genSolvablePolynomial.sum(genPolynomial, expVector);
        }
        return genSolvablePolynomial;
    }

    @Override
    public GenSolvablePolynomial<GenPolynomial<C>> evalAsRightRecursivePolynomial() {
        if (this.isONE() || this.isZERO()) {
            return this;
        }
        if (!(this instanceof RecSolvablePolynomial)) {
            return this;
        }
        RecSolvablePolynomialRing<C> recSolvablePolynomialRing = this.ring;
        if (recSolvablePolynomialRing.coeffTable.isEmpty()) {
            return this;
        }
        GenSolvablePolynomial genSolvablePolynomial = recSolvablePolynomialRing.getZERO();
        RecSolvablePolynomial recSolvablePolynomial = this;
        for (Map.Entry entry : recSolvablePolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            GenPolynomial genPolynomial = (GenPolynomial)entry.getValue();
            RecSolvablePolynomial<C> recSolvablePolynomial2 = ((RecSolvablePolynomial)recSolvablePolynomialRing.valueOf(expVector)).multiply(recSolvablePolynomialRing.valueOf(genPolynomial));
            genSolvablePolynomial = (RecSolvablePolynomial)genSolvablePolynomial.sum(recSolvablePolynomial2);
        }
        return genSolvablePolynomial;
    }

    @Override
    public boolean isRightRecursivePolynomial(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial) {
        if (this.isZERO()) {
            return genSolvablePolynomial.isZERO();
        }
        if (this.isONE()) {
            return genSolvablePolynomial.isONE();
        }
        if (!(this instanceof RecSolvablePolynomial)) {
            return !(genSolvablePolynomial instanceof RecSolvablePolynomial);
        }
        if (!(genSolvablePolynomial instanceof RecSolvablePolynomial)) {
            return false;
        }
        RecSolvablePolynomialRing<C> recSolvablePolynomialRing = this.ring;
        if (recSolvablePolynomialRing.coeffTable.isEmpty()) {
            RecSolvablePolynomialRing recSolvablePolynomialRing2 = (RecSolvablePolynomialRing)genSolvablePolynomial.ring;
            return recSolvablePolynomialRing2.coeffTable.isEmpty();
        }
        RecSolvablePolynomial recSolvablePolynomial = this;
        RecSolvablePolynomial recSolvablePolynomial2 = (RecSolvablePolynomial)genSolvablePolynomial.evalAsRightRecursivePolynomial();
        recSolvablePolynomial = (RecSolvablePolynomial)PolyUtil.monic(recSolvablePolynomial);
        recSolvablePolynomial2 = (RecSolvablePolynomial)PolyUtil.monic(recSolvablePolynomial2);
        return recSolvablePolynomial.equals(recSolvablePolynomial2);
    }
}

