/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.ModuleList;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SolvableModuleListTest
extends TestCase {
    ModuleList<BigRational> m;
    PolynomialList<BigRational> p;
    GenSolvablePolynomial<BigRational> a;
    GenSolvablePolynomial<BigRational> b;
    GenSolvablePolynomial<BigRational> c;
    GenSolvablePolynomial<BigRational> d;
    GenSolvablePolynomial<BigRational> e;
    BigRational cfac;
    GenSolvablePolynomialRing<BigRational> pfac;
    int rl = 4;
    int kl = 4;
    int ll = 4;
    int el = 5;
    float q = 0.5f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SolvableModuleListTest.suite());
    }

    public SolvableModuleListTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SolvableModuleListTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.cfac = new BigRational(1L);
        TermOrder termOrder = new TermOrder();
        this.pfac = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.rl, termOrder);
        this.m = null;
        this.p = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.m = null;
        this.p = null;
    }

    public void testConstructor() {
        this.p = new PolynomialList<BigRational>((GenPolynomialRing<BigRational>)this.pfac, (List)null);
        SolvableModuleListTest.assertTrue((String)"p = 0", (this.p.list == null ? 1 : 0) != 0);
        this.m = new ModuleList<BigRational>((GenPolynomialRing<BigRational>)this.pfac, (List)null);
        SolvableModuleListTest.assertTrue((String)"m = 0", (this.m.list == null ? 1 : 0) != 0);
    }

    public void testPolynomialList() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < 7; ++i) {
            this.a = this.pfac.random(this.kl, this.ll + i, this.el, this.q);
            SolvableModuleListTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            SolvableModuleListTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            SolvableModuleListTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
            arrayList.add(this.a);
        }
        this.p = new PolynomialList<BigRational>((GenPolynomialRing<BigRational>)this.pfac, arrayList);
        SolvableModuleListTest.assertTrue((String)"p == p", (boolean)this.p.equals(this.p));
        SolvableModuleListTest.assertEquals((String)"p.length", (int)7, (int)this.p.list.size());
    }

    public void testModuleList() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < 4; ++i) {
            ArrayList<GenSolvablePolynomial<BigRational>> arrayList2 = new ArrayList<GenSolvablePolynomial<BigRational>>();
            for (int j = 0; j < 3; ++j) {
                this.a = this.pfac.random(this.kl, this.ll, this.el, this.q);
                SolvableModuleListTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
                SolvableModuleListTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
                SolvableModuleListTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
                arrayList2.add(this.a);
            }
            arrayList.add(arrayList2);
        }
        this.m = new ModuleList<BigRational>((GenPolynomialRing<BigRational>)this.pfac, arrayList);
        SolvableModuleListTest.assertTrue((String)"m == m", (boolean)this.m.equals(this.m));
        SolvableModuleListTest.assertEquals((String)"m.length", (int)4, (int)this.m.list.size());
    }

    public void testModulePolynomialList() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < 4; ++i) {
            ArrayList<GenSolvablePolynomial<BigRational>> arrayList2 = new ArrayList<GenSolvablePolynomial<BigRational>>();
            for (int j = 0; j < 3; ++j) {
                this.a = this.pfac.random(this.kl, this.ll, this.el, this.q);
                SolvableModuleListTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
                SolvableModuleListTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
                SolvableModuleListTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
                arrayList2.add(this.a);
            }
            arrayList.add(arrayList2);
        }
        this.m = new ModuleList<BigRational>((GenPolynomialRing<BigRational>)this.pfac, arrayList);
        SolvableModuleListTest.assertTrue((String)"m == m", (boolean)this.m.equals(this.m));
        SolvableModuleListTest.assertEquals((String)"m.length", (int)4, (int)this.m.list.size());
        this.p = this.m.getPolynomialList();
        SolvableModuleListTest.assertTrue((String)"p == p", (boolean)this.p.equals(this.p));
        SolvableModuleListTest.assertEquals((String)"p.length", (int)4, (int)this.p.list.size());
    }

    public void testModulePolynomialModuleList() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < 4; ++i) {
            ArrayList<GenSolvablePolynomial<BigRational>> arrayList2 = new ArrayList<GenSolvablePolynomial<BigRational>>();
            for (int j = 0; j < 3; ++j) {
                this.a = this.pfac.random(this.kl, this.ll, this.el, this.q);
                SolvableModuleListTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
                SolvableModuleListTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
                SolvableModuleListTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
                arrayList2.add(this.a);
            }
            arrayList.add(arrayList2);
        }
        this.m = new ModuleList<BigRational>((GenPolynomialRing<BigRational>)this.pfac, arrayList);
        SolvableModuleListTest.assertTrue((String)"m == m", (boolean)this.m.equals(this.m));
        SolvableModuleListTest.assertEquals((String)"m.length", (int)4, (int)this.m.list.size());
        this.p = this.m.getPolynomialList();
        SolvableModuleListTest.assertTrue((String)"p == p", (boolean)this.p.equals(this.p));
        SolvableModuleListTest.assertEquals((String)"p.length", (int)4, (int)this.p.list.size());
        ModuleList<BigRational> moduleList = null;
        moduleList = this.p.getModuleList(3);
        SolvableModuleListTest.assertTrue((String)"m2 == m2", (boolean)moduleList.equals(moduleList));
        SolvableModuleListTest.assertEquals((String)"m2.length", (int)4, (int)moduleList.list.size());
        SolvableModuleListTest.assertTrue((String)"m == m2", (boolean)this.m.equals(moduleList));
    }

    public void testModulePolynomialModuleListPolynomial() {
        Serializable serializable;
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < 4; ++i) {
            serializable = new ArrayList();
            for (int j = 0; j < 3; ++j) {
                this.a = this.pfac.random(this.kl, this.ll, this.el, this.q);
                SolvableModuleListTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
                SolvableModuleListTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
                SolvableModuleListTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
                serializable.add(this.a);
            }
            arrayList.add(serializable);
        }
        this.m = new ModuleList<BigRational>((GenPolynomialRing<BigRational>)this.pfac, arrayList);
        SolvableModuleListTest.assertTrue((String)"m == m", (boolean)this.m.equals(this.m));
        SolvableModuleListTest.assertEquals((String)"m.length", (int)4, (int)this.m.list.size());
        this.p = this.m.getPolynomialList();
        SolvableModuleListTest.assertTrue((String)"p == p", (boolean)this.p.equals(this.p));
        SolvableModuleListTest.assertEquals((String)"p.length", (int)4, (int)this.p.list.size());
        ModuleList<BigRational> moduleList = null;
        moduleList = this.p.getModuleList(3);
        SolvableModuleListTest.assertTrue((String)"m2 == m2", (boolean)moduleList.equals(moduleList));
        SolvableModuleListTest.assertEquals((String)"m2.length", (int)4, (int)moduleList.list.size());
        SolvableModuleListTest.assertTrue((String)"m == m2", (boolean)this.m.equals(moduleList));
        serializable = null;
        serializable = moduleList.getPolynomialList();
        SolvableModuleListTest.assertTrue((String)"p2 == p2", (boolean)((PolynomialList)serializable).equals(serializable));
        SolvableModuleListTest.assertEquals((String)"p2.length", (int)4, (int)((PolynomialList)serializable).list.size());
        SolvableModuleListTest.assertTrue((String)"p == p2", (boolean)this.p.list.equals(((PolynomialList)serializable).list));
    }

    public void testWeylModulePolynomialModuleListPolynomial() {
        Serializable serializable;
        int n = 4;
        this.pfac = new GenSolvablePolynomialRing<BigRational>(this.cfac, n);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.pfac);
        RelationTable relationTable = this.pfac.table;
        RelationTable relationTable2 = null;
        RelationTable relationTable3 = null;
        RelationTable relationTable4 = null;
        RelationTable relationTable5 = null;
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < 4; ++i) {
            serializable = new ArrayList<GenSolvablePolynomial<BigRational>>();
            for (int j = 0; j < 3; ++j) {
                this.a = this.pfac.random(this.kl, this.ll, this.el, this.q);
                SolvableModuleListTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
                SolvableModuleListTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
                SolvableModuleListTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
                serializable.add(this.a);
            }
            arrayList.add(serializable);
        }
        this.m = new ModuleList<BigRational>((GenPolynomialRing<BigRational>)this.pfac, arrayList);
        SolvableModuleListTest.assertTrue((String)"m == m", (boolean)this.m.equals(this.m));
        SolvableModuleListTest.assertEquals((String)"m.length", (int)4, (int)this.m.list.size());
        relationTable2 = ((GenSolvablePolynomialRing)this.m.ring).table;
        SolvableModuleListTest.assertEquals((String)"table1 == table2", relationTable, relationTable2);
        this.p = this.m.getPolynomialList();
        SolvableModuleListTest.assertTrue((String)"p == p", (boolean)this.p.equals(this.p));
        SolvableModuleListTest.assertEquals((String)"p.length", (int)4, (int)this.p.list.size());
        relationTable3 = ((GenSolvablePolynomialRing)this.p.ring).table;
        ModuleList<BigRational> moduleList = null;
        moduleList = this.p.getModuleList(3);
        SolvableModuleListTest.assertTrue((String)"m2 == m2", (boolean)moduleList.equals(moduleList));
        SolvableModuleListTest.assertEquals((String)"m2.length", (int)4, (int)moduleList.list.size());
        SolvableModuleListTest.assertTrue((String)"m == m2", (boolean)this.m.equals(moduleList));
        relationTable4 = ((GenSolvablePolynomialRing)moduleList.ring).table;
        SolvableModuleListTest.assertEquals((String)"table2 == table4", relationTable2, relationTable4);
        SolvableModuleListTest.assertEquals((String)"table1 == table4", relationTable, relationTable4);
        serializable = null;
        serializable = moduleList.getPolynomialList();
        SolvableModuleListTest.assertTrue((String)"p2 == p2", (boolean)((PolynomialList)serializable).equals(serializable));
        SolvableModuleListTest.assertEquals((String)"p2.length", (int)4, (int)((PolynomialList)serializable).list.size());
        SolvableModuleListTest.assertTrue((String)"p == p2", (boolean)this.p.list.equals(((PolynomialList)serializable).list));
        relationTable5 = ((GenSolvablePolynomialRing)((PolynomialList)serializable).ring).table;
        SolvableModuleListTest.assertEquals((String)"table2 == table4", relationTable3.table, relationTable5.table);
    }
}

