/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.root.ComplexAlgebraicRing;
import edu.jas.root.InvalidBoundaryException;
import edu.jas.root.Rectangle;
import edu.jas.structure.GcdRingElem;

public class ComplexAlgebraicNumber<C extends GcdRingElem<C> & Rational>
implements GcdRingElem<ComplexAlgebraicNumber<C>> {
    public final AlgebraicNumber<Complex<C>> number;
    public final ComplexAlgebraicRing<C> ring;

    public ComplexAlgebraicNumber(ComplexAlgebraicRing<C> complexAlgebraicRing, GenPolynomial<Complex<C>> genPolynomial) {
        this.number = new AlgebraicNumber<Complex<Complex<C>>>(complexAlgebraicRing.algebraic, genPolynomial);
        this.ring = complexAlgebraicRing;
    }

    public ComplexAlgebraicNumber(ComplexAlgebraicRing<C> complexAlgebraicRing, AlgebraicNumber<Complex<C>> algebraicNumber) {
        this.number = algebraicNumber;
        this.ring = complexAlgebraicRing;
    }

    public ComplexAlgebraicNumber(ComplexAlgebraicRing<C> complexAlgebraicRing) {
        this(complexAlgebraicRing, (AlgebraicNumber<Complex<C>>)complexAlgebraicRing.algebraic.getZERO());
    }

    @Override
    public ComplexAlgebraicRing<C> factory() {
        return this.ring;
    }

    @Override
    public ComplexAlgebraicNumber<C> copy() {
        return new ComplexAlgebraicNumber<C>(this.ring, this.number);
    }

    @Override
    public boolean isZERO() {
        return this.number.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.number.isONE();
    }

    @Override
    public boolean isUnit() {
        return this.number.isUnit();
    }

    public boolean isRootOfUnity() {
        return this.number.isRootOfUnity();
    }

    public String toString() {
        if (PrettyPrint.isTrue()) {
            return "{ " + this.number.toString() + " }";
        }
        return "Complex" + this.number.toString();
    }

    @Override
    public String toScript() {
        return this.number.toScript();
    }

    @Override
    public String toScriptFactory() {
        return ((ComplexAlgebraicRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(ComplexAlgebraicNumber<C> complexAlgebraicNumber) {
        int n = 0;
        if (this.number.ring != complexAlgebraicNumber.number.ring) {
            n = this.number.ring.modul.compareTo(complexAlgebraicNumber.number.ring.modul);
            System.out.println("s_mod = " + n);
        }
        if (n != 0) {
            return n;
        }
        n = this.number.compareTo(complexAlgebraicNumber.number);
        return n;
    }

    @Override
    public int compareTo(AlgebraicNumber<Complex<C>> algebraicNumber) {
        int n = this.number.compareTo(algebraicNumber);
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ComplexAlgebraicNumber)) {
            return false;
        }
        ComplexAlgebraicNumber complexAlgebraicNumber = (ComplexAlgebraicNumber)object;
        if (!this.ring.equals(complexAlgebraicNumber.ring)) {
            return false;
        }
        return this.number.equals(complexAlgebraicNumber.number);
    }

    @Override
    public int hashCode() {
        return 37 * this.number.val.hashCode() + this.ring.hashCode();
    }

    @Override
    public ComplexAlgebraicNumber<C> abs() {
        if (this.signum() < 0) {
            return new ComplexAlgebraicNumber<C>(this.ring, this.number.negate());
        }
        return this;
    }

    @Override
    public ComplexAlgebraicNumber<C> sum(ComplexAlgebraicNumber<C> complexAlgebraicNumber) {
        return new ComplexAlgebraicNumber<Complex<C>>(this.ring, this.number.sum((Complex<AlgebraicNumber<Complex<C>>>)((Object)complexAlgebraicNumber.number)));
    }

    @Override
    public ComplexAlgebraicNumber<C> sum(GenPolynomial<Complex<C>> genPolynomial) {
        return new ComplexAlgebraicNumber<Complex<C>>(this.ring, this.number.sum((Complex<GenPolynomial<Complex<C>>>)((Object)genPolynomial)));
    }

    @Override
    public ComplexAlgebraicNumber<C> sum(AlgebraicNumber<Complex<C>> algebraicNumber) {
        return new ComplexAlgebraicNumber<Complex<C>>(this.ring, this.number.sum((Complex<AlgebraicNumber<Complex<C>>>)((Object)algebraicNumber)));
    }

    @Override
    public ComplexAlgebraicNumber<C> sum(Complex<C> complex) {
        return new ComplexAlgebraicNumber<C>(this.ring, this.number.sum(complex));
    }

    @Override
    public ComplexAlgebraicNumber<C> negate() {
        return new ComplexAlgebraicNumber<C>(this.ring, this.number.negate());
    }

    @Override
    public ComplexAlgebraicNumber<C> subtract(ComplexAlgebraicNumber<C> complexAlgebraicNumber) {
        return new ComplexAlgebraicNumber<C>(this.ring, this.number.subtract(complexAlgebraicNumber.number));
    }

    @Override
    public ComplexAlgebraicNumber<C> divide(ComplexAlgebraicNumber<C> complexAlgebraicNumber) {
        return this.multiply((ComplexAlgebraicNumber<C>)complexAlgebraicNumber.inverse());
    }

    @Override
    public ComplexAlgebraicNumber<C> inverse() {
        return new ComplexAlgebraicNumber<C>(this.ring, this.number.inverse());
    }

    @Override
    public ComplexAlgebraicNumber<C> remainder(ComplexAlgebraicNumber<C> complexAlgebraicNumber) {
        return new ComplexAlgebraicNumber<C>(this.ring, this.number.remainder(complexAlgebraicNumber.number));
    }

    public ComplexAlgebraicNumber<C>[] quotientRemainder(ComplexAlgebraicNumber<C> complexAlgebraicNumber) {
        return new ComplexAlgebraicNumber[]{this.divide(complexAlgebraicNumber), this.remainder(complexAlgebraicNumber)};
    }

    @Override
    public ComplexAlgebraicNumber<C> multiply(ComplexAlgebraicNumber<C> complexAlgebraicNumber) {
        return new ComplexAlgebraicNumber<Complex<C>>(this.ring, this.number.multiply((Complex<AlgebraicNumber<Complex<C>>>)((Object)complexAlgebraicNumber.number)));
    }

    @Override
    public ComplexAlgebraicNumber<C> multiply(Complex<C> complex) {
        return new ComplexAlgebraicNumber<C>(this.ring, this.number.multiply(complex));
    }

    @Override
    public ComplexAlgebraicNumber<C> multiply(GenPolynomial<Complex<C>> genPolynomial) {
        return new ComplexAlgebraicNumber<C>(this.ring, this.number.multiply(genPolynomial));
    }

    public ComplexAlgebraicNumber<C> monic() {
        return new ComplexAlgebraicNumber<C>(this.ring, this.number.monic());
    }

    @Override
    public ComplexAlgebraicNumber<C> gcd(ComplexAlgebraicNumber<C> complexAlgebraicNumber) {
        return new ComplexAlgebraicNumber<C>(this.ring, this.number.gcd(complexAlgebraicNumber.number));
    }

    public ComplexAlgebraicNumber<C>[] egcd(ComplexAlgebraicNumber<C> complexAlgebraicNumber) {
        AlgebraicNumber<Complex<C>>[] algebraicNumberArray = this.number.egcd(complexAlgebraicNumber.number);
        ComplexAlgebraicNumber[] complexAlgebraicNumberArray = new ComplexAlgebraicNumber[]{new ComplexAlgebraicNumber<C>(this.ring, algebraicNumberArray[0]), new ComplexAlgebraicNumber<C>(this.ring, algebraicNumberArray[1]), new ComplexAlgebraicNumber<C>(this.ring, algebraicNumberArray[2])};
        return complexAlgebraicNumberArray;
    }

    @Override
    public int signum() {
        this.ring.ensureEngine();
        try {
            Rectangle rectangle = this.ring.engine.invariantRectangle(this.ring.root, this.ring.algebraic.modul, this.number.val);
            this.ring.setRoot(rectangle);
            Complex complex = rectangle.getCenter();
            return complex.signum();
        }
        catch (InvalidBoundaryException invalidBoundaryException) {
            invalidBoundaryException.printStackTrace();
            throw new RuntimeException(invalidBoundaryException);
        }
    }

    public Complex<BigRational> magnitude() {
        this.ring.ensureEngine();
        try {
            Rectangle rectangle = this.ring.engine.invariantMagnitudeRectangle(this.ring.root, this.ring.algebraic.modul, this.number.val, this.ring.getEps());
            this.ring.setRoot(rectangle);
            Complex complex = this.ring.engine.complexRectangleMagnitude(rectangle, this.ring.algebraic.modul, this.number.val);
            BigRational bigRational = ((Rational)((Object)((GcdRingElem)complex.getRe()))).getRational();
            BigRational bigRational2 = ((Rational)((Object)((GcdRingElem)complex.getIm()))).getRational();
            ComplexRing<BigRational> complexRing = new ComplexRing<BigRational>(bigRational.factory());
            return new Complex<BigRational>(complexRing, bigRational, bigRational2);
        }
        catch (InvalidBoundaryException invalidBoundaryException) {
            invalidBoundaryException.printStackTrace();
            throw new RuntimeException(invalidBoundaryException);
        }
    }

    public Complex<BigDecimal> decimalMagnitude() {
        Complex<BigRational> complex = this.magnitude();
        ComplexRing<BigDecimal> complexRing = new ComplexRing<BigDecimal>(BigDecimal.ZERO);
        return new Complex<BigDecimal>(complexRing, new BigDecimal(complex.getRe()), new BigDecimal(complex.getIm()));
    }
}

