/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.GcdRingElem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Factors<C extends GcdRingElem<C>>
implements Comparable<Factors<C>>,
Serializable {
    public final GenPolynomial<C> poly;
    public final AlgebraicNumberRing<C> afac;
    public final GenPolynomial<AlgebraicNumber<C>> apoly;
    public final List<GenPolynomial<AlgebraicNumber<C>>> afactors;
    public final List<Factors<AlgebraicNumber<C>>> arfactors;

    public Factors(GenPolynomial<C> genPolynomial) {
        this(genPolynomial, null, null, null, null);
    }

    public Factors(GenPolynomial<C> genPolynomial, AlgebraicNumberRing<C> algebraicNumberRing, GenPolynomial<AlgebraicNumber<C>> genPolynomial2, List<GenPolynomial<AlgebraicNumber<C>>> list) {
        this(genPolynomial, algebraicNumberRing, genPolynomial2, list, null);
    }

    public Factors(GenPolynomial<C> genPolynomial, AlgebraicNumberRing<C> algebraicNumberRing, GenPolynomial<AlgebraicNumber<C>> genPolynomial2, List<GenPolynomial<AlgebraicNumber<C>>> list, List<Factors<AlgebraicNumber<C>>> list2) {
        this.poly = genPolynomial;
        this.afac = algebraicNumberRing;
        this.apoly = genPolynomial2;
        this.afactors = list;
        this.arfactors = list2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.poly.toString());
        if (this.afac == null) {
            return stringBuffer.toString();
        }
        stringBuffer.append(" = ");
        boolean bl = true;
        for (GenPolynomial<AlgebraicNumber<C>> comparable : this.afactors) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(comparable.toString());
        }
        stringBuffer.append("\n  ## over " + this.afac.toString() + "\n");
        if (this.arfactors == null) {
            return stringBuffer.toString();
        }
        bl = true;
        for (Factors factors : this.arfactors) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",\n");
            }
            stringBuffer.append(factors.toString());
        }
        return stringBuffer.toString();
    }

    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.afac == null) {
            return stringBuffer.toString();
        }
        boolean bl = true;
        for (GenPolynomial<AlgebraicNumber<C>> comparable : this.afactors) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("\n * ");
            }
            stringBuffer.append(comparable.toScript());
        }
        stringBuffer.append("   #:: " + this.afac.toScript() + "");
        if (this.arfactors == null) {
            return stringBuffer.toString();
        }
        for (Factors factors : this.arfactors) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("\n * ");
            }
            stringBuffer.append(factors.toScript());
        }
        return stringBuffer.toString();
    }

    public int length() {
        int n = 0;
        if (this.afac == null) {
            return n;
        }
        n += this.afactors.size();
        if (this.arfactors == null) {
            return n;
        }
        for (Factors<AlgebraicNumber<C>> factors : this.arfactors) {
            n += factors.length();
        }
        return n;
    }

    public int hashCode() {
        int n = this.poly.hashCode();
        if (this.afac == null) {
            return n;
        }
        n <<= 27;
        n += this.afac.hashCode();
        if (this.afactors != null) {
            n <<= 27;
            n += this.afactors.hashCode();
        }
        if (this.arfactors != null) {
            n <<= 27;
            n += this.arfactors.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Factors)) {
            return false;
        }
        Factors factors = (Factors)object;
        return this.compareTo(factors) == 0;
    }

    @Override
    public int compareTo(Factors<C> factors) {
        int n = this.poly.compareTo(factors.poly);
        if (n != 0) {
            return n;
        }
        if (this.afac == null) {
            return -1;
        }
        if (factors.afac == null) {
            return 1;
        }
        n = this.afac.modul.compareTo(factors.afac.modul);
        if (n != 0) {
            return n;
        }
        GenPolynomialRing genPolynomialRing = this.afactors.get((int)0).ring;
        PolynomialList polynomialList = new PolynomialList(genPolynomialRing, this.afactors);
        GenPolynomialRing genPolynomialRing2 = factors.afactors.get((int)0).ring;
        PolynomialList polynomialList2 = new PolynomialList(genPolynomialRing2, factors.afactors);
        n = polynomialList.compareTo(polynomialList2);
        if (n != 0) {
            return n;
        }
        if (this.arfactors == null && factors.arfactors == null) {
            return 0;
        }
        if (this.arfactors == null) {
            return -1;
        }
        if (factors.arfactors == null) {
            return 1;
        }
        int n2 = 0;
        for (Factors<AlgebraicNumber<AlgebraicNumber<C>>> factors2 : this.arfactors) {
            if (n2 >= factors.arfactors.size()) {
                return 1;
            }
            Factors<AlgebraicNumber<C>> factors3 = factors.arfactors.get(n2);
            n = factors2.compareTo(factors3);
            if (n != 0) {
                return n;
            }
            ++n2;
        }
        if (n2 < factors.arfactors.size()) {
            return -1;
        }
        return 0;
    }

    public AlgebraicNumberRing<C> findExtensionField() {
        if (this.afac == null) {
            return null;
        }
        if (this.arfactors == null) {
            return this.afac;
        }
        AlgebraicNumberRing<Object> algebraicNumberRing = this.afac;
        int n = 1;
        for (Factors<AlgebraicNumber<C>> factors : this.arfactors) {
            int n2;
            AlgebraicNumberRing<AlgebraicNumber<C>> algebraicNumberRing2 = factors.findExtensionField();
            if (algebraicNumberRing2 == null || (n2 = algebraicNumberRing2.depth()) <= n) continue;
            n = n2;
            algebraicNumberRing = algebraicNumberRing2;
        }
        return algebraicNumberRing;
    }

    public List<GenPolynomial<AlgebraicNumber<C>>> getFactors() {
        ArrayList<GenPolynomial<AlgebraicNumber<C>>> arrayList = new ArrayList<GenPolynomial<AlgebraicNumber<C>>>();
        if (this.afac == null) {
            return arrayList;
        }
        arrayList.addAll(this.afactors);
        if (this.arfactors == null) {
            return arrayList;
        }
        for (Factors<AlgebraicNumber<C>> factors : this.arfactors) {
            arrayList.add(factors.poly);
        }
        return arrayList;
    }

    public Factors<AlgebraicNumber<C>> getFactor(GenPolynomial<AlgebraicNumber<C>> genPolynomial) {
        if (this.afac == null) {
            return null;
        }
        for (Factors<AlgebraicNumber<C>> factors : this.arfactors) {
            if (!genPolynomial.equals(factors.poly)) continue;
            return factors;
        }
        return null;
    }
}

