/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.GenPolynomial;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GreatestCommonDivisorPrimitive<C extends GcdRingElem<C>>
extends GreatestCommonDivisorAbstract<C> {
    private static final Logger logger = LogManager.getLogger(GreatestCommonDivisorPrimitive.class);
    private static final boolean debug = logger.isDebugEnabled();

    @Override
    public GenPolynomial<C> baseGcd(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        AbelianGroupElem<GenPolynomial<C>> abelianGroupElem;
        AbelianGroupElem<GenPolynomial<C>> abelianGroupElem2;
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return genPolynomial;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial2;
        }
        if (genPolynomial.ring.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " no univariate polynomial");
        }
        long l = genPolynomial.degree(0);
        long l2 = genPolynomial2.degree(0);
        if (l2 > l) {
            abelianGroupElem2 = genPolynomial;
            abelianGroupElem = genPolynomial2;
            long l3 = l2;
            l2 = l;
            l = l3;
        } else {
            abelianGroupElem = genPolynomial;
            abelianGroupElem2 = genPolynomial2;
        }
        if (debug) {
            logger.debug("degrees: e = " + l + ", f = " + l2);
        }
        abelianGroupElem2 = ((GenPolynomial)abelianGroupElem2).abs();
        abelianGroupElem = ((GenPolynomial)abelianGroupElem).abs();
        C c = this.baseContent(abelianGroupElem2);
        C c2 = this.baseContent(abelianGroupElem);
        C c3 = this.gcd(c, c2);
        abelianGroupElem2 = this.divide(abelianGroupElem2, c);
        abelianGroupElem = this.divide(abelianGroupElem, c2);
        if (((GenPolynomial)abelianGroupElem2).isONE()) {
            return ((GenPolynomial)abelianGroupElem2).multiply((GenPolynomial<C>)c3);
        }
        if (((GenPolynomial)abelianGroupElem).isONE()) {
            return ((GenPolynomial)abelianGroupElem).multiply((GenPolynomial<C>)c3);
        }
        while (!((GenPolynomial)abelianGroupElem2).isZERO()) {
            GenPolynomial<GenPolynomial<C>> genPolynomial3 = PolyUtil.baseSparsePseudoRemainder(abelianGroupElem, abelianGroupElem2);
            abelianGroupElem = abelianGroupElem2;
            abelianGroupElem2 = this.basePrimitivePart(genPolynomial3);
        }
        return ((GenPolynomial)abelianGroupElem).multiply((GenPolynomial<C>)c3).abs();
    }

    @Override
    public GenPolynomial<GenPolynomial<C>> recursiveUnivariateGcd(GenPolynomial<GenPolynomial<C>> genPolynomial, GenPolynomial<GenPolynomial<C>> genPolynomial2) {
        AbelianGroupElem<GenPolynomial<Object>> abelianGroupElem;
        AbelianGroupElem<GenPolynomial<Object>> abelianGroupElem2;
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return genPolynomial;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial2;
        }
        if (genPolynomial.ring.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " no univariate polynomial");
        }
        long l = genPolynomial.degree(0);
        long l2 = genPolynomial2.degree(0);
        if (l2 > l) {
            abelianGroupElem2 = genPolynomial;
            abelianGroupElem = genPolynomial2;
            long l3 = l2;
            l2 = l;
            l = l3;
        } else {
            abelianGroupElem = genPolynomial;
            abelianGroupElem2 = genPolynomial2;
        }
        if (debug) {
            logger.debug("degrees: e = " + l + ", f = " + l2);
        }
        abelianGroupElem2 = ((GenPolynomial)abelianGroupElem2).abs();
        abelianGroupElem = abelianGroupElem.abs();
        GenPolynomial<C> genPolynomial3 = this.recursiveContent(abelianGroupElem2);
        GenPolynomial<C> genPolynomial4 = this.recursiveContent(abelianGroupElem);
        GenPolynomial<C> genPolynomial5 = this.gcd(genPolynomial3, genPolynomial4);
        abelianGroupElem2 = PolyUtil.recursiveDivide(abelianGroupElem2, genPolynomial3);
        abelianGroupElem = PolyUtil.recursiveDivide(abelianGroupElem, genPolynomial4);
        if (((GenPolynomial)abelianGroupElem2).isONE()) {
            return ((GenPolynomial)abelianGroupElem2).multiply(genPolynomial5);
        }
        if (abelianGroupElem.isONE()) {
            return abelianGroupElem.multiply(genPolynomial5);
        }
        while (!((GenPolynomial)abelianGroupElem2).isZERO()) {
            GenPolynomial genPolynomial6 = PolyUtil.recursivePseudoRemainder(abelianGroupElem, abelianGroupElem2);
            if (logger.isDebugEnabled()) {
                logger.info("recursivePseudoRemainder.bits = " + genPolynomial6.bitLength());
            }
            abelianGroupElem = abelianGroupElem2;
            abelianGroupElem2 = this.recursivePrimitivePart(genPolynomial6);
        }
        return ((GenPolynomial)abelianGroupElem.abs()).multiply(genPolynomial5);
    }
}

