/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.Squarefree;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SquarefreeAbstract<C extends GcdRingElem<C>>
implements Squarefree<C> {
    private static final Logger logger = LogManager.getLogger(SquarefreeAbstract.class);
    protected final GreatestCommonDivisorAbstract<C> engine;

    public SquarefreeAbstract(GreatestCommonDivisorAbstract<C> greatestCommonDivisorAbstract) {
        this.engine = greatestCommonDivisorAbstract;
    }

    public abstract GenPolynomial<C> baseSquarefreePart(GenPolynomial<C> var1);

    public abstract SortedMap<GenPolynomial<C>, Long> baseSquarefreeFactors(GenPolynomial<C> var1);

    public abstract GenPolynomial<GenPolynomial<C>> recursiveUnivariateSquarefreePart(GenPolynomial<GenPolynomial<C>> var1);

    public abstract SortedMap<GenPolynomial<GenPolynomial<C>>, Long> recursiveUnivariateSquarefreeFactors(GenPolynomial<GenPolynomial<C>> var1);

    @Override
    public abstract GenPolynomial<C> squarefreePart(GenPolynomial<C> var1);

    @Override
    public boolean isSquarefree(GenPolynomial<C> genPolynomial) {
        GenPolynomial<C> genPolynomial2 = this.squarefreePart((C)genPolynomial);
        GenPolynomial<C> genPolynomial3 = genPolynomial;
        genPolynomial3 = genPolynomial.ring.coFac.isField() ? genPolynomial3.monic() : this.engine.basePrimitivePart(genPolynomial3);
        boolean bl = genPolynomial3.equals(genPolynomial2);
        return bl;
    }

    @Override
    public boolean isSquarefree(List<GenPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        for (GenPolynomial<C> genPolynomial : list) {
            if (this.isSquarefree(genPolynomial)) continue;
            return false;
        }
        return true;
    }

    public boolean isRecursiveSquarefree(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        GenPolynomial<GenPolynomial<C>> genPolynomial2 = this.recursiveUnivariateSquarefreePart(genPolynomial);
        boolean bl = genPolynomial.equals(genPolynomial2);
        if (!bl) {
            logger.info("not Squarefree, S != P: " + genPolynomial + " != " + genPolynomial2);
        }
        return bl;
    }

    @Override
    public abstract SortedMap<GenPolynomial<C>, Long> squarefreeFactors(GenPolynomial<C> var1);

    @Override
    public List<GenPolynomial<C>> coPrimeSquarefree(List<GenPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList arrayList = new ArrayList();
        for (GenPolynomial<C> genPolynomial : list) {
            SortedMap<GenPolynomial<C>, Long> sortedMap = this.squarefreeFactors((C)genPolynomial);
            arrayList.addAll(sortedMap.keySet());
        }
        List<GenPolynomial<C>> list2 = this.engine.coPrime(arrayList);
        return list2;
    }

    @Override
    public List<GenPolynomial<C>> coPrimeSquarefree(GenPolynomial<C> genPolynomial, List<GenPolynomial<C>> list) {
        if (genPolynomial == null || genPolynomial.isZERO() || genPolynomial.isConstant()) {
            return list;
        }
        SortedMap<GenPolynomial<C>, Long> sortedMap = this.squarefreeFactors((C)genPolynomial);
        List<GenPolynomial<C>> list2 = list;
        for (GenPolynomial<C> genPolynomial2 : sortedMap.keySet()) {
            list2 = this.engine.coPrime(genPolynomial2, list2);
        }
        return list2;
    }

    @Override
    public boolean isCoPrimeSquarefree(List<GenPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        if (!this.engine.isCoPrime(list)) {
            return false;
        }
        return this.isSquarefree(list);
    }

    public SortedMap<GenPolynomial<C>, Long> normalizeFactorization(SortedMap<GenPolynomial<C>, Long> sortedMap) {
        if (sortedMap == null || sortedMap.size() <= 1) {
            return sortedMap;
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(sortedMap.keySet());
        AbelianGroupElem abelianGroupElem = (GenPolynomial)arrayList.get(0);
        if (abelianGroupElem.ring.characteristic().signum() != 0) {
            return sortedMap;
        }
        long l = (Long)sortedMap.get(abelianGroupElem);
        TreeMap<GenPolynomial<C>, Long> treeMap = new TreeMap<GenPolynomial<C>, Long>();
        for (int i = 1; i < arrayList.size(); ++i) {
            AbelianGroupElem abelianGroupElem2 = (GenPolynomial)arrayList.get(i);
            long l2 = (Long)sortedMap.get(abelianGroupElem2);
            if (abelianGroupElem2.signum() < 0 && l2 % 2L != 0L && l % 2L != 0L) {
                abelianGroupElem2 = abelianGroupElem2.negate();
                abelianGroupElem = abelianGroupElem.negate();
            }
            treeMap.put((GenPolynomial<C>)abelianGroupElem2, l2);
        }
        if (!abelianGroupElem.isONE()) {
            treeMap.put((GenPolynomial<C>)abelianGroupElem, l);
        }
        return treeMap;
    }

    @Override
    public boolean isFactorization(GenPolynomial<C> genPolynomial, List<GenPolynomial<C>> list) {
        boolean bl;
        if (genPolynomial == null || list == null) {
            throw new IllegalArgumentException("P and F may not be null");
        }
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial2 = genPolynomial.ring.getONE();
        for (GenPolynomial<C> genPolynomial3 : list) {
            genPolynomial2 = genPolynomial2.multiply((GenPolynomial<GenPolynomial<C>>)genPolynomial3);
        }
        boolean bl2 = bl = genPolynomial.equals(genPolynomial2) || genPolynomial.equals(genPolynomial2.negate());
        if (!bl) {
            logger.info("no factorization(list): F = " + list + ", P = " + genPolynomial + ", t = " + genPolynomial2);
        }
        return bl;
    }

    public long factorCount(SortedMap<GenPolynomial<C>, Long> sortedMap) {
        if (sortedMap == null || sortedMap.isEmpty()) {
            return 0L;
        }
        long l = 0L;
        for (Long l2 : sortedMap.values()) {
            l += l2.longValue();
        }
        return l;
    }

    @Override
    public boolean isFactorization(GenPolynomial<C> genPolynomial, SortedMap<GenPolynomial<C>, Long> sortedMap) {
        boolean bl;
        if (genPolynomial == null || sortedMap == null) {
            throw new IllegalArgumentException("P and F may not be null");
        }
        if (genPolynomial.isZERO() && sortedMap.size() == 0) {
            return true;
        }
        GenPolynomial<GenPolynomial> genPolynomial2 = genPolynomial.ring.getONE();
        for (Map.Entry<GenPolynomial<C>, Long> entry : sortedMap.entrySet()) {
            GenPolynomial<C> genPolynomial3 = entry.getKey();
            Long l = entry.getValue();
            long l2 = l;
            GenPolynomial genPolynomial4 = (GenPolynomial)genPolynomial3.power(l2);
            genPolynomial2 = genPolynomial2.multiply(genPolynomial4);
        }
        boolean bl2 = bl = genPolynomial.equals(genPolynomial2) || genPolynomial.equals(genPolynomial2.negate());
        if (!bl) {
            boolean bl3 = bl = (genPolynomial = genPolynomial.monic()).equals(genPolynomial2 = genPolynomial2.monic()) || genPolynomial.equals(genPolynomial2.negate());
            if (bl) {
                return bl;
            }
            logger.info("no factorization(map): F = " + sortedMap + ", P = " + genPolynomial + ", t = " + genPolynomial2);
        }
        return bl;
    }

    public boolean isRecursiveFactorization(GenPolynomial<GenPolynomial<C>> genPolynomial, SortedMap<GenPolynomial<GenPolynomial<C>>, Long> sortedMap) {
        boolean bl;
        Comparable<Long> comparable;
        Serializable serializable;
        if (genPolynomial == null || sortedMap == null) {
            throw new IllegalArgumentException("P and F may not be null");
        }
        if (genPolynomial.isZERO() && sortedMap.size() == 0) {
            return true;
        }
        GenPolynomial<GenPolynomial<GenPolynomial>> genPolynomial2 = genPolynomial.ring.getONE();
        for (Map.Entry<GenPolynomial<GenPolynomial<C>>, Long> object : sortedMap.entrySet()) {
            serializable = object.getKey();
            comparable = object.getValue();
            long genPolynomial4 = (Long)comparable;
            GenPolynomial genPolynomial3 = (GenPolynomial)serializable.power(genPolynomial4);
            genPolynomial2 = genPolynomial2.multiply(genPolynomial3);
        }
        boolean bl2 = bl = genPolynomial.equals(genPolynomial2) || genPolynomial.equals(genPolynomial2.negate());
        if (!bl) {
            GenPolynomialRing genPolynomialRing = (GenPolynomialRing)genPolynomial.ring.coFac;
            serializable = GCDFactory.getProxy(genPolynomialRing.coFac);
            comparable = ((GreatestCommonDivisorAbstract)serializable).recursivePrimitivePart(genPolynomial);
            comparable = PolyUtil.monic(comparable);
            GenPolynomial genPolynomial4 = ((GreatestCommonDivisorAbstract)serializable).recursivePrimitivePart(genPolynomial2);
            boolean bl3 = bl = ((GenPolynomial)comparable).equals(genPolynomial4 = PolyUtil.monic(genPolynomial4)) || ((GenPolynomial)comparable).equals(genPolynomial4.negate());
            if (bl) {
                return bl;
            }
            logger.info("no factorization(map): F  = " + sortedMap + ", P  = " + genPolynomial + ", t  = " + genPolynomial2 + ", Pp = " + comparable + ", tp = " + genPolynomial4);
        }
        return bl;
    }

    public GenPolynomial<GenPolynomial<C>> recursiveSquarefreePart(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        if (genPolynomial.ring.nvar <= 1) {
            return this.recursiveUnivariateSquarefreePart(genPolynomial);
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        RingFactory ringFactory = genPolynomialRing.coFac;
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)ringFactory;
        GenPolynomialRing genPolynomialRing3 = genPolynomialRing2.extend(genPolynomialRing.nvar);
        GenPolynomial genPolynomial2 = PolyUtil.distribute(genPolynomialRing3, genPolynomial);
        GenPolynomial genPolynomial3 = this.squarefreePart((C)genPolynomial2);
        GenPolynomial genPolynomial4 = PolyUtil.recursive(genPolynomialRing, genPolynomial3);
        return genPolynomial4;
    }

    public SortedMap<GenPolynomial<GenPolynomial<C>>, Long> recursiveSquarefreeFactors(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        TreeMap<GenPolynomial<GenPolynomial<C>>, Long> treeMap = new TreeMap<GenPolynomial<GenPolynomial<C>>, Long>();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return treeMap;
        }
        if (genPolynomial.ring.nvar <= 1) {
            return this.recursiveUnivariateSquarefreeFactors(genPolynomial);
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        RingFactory ringFactory = genPolynomialRing.coFac;
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)ringFactory;
        GenPolynomialRing genPolynomialRing3 = genPolynomialRing2.extend(genPolynomialRing.nvar);
        GenPolynomial genPolynomial2 = PolyUtil.distribute(genPolynomialRing3, genPolynomial);
        SortedMap sortedMap = this.squarefreeFactors((C)genPolynomial2);
        for (Map.Entry entry : sortedMap.entrySet()) {
            GenPolynomial genPolynomial3 = entry.getKey();
            Long l = entry.getValue();
            GenPolynomial genPolynomial4 = PolyUtil.recursive(genPolynomialRing, genPolynomial3);
            treeMap.put(genPolynomial4, l);
        }
        return treeMap;
    }

    public List<List<GenPolynomial<C>>> basePartialFraction(GenPolynomial<C> genPolynomial, SortedMap<GenPolynomial<C>, Long> sortedMap) {
        Iterable<Monomial<Object>> iterable;
        if (sortedMap == null || genPolynomial == null) {
            throw new IllegalArgumentException("null A or D not allowed");
        }
        ArrayList<List<GenPolynomial<C>>> arrayList = new ArrayList<List<GenPolynomial<C>>>(sortedMap.size() + 1);
        if (sortedMap.size() == 0) {
            return arrayList;
        }
        if (genPolynomial.isZERO()) {
            for (Map.Entry<GenPolynomial<C>, Long> entry : sortedMap.entrySet()) {
                long l = entry.getValue();
                int l2 = (int)l + 1;
                ArrayList<GenPolynomial<C>> arrayList2 = new ArrayList<GenPolynomial<C>>(l2);
                for (int object3 = 0; object3 < l2; ++object3) {
                    arrayList2.add(genPolynomial);
                }
                arrayList.add(arrayList2);
            }
            ArrayList arrayList3 = new ArrayList(1);
            arrayList3.add(genPolynomial);
            arrayList.add(0, arrayList3);
            return arrayList;
        }
        ArrayList arrayList4 = new ArrayList(sortedMap.size());
        for (Map.Entry<GenPolynomial<C>, Long> object2 : sortedMap.entrySet()) {
            iterable = object2.getKey();
            long n = object2.getValue();
            GenPolynomial genPolynomial2 = (GenPolynomial)iterable.power(n);
            arrayList4.add(genPolynomial2);
        }
        List<GenPolynomial<C>> list = this.engine.basePartialFraction(genPolynomial, arrayList4);
        GenPolynomial genPolynomial3 = (GenPolynomial)list.remove(0);
        iterable = new ArrayList(1);
        iterable.add((GenPolynomial)genPolynomial3);
        arrayList.add((List<GenPolynomial<C>>)iterable);
        int n = 0;
        for (Map.Entry<GenPolynomial<C>, Long> entry : sortedMap.entrySet()) {
            GenPolynomial<C> genPolynomial4 = entry.getKey();
            long l = entry.getValue();
            int n2 = (int)l;
            GenPolynomial genPolynomial5 = (GenPolynomial)list.get(n);
            List<GenPolynomial<C>> list2 = this.engine.basePartialFraction(genPolynomial5, genPolynomial4, n2);
            arrayList.add(list2);
            ++n;
        }
        return arrayList;
    }

    public boolean isBasePartialFraction(GenPolynomial<C> genPolynomial, SortedMap<GenPolynomial<C>, Long> sortedMap, List<List<GenPolynomial<C>>> list) {
        GenPolynomial genPolynomial2;
        if (sortedMap == null || genPolynomial == null || list == null) {
            throw new IllegalArgumentException("null A, D or F not allowed");
        }
        if (sortedMap.isEmpty() && list.isEmpty()) {
            return true;
        }
        if (sortedMap.isEmpty() || list.isEmpty()) {
            return false;
        }
        ArrayList arrayList = new ArrayList(sortedMap.size());
        for (Map.Entry<GenPolynomial<C>, Long> entry : sortedMap.entrySet()) {
            genPolynomial2 = entry.getKey();
            long l = entry.getValue();
            GenPolynomial genPolynomial3 = (GenPolynomial)genPolynomial2.power(l);
            arrayList.add(genPolynomial3);
        }
        List<GenPolynomial<C>> list2 = list.get(0);
        if (list2.size() != 1) {
            logger.info("size(fi) != 1 " + list2);
            return false;
        }
        genPolynomial2 = (GenPolynomial)list2.get(0);
        ArrayList arrayList2 = new ArrayList(sortedMap.size() + 1);
        arrayList2.add(genPolynomial2);
        int n = 0;
        for (Map.Entry entry : sortedMap.entrySet()) {
            GenPolynomial genPolynomial4 = (GenPolynomial)entry.getKey();
            long l = (Long)entry.getValue();
            int n2 = (int)l;
            List<GenPolynomial<C>> list3 = list.get(n + 1);
            GenPolynomial<C> genPolynomial5 = this.engine.basePartialFractionValue(genPolynomial4, n2, list3);
            arrayList2.add(genPolynomial5);
            ++n;
        }
        boolean bl = this.engine.isBasePartialFraction(genPolynomial, arrayList, arrayList2);
        if (!bl) {
            System.out.println("not final isPartFrac " + arrayList2);
        }
        return bl;
    }

    public C squarefreePart(C c) {
        if (c == null) {
            return null;
        }
        GcdRingElem gcdRingElem = null;
        SortedMap<C, Long> sortedMap = this.squarefreeFactors(c);
        for (GcdRingElem gcdRingElem2 : sortedMap.keySet()) {
            if (gcdRingElem == null) {
                gcdRingElem = gcdRingElem2;
                continue;
            }
            gcdRingElem = gcdRingElem.multiply(gcdRingElem2);
        }
        return (C)gcdRingElem;
    }

    public abstract SortedMap<C, Long> squarefreeFactors(C var1);
}

