/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gb.ReductionSeq;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.Power;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import edu.jas.ufd.SquarefreeFieldCharP;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SquarefreeInfiniteAlgebraicFieldCharP<C extends GcdRingElem<C>>
extends SquarefreeFieldCharP<AlgebraicNumber<C>> {
    private static final Logger logger = LogManager.getLogger(SquarefreeInfiniteAlgebraicFieldCharP.class);
    protected final SquarefreeAbstract<C> aengine;

    public SquarefreeInfiniteAlgebraicFieldCharP(RingFactory<AlgebraicNumber<C>> ringFactory) {
        super(ringFactory);
        if (ringFactory.isFinite()) {
            throw new IllegalArgumentException("fac must be in-finite");
        }
        AlgebraicNumberRing algebraicNumberRing = (AlgebraicNumberRing)ringFactory;
        GenPolynomialRing genPolynomialRing = algebraicNumberRing.ring;
        this.aengine = SquarefreeFactory.getImplementation(genPolynomialRing);
    }

    @Override
    public SortedMap<AlgebraicNumber<C>, Long> squarefreeFactors(AlgebraicNumber<C> algebraicNumber) {
        if (algebraicNumber == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        TreeMap<AlgebraicNumber<C>, Long> treeMap = new TreeMap<AlgebraicNumber<C>, Long>();
        if (algebraicNumber.isZERO()) {
            return treeMap;
        }
        if (algebraicNumber.isONE()) {
            treeMap.put(algebraicNumber, 1L);
            return treeMap;
        }
        GenPolynomial genPolynomial = algebraicNumber.val;
        AlgebraicNumberRing algebraicNumberRing = algebraicNumber.ring;
        if (!genPolynomial.isONE()) {
            SortedMap sortedMap = this.aengine.squarefreeFactors(genPolynomial);
            for (Map.Entry entry : sortedMap.entrySet()) {
                GenPolynomial genPolynomial2 = entry.getKey();
                AlgebraicNumber algebraicNumber2 = new AlgebraicNumber(algebraicNumberRing, genPolynomial2);
                treeMap.put(algebraicNumber2, entry.getValue());
            }
        }
        if (treeMap.size() == 0) {
            treeMap.put(algebraicNumber, 1L);
        }
        return treeMap;
    }

    public SortedMap<AlgebraicNumber<C>, Long> rootCharacteristic(AlgebraicNumber<C> algebraicNumber) {
        int n;
        RingElem ringElem;
        GcdRingElem gcdRingElem;
        RingElem ringElem2;
        RingElem ringElem3;
        RingElem ringElem4;
        GcdRingElem gcdRingElem2;
        Object object;
        RingElem ringElem5;
        AbelianGroupElem abelianGroupElem;
        ExpVector n2;
        Serializable serializable;
        Object object2;
        Iterable<Monomial<Object>> iterable;
        if (algebraicNumber == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        BigInteger bigInteger = algebraicNumber.ring.characteristic();
        if (bigInteger.signum() == 0) {
            return null;
        }
        TreeMap<AlgebraicNumber<C>, Long> treeMap = new TreeMap<AlgebraicNumber<C>, Long>();
        if (algebraicNumber.isZERO()) {
            return treeMap;
        }
        if (algebraicNumber.isONE()) {
            treeMap.put(algebraicNumber, 1L);
            return treeMap;
        }
        AlgebraicNumberRing algebraicNumberRing = algebraicNumber.ring;
        long l = algebraicNumberRing.modul.degree(0);
        int n22 = (int)l;
        String[] stringArray = GenPolynomialRing.newVars("c", n22);
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(algebraicNumberRing, n22, stringArray);
        List list = genPolynomialRing.univariateList();
        GenPolynomial genPolynomial = genPolynomialRing.getZERO();
        GenPolynomialRing genPolynomialRing2 = algebraicNumberRing.ring;
        long l2 = 0L;
        for (GenPolynomial iterable22 : list) {
            iterable = genPolynomialRing2.univariate(0, l2++);
            object2 = iterable22.multiply(new AlgebraicNumber(algebraicNumberRing, iterable));
            genPolynomial = genPolynomial.sum(object2);
        }
        GenPolynomial genPolynomial2 = (GenPolynomial)Power.positivePower(genPolynomial, bigInteger);
        if (logger.isInfoEnabled()) {
            logger.info("cp   = " + genPolynomial);
            logger.info("cp^p = " + genPolynomial2);
            logger.info("P    = " + algebraicNumber);
        }
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(genPolynomialRing2.coFac, genPolynomialRing);
        iterable = new ArrayList();
        if (l == bigInteger.longValue() && algebraicNumberRing.modul.length() == 2) {
            logger.info("deg(" + l + ") == char_p(" + bigInteger.longValue() + ")");
            object2 = genPolynomial2.iterator();
            while (object2.hasNext()) {
                serializable = (Monomial)object2.next();
                n2 = ((Monomial)serializable).e;
                abelianGroupElem = (AlgebraicNumber)((Monomial)serializable).c;
                ringElem5 = ((AlgebraicNumber)abelianGroupElem).val;
                for (Monomial monomial : ringElem5) {
                    object = monomial.e;
                    gcdRingElem2 = (GcdRingElem)monomial.c;
                    ringElem4 = (GcdRingElem)algebraicNumber.val.coefficient((ExpVector)object);
                    ringElem3 = (GcdRingElem)((RingFactory)ringElem4.factory()).getONE();
                    ringElem2 = (GcdRingElem)((RingFactory)ringElem4.factory()).getZERO();
                    if (gcdRingElem2 instanceof AlgebraicNumber && ringElem4 instanceof AlgebraicNumber) {
                        throw new UnsupportedOperationException("case multiple algebraic extensions not implemented");
                    }
                    if (!(gcdRingElem2 instanceof Quotient) || !(ringElem4 instanceof Quotient)) continue;
                    gcdRingElem = (Quotient)gcdRingElem2;
                    Quotient quotient = (Quotient)ringElem4;
                    if (quotient.isConstant()) {
                        throw new ArithmeticException("finite field not allowed here " + algebraicNumberRing.toScript());
                    }
                    Quotient quotient2 = ((Quotient)gcdRingElem).divide(quotient);
                    if (quotient2.isConstant()) {
                        ringElem3 = gcdRingElem2;
                        ringElem2 = ringElem4;
                    }
                    ringElem = new GenPolynomial(genPolynomialRing3, ringElem3, n2);
                    ringElem = ((GenPolynomial)ringElem).subtract(ringElem2);
                    iterable.add(ringElem);
                }
            }
        } else {
            object2 = genPolynomial2.iterator();
            while (object2.hasNext()) {
                serializable = (Monomial)object2.next();
                n2 = ((Monomial)serializable).e;
                abelianGroupElem = (AlgebraicNumber)((Monomial)serializable).c;
                ringElem5 = ((AlgebraicNumber)abelianGroupElem).val;
                for (Monomial monomial : ringElem5) {
                    object = monomial.e;
                    gcdRingElem2 = (GcdRingElem)monomial.c;
                    ringElem4 = (GcdRingElem)algebraicNumber.val.coefficient((ExpVector)object);
                    ringElem3 = new GenPolynomial<GcdRingElem>(genPolynomialRing3, gcdRingElem2, n2);
                    ringElem3 = ((GenPolynomial)ringElem3).subtract((GcdRingElem)ringElem4);
                    iterable.add(ringElem3);
                }
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("equations = " + iterable);
        }
        if ((n = ((GroebnerBaseAbstract)(serializable = new GroebnerBaseSeq())).commonZeroTest(iterable = (object2 = new ReductionSeq()).irreducibleSet(iterable))) < 0) {
            return null;
        }
        if (logger.isInfoEnabled()) {
            logger.info("solution = " + iterable);
        }
        abelianGroupElem = genPolynomialRing2.getZERO();
        for (GenPolynomial genPolynomial3 : iterable) {
            if (genPolynomial3.length() <= 1) continue;
            if (genPolynomial3.length() > 2) {
                throw new IllegalArgumentException("dim > 0 not implemented " + genPolynomial3);
            }
            ExpVector expVector = genPolynomial3.leadingExpVector();
            object = expVector.dependencyOnVariables();
            if (object == null || ((Object)object).length == 0) continue;
            Object object3 = object[0];
            ringElem4 = genPolynomialRing2.univariate(0, l - 1L - (long)object3);
            ringElem3 = (GcdRingElem)genPolynomial3.trailingBaseCoefficient();
            ringElem3 = (GcdRingElem)ringElem3.negate();
            if (expVector.maxDeg() == bigInteger.longValue() && (ringElem2 = this.aengine.squarefreeFactors(ringElem3)) != null && ringElem2.size() > 0) {
                gcdRingElem = (GcdRingElem)genPolynomialRing2.coFac.getONE();
                for (Map.Entry entry : ringElem2.entrySet()) {
                    ringElem = (GcdRingElem)entry.getKey();
                    long l3 = (Long)entry.getValue();
                    if (l3 % bigInteger.longValue() == 0L) {
                        long l4 = l3 / bigInteger.longValue();
                        gcdRingElem = (GcdRingElem)gcdRingElem.multiply(ringElem.power(l4));
                        continue;
                    }
                    gcdRingElem = (GcdRingElem)((Object)gcdRingElem.multiply(ringElem));
                }
                ringElem3 = gcdRingElem;
            }
            ringElem4 = ((GenPolynomial)ringElem4).multiply(ringElem3);
            abelianGroupElem = ((GenPolynomial)abelianGroupElem).sum(ringElem4);
        }
        ringElem5 = new AlgebraicNumber(algebraicNumberRing, abelianGroupElem);
        if (logger.isInfoEnabled()) {
            logger.info("solution AN = " + ringElem5);
        }
        treeMap.put((AlgebraicNumber<C>)ringElem5, 1L);
        return treeMap;
    }

    public GenPolynomial<AlgebraicNumber<C>> rootCharacteristic(GenPolynomial<AlgebraicNumber<C>> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            GenPolynomialRing genPolynomialRing2 = genPolynomialRing.recursive(1);
            GenPolynomial<GenPolynomial<AlgebraicNumber<C>>> genPolynomial2 = PolyUtil.recursive(genPolynomialRing2, genPolynomial);
            GenPolynomial genPolynomial3 = this.recursiveUnivariateRootCharacteristic(genPolynomial2);
            if (genPolynomial3 == null) {
                return null;
            }
            GenPolynomial<AlgebraicNumber<C>> genPolynomial4 = PolyUtil.distribute(genPolynomialRing, genPolynomial3);
            return genPolynomial4;
        }
        RingFactory ringFactory = genPolynomialRing.coFac;
        if (ringFactory.characteristic().signum() != 1) {
            throw new IllegalArgumentException(genPolynomial.getClass().getName() + " only for ModInteger polynomials " + ringFactory);
        }
        long l = ringFactory.characteristic().longValue();
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        for (Monomial<AlgebraicNumber<C>> monomial : genPolynomial) {
            ExpVector expVector = monomial.e;
            long l2 = expVector.getVal(0);
            if (l2 % l != 0L) {
                return null;
            }
            l2 /= l;
            SortedMap<AlgebraicNumber<C>, Long> sortedMap = this.rootCharacteristic((AlgebraicNumber)monomial.c);
            if (sortedMap == null) {
                return null;
            }
            if (logger.isInfoEnabled()) {
                logger.info("sm_alg,root = " + sortedMap);
            }
            AlgebraicNumber<AlgebraicNumber<AlgebraicNumber>> algebraicNumber = (AlgebraicNumber<AlgebraicNumber<AlgebraicNumber>>)ringFactory.getONE();
            for (Map.Entry<AlgebraicNumber<C>, Long> entry : sortedMap.entrySet()) {
                AlgebraicNumber algebraicNumber2 = entry.getKey();
                long l3 = entry.getValue();
                if (l3 > 1L) {
                    algebraicNumber2 = (AlgebraicNumber)algebraicNumber2.power(l3);
                }
                algebraicNumber = algebraicNumber.multiply(algebraicNumber2);
            }
            ExpVector expVector2 = ExpVector.create(1, 0, l2);
            ((GenPolynomial)element).doPutToMap(expVector2, algebraicNumber);
        }
        logger.info("sm_alg,root,d = " + element);
        return element;
    }

    @Override
    public GenPolynomial<AlgebraicNumber<C>> baseRootCharacteristic(GenPolynomial<AlgebraicNumber<C>> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(genPolynomial.getClass().getName() + " only for univariate polynomials");
        }
        RingFactory ringFactory = genPolynomialRing.coFac;
        if (ringFactory.characteristic().signum() != 1) {
            throw new IllegalArgumentException(genPolynomial.getClass().getName() + " only for char p > 0 " + ringFactory);
        }
        long l = ringFactory.characteristic().longValue();
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        for (Monomial<AlgebraicNumber<C>> monomial : genPolynomial) {
            ExpVector expVector = monomial.e;
            long l2 = expVector.getVal(0);
            if (l2 % l != 0L) {
                return null;
            }
            l2 /= l;
            SortedMap<AlgebraicNumber<C>, Long> sortedMap = this.rootCharacteristic((AlgebraicNumber)monomial.c);
            if (sortedMap == null) {
                return null;
            }
            if (logger.isInfoEnabled()) {
                logger.info("sm_alg,base,root = " + sortedMap);
            }
            AlgebraicNumber<AlgebraicNumber<AlgebraicNumber>> algebraicNumber = (AlgebraicNumber<AlgebraicNumber<AlgebraicNumber>>)ringFactory.getONE();
            for (Map.Entry<AlgebraicNumber<C>, Long> entry : sortedMap.entrySet()) {
                AlgebraicNumber algebraicNumber2 = entry.getKey();
                long l3 = entry.getValue();
                AlgebraicNumber algebraicNumber3 = algebraicNumber2;
                if (l3 > 1L) {
                    algebraicNumber3 = (AlgebraicNumber)algebraicNumber2.power(l3);
                }
                algebraicNumber = algebraicNumber.multiply(algebraicNumber3);
            }
            ExpVector expVector2 = ExpVector.create(1, 0, l2);
            ((GenPolynomial)element).doPutToMap(expVector2, algebraicNumber);
        }
        if (logger.isInfoEnabled()) {
            logger.info("sm_alg,base,d = " + element);
        }
        return element;
    }

    @Override
    public GenPolynomial<GenPolynomial<AlgebraicNumber<C>>> recursiveUnivariateRootCharacteristic(GenPolynomial<GenPolynomial<AlgebraicNumber<C>>> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(genPolynomial.getClass().getName() + " only for univariate recursive polynomials");
        }
        RingFactory ringFactory = genPolynomialRing.coFac;
        if (ringFactory.characteristic().signum() != 1) {
            throw new IllegalArgumentException(genPolynomial.getClass().getName() + " only for char p > 0 " + ringFactory);
        }
        long l = ringFactory.characteristic().longValue();
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        for (Monomial<GenPolynomial<AlgebraicNumber<C>>> monomial : genPolynomial) {
            ExpVector expVector = monomial.e;
            long l2 = expVector.getVal(0);
            if (l2 % l != 0L) {
                return null;
            }
            l2 /= l;
            GenPolynomial<AlgebraicNumber<C>> genPolynomial2 = this.rootCharacteristic((GenPolynomial)monomial.c);
            if (genPolynomial2 == null) {
                return null;
            }
            ExpVector expVector2 = ExpVector.create(1, 0, l2);
            ((GenPolynomial)element).doPutToMap(expVector2, genPolynomial2);
        }
        return element;
    }
}

