/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModularNotInvertibleException;
import edu.jas.kern.PrettyPrint;
import edu.jas.structure.NotInvertibleException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ModIntegerTest
extends TestCase {
    ModIntegerRing zm;
    ModIntegerRing z1;
    ModIntegerRing z2;
    ModInteger a;
    ModInteger b;
    ModInteger c;
    ModInteger d;
    ModInteger e;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ModIntegerTest.suite());
    }

    public ModIntegerTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ModIntegerTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.z2 = null;
        this.z1 = null;
        this.zm = null;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.z2 = null;
        this.z1 = null;
        this.zm = null;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected static java.math.BigInteger getPrime1() {
        long l = 2L;
        for (int i = 1; i < 60; ++i) {
            l *= 2L;
        }
        return new java.math.BigInteger("" + (l -= 93L));
    }

    protected static java.math.BigInteger getPrime2() {
        long l = 2L;
        for (int i = 1; i < 30; ++i) {
            l *= 2L;
        }
        return new java.math.BigInteger("" + (l -= 35L));
    }

    public void testConstants() {
        this.zm = new ModIntegerRing(5L);
        this.d = new ModInteger(this.zm, 11L);
        this.a = this.zm.getZERO();
        this.b = this.zm.getONE();
        this.c = ModInteger.MIDIF(this.b, this.b);
        ModIntegerTest.assertEquals((String)"1-1 = 0", (Object)this.c, (Object)this.a);
        ModIntegerTest.assertTrue((String)"1-1 = 0", (boolean)this.c.isZERO());
        ModIntegerTest.assertTrue((String)"1 = 1", (boolean)this.b.isONE());
    }

    public void testBitLength() {
        this.zm = new ModIntegerRing(163L);
        this.a = this.zm.getZERO();
        this.b = this.zm.getONE();
        this.c = this.zm.random(30);
        ModIntegerTest.assertEquals((String)"len(0) = 1", (long)1L, (long)this.a.bitLength());
        ModIntegerTest.assertEquals((String)"len(1) = 2", (long)2L, (long)this.b.bitLength());
        ModIntegerTest.assertEquals((String)"len(-1) = len(mod)", (long)(this.zm.modul.bitLength() + 1), (long)this.b.negate().bitLength());
        ModIntegerTest.assertTrue((String)"len(random) >= 1", (1L <= this.c.bitLength() ? 1 : 0) != 0);
    }

    public void testConstructor() {
        Object object;
        this.zm = new ModIntegerRing("5");
        this.a = new ModInteger(this.zm, "64");
        this.b = new ModInteger(this.zm, "34");
        ModIntegerTest.assertEquals((String)"64(5) = 34(5)", (Object)this.a, (Object)this.b);
        this.zm = new ModIntegerRing("7");
        this.a = new ModInteger(this.zm, "-4");
        this.b = new ModInteger(this.zm, "3");
        ModIntegerTest.assertEquals((String)"-4(7) = 3(7)", (Object)this.a, (Object)this.b);
        String string = "61111111111111111111111111111111111111111111";
        this.zm = new ModIntegerRing("10");
        this.a = new ModInteger(this.zm, string);
        String string2 = this.a.toString();
        if (PrettyPrint.isTrue()) {
            object = "1";
            ModIntegerTest.assertEquals((String)"stringConstr = toString", (String)object, (String)string2);
        } else {
            object = "1 mod(10)";
            ModIntegerTest.assertEquals((String)"stringConstr = toString", (String)object, (String)string2);
        }
        this.zm = new ModIntegerRing(7L);
        this.a = new ModInteger(this.zm, 1L);
        this.b = new ModInteger(this.zm, -1L);
        this.c = ModInteger.MISUM(this.b, this.a);
        ModIntegerTest.assertTrue((String)"1 = 1", (boolean)this.a.isONE());
        ModIntegerTest.assertTrue((String)"1 = 1", (boolean)this.b.isUnit());
        ModIntegerTest.assertEquals((String)"1+(-1) = 0", (Object)this.c, (Object)this.zm.getZERO());
        this.zm = new ModIntegerRing(5L);
        this.a = new ModInteger(this.zm, 3L);
        this.b = new ModInteger(this.zm, 0L);
        this.c = this.zm.parse(" 13 ");
        ModIntegerTest.assertEquals((String)"3(5) = 3(5)", (Object)this.a, (Object)this.c);
        object = new StringReader("  13\n w ");
        this.c = this.zm.parse((Reader)object);
        ModIntegerTest.assertEquals((String)"3(5) = 3(5)", (Object)this.a, (Object)this.c);
    }

    public void testRandom() {
        this.zm = new ModIntegerRing(19L);
        this.a = this.zm.random(500);
        this.b = this.a.copy();
        this.c = ModInteger.MIDIF(this.b, this.a);
        ModIntegerTest.assertEquals((String)"a-b = 0", (Object)this.c, (Object)this.zm.getZERO());
        this.d = new ModInteger(new ModIntegerRing(this.b.getModul()), this.b.getVal());
        ModIntegerTest.assertEquals((String)"sign(a-a) = 0", (int)0, (int)this.b.compareTo(this.d));
    }

    public void testAddition() {
        this.zm = new ModIntegerRing(19L);
        this.a = this.zm.random(100);
        this.b = ModInteger.MISUM(this.a, this.a);
        this.c = ModInteger.MIDIF(this.b, this.a);
        ModIntegerTest.assertEquals((String)"a+a-a = a", (Object)this.c, (Object)this.a);
        ModIntegerTest.assertEquals((String)"a+a-a = a", (int)0, (int)ModInteger.MICOMP(this.c, this.a));
        this.d = ModInteger.MISUM(this.a, this.zm.getZERO());
        ModIntegerTest.assertEquals((String)"a+0 = a", (Object)this.d, (Object)this.a);
        this.d = ModInteger.MIDIF(this.a, this.zm.getZERO());
        ModIntegerTest.assertEquals((String)"a-0 = a", (Object)this.d, (Object)this.a);
        this.d = ModInteger.MIDIF(this.a, this.a);
        ModIntegerTest.assertEquals((String)"a-a = 0", (Object)this.d, (Object)this.zm.getZERO());
    }

    public void testMultiplication() {
        this.zm = new ModIntegerRing(5L);
        this.d = new ModInteger(this.zm, 11L);
        this.a = this.zm.random(100);
        if (this.a.isZERO()) {
            this.a = this.d;
        }
        this.b = ModInteger.MIPROD(this.a, this.a);
        this.c = ModInteger.MIQ(this.b, this.a);
        ModIntegerTest.assertEquals((String)"a*a/a = a", (Object)this.c, (Object)this.a);
        ModIntegerTest.assertEquals((String)"a*a/a = a", (int)0, (int)this.c.compareTo(this.a));
        this.d = ModInteger.MIPROD(this.a, this.zm.getONE());
        ModIntegerTest.assertEquals((String)"a*1 = a", (Object)this.d, (Object)this.a);
        this.d = ModInteger.MIQ(this.a, this.zm.getONE());
        ModIntegerTest.assertEquals((String)"a/1 = a", (Object)this.d, (Object)this.a);
        this.a = this.zm.random(100);
        if (this.a.isZERO()) {
            this.a = this.d;
        }
        this.b = ModInteger.MIINV(this.a);
        this.c = ModInteger.MIPROD(this.a, this.b);
        ModIntegerTest.assertTrue((String)"a*1/a = 1", (boolean)this.c.isONE());
        try {
            this.a = this.zm.getZERO().inverse();
            ModIntegerTest.fail((String)"0 invertible");
        }
        catch (NotInvertibleException notInvertibleException) {
            // empty catch block
        }
        this.zm = new ModIntegerRing(15L);
        this.a = new ModInteger(this.zm, 5L);
        ModIntegerTest.assertFalse((String)"5 !unit mod 15", (boolean)this.a.isUnit());
        try {
            this.b = this.a.inverse();
            ModIntegerTest.fail((String)"5 invertible");
        }
        catch (ModularNotInvertibleException modularNotInvertibleException) {
            ModIntegerTest.assertTrue((String)"f  = 15 ", (boolean)modularNotInvertibleException.f.equals(new BigInteger(15L)));
            ModIntegerTest.assertTrue((String)"f1 =  5 ", (boolean)modularNotInvertibleException.f1.equals(new BigInteger(5L)));
            ModIntegerTest.assertTrue((String)"f2 =  3 ", (boolean)modularNotInvertibleException.f2.equals(new BigInteger(3L)));
            ModIntegerTest.assertTrue((String)"f  =  f1*f2 ", (boolean)modularNotInvertibleException.f.equals(modularNotInvertibleException.f1.multiply(modularNotInvertibleException.f2)));
        }
        catch (NotInvertibleException notInvertibleException) {
            ModIntegerTest.fail((String)("wrong exception " + notInvertibleException));
        }
    }

    public void testChineseRemainder() {
        this.zm = new ModIntegerRing(247L);
        this.a = this.zm.random(9);
        this.z1 = new ModIntegerRing(19L);
        this.b = new ModInteger(this.z1, this.a.getVal().longValue());
        this.z2 = new ModIntegerRing(13L);
        this.c = new ModInteger(this.z2, this.a.getVal().longValue());
        this.d = new ModInteger(this.z2, 19L);
        this.d = this.d.inverse();
        this.e = this.zm.chineseRemainder(this.b, this.d, this.c);
        ModIntegerTest.assertEquals((String)"cra(a mod 19,a mod 13) = a", (Object)this.a, (Object)this.e);
        java.math.BigInteger bigInteger = ModIntegerTest.getPrime1();
        java.math.BigInteger bigInteger2 = ModIntegerTest.getPrime2();
        java.math.BigInteger bigInteger3 = bigInteger.multiply(bigInteger2);
        this.zm = new ModIntegerRing(bigInteger3);
        this.z1 = new ModIntegerRing(bigInteger);
        this.z2 = new ModIntegerRing(bigInteger2);
        for (int i = 0; i < 5; ++i) {
            this.a = this.zm.random(44);
            this.b = new ModInteger(this.z1, this.a.getVal());
            this.c = new ModInteger(this.z2, this.a.getVal());
            ModInteger modInteger = new ModInteger(this.z2, bigInteger);
            this.d = modInteger.inverse();
            this.e = this.zm.chineseRemainder(this.b, this.d, this.c);
            ModIntegerTest.assertEquals((String)"cra(a mod p1,a mod p2) = a", (Object)this.a, (Object)this.e);
        }
    }

    public void testChineseRemainderLists() {
        java.math.BigInteger bigInteger = ModIntegerTest.getPrime1();
        java.math.BigInteger bigInteger2 = ModIntegerTest.getPrime2();
        java.math.BigInteger bigInteger3 = bigInteger.multiply(bigInteger2);
        this.zm = new ModIntegerRing(bigInteger3);
        this.z1 = new ModIntegerRing(bigInteger);
        this.z2 = new ModIntegerRing(bigInteger2);
        ArrayList<ModInteger> arrayList = new ArrayList<ModInteger>();
        ArrayList<ModInteger> arrayList2 = new ArrayList<ModInteger>();
        for (int i = 0; i < 5; ++i) {
            this.a = this.zm.random(17);
            this.b = new ModInteger(this.z1, this.a.getVal());
            this.c = new ModInteger(this.z2, this.a.getVal());
            arrayList.add(this.b);
            arrayList2.add(this.c);
        }
        List<ModInteger> list = ModIntegerRing.chineseRemainder(this.z1.getONE(), this.z2.getONE(), arrayList, arrayList2);
        ModIntegerTest.assertEquals((String)"p1 * p2) = a.modul: ", (Object)this.zm, (Object)list.get((int)0).ring);
        for (ModInteger modInteger : list) {
            this.b = new ModInteger(this.z1, modInteger.getVal());
            this.c = new ModInteger(this.z2, modInteger.getVal());
            ModIntegerTest.assertTrue((String)"cra(a mod p1, a mod p2) = a: ", (boolean)arrayList.contains(this.b));
            ModIntegerTest.assertTrue((String)"cra(a mod p1, a mod p2) = a: ", (boolean)arrayList2.contains(this.c));
        }
    }

    public void testIterator() {
        int n = 10;
        this.zm = new ModIntegerRing(n);
        ModInteger modInteger = null;
        Object object = this.zm.iterator();
        while (object.hasNext()) {
            ModInteger modInteger2;
            modInteger = modInteger2 = object.next();
        }
        object = new ModInteger(this.zm, n - 1);
        ModIntegerTest.assertTrue((String)"j == m-1 ", (boolean)modInteger.equals(object));
    }
}

