/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.ProductRing;
import edu.jas.structure.Element;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.RegularRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Product<C extends RingElem<C>>
implements RegularRingElem<Product<C>> {
    private static final Logger logger = LogManager.getLogger(Product.class);
    public final ProductRing<C> ring;
    public final SortedMap<Integer, C> val;
    protected int isunit = -1;

    public Product(ProductRing<C> productRing) {
        this(productRing, new TreeMap(), 0);
    }

    public Product(ProductRing<C> productRing, SortedMap<Integer, C> sortedMap) {
        this(productRing, sortedMap, -1);
    }

    public Product(ProductRing<C> productRing, SortedMap<Integer, C> sortedMap, int n) {
        this.ring = productRing;
        this.val = sortedMap;
        this.isunit = n;
    }

    public C get(int n) {
        return (C)((RingElem)this.val.get(n));
    }

    @Override
    public ProductRing<C> factory() {
        return this.ring;
    }

    @Override
    public Product<C> copy() {
        return new Product<C>(this.ring, this.val, this.isunit);
    }

    @Override
    public boolean isZERO() {
        return this.val.size() == 0;
    }

    @Override
    public boolean isONE() {
        if (this.val.size() != this.ring.length()) {
            return false;
        }
        for (RingElem ringElem : this.val.values()) {
            if (ringElem.isONE()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isFull() {
        return this.val.size() == this.ring.length();
    }

    @Override
    public boolean isUnit() {
        if (this.isunit > 0) {
            return true;
        }
        if (this.isunit == 0) {
            return false;
        }
        if (this.isZERO()) {
            this.isunit = 0;
            return false;
        }
        for (RingElem ringElem : this.val.values()) {
            if (ringElem.isUnit()) continue;
            this.isunit = 0;
            return false;
        }
        this.isunit = 1;
        return true;
    }

    @Override
    public boolean isIdempotent() {
        for (RingElem ringElem : this.val.values()) {
            if (ringElem.isONE()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.val.toString();
    }

    @Override
    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer("( ");
        boolean bl = true;
        for (Map.Entry<Integer, C> entry : this.val.entrySet()) {
            Integer n = entry.getKey();
            RingElem ringElem = (RingElem)entry.getValue();
            if (bl) {
                bl = false;
            } else if (ringElem.signum() < 0) {
                stringBuffer.append(" - ");
                ringElem = (RingElem)ringElem.negate();
            } else {
                stringBuffer.append(" + ");
            }
            if (!ringElem.isONE()) {
                stringBuffer.append(ringElem.toScript() + "*");
            }
            stringBuffer.append("pg" + n);
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    @Override
    public String toScriptFactory() {
        return ((ProductRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(Product<C> product) {
        if (!this.ring.equals(product.ring)) {
            logger.info("other ring " + product.ring);
            throw new IllegalArgumentException("rings not comparable " + this);
        }
        SortedMap<Integer, C> sortedMap = product.val;
        Iterator<Map.Entry<Integer, C>> iterator = this.val.entrySet().iterator();
        Iterator<Map.Entry<Integer, C>> iterator2 = sortedMap.entrySet().iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Map.Entry<Integer, C> entry = iterator.next();
            Map.Entry<Integer, C> entry2 = iterator2.next();
            int n = entry.getKey().compareTo(entry2.getKey());
            if (n != 0) {
                return n;
            }
            n = ((RingElem)entry.getValue()).compareTo((Element)entry2.getValue());
            if (n == 0) continue;
            return n;
        }
        if (iterator.hasNext()) {
            return -1;
        }
        if (iterator2.hasNext()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Product)) {
            return false;
        }
        Product product = (Product)object;
        return 0 == this.compareTo(product);
    }

    @Override
    public int hashCode() {
        int n = this.ring.hashCode();
        n = 37 * n + this.val.hashCode();
        return n;
    }

    public Product<C> extend(int n, int n2) {
        RingFactory<RingElem> ringFactory = this.ring.getFactory(n2);
        TreeMap<Integer, C> treeMap = new TreeMap<Integer, C>(this.val);
        RingElem ringElem = (RingElem)this.val.get(n);
        RingElem ringElem2 = ringFactory.copy(ringElem);
        if (!ringElem2.isZERO()) {
            treeMap.put(n2, ringElem2);
        }
        return new Product<C>(this.ring, treeMap, this.isunit);
    }

    @Override
    public Product<C> abs() {
        TreeMap<Integer, RingElem> treeMap = new TreeMap<Integer, RingElem>();
        for (Map.Entry<Integer, C> entry : this.val.entrySet()) {
            Integer n = entry.getKey();
            RingElem ringElem = (RingElem)((RingElem)entry.getValue()).abs();
            treeMap.put(n, ringElem);
        }
        return new Product<C>(this.ring, treeMap, this.isunit);
    }

    @Override
    public Product<C> sum(Product<C> product) {
        if (product == null || product.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return product;
        }
        TreeMap<Integer, C> treeMap = new TreeMap<Integer, C>(this.val);
        SortedMap<Integer, C> sortedMap = product.val;
        for (Map.Entry<Integer, C> entry : sortedMap.entrySet()) {
            Integer n = entry.getKey();
            RingElem ringElem = (RingElem)treeMap.get(n);
            RingElem ringElem2 = (RingElem)entry.getValue();
            if (ringElem != null) {
                if (!(ringElem = ringElem.sum(ringElem2)).isZERO()) {
                    treeMap.put(n, ringElem);
                    continue;
                }
                treeMap.remove(n);
                continue;
            }
            treeMap.put(n, ringElem2);
        }
        return new Product<C>(this.ring, treeMap);
    }

    @Override
    public Product<C> negate() {
        TreeMap<Integer, RingElem> treeMap = new TreeMap<Integer, RingElem>();
        for (Map.Entry<Integer, C> entry : this.val.entrySet()) {
            Integer n = entry.getKey();
            RingElem ringElem = (RingElem)((RingElem)entry.getValue()).negate();
            treeMap.put(n, ringElem);
        }
        return new Product<C>(this.ring, treeMap, this.isunit);
    }

    @Override
    public int signum() {
        if (this.val.size() == 0) {
            return 0;
        }
        RingElem ringElem = (RingElem)this.val.get(this.val.firstKey());
        return ringElem.signum();
    }

    @Override
    public Product<C> subtract(Product<C> product) {
        return this.sum((Product<C>)product.negate());
    }

    @Override
    public Product<C> inverse() {
        if (this.isZERO()) {
            return this;
        }
        int n = 0;
        TreeMap<Integer, RingElem> treeMap = new TreeMap<Integer, RingElem>();
        for (Map.Entry<Integer, C> entry : this.val.entrySet()) {
            Integer n2 = entry.getKey();
            RingElem ringElem = (RingElem)entry.getValue();
            try {
                ringElem = (RingElem)ringElem.inverse();
            }
            catch (NotInvertibleException notInvertibleException) {
                ringElem = null;
            }
            if (ringElem == null || ringElem.isZERO()) continue;
            treeMap.put(n2, ringElem);
            n = 1;
        }
        return new Product<C>(this.ring, treeMap, n);
    }

    @Override
    public Product<C> idempotent() {
        if (this.isZERO()) {
            return this;
        }
        TreeMap<Integer, RingElem> treeMap = new TreeMap<Integer, RingElem>();
        for (Integer n : this.val.keySet()) {
            RingFactory<C> ringFactory = this.ring.getFactory(n);
            RingElem ringElem = (RingElem)ringFactory.getONE();
            treeMap.put(n, ringElem);
        }
        return new Product<C>(this.ring, treeMap, 1);
    }

    @Override
    public Product<C> idemComplement() {
        if (this.isZERO()) {
            return this.ring.getONE();
        }
        int n = 0;
        TreeMap<Integer, RingElem> treeMap = new TreeMap<Integer, RingElem>();
        for (int i = 0; i < this.ring.length(); ++i) {
            RingElem ringElem = (RingElem)this.val.get(i);
            if (ringElem != null) continue;
            RingFactory<C> ringFactory = this.ring.getFactory(i);
            RingElem ringElem2 = (RingElem)ringFactory.getONE();
            treeMap.put(i, ringElem2);
            n = 1;
        }
        return new Product<C>(this.ring, treeMap, n);
    }

    @Override
    public Product<C> idempotentAnd(Product<C> product) {
        if (this.isZERO() && product.isZERO()) {
            return this;
        }
        int n = 0;
        TreeMap<Integer, RingElem> treeMap = new TreeMap<Integer, RingElem>();
        for (int i = 0; i < this.ring.length(); ++i) {
            RingElem ringElem = (RingElem)this.val.get(i);
            RingElem ringElem2 = (RingElem)product.val.get(i);
            if (ringElem == null || ringElem2 == null) continue;
            RingFactory<C> ringFactory = this.ring.getFactory(i);
            RingElem ringElem3 = (RingElem)ringFactory.getONE();
            treeMap.put(i, ringElem3);
            n = 1;
        }
        return new Product<C>(this.ring, treeMap, n);
    }

    @Override
    public Product<C> idempotentOr(Product<C> product) {
        if (this.isZERO() && product.isZERO()) {
            return this;
        }
        int n = 0;
        TreeMap<Integer, RingElem> treeMap = new TreeMap<Integer, RingElem>();
        for (int i = 0; i < this.ring.length(); ++i) {
            RingElem ringElem = (RingElem)this.val.get(i);
            RingElem ringElem2 = (RingElem)product.val.get(i);
            if (ringElem == null && ringElem2 == null) continue;
            RingFactory<C> ringFactory = this.ring.getFactory(i);
            RingElem ringElem3 = (RingElem)ringFactory.getONE();
            treeMap.put(i, ringElem3);
            n = 1;
        }
        return new Product<C>(this.ring, treeMap, n);
    }

    @Override
    public Product<C> fillIdempotent(Product<C> product) {
        if (product.isZERO()) {
            return this;
        }
        TreeMap<Integer, C> treeMap = new TreeMap<Integer, C>(this.val);
        for (int i = 0; i < this.ring.length(); ++i) {
            RingElem ringElem;
            RingElem ringElem2 = (RingElem)treeMap.get(i);
            if (ringElem2 != null || (ringElem = (RingElem)product.val.get(i)) == null) continue;
            RingFactory<C> ringFactory = this.ring.getFactory(i);
            RingElem ringElem3 = (RingElem)ringFactory.getONE();
            treeMap.put(i, ringElem3);
        }
        return new Product<C>(this.ring, treeMap, this.isunit);
    }

    @Override
    public Product<C> fillOne() {
        if (this.isFull()) {
            return this;
        }
        if (this.isZERO()) {
            return this.ring.getONE();
        }
        TreeMap<Integer, C> treeMap = new TreeMap<Integer, C>(this.val);
        for (int i = 0; i < this.ring.length(); ++i) {
            RingElem ringElem = (RingElem)treeMap.get(i);
            if (ringElem != null) continue;
            RingFactory<C> ringFactory = this.ring.getFactory(i);
            RingElem ringElem2 = (RingElem)ringFactory.getONE();
            treeMap.put(i, ringElem2);
        }
        return new Product<C>(this.ring, treeMap, this.isunit);
    }

    @Override
    public Product<C> divide(Product<C> product) {
        if (product == null) {
            return this.ring.getZERO();
        }
        if (product.isZERO()) {
            return product;
        }
        if (this.isZERO()) {
            return this;
        }
        TreeMap<Integer, RingElem> treeMap = new TreeMap<Integer, RingElem>();
        SortedMap<Integer, C> sortedMap = product.val;
        for (Map.Entry<Integer, C> entry : this.val.entrySet()) {
            Integer n = entry.getKey();
            RingElem ringElem = (RingElem)sortedMap.get(n);
            if (ringElem == null) continue;
            RingElem ringElem2 = (RingElem)entry.getValue();
            try {
                ringElem2 = ringElem2.divide(ringElem);
            }
            catch (NotInvertibleException notInvertibleException) {
                System.out.println("product divide error: x = " + ringElem2 + ", y = " + ringElem);
                ringElem2 = null;
            }
            if (ringElem2 == null || ringElem2.isZERO()) continue;
            treeMap.put(n, ringElem2);
        }
        return new Product<C>(this.ring, treeMap);
    }

    @Override
    public Product<C> remainder(Product<C> product) {
        if (product == null) {
            return this;
        }
        if (product.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        TreeMap<Integer, RingElem> treeMap = new TreeMap<Integer, RingElem>();
        SortedMap<Integer, C> sortedMap = product.val;
        for (Map.Entry<Integer, C> entry : this.val.entrySet()) {
            Integer n = entry.getKey();
            RingElem ringElem = (RingElem)sortedMap.get(n);
            if (ringElem == null) continue;
            RingElem ringElem2 = (RingElem)entry.getValue();
            if ((ringElem2 = ringElem2.remainder(ringElem)) == null || ringElem2.isZERO()) continue;
            treeMap.put(n, ringElem2);
        }
        return new Product<C>(this.ring, treeMap);
    }

    public Product<C>[] quotientRemainder(Product<C> product) {
        return new Product[]{this.divide(product), this.remainder(product)};
    }

    @Override
    public Product<C> multiply(Product<C> product) {
        if (product == null) {
            return this.ring.getZERO();
        }
        if (product.isZERO()) {
            return product;
        }
        if (this.isZERO()) {
            return this;
        }
        TreeMap<Integer, RingElem> treeMap = new TreeMap<Integer, RingElem>();
        SortedMap<Integer, C> sortedMap = product.val;
        for (Map.Entry<Integer, C> entry : this.val.entrySet()) {
            Integer n = entry.getKey();
            RingElem ringElem = (RingElem)sortedMap.get(n);
            if (ringElem == null) continue;
            RingElem ringElem2 = (RingElem)entry.getValue();
            if ((ringElem2 = ringElem2.multiply(ringElem)) == null || ringElem2.isZERO()) continue;
            treeMap.put(n, ringElem2);
        }
        return new Product<C>(this.ring, treeMap);
    }

    @Override
    public Product<C> multiply(C c) {
        TreeMap<Integer, RingElem> treeMap = new TreeMap<Integer, RingElem>();
        for (Map.Entry<Integer, C> entry : this.val.entrySet()) {
            Integer n = entry.getKey();
            RingElem ringElem = (RingElem)((RingElem)entry.getValue()).multiply(c);
            if (ringElem == null || ringElem.isZERO()) continue;
            treeMap.put(n, ringElem);
        }
        return new Product<C>(this.ring, treeMap);
    }

    @Override
    public Product<C> gcd(Product<C> product) {
        if (product == null || product.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return product;
        }
        TreeMap<Integer, C> treeMap = new TreeMap<Integer, C>(this.val);
        SortedMap<Integer, C> sortedMap = product.val;
        for (Map.Entry<Integer, C> entry : sortedMap.entrySet()) {
            Integer n = entry.getKey();
            RingElem ringElem = (RingElem)treeMap.get(n);
            RingElem ringElem2 = (RingElem)entry.getValue();
            if (ringElem != null) {
                if ((ringElem = ringElem.gcd(ringElem2)) != null && !ringElem.isZERO()) {
                    treeMap.put(n, ringElem);
                    continue;
                }
                treeMap.remove(n);
                continue;
            }
            treeMap.put(n, ringElem2);
        }
        return new Product<C>(this.ring, treeMap);
    }

    public Product<C>[] egcd(Product<C> product) {
        Product[] productArray = new Product[]{null, null, null};
        if (product == null || product.isZERO()) {
            productArray[0] = this;
            return productArray;
        }
        if (this.isZERO()) {
            productArray[0] = product;
            return productArray;
        }
        TreeMap<Integer, C> treeMap = new TreeMap<Integer, C>(this.val);
        SortedMap<Integer, C> sortedMap = ((Product)this.idempotent()).val;
        TreeMap treeMap2 = new TreeMap();
        SortedMap<Integer, C> sortedMap2 = product.val;
        for (Map.Entry<Integer, C> entry : sortedMap2.entrySet()) {
            Integer n = entry.getKey();
            RingElem ringElem = (RingElem)treeMap.get(n);
            RingElem ringElem2 = (RingElem)entry.getValue();
            if (ringElem != null) {
                RingElem[] ringElemArray = ringElem.egcd(ringElem2);
                if (!ringElemArray[0].isZERO()) {
                    treeMap.put(n, ringElemArray[0]);
                    sortedMap.put(n, ringElemArray[1]);
                    treeMap2.put(n, ringElemArray[2]);
                    continue;
                }
                treeMap.remove(n);
                continue;
            }
            treeMap.put(n, ringElem2);
            treeMap2.put(n, this.ring.getFactory(n).getONE());
        }
        productArray[0] = new Product<C>(this.ring, treeMap);
        productArray[1] = new Product<C>(this.ring, sortedMap);
        productArray[2] = new Product<C>(this.ring, treeMap2);
        return productArray;
    }
}

