/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.CriticalPair;
import edu.jas.gb.GBSPTransportMessEnd;
import edu.jas.gb.GBSPTransportMessPair;
import edu.jas.gb.GBSPTransportMessPairIndex;
import edu.jas.gb.GBSPTransportMessPoly;
import edu.jas.gb.GBSPTransportMessReq;
import edu.jas.gb.ReductionPar;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.DistHashTable;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ReducerClientSeqPair<C extends RingElem<C>>
implements Runnable {
    private final SocketChannel pairChannel;
    private final DistHashTable<Integer, GenPolynomial<C>> theList;
    private final ReductionPar<C> red;
    private static final Logger logger = LogManager.getLogger(ReducerClientSeqPair.class);

    ReducerClientSeqPair(SocketChannel socketChannel, DistHashTable<Integer, GenPolynomial<C>> distHashTable) {
        this.pairChannel = socketChannel;
        this.theList = distHashTable;
        this.red = new ReductionPar();
    }

    @Override
    public void run() {
        if (logger.isDebugEnabled()) {
            logger.debug("pairChannel = " + this.pairChannel + "reducer client running");
        }
        CriticalPair criticalPair = null;
        GenPolynomial genPolynomial = null;
        boolean bl = true;
        int n = 0;
        while (bl) {
            GBSPTransportMessReq gBSPTransportMessReq = new GBSPTransportMessReq();
            if (logger.isDebugEnabled()) {
                logger.debug("send request = " + gBSPTransportMessReq);
            }
            try {
                this.pairChannel.send(gBSPTransportMessReq);
            }
            catch (IOException iOException) {
                bl = false;
                iOException.printStackTrace();
                break;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("receive pair, goon = " + bl);
            }
            Object object = null;
            try {
                object = this.pairChannel.receive();
            }
            catch (IOException iOException) {
                bl = false;
                if (!logger.isDebugEnabled()) break;
                iOException.printStackTrace();
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                bl = false;
                classNotFoundException.printStackTrace();
            }
            if (logger.isDebugEnabled()) {
                logger.info("received pair = " + object);
            }
            genPolynomial = null;
            if (object == null) continue;
            if (object instanceof GBSPTransportMessEnd) {
                bl = false;
                continue;
            }
            if (object instanceof GBSPTransportMessPair || object instanceof GBSPTransportMessPairIndex) {
                GenPolynomial<C> genPolynomial2 = null;
                GenPolynomial<C> genPolynomial3 = null;
                if (object instanceof GBSPTransportMessPair && (criticalPair = ((GBSPTransportMessPair)object).pair) != null) {
                    genPolynomial3 = criticalPair.pi;
                    genPolynomial2 = criticalPair.pj;
                }
                if (object instanceof GBSPTransportMessPairIndex) {
                    Integer n2 = ((GBSPTransportMessPairIndex)object).i;
                    Integer n3 = ((GBSPTransportMessPairIndex)object).j;
                    genPolynomial3 = this.theList.getWait(n2);
                    genPolynomial2 = this.theList.getWait(n3);
                }
                if (logger.isDebugEnabled()) {
                    logger.info("pi = " + genPolynomial3.leadingExpVector() + ", pj = " + genPolynomial2.leadingExpVector());
                }
                if (genPolynomial3 != null && genPolynomial2 != null) {
                    GenPolynomial genPolynomial4 = this.red.SPolynomial(genPolynomial3, genPolynomial2);
                    if (genPolynomial4.isZERO()) {
                        genPolynomial = genPolynomial4;
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug("ht(S) = " + genPolynomial4.leadingExpVector());
                        }
                        genPolynomial = this.red.normalform(this.theList, genPolynomial4);
                        ++n;
                        if (!genPolynomial.isZERO()) {
                            genPolynomial = genPolynomial.monic();
                            if (logger.isDebugEnabled()) {
                                logger.info("ht(H) = " + genPolynomial.leadingExpVector());
                            }
                        }
                    }
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("invalid message = " + object);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            if (logger.isDebugEnabled()) {
                logger.info("send H polynomial = " + genPolynomial);
            }
            try {
                this.pairChannel.send(new GBSPTransportMessPoly(genPolynomial));
            }
            catch (IOException iOException) {
                bl = false;
                iOException.printStackTrace();
                break;
            }
        }
        logger.info("terminated, done " + n + " reductions");
        this.pairChannel.close();
    }
}

