/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gbufd.MultiplicativeSet;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultiplicativeSetFactors<C extends GcdRingElem<C>>
extends MultiplicativeSet<C> {
    private static final Logger logger = LogManager.getLogger(MultiplicativeSetFactors.class);
    protected final FactorAbstract<C> engine;

    public MultiplicativeSetFactors(GenPolynomialRing<C> genPolynomialRing) {
        super(genPolynomialRing);
        this.engine = FactorFactory.getImplementation(genPolynomialRing.coFac);
    }

    protected MultiplicativeSetFactors(GenPolynomialRing<C> genPolynomialRing, List<GenPolynomial<C>> list, FactorAbstract<C> factorAbstract) {
        super(genPolynomialRing, list);
        this.engine = factorAbstract;
    }

    @Override
    public String toString() {
        return "MultiplicativeSetFactors" + this.mset;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof MultiplicativeSetFactors)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public MultiplicativeSetFactors<C> add(GenPolynomial<C> genPolynomial) {
        GenPolynomial<C> genPolynomial2;
        if (genPolynomial == null || genPolynomial.isZERO() || genPolynomial.isConstant()) {
            return this;
        }
        if (this.ring.coFac.isField()) {
            genPolynomial = genPolynomial.monic();
        }
        if ((genPolynomial2 = this.removeFactors(genPolynomial)).isConstant()) {
            logger.info("skipped unit or constant = " + genPolynomial2);
            return this;
        }
        List<GenPolynomial<C>> list = this.engine.factorsRadical(genPolynomial2);
        logger.info("factorsRadical = " + list);
        if (this.ring.coFac.isField()) {
            list = PolyUtil.monic(list);
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(this.mset);
        for (GenPolynomial<C> genPolynomial3 : list) {
            if (genPolynomial3.isConstant() || genPolynomial3.isZERO() || this.mset.contains(genPolynomial3)) continue;
            logger.info("added to irreducible mset = " + genPolynomial3);
            arrayList.add(genPolynomial3);
        }
        return new MultiplicativeSetFactors<C>(this.ring, arrayList, this.engine);
    }

    @Override
    public MultiplicativeSetFactors<C> replace(List<GenPolynomial<C>> list) {
        MultiplicativeSet multiplicativeSet = new MultiplicativeSetFactors<C>(this.ring);
        if (list == null || list.size() == 0) {
            return multiplicativeSet;
        }
        for (GenPolynomial<C> genPolynomial : list) {
            multiplicativeSet = multiplicativeSet.add((GenPolynomial)genPolynomial);
        }
        return multiplicativeSet;
    }
}

