/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.gb.SGBProxy;
import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.gbufd.SGBFactory;
import edu.jas.gbufd.SolvableGroebnerBasePseudoRecSeq;
import edu.jas.gbufd.SolvableGroebnerBasePseudoSeq;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.MonoidElem;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SGBFactoryTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    GenSolvablePolynomialRing<BigInteger> dfac;
    GenSolvablePolynomialRing<BigInteger> cfac;
    GenSolvablePolynomialRing<GenPolynomial<BigInteger>> rfac;
    BigInteger ai;
    BigInteger bi;
    BigInteger ci;
    BigInteger di;
    BigInteger ei;
    GenSolvablePolynomial<BigInteger> a;
    GenSolvablePolynomial<BigInteger> b;
    GenSolvablePolynomial<BigInteger> c;
    GenSolvablePolynomial<BigInteger> d;
    GenSolvablePolynomial<BigInteger> e;
    GenSolvablePolynomial<GenPolynomial<BigInteger>> ar;
    GenSolvablePolynomial<GenPolynomial<BigInteger>> br;
    GenSolvablePolynomial<GenPolynomial<BigInteger>> cr;
    GenSolvablePolynomial<GenPolynomial<BigInteger>> dr;
    GenSolvablePolynomial<GenPolynomial<BigInteger>> er;
    int rl = 5;
    int kl = 4;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SGBFactoryTest.suite());
        ComputerThreads.terminate();
    }

    public SGBFactoryTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SGBFactoryTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.dfac = new GenSolvablePolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to);
        this.cfac = new GenSolvablePolynomialRing<BigInteger>(new BigInteger(1L), this.rl - 1, this.to);
        this.rfac = new GenSolvablePolynomialRing<BigInteger>(this.cfac, 1, this.to);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
    }

    public void testBigInteger() {
        BigInteger bigInteger = new BigInteger();
        SolvableGroebnerBaseAbstract<BigInteger> solvableGroebnerBaseAbstract = SGBFactory.getImplementation(bigInteger);
        SGBFactoryTest.assertTrue((String)("bba integer " + solvableGroebnerBaseAbstract), (boolean)(solvableGroebnerBaseAbstract instanceof SolvableGroebnerBasePseudoSeq));
    }

    public void testModInteger() {
        ModIntegerRing modIntegerRing = new ModIntegerRing(19L, true);
        SolvableGroebnerBaseAbstract<ModInteger> solvableGroebnerBaseAbstract = SGBFactory.getImplementation(modIntegerRing);
        SGBFactoryTest.assertTrue((String)("bba modular field " + solvableGroebnerBaseAbstract), (boolean)(solvableGroebnerBaseAbstract instanceof SolvableGroebnerBaseSeq));
        modIntegerRing = new ModIntegerRing(30L);
        solvableGroebnerBaseAbstract = SGBFactory.getImplementation(modIntegerRing);
        SGBFactoryTest.assertTrue((String)("bba modular ring " + solvableGroebnerBaseAbstract), (boolean)(solvableGroebnerBaseAbstract instanceof SolvableGroebnerBasePseudoSeq));
    }

    public void testBigRational() {
        BigRational bigRational = new BigRational();
        SolvableGroebnerBaseAbstract<BigRational> solvableGroebnerBaseAbstract = SGBFactory.getImplementation(bigRational);
        SGBFactoryTest.assertTrue((String)("bba field " + solvableGroebnerBaseAbstract), (boolean)(solvableGroebnerBaseAbstract instanceof SolvableGroebnerBaseSeq));
    }

    public void testBigComplex() {
        BigComplex bigComplex = new BigComplex();
        SolvableGroebnerBaseAbstract<BigComplex> solvableGroebnerBaseAbstract = SGBFactory.getImplementation(bigComplex);
        SGBFactoryTest.assertTrue((String)("bba field " + solvableGroebnerBaseAbstract), (boolean)(solvableGroebnerBaseAbstract instanceof SolvableGroebnerBaseSeq));
    }

    public void testAlgebraicNumberBigRational() {
        BigRational bigRational = new BigRational();
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 1);
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        while (genPolynomial.isZERO() || genPolynomial.isONE() || genPolynomial.isConstant()) {
            genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        }
        AlgebraicNumberRing<BigRational> algebraicNumberRing = new AlgebraicNumberRing<BigRational>(genPolynomial);
        SolvableGroebnerBaseAbstract<BigRational> solvableGroebnerBaseAbstract = SGBFactory.getImplementation(algebraicNumberRing);
        SGBFactoryTest.assertTrue((String)("bba algebraic ring " + solvableGroebnerBaseAbstract), (boolean)(solvableGroebnerBaseAbstract instanceof SolvableGroebnerBasePseudoSeq));
        genPolynomial = genPolynomialRing.univariate(0).subtract((BigRational)genPolynomialRing.getONE());
        algebraicNumberRing = new AlgebraicNumberRing<BigRational>(genPolynomial, true);
        solvableGroebnerBaseAbstract = SGBFactory.getImplementation(algebraicNumberRing);
        SGBFactoryTest.assertTrue((String)("bba algebraic field " + solvableGroebnerBaseAbstract), (boolean)(solvableGroebnerBaseAbstract instanceof SolvableGroebnerBaseSeq));
    }

    public void testAlgebraicNumberModInteger() {
        ModIntegerRing modIntegerRing = new ModIntegerRing(19L, true);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1);
        GenPolynomial<ModInteger> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        while (genPolynomial.isZERO() || genPolynomial.isONE() || genPolynomial.isConstant()) {
            genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        }
        AlgebraicNumberRing<ModInteger> algebraicNumberRing = new AlgebraicNumberRing<ModInteger>(genPolynomial);
        MonoidElem monoidElem = algebraicNumberRing.getONE();
        SGBFactoryTest.assertTrue((String)("a == 1 " + monoidElem), (boolean)((AlgebraicNumber)monoidElem).isONE());
        SolvableGroebnerBaseAbstract<ModInteger> solvableGroebnerBaseAbstract = SGBFactory.getImplementation(algebraicNumberRing);
        SGBFactoryTest.assertTrue((String)("bba algebraic ring " + solvableGroebnerBaseAbstract), (boolean)(solvableGroebnerBaseAbstract instanceof SolvableGroebnerBasePseudoSeq));
    }

    public void testGenPolynomial() {
        GenPolynomialRing<BigRational> genPolynomialRing;
        BigRational bigRational = new BigRational();
        GenPolynomialRing<BigRational> genPolynomialRing2 = genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.to);
        SolvableGroebnerBaseAbstract<GenPolynomial<BigRational>> solvableGroebnerBaseAbstract = SGBFactory.getImplementation(genPolynomialRing);
        SGBFactoryTest.assertTrue((String)("bba recursive polynomial " + solvableGroebnerBaseAbstract), (boolean)(solvableGroebnerBaseAbstract instanceof SolvableGroebnerBasePseudoRecSeq));
        SolvableGroebnerBaseAbstract<BigRational> solvableGroebnerBaseAbstract2 = SGBFactory.getImplementation(genPolynomialRing2);
        SGBFactoryTest.assertTrue((String)("bba recursive polynomial " + solvableGroebnerBaseAbstract2), (boolean)(solvableGroebnerBaseAbstract2 instanceof SolvableGroebnerBasePseudoRecSeq));
    }

    public void testProxy() {
        BigRational bigRational = new BigRational();
        SolvableGroebnerBaseAbstract<BigRational> solvableGroebnerBaseAbstract = SGBFactory.getProxy(bigRational);
        SGBFactoryTest.assertTrue((String)("bba field " + solvableGroebnerBaseAbstract), (boolean)(solvableGroebnerBaseAbstract instanceof SGBProxy));
        solvableGroebnerBaseAbstract.terminate();
        ModIntegerRing modIntegerRing = new ModIntegerRing(6L);
        SolvableGroebnerBaseAbstract<ModInteger> solvableGroebnerBaseAbstract2 = SGBFactory.getProxy(modIntegerRing);
        SGBFactoryTest.assertTrue((String)("bbm ! field " + solvableGroebnerBaseAbstract2), (!(solvableGroebnerBaseAbstract2 instanceof SGBProxy) ? 1 : 0) != 0);
        solvableGroebnerBaseAbstract2.terminate();
    }
}

