/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.Scripting;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.OrderedModuleList;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import edu.jas.vector.GenVector;
import edu.jas.vector.GenVectorModul;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModuleList<C extends RingElem<C>>
implements Serializable {
    public final GenPolynomialRing<C> ring;
    public final List<List<GenPolynomial<C>>> list;
    public final int rows;
    public final int cols;
    private static final Logger logger = LogManager.getLogger(ModuleList.class);

    public ModuleList(GenPolynomialRing<C> genPolynomialRing, List<List<GenPolynomial<C>>> list) {
        this.ring = genPolynomialRing;
        this.list = ModuleList.padCols(genPolynomialRing, list);
        if (this.list == null) {
            this.rows = -1;
            this.cols = -1;
        } else {
            this.rows = this.list.size();
            this.cols = this.rows > 0 ? this.list.get(0).size() : -1;
        }
    }

    public ModuleList(GenSolvablePolynomialRing<C> genSolvablePolynomialRing, List<List<GenSolvablePolynomial<C>>> list) {
        this((GenPolynomialRing<C>)genSolvablePolynomialRing, ModuleList.castToList(list));
    }

    public ModuleList(GenVectorModul<GenPolynomial<C>> genVectorModul, List<GenVector<GenPolynomial<C>>> list) {
        this((GenPolynomialRing)genVectorModul.coFac, ModuleList.vecToList(list));
    }

    public boolean equals(Object object) {
        List<List<GenPolynomial<C>>> list;
        if (object == null) {
            return false;
        }
        if (!(object instanceof ModuleList)) {
            return false;
        }
        ModuleList moduleList = (ModuleList)object;
        if (!this.ring.equals(moduleList.ring)) {
            return false;
        }
        if (this.list == moduleList.list) {
            return true;
        }
        if (this.list == null || moduleList.list == null) {
            return false;
        }
        if (this.list.size() != moduleList.list.size()) {
            return false;
        }
        List<List<GenPolynomial<C>>> list2 = OrderedModuleList.sort(this.ring, this.list);
        return list2.equals(list = OrderedModuleList.sort(this.ring, moduleList.list));
    }

    public int hashCode() {
        int n = this.ring.hashCode();
        n = 37 * n + (this.list == null ? 0 : this.list.hashCode());
        return n;
    }

    public boolean isEmpty() {
        if (this.list == null) {
            return true;
        }
        return this.rows <= 0;
    }

    public boolean isZERO() {
        if (this.list == null) {
            return true;
        }
        if (this.rows <= 0) {
            return true;
        }
        for (List<GenPolynomial<C>> list : this.list) {
            for (GenPolynomial<C> genPolynomial : list) {
                if (genPolynomial.isZERO()) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = null;
        if (this.ring != null) {
            stringBuffer.append(this.ring.toString());
            stringArray = this.ring.getVars();
        }
        if (this.list == null) {
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
        boolean bl = true;
        stringBuffer.append("(\n");
        for (List<GenPolynomial<C>> list : this.list) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",\n");
            }
            boolean bl2 = true;
            stringBuffer.append(" ( ");
            for (GenPolynomial<C> genPolynomial : list) {
                String string = genPolynomial == null ? "0" : (stringArray != null ? genPolynomial.toString(stringArray) : genPolynomial.toString());
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuffer.append(", ");
                    if (string.length() > 100) {
                        stringBuffer.append("\n");
                    }
                }
                stringBuffer.append(string);
            }
            stringBuffer.append(" )");
        }
        stringBuffer.append("\n)");
        return stringBuffer.toString();
    }

    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.ring instanceof GenSolvablePolynomialRing) {
            stringBuffer.append("Solvable");
        }
        switch (Scripting.getLang()) {
            case Ruby: {
                stringBuffer.append("SubModule.new(");
                break;
            }
            default: {
                stringBuffer.append("SubModule(");
            }
        }
        if (this.ring != null) {
            stringBuffer.append(this.ring.toScript());
        }
        if (this.list == null) {
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
        switch (Scripting.getLang()) {
            case Ruby: {
                stringBuffer.append(",\"\",[");
                break;
            }
            default: {
                stringBuffer.append(",list=[");
            }
        }
        boolean bl = true;
        for (List<GenPolynomial<C>> list : this.list) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            boolean bl2 = true;
            stringBuffer.append(" ( ");
            for (GenPolynomial<C> genPolynomial : list) {
                String string = genPolynomial == null ? "0" : genPolynomial.toScript();
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(string);
            }
            stringBuffer.append(" )");
        }
        stringBuffer.append(" ])");
        return stringBuffer.toString();
    }

    public static <C extends RingElem<C>> List<List<GenPolynomial<C>>> padCols(GenPolynomialRing<C> genPolynomialRing, List<List<GenPolynomial<C>>> list) {
        if (list == null) {
            return list;
        }
        int n = 0;
        int n2 = 0;
        for (List<GenPolynomial<C>> list2 : list) {
            if (list2 == null) continue;
            ++n2;
            if (list2.size() <= n) continue;
            n = list2.size();
        }
        ArrayList arrayList = new ArrayList(n2);
        for (List list3 : list) {
            if (list3 == null) continue;
            ArrayList<AbelianGroupElem> arrayList2 = new ArrayList<AbelianGroupElem>(list3);
            while (arrayList2.size() < n) {
                arrayList2.add(genPolynomialRing.getZERO());
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public PolynomialList<C> getPolynomialList() {
        return this.getPolynomialList(false);
    }

    public PolynomialList<C> getPolynomialList(boolean bl) {
        GenPolynomialRing<C> genPolynomialRing = this.ring.extend(this.cols, bl);
        logger.debug("extended ring = " + genPolynomialRing);
        return this.getPolynomialList(genPolynomialRing);
    }

    public PolynomialList<C> getPolynomialList(GenPolynomialRing<C> genPolynomialRing) {
        ArrayList arrayList = null;
        if (this.list == null) {
            return new PolynomialList<C>(genPolynomialRing, arrayList);
        }
        arrayList = new ArrayList(this.rows);
        if (this.rows == 0) {
            return new PolynomialList<C>(genPolynomialRing, arrayList);
        }
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial = genPolynomialRing.getZERO();
        GenPolynomial<C> genPolynomial2 = null;
        for (List<GenPolynomial<C>> list : this.list) {
            GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial3 = genPolynomial;
            int n = 0;
            for (GenPolynomial<C> genPolynomial4 : list) {
                genPolynomial2 = genPolynomial4.extend(genPolynomialRing, n, 1L);
                genPolynomial3 = genPolynomial3.sum((GenPolynomial<GenPolynomial<C>>)genPolynomial2);
                ++n;
            }
            arrayList.add(genPolynomial3);
        }
        return new PolynomialList<C>(genPolynomialRing, arrayList);
    }

    public List<List<GenSolvablePolynomial<C>>> castToSolvableList() {
        ArrayList<List<GenSolvablePolynomial<C>>> arrayList = null;
        if (this.list == null) {
            return arrayList;
        }
        arrayList = new ArrayList<List<GenSolvablePolynomial<C>>>(this.list.size());
        for (List<GenPolynomial<C>> list : this.list) {
            ArrayList<GenSolvablePolynomial> arrayList2 = new ArrayList<GenSolvablePolynomial>(list.size());
            for (GenPolynomial<C> genPolynomial : list) {
                if (!(genPolynomial instanceof GenSolvablePolynomial)) {
                    throw new RuntimeException("no solvable polynomial " + genPolynomial);
                }
                GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)genPolynomial;
                arrayList2.add(genSolvablePolynomial);
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public static <C extends RingElem<C>> List<List<GenPolynomial<C>>> castToList(List<List<GenSolvablePolynomial<C>>> list) {
        ArrayList<List<GenPolynomial<C>>> arrayList = null;
        if (list == null) {
            return arrayList;
        }
        arrayList = new ArrayList<List<GenPolynomial<C>>>(list.size());
        for (List<GenSolvablePolynomial<C>> list2 : list) {
            ArrayList<GenSolvablePolynomial<C>> arrayList2 = new ArrayList<GenSolvablePolynomial<C>>(list2.size());
            for (GenSolvablePolynomial<C> genSolvablePolynomial : list2) {
                arrayList2.add(genSolvablePolynomial);
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public static <C extends RingElem<C>> List<List<GenPolynomial<C>>> vecToList(List<GenVector<GenPolynomial<C>>> list) {
        ArrayList<List<GenPolynomial<C>>> arrayList = null;
        if (list == null) {
            return arrayList;
        }
        arrayList = new ArrayList<List<GenPolynomial<C>>>(list.size());
        for (GenVector<GenPolynomial<C>> genVector : list) {
            List list2 = genVector.val;
            arrayList.add(list2);
        }
        return arrayList;
    }
}

