/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.PrettyPrint;
import edu.jas.poly.ExpVector;
import edu.jas.poly.ExpVectorPair;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.GenWordPolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TableRelation;
import edu.jas.structure.RingElem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RelationTable<C extends RingElem<C>>
implements Serializable {
    public final Map<List<Integer>, List> table = new HashMap<List<Integer>, List>();
    public final GenSolvablePolynomialRing<C> ring;
    public final boolean coeffTable;
    private static final Logger logger = LogManager.getLogger(RelationTable.class);
    private static final boolean debug = logger.isDebugEnabled();

    public RelationTable(GenSolvablePolynomialRing<C> genSolvablePolynomialRing) {
        this(genSolvablePolynomialRing, false);
    }

    public RelationTable(GenSolvablePolynomialRing<C> genSolvablePolynomialRing, boolean bl) {
        this.ring = genSolvablePolynomialRing;
        if (this.ring == null) {
            throw new IllegalArgumentException("RelationTable no ring");
        }
        this.coeffTable = bl;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof RelationTable)) {
            logger.info("no RelationTable");
            return false;
        }
        RelationTable relationTable = (RelationTable)object;
        if (!this.table.keySet().equals(relationTable.table.keySet())) {
            logger.info("keySet != :  a = " + this.table.keySet() + ", b = " + relationTable.table.keySet());
            return false;
        }
        for (Map.Entry<List<Integer>, List> entry : this.table.entrySet()) {
            Map<ExpVectorPair, GenPolynomial<C>> map;
            List<Integer> list = entry.getKey();
            List list2 = entry.getValue();
            List list3 = relationTable.table.get(list);
            Map<ExpVectorPair, GenPolynomial<C>> map2 = this.fromListDeg2(list2);
            if (this.equalMaps(map2, map = this.fromListDeg2(list3))) continue;
            return false;
        }
        return true;
    }

    Map<ExpVectorPair, GenPolynomial<C>> fromListDeg2(List list) {
        HashMap<ExpVectorPair, GenPolynomial<C>> hashMap = new HashMap<ExpVectorPair, GenPolynomial<C>>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ExpVectorPair expVectorPair = (ExpVectorPair)iterator.next();
            if (!iterator.hasNext()) break;
            GenPolynomial genPolynomial = (GenPolynomial)iterator.next();
            if (expVectorPair.totalDeg() != 2L) continue;
            hashMap.put(expVectorPair, genPolynomial);
        }
        return hashMap;
    }

    int fromListDeg2HashCode(List list) {
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ExpVectorPair expVectorPair = (ExpVectorPair)iterator.next();
            n = 31 * n + expVectorPair.hashCode();
            if (!iterator.hasNext()) break;
            GenPolynomial genPolynomial = (GenPolynomial)iterator.next();
            if (expVectorPair.totalDeg() != 2L) continue;
            n = 31 * n + genPolynomial.val.hashCode();
        }
        return n;
    }

    boolean equalMaps(Map<ExpVectorPair, GenPolynomial<C>> map, Map<ExpVectorPair, GenPolynomial<C>> map2) {
        if (!map.keySet().equals(map2.keySet())) {
            return false;
        }
        for (Map.Entry<ExpVectorPair, GenPolynomial<C>> entry : map.entrySet()) {
            ExpVectorPair expVectorPair;
            GenPolynomial<C> genPolynomial;
            GenPolynomial<C> genPolynomial2 = entry.getValue();
            if (genPolynomial2.compareTo(genPolynomial = map2.get(expVectorPair = entry.getKey())) == 0) continue;
            logger.info("ep = " + expVectorPair + ", p1 = " + genPolynomial2 + ", p2 = " + genPolynomial);
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        n = this.table.keySet().hashCode();
        for (Map.Entry<List<Integer>, List> entry : this.table.entrySet()) {
            List list = entry.getValue();
            int n2 = this.fromListDeg2HashCode(list);
            n = 31 * n + n2;
        }
        return n;
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("RelationTable[");
        boolean bl = true;
        for (Map.Entry<List<Integer>, List> entry : this.table.entrySet()) {
            List<Integer> list = entry.getKey();
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(list.toString());
            List list2 = entry.getValue();
            stringBuffer.append("=");
            stringBuffer.append(list2.toString());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toString(String[] stringArray) {
        if (stringArray == null) {
            return this.toString();
        }
        StringBuffer stringBuffer = new StringBuffer("");
        String[] stringArray2 = null;
        if (this.coeffTable) {
            if (this.ring.coFac instanceof GenPolynomialRing) {
                stringArray2 = ((GenPolynomialRing)this.ring.coFac).getVars();
            } else if (this.ring.coFac instanceof GenWordPolynomialRing) {
                stringArray2 = ((GenWordPolynomialRing)this.ring.coFac).getVars();
            }
            stringBuffer.append("Coefficient ");
        }
        stringBuffer.append("RelationTable\n(");
        if (PrettyPrint.isTrue()) {
            boolean bl = true;
            for (Map.Entry<List<Integer>, List> entry : this.table.entrySet()) {
                if (bl) {
                    bl = false;
                    stringBuffer.append("\n");
                } else {
                    stringBuffer.append(",\n");
                }
                List list = entry.getValue();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ExpVectorPair expVectorPair = (ExpVectorPair)iterator.next();
                    GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)iterator.next();
                    if (expVectorPair.totalDeg() != 2L) continue;
                    stringBuffer.append("( " + expVectorPair.getFirst().toString(stringArray) + " ), ");
                    if (stringArray2 == null) {
                        stringBuffer.append("( " + expVectorPair.getSecond().toString(stringArray) + " ), ");
                    } else {
                        stringBuffer.append("( " + expVectorPair.getSecond().toString(stringArray2) + " ), ");
                    }
                    stringBuffer.append("( " + genSolvablePolynomial.toString(stringArray) + " )");
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(",\n");
                }
            }
        } else {
            boolean bl = true;
            for (Map.Entry<List<Integer>, List> entry : this.table.entrySet()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(",\n");
                }
                List list = entry.getValue();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ExpVectorPair expVectorPair = (ExpVectorPair)iterator.next();
                    stringBuffer.append("( " + expVectorPair.getFirst().toString(stringArray) + " ), ");
                    if (stringArray2 == null) {
                        stringBuffer.append("( " + expVectorPair.getSecond().toString(stringArray) + " ), ");
                    } else {
                        stringBuffer.append("( " + expVectorPair.getSecond().toString(stringArray2) + " ), ");
                    }
                    GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)iterator.next();
                    stringBuffer.append(" " + genSolvablePolynomial.toString(stringArray));
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(",\n");
                }
            }
        }
        stringBuffer.append("\n)\n");
        return stringBuffer.toString();
    }

    public String toScript() {
        String[] stringArray = this.ring.vars;
        String[] stringArray2 = null;
        if (this.coeffTable) {
            if (this.ring.coFac instanceof GenPolynomialRing) {
                stringArray2 = ((GenPolynomialRing)this.ring.coFac).getVars();
            } else if (this.ring.coFac instanceof GenWordPolynomialRing) {
                stringArray2 = ((GenWordPolynomialRing)this.ring.coFac).getVars();
            }
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        boolean bl = true;
        for (Map.Entry<List<Integer>, List> entry : this.table.entrySet()) {
            if (bl) {
                bl = false;
                stringBuffer.append("");
            } else {
                stringBuffer.append(", ");
            }
            List list = entry.getValue();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ExpVectorPair expVectorPair = (ExpVectorPair)iterator.next();
                GenPolynomial genPolynomial = (GenPolynomial)iterator.next();
                if (expVectorPair.totalDeg() > 2L) continue;
                stringBuffer.append("" + expVectorPair.getFirst().toScript(stringArray) + ", ");
                if (this.coeffTable) {
                    String string = expVectorPair.getSecond().toScript(stringArray2);
                    if (string.isEmpty()) {
                        string = ((RingElem)genPolynomial.leadingBaseCoefficient().abs()).toScript();
                    }
                    stringBuffer.append("" + string + ", ");
                } else {
                    stringBuffer.append("" + expVectorPair.getSecond().toScript(stringArray) + ", ");
                }
                stringBuffer.append(" " + genPolynomial.toScript());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(ExpVector expVector, ExpVector serializable, GenSolvablePolynomial<C> genSolvablePolynomial) {
        Serializable serializable2;
        Object object;
        Serializable serializable3;
        Object object2;
        Object object3;
        if (genSolvablePolynomial == null || expVector == null || serializable == null) {
            throw new IllegalArgumentException("RelationTable update e|f|p == null");
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = genSolvablePolynomial.ring;
        if (debug) {
            logger.info("new relation = " + genSolvablePolynomialRing.toScript(expVector) + " .*. " + genSolvablePolynomialRing.toScript((ExpVector)serializable) + " = " + genSolvablePolynomial.toScript());
        }
        if (!this.coeffTable) {
            if (expVector.totalDeg() == 1L && serializable.totalDeg() == 1L) {
                object3 = expVector.dependencyOnVariables();
                object2 = serializable.dependencyOnVariables();
                logger.debug("update e ? f " + (int)object3[0] + " " + (int)object2[0]);
                if (object3[0] == object2[0]) {
                    throw new IllegalArgumentException("RelationTable update e==f");
                }
                if (object3[0] > object2[0]) {
                    logger.error("update e < f: " + genSolvablePolynomialRing.toScript(expVector) + " < " + genSolvablePolynomialRing.toScript((ExpVector)serializable));
                    serializable3 = expVector;
                    expVector = serializable;
                    serializable = serializable3;
                    object = genSolvablePolynomial.leadingMonomial();
                    ExpVector expVector2 = expVector.sum((ExpVector)serializable);
                    if (!expVector2.equals(object.getKey())) {
                        throw new IllegalArgumentException("update e*f != lt(p): " + genSolvablePolynomialRing.toScript(expVector2) + ", lt = " + genSolvablePolynomialRing.toScript((ExpVector)object.getKey()));
                    }
                    serializable2 = genSolvablePolynomial.reductum();
                    serializable2 = ((GenPolynomial)serializable2).negate();
                    genSolvablePolynomial = (GenSolvablePolynomial)serializable2;
                    genSolvablePolynomial.doPutToMap((ExpVector)object.getKey(), (RingElem)object.getValue());
                }
            }
            if (!((ExpVector)(object3 = expVector.sum((ExpVector)serializable))).equals(object2 = genSolvablePolynomial.leadingExpVector())) {
                logger.error("relation term order = " + this.ring.tord);
                throw new IllegalArgumentException("update e*f != lt(p): " + genSolvablePolynomialRing.toScript((ExpVector)object3) + " != " + genSolvablePolynomialRing.toScript((ExpVector)object2));
            }
        } else {
            object3 = genSolvablePolynomial.leadingExpVector();
            if (!expVector.equals(object3)) {
                logger.error("relation term order = " + this.ring.tord);
                throw new IllegalArgumentException("Coefficient RelationTable update e != lt(p): " + genSolvablePolynomialRing.toScript(expVector) + " != " + genSolvablePolynomialRing.toScript((ExpVector)object3));
            }
            if (genSolvablePolynomial.leadingBaseCoefficient() instanceof GenPolynomial) {
                object3 = ((GenPolynomial)genSolvablePolynomial.leadingBaseCoefficient()).leadingExpVector();
                if (!serializable.equals(object3)) {
                    logger.error("relation term order = " + this.ring.tord);
                    logger.error("Coefficient RelationTable update f != lt(lfcd(p)): " + genSolvablePolynomialRing.toScript(expVector) + ", f = " + serializable + ", p = " + genSolvablePolynomial.toScript());
                    throw new IllegalArgumentException("Coefficient RelationTable update f != lt(lfcd(p)): " + expVector + ", f = " + serializable + ", p = " + genSolvablePolynomial);
                }
            } else if (genSolvablePolynomial.leadingBaseCoefficient() instanceof GenWordPolynomial && !serializable.equals(object3 = ((GenWordPolynomial)genSolvablePolynomial.leadingBaseCoefficient()).leadingWord().leadingExpVector())) {
                logger.error("relation term order = " + this.ring.tord);
                logger.error("Coefficient RelationTable update f != lt(lfcd(p)): " + genSolvablePolynomialRing.toScript(expVector) + ", f = " + serializable + ", p = " + genSolvablePolynomial.toScript());
                throw new IllegalArgumentException("Coefficient RelationTable update f != lt(lfcd(p)): " + expVector + ", f = " + serializable + ", p = " + genSolvablePolynomial);
            }
        }
        object3 = this.makeKey(expVector, (ExpVector)serializable);
        object2 = new ExpVectorPair(expVector, (ExpVector)serializable);
        if (object3.size() != 2) {
            logger.warn("key = " + object3 + ", evp = " + object2);
        }
        if ((serializable3 = this.table.get(object3)) == null) {
            serializable3 = new LinkedList<Object>();
            serializable3.add(object2);
            serializable3.add(genSolvablePolynomial);
            this.table.put((List<Integer>)object3, (List)((Object)serializable3));
            return;
        }
        int n = -1;
        serializable2 = serializable3;
        synchronized (serializable2) {
            ListIterator listIterator = serializable3.listIterator();
            while (listIterator.hasNext()) {
                ExpVectorPair expVectorPair = (ExpVectorPair)listIterator.next();
                object = listIterator.next();
                if (!expVectorPair.isMultiple((ExpVectorPair)object2)) continue;
                n = listIterator.nextIndex();
            }
            if (n < 0) {
                n = 0;
            }
            serializable3.add(n, object2);
            serializable3.add(n + 1, genSolvablePolynomial);
        }
    }

    public void update(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2, GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (genPolynomial.isZERO() || genPolynomial2.isZERO()) {
            throw new IllegalArgumentException("polynomials may not be zero: " + genPolynomial + ", " + genPolynomial2);
        }
        C c = genPolynomial.leadingBaseCoefficient();
        C c2 = genPolynomial2.leadingBaseCoefficient();
        if (!c.isONE()) {
            throw new IllegalArgumentException("lbcf of polynomials must be one: " + c + ", " + c2 + ", p = " + genSolvablePolynomial);
        }
        ExpVector expVector = genPolynomial.leadingExpVector();
        ExpVector expVector2 = genPolynomial2.leadingExpVector();
        if (this.coeffTable && expVector2.isZERO()) {
            if (c2 instanceof GenPolynomial) {
                expVector2 = ((GenPolynomial)c2).leadingExpVector();
            } else if (c2 instanceof GenWordPolynomial) {
                expVector2 = ((GenWordPolynomial)c2).leadingWord().leadingExpVector();
            }
        }
        this.update(expVector, expVector2, genSolvablePolynomial);
    }

    public void update(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2, GenPolynomial<C> genPolynomial3) {
        if (genPolynomial3.isZERO()) {
            throw new IllegalArgumentException("polynomial may not be zero: " + genPolynomial3);
        }
        if (genPolynomial3.isONE()) {
            throw new IllegalArgumentException("product of polynomials may not be one: " + genPolynomial3);
        }
        GenSolvablePolynomial<C> genSolvablePolynomial = new GenSolvablePolynomial<C>(this.ring, genPolynomial3.val);
        this.update(genPolynomial, genPolynomial2, genSolvablePolynomial);
    }

    public void update(ExpVector expVector, ExpVector expVector2, GenPolynomial<C> genPolynomial) {
        if (genPolynomial.isZERO()) {
            throw new IllegalArgumentException("polynomial may not be zero: " + genPolynomial);
        }
        if (genPolynomial.isONE()) {
            throw new IllegalArgumentException("product of polynomials may not be one: " + genPolynomial);
        }
        GenSolvablePolynomial<C> genSolvablePolynomial = new GenSolvablePolynomial<C>(this.ring, genPolynomial.val);
        this.update(expVector, expVector2, genSolvablePolynomial);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableRelation<C> lookup(ExpVector expVector, ExpVector expVector2) {
        List<Integer> list = this.makeKey(expVector, expVector2);
        List list2 = this.table.get(list);
        if (list2 == null) {
            GenSolvablePolynomial<RingElem> genSolvablePolynomial = null;
            RingElem ringElem = null;
            if (!this.coeffTable) {
                ExpVector expVector3 = expVector.sum(expVector2);
                genSolvablePolynomial = this.ring.valueOf(expVector3);
            } else {
                if (this.ring.coFac instanceof GenPolynomialRing) {
                    GenPolynomialRing genPolynomialRing = (GenPolynomialRing)this.ring.coFac;
                    GenPolynomial genPolynomial = genPolynomialRing.valueOf(expVector2);
                    ringElem = genPolynomial;
                } else if (this.ring.coFac instanceof GenWordPolynomialRing) {
                    GenWordPolynomialRing genWordPolynomialRing = (GenWordPolynomialRing)this.ring.coFac;
                    GenWordPolynomial genWordPolynomial = genWordPolynomialRing.valueOf(expVector2);
                    ringElem = genWordPolynomial;
                }
                genSolvablePolynomial = new GenSolvablePolynomial<RingElem>(this.ring, ringElem, expVector);
            }
            return new TableRelation(null, null, genSolvablePolynomial);
        }
        ExpVectorPair expVectorPair = new ExpVectorPair(expVector, expVector2);
        ExpVector expVector4 = null;
        ExpVector expVector5 = null;
        ExpVectorPair expVectorPair2 = null;
        GenSolvablePolynomial genSolvablePolynomial = null;
        List list3 = list2;
        synchronized (list3) {
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                expVectorPair2 = (ExpVectorPair)iterator.next();
                genSolvablePolynomial = (GenSolvablePolynomial)iterator.next();
                if (!expVectorPair.isMultiple(expVectorPair2)) continue;
                expVector4 = expVector.subtract(expVectorPair2.getFirst());
                expVector5 = expVector2.subtract(expVectorPair2.getSecond());
                if (expVector4.isZERO()) {
                    expVector4 = null;
                }
                if (expVector5.isZERO()) {
                    expVector5 = null;
                }
                if (debug) {
                    if (genSolvablePolynomial != null && genSolvablePolynomial.ring.vars != null) {
                        logger.info("found relation = " + expVector.toString(genSolvablePolynomial.ring.vars) + " .*. " + expVector2.toString(genSolvablePolynomial.ring.vars) + " = " + genSolvablePolynomial);
                    } else {
                        logger.info("found relation = " + expVector + " .*. " + expVector2 + " = " + genSolvablePolynomial);
                    }
                }
                return new TableRelation(expVector4, expVector5, genSolvablePolynomial);
            }
        }
        throw new RuntimeException("no entry found in relation table for " + expVectorPair);
    }

    protected List<Integer> makeKey(ExpVector expVector, ExpVector expVector2) {
        int n;
        int[] nArray = expVector.dependencyOnVariables();
        int[] nArray2 = expVector2.dependencyOnVariables();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length + nArray2.length);
        for (n = 0; n < nArray.length; ++n) {
            arrayList.add(nArray[n]);
        }
        for (n = 0; n < nArray2.length; ++n) {
            arrayList.add(nArray2[n]);
        }
        return arrayList;
    }

    public int size() {
        int n = 0;
        if (this.table == null || this.table.isEmpty()) {
            return n;
        }
        for (List list : this.table.values()) {
            n += list.size() / 2;
        }
        return n;
    }

    public void extend(RelationTable<C> relationTable) {
        if (relationTable.table.isEmpty()) {
            return;
        }
        int n = this.ring.nvar - relationTable.ring.nvar;
        int n2 = 0;
        long l = 0L;
        for (List<Integer> list : relationTable.table.keySet()) {
            List list2 = relationTable.table.get(list);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                ExpVectorPair expVectorPair = (ExpVectorPair)iterator.next();
                ExpVector expVector = expVectorPair.getFirst();
                ExpVector expVector2 = expVectorPair.getSecond();
                GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)iterator.next();
                ExpVector expVector3 = expVector.extend(n, n2, l);
                ExpVector expVector4 = this.coeffTable ? expVector2 : expVector2.extend(n, n2, l);
                GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)genSolvablePolynomial.extend(this.ring, n2, l);
                this.update(expVector3, expVector4, genSolvablePolynomial2);
            }
        }
    }

    public void contract(RelationTable<C> relationTable) {
        if (relationTable.table.isEmpty()) {
            return;
        }
        int n = relationTable.ring.nvar - this.ring.nvar;
        for (List<Integer> list : relationTable.table.keySet()) {
            List list2 = relationTable.table.get(list);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                Map<ExpVector, GenPolynomial<C>> map;
                ExpVectorPair expVectorPair = (ExpVectorPair)iterator.next();
                ExpVector expVector = expVectorPair.getFirst();
                ExpVector expVector2 = expVectorPair.getSecond();
                GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)iterator.next();
                ExpVector expVector3 = expVector.contract(n, expVector.length() - n);
                ExpVector expVector4 = this.coeffTable ? expVector2 : expVector2.contract(n, expVector2.length() - n);
                if (expVector3.isZERO() || (map = genSolvablePolynomial.contract(this.ring)).size() != 1) continue;
                GenPolynomial<C> genPolynomial = map.values().iterator().next();
                this.update(expVector3, expVector4, genPolynomial);
            }
        }
    }

    public void recursive(RelationTable relationTable) {
        if (relationTable.table.isEmpty()) {
            return;
        }
        GenPolynomialRing genPolynomialRing = (GenPolynomialRing)this.ring.coFac;
        int n = this.ring.nvar;
        Iterator<List<Integer>> iterator = relationTable.table.keySet().iterator();
        while (iterator.hasNext()) {
            List<Integer> list;
            List<Integer> list2 = list = iterator.next();
            List list3 = relationTable.table.get(list2);
            Iterator iterator2 = list3.iterator();
            while (iterator2.hasNext()) {
                Object object;
                ExpVectorPair expVectorPair = (ExpVectorPair)iterator2.next();
                ExpVector expVector = expVectorPair.getFirst();
                ExpVector expVector2 = expVectorPair.getSecond();
                GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)iterator2.next();
                ExpVector expVector3 = expVector.contract(0, n);
                ExpVector expVector4 = this.coeffTable ? expVector2 : expVector2.contract(0, n);
                if (expVector3.isZERO()) continue;
                Map map = genSolvablePolynomial.contract(genPolynomialRing);
                if (map.size() == 1) {
                    GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)map.values().iterator().next();
                    this.update(expVector3, expVector4, genSolvablePolynomial2);
                    continue;
                }
                GenPolynomial genPolynomial = this.ring.getZERO();
                for (Map.Entry entry : map.entrySet()) {
                    ExpVector expVector5 = entry.getKey();
                    GenPolynomial genPolynomial2 = entry.getValue();
                    RingElem ringElem = genPolynomial2;
                    GenSolvablePolynomial<RingElem> genSolvablePolynomial3 = new GenSolvablePolynomial<RingElem>(this.ring, ringElem, expVector5);
                    genPolynomial = (GenSolvablePolynomial)genPolynomial.sum(genSolvablePolynomial3);
                }
                if (this.coeffTable) {
                    expVector4 = ((GenPolynomial)genPolynomial.leadingBaseCoefficient()).leadingExpVector();
                }
                if (expVector4.isZERO()) continue;
                if (this.coeffTable) {
                    object = this.ring.toScript(expVector3) + " * " + genPolynomial.leadingBaseCoefficient() + " = " + genPolynomial.toScript();
                    logger.info("coeffTable: adding " + (String)object);
                } else {
                    object = this.ring.toScript(expVector3) + " * " + this.ring.toScript(expVector4) + " = " + genPolynomial.toScript();
                    logger.info("no coeffTable: adding " + (String)object);
                }
                this.update(expVector3, expVector4, (GenSolvablePolynomial<C>)genPolynomial);
            }
        }
    }

    public void reverse(RelationTable<C> relationTable) {
        if (relationTable.table.isEmpty()) {
            return;
        }
        if (!this.table.isEmpty()) {
            logger.error("reverse table not empty");
        }
        int n = -1;
        if (this.ring.tord.getEvord2() != 0 && this.ring.partial) {
            n = this.ring.tord.getSplit();
        }
        logger.debug("k split = " + n);
        for (List<Integer> list : relationTable.table.keySet()) {
            List list2 = relationTable.table.get(list);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                ExpVector expVector;
                ExpVector expVector2;
                ExpVectorPair expVectorPair = (ExpVectorPair)iterator.next();
                ExpVector expVector3 = expVectorPair.getFirst();
                ExpVector expVector4 = expVectorPair.getSecond();
                GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)iterator.next();
                boolean bl = true;
                if (n >= 0) {
                    expVector2 = expVector3.reverse(n);
                    expVector = this.coeffTable ? expVector4 : expVector4.reverse(n);
                } else {
                    expVector2 = expVector3.reverse();
                    expVector = this.coeffTable ? expVector4 : expVector4.reverse();
                }
                GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)genSolvablePolynomial.reverse(this.ring);
                if (!bl) {
                    this.update(expVector3, expVector4, genSolvablePolynomial2);
                    continue;
                }
                if (this.coeffTable) {
                    this.update(expVector2, expVector, genSolvablePolynomial2);
                    continue;
                }
                this.update(expVector, expVector2, genSolvablePolynomial2);
            }
        }
    }

    public List<GenSolvablePolynomial<C>> relationList() {
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>();
        for (Map.Entry<List<Integer>, List> entry : this.table.entrySet()) {
            List list = entry.getValue();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                RingElem ringElem;
                ExpVectorPair expVectorPair = (ExpVectorPair)iterator.next();
                ExpVector expVector = expVectorPair.getFirst();
                GenPolynomial genPolynomial = this.ring.valueOf(expVector);
                ExpVector expVector2 = expVectorPair.getSecond();
                GenPolynomial genPolynomial2 = null;
                if (this.coeffTable) {
                    RingElem ringElem2;
                    ringElem = null;
                    if (this.ring.coFac instanceof GenPolynomialRing) {
                        ringElem2 = ((GenPolynomialRing)this.ring.coFac).valueOf(expVector2);
                        ringElem = ringElem2;
                    } else if (this.ring.coFac instanceof GenWordPolynomialRing) {
                        ringElem2 = ((GenWordPolynomialRing)this.ring.coFac).valueOf(expVector2);
                        ringElem = ringElem2;
                    }
                    genPolynomial2 = this.ring.valueOf(ringElem);
                } else {
                    genPolynomial2 = this.ring.valueOf(expVector2);
                }
                ringElem = (GenSolvablePolynomial)iterator.next();
                arrayList.add((GenSolvablePolynomial<C>)genPolynomial);
                arrayList.add((GenSolvablePolynomial<C>)genPolynomial2);
                arrayList.add((GenSolvablePolynomial<C>)ringElem);
            }
        }
        return arrayList;
    }

    public void addSolvRelations(List<GenSolvablePolynomial<C>> list) {
        PolynomialList<C> polynomialList = new PolynomialList<C>(this.ring, list);
        this.addRelations(polynomialList.getList());
    }

    public void addRelations(List<GenPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Iterator<GenPolynomial<C>> iterator = list.iterator();
        while (iterator.hasNext()) {
            GenPolynomial<C> genPolynomial = iterator.next();
            ExpVector expVector = genPolynomial.leadingExpVector();
            ExpVector expVector2 = null;
            if (!iterator.hasNext()) {
                throw new IllegalArgumentException("F and poly part missing");
            }
            GenPolynomial<C> genPolynomial2 = iterator.next();
            if (!iterator.hasNext()) {
                throw new IllegalArgumentException("poly part missing");
            }
            GenPolynomial<C> genPolynomial3 = iterator.next();
            if (this.coeffTable) {
                if (!genPolynomial2.isConstant()) {
                    throw new IllegalArgumentException("F  not constant for coeffTable: " + genPolynomial2);
                }
                if (this.ring.coFac instanceof GenPolynomialRing) {
                    expVector2 = ((GenPolynomial)genPolynomial2.leadingBaseCoefficient()).leadingExpVector();
                } else if (this.ring.coFac instanceof GenWordPolynomialRing) {
                    expVector2 = ((GenWordPolynomial)genPolynomial2.leadingBaseCoefficient()).leadingWord().leadingExpVector();
                }
            } else {
                expVector2 = genPolynomial2.leadingExpVector();
            }
            this.update(expVector, expVector2, genPolynomial3);
        }
    }
}

