/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.AlgebraElem;
import edu.jas.structure.Element;
import edu.jas.structure.MonoidElem;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.FactorRational;
import edu.jas.ufd.PartialFraction;
import edu.jas.ufd.QuotientRing;
import edu.jas.vector.GenMatrix;
import edu.jas.vector.GenMatrixRing;
import java.util.ArrayList;
import java.util.SortedMap;

public class Examples {
    public static void main(String[] stringArray) {
        Examples.example1();
        Examples.example2();
        Examples.example10();
        Examples.example11();
        ComputerThreads.terminate();
    }

    public static void example1() {
        System.out.println("\n\n example 1");
        BigInteger bigInteger = new BigInteger();
        System.out.println("cfac = " + bigInteger);
        String[] stringArray = new String[]{"a", "b"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, stringArray);
        System.out.println(" fac = " + genPolynomialRing.toScript());
        QuotientRing<BigInteger> quotientRing = new QuotientRing<BigInteger>(genPolynomialRing);
        System.out.println("efac = " + quotientRing.toScript());
        String[] stringArray2 = new String[]{"x", "y", "z"};
        GenPolynomialRing<BigInteger> genPolynomialRing2 = new GenPolynomialRing<BigInteger>(quotientRing, 3, stringArray2);
        System.out.println("qfac = " + genPolynomialRing2.toScript());
        GenMatrixRing<BigInteger> genMatrixRing = new GenMatrixRing<BigInteger>(genPolynomialRing2, 3, 3);
        System.out.println("mfac = " + genMatrixRing.toScript());
        GenPolynomial<BigInteger> genPolynomial = genPolynomialRing2.random(3, 4, 2, 0.3f);
        System.out.println("\np = " + genPolynomial);
        AlgebraElem algebraElem = genMatrixRing.random(3, 0.4f);
        System.out.println("\nm = " + ((GenMatrix)algebraElem).toScript());
    }

    public static void example2() {
        System.out.println("\n\n example 2");
        BigInteger bigInteger = new BigInteger();
        String[] stringArray = new String[]{"a", "b", "c", "d"};
        int n = stringArray.length;
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, stringArray);
        ArrayList<GenPolynomial<BigInteger>> arrayList = new ArrayList<GenPolynomial<BigInteger>>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(genPolynomialRing.univariate(i));
        }
        System.out.println("vars = " + arrayList);
        GenPolynomial<GenPolynomial<GenPolynomial>> genPolynomial = ((GenPolynomial)arrayList.get(0)).multiply((GenPolynomial)arrayList.get(1)).sum((GenPolynomial)((GenPolynomial)arrayList.get(0)).multiply((GenPolynomial)arrayList.get(2))).sum(((GenPolynomial)arrayList.get(3)).multiply((GenPolynomial)arrayList.get(1))).sum(((GenPolynomial)arrayList.get(3)).multiply((GenPolynomial)arrayList.get(2)));
        System.out.println("tmp = " + genPolynomial);
        FactorAbstract<BigInteger> factorAbstract = FactorFactory.getImplementation(bigInteger);
        SortedMap<GenPolynomial<GenPolynomial<GenPolynomial>>, Long> sortedMap = factorAbstract.factors(genPolynomial);
        System.out.println("factors = " + sortedMap);
    }

    public static void example6() {
        System.out.println("\n\nexample 6");
        TermOrder termOrder = new TermOrder(2);
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"x"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 1, termOrder, stringArray);
        Element element = genPolynomialRing.parse("x^7 + x + 1");
        GenPolynomial genPolynomial = PolyUtil.baseDeriviative(element);
        FactorRational factorRational = new FactorRational();
        PartialFraction partialFraction = factorRational.baseAlgebraicPartialFraction(genPolynomial, element);
        System.out.println("\nintegral " + partialFraction);
    }

    public static void example9() {
        System.out.println("\n\nexample 9");
        TermOrder termOrder = new TermOrder(2);
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"x"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 1, termOrder, stringArray);
        Element element = genPolynomialRing.parse("( x^5 + x - 7 )");
        MonoidElem monoidElem = genPolynomialRing.getONE();
        FactorRational factorRational = new FactorRational();
        PartialFraction partialFraction = factorRational.baseAlgebraicPartialFraction(monoidElem, element);
        System.out.println("\nintegral " + partialFraction);
    }

    public static void example10() {
        System.out.println("\n\nexample 10");
        TermOrder termOrder = new TermOrder(2);
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"w2"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 1, termOrder, stringArray);
        System.out.println("pfac   = " + genPolynomialRing.toScript());
        Element element = genPolynomialRing.parse(" w2^2 - 2 ");
        System.out.println("w2     = " + element);
        AlgebraicNumberRing algebraicNumberRing = new AlgebraicNumberRing(element, true);
        System.out.println("a2fac  = " + algebraicNumberRing.toScript());
        String[] stringArray2 = new String[]{"x"};
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(algebraicNumberRing, 1, termOrder, stringArray2);
        System.out.println("apfac  = " + genPolynomialRing2.toScript());
        QuotientRing quotientRing = new QuotientRing(genPolynomialRing2);
        System.out.println("qfac   = " + quotientRing.toScript());
        String[] stringArray3 = new String[]{"wx"};
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(quotientRing, 1, termOrder, stringArray3);
        System.out.println("pqfac  = " + genPolynomialRing3.toScript());
        Element element2 = genPolynomialRing3.parse(" wx^2 - { x } ");
        System.out.println("wx     = " + element2);
        AlgebraicNumberRing algebraicNumberRing2 = new AlgebraicNumberRing(element2, true);
        System.out.println("axfac  = " + algebraicNumberRing2.toScript());
        String[] stringArray4 = new String[]{"y"};
        GenPolynomialRing genPolynomialRing4 = new GenPolynomialRing(algebraicNumberRing2, 1, termOrder, stringArray4);
        System.out.println("apqfac = " + genPolynomialRing4.toScript());
        Element element3 = genPolynomialRing4.parse(" ( y^2 - { { x } } ) * ( y^2 - 2 )^2 ");
        System.out.println("f      = " + element3);
        FactorAbstract factorAbstract = FactorFactory.getImplementation(algebraicNumberRing2);
        System.out.println("engine = " + factorAbstract);
        SortedMap sortedMap = factorAbstract.factors(element3);
        System.out.println("factors(f) = " + sortedMap);
    }

    public static void example11() {
        System.out.println("\n\nexample 11");
        for (int i = 0; i < 10; ++i) {
            String[] stringArray = new String[]{"a", "c", "d", "e", "x"};
            GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(BigInteger.ZERO, stringArray.length, new TermOrder(2), stringArray);
            Element element = genPolynomialRing.parse("a*d*e + c*d^2*x + a*e^2*x + c*d*e*x^2");
            FactorAbstract<BigInteger> factorAbstract = FactorFactory.getImplementation(BigInteger.ZERO);
            long l = System.currentTimeMillis();
            SortedMap sortedMap = factorAbstract.factors((GenPolynomial<BigInteger>)element);
            l = System.currentTimeMillis() - l;
            boolean bl = factorAbstract.isFactorization((GenPolynomial<BigInteger>)element, sortedMap);
            if (bl) continue;
            System.out.println("Run " + i + ": " + ((GenPolynomial)element).toString());
            System.out.println("Run not Factors " + l + "ms: " + sortedMap.toString());
        }
    }
}

