/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.kern.ComputerThreads;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class QuotIntPolynomialTest
extends TestCase {
    QuotientRing<BigInteger> eFac;
    GenPolynomialRing<BigInteger> mfac;
    GenPolynomialRing<Quotient<BigInteger>> qfac;
    GenPolynomial<Quotient<BigInteger>> a;
    GenPolynomial<Quotient<BigInteger>> b;
    GenPolynomial<Quotient<BigInteger>> c;
    GenPolynomial<Quotient<BigInteger>> d;
    GenPolynomial<Quotient<BigInteger>> e;
    int rl = 3;
    int kl = 2;
    int ll = 4;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)QuotIntPolynomialTest.suite());
        ComputerThreads.terminate();
    }

    public QuotIntPolynomialTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(QuotIntPolynomialTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"a", "b", "c"};
        BigInteger bigInteger = new BigInteger(1L);
        this.mfac = new GenPolynomialRing<BigInteger>(bigInteger, this.rl, termOrder, stringArray);
        this.eFac = new QuotientRing<BigInteger>(this.mfac);
        String[] stringArray2 = new String[]{"w", "x", "y", "z"};
        this.qfac = new GenPolynomialRing<BigInteger>(this.eFac, this.rl + 1, stringArray2);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.eFac = null;
        this.mfac = null;
        this.qfac = null;
        ComputerThreads.terminate();
    }

    public void testConstruction() {
        this.c = this.qfac.getONE();
        QuotIntPolynomialTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        QuotIntPolynomialTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        QuotIntPolynomialTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.qfac.getZERO();
        QuotIntPolynomialTest.assertTrue((String)"length( d ) = 0", (this.d.length() == 0 ? 1 : 0) != 0);
        QuotIntPolynomialTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        QuotIntPolynomialTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        for (int i = 0; i < 3; ++i) {
            this.a = this.qfac.random(this.kl, this.ll + i, this.el, this.q);
            if (this.a.isZERO() || this.a.isONE()) continue;
            QuotIntPolynomialTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            QuotIntPolynomialTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            QuotIntPolynomialTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
            this.b = this.a.monic();
            Quotient<BigInteger> quotient = this.b.leadingBaseCoefficient();
            QuotIntPolynomialTest.assertTrue((String)("ldbcf( b" + i + " ) == 1 " + this.b + ", a = " + this.a), (boolean)quotient.isONE());
        }
    }

    public void testAddition() {
        this.a = this.qfac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.qfac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.a.sum((Quotient<BigInteger>)((Object)this.b));
        this.d = this.c.subtract((Quotient<BigInteger>)((Object)this.b));
        QuotIntPolynomialTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.a.sum((Quotient<BigInteger>)((Object)this.b));
        this.d = this.b.sum((Quotient<BigInteger>)((Object)this.a));
        QuotIntPolynomialTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.qfac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.c.sum((Quotient<BigInteger>)((Object)this.a.sum((Quotient<BigInteger>)((Object)this.b))));
        this.e = this.c.sum((Quotient<BigInteger>)((Object)this.a)).sum(this.b);
        QuotIntPolynomialTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
        this.c = this.a.sum((Quotient<BigInteger>)this.qfac.getZERO());
        this.d = this.a.subtract((Quotient<BigInteger>)this.qfac.getZERO());
        QuotIntPolynomialTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((GenPolynomial)this.qfac.getZERO()).sum(this.a);
        this.d = ((GenPolynomial)this.qfac.getZERO()).subtract(this.a.negate());
        QuotIntPolynomialTest.assertEquals((String)"0+a = 0+(-a)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.qfac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.qfac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.multiply((Quotient<BigInteger>)((Object)this.a));
        this.d = this.a.multiply((Quotient<BigInteger>)((Object)this.b));
        if (!this.a.isZERO() && !this.b.isZERO()) {
            QuotIntPolynomialTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
            QuotIntPolynomialTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        }
        this.e = this.d.subtract((Quotient<BigInteger>)((Object)this.c));
        QuotIntPolynomialTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        QuotIntPolynomialTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        QuotIntPolynomialTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.qfac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((Quotient<BigInteger>)((Object)this.b.multiply((Quotient<BigInteger>)((Object)this.c))));
        this.e = this.a.multiply((Quotient<BigInteger>)((Object)this.b)).multiply(this.c);
        QuotIntPolynomialTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        QuotIntPolynomialTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        this.c = this.a.multiply((Quotient<BigInteger>)this.qfac.getONE());
        this.d = ((GenPolynomial)this.qfac.getONE()).multiply(this.a);
        QuotIntPolynomialTest.assertEquals((String)"a*1 = 1*a", this.c, this.d);
        if (this.a.isUnit()) {
            this.c = this.a.inverse();
            this.d = this.c.multiply((Quotient<BigInteger>)((Object)this.a));
            QuotIntPolynomialTest.assertTrue((String)"a*1/a = 1", (boolean)this.d.isONE());
        }
    }

    public void testParse() {
        this.a = this.qfac.random(this.kl, this.ll * 2, this.el * 2, this.q * 2.0f);
        PrettyPrint.setPretty();
        String string = this.a.toString(this.qfac.getVars());
        this.b = this.qfac.parse(string);
        QuotIntPolynomialTest.assertEquals((String)"parse(a.toSting()) = a", this.a, this.b);
    }
}

