#
# jruby examples for jas.
# $Id: eliminate.rb 4880 2014-08-23 20:38:52Z kredel $
#

require "examples/jas"

# ideal elimination example

r = PolyRing.new( QQ(), "(x,y,z)", PolyRing.grad );
puts "Ring: " + str(r);
puts;

ps1 = """
(
 ( x^2 - 2 ),
 ( y^2 - 3 ),
 ( z^3 - x * y )
)
""";

ff = [ x**2 - 2,
       y**2 - 3,
       z**3 - x * y
     ]

#F1 = r.ideal( ps1 );
F1 = r.ideal( "", ff );
puts "Ideal: " + str(F1);
puts;

e = PolyRing.new( QQ(), "(x,z)", PolyRing.grad );
puts "Ring: " + str(e);
puts;

#startLog();

rg1 = F1.eliminateRing(e);
puts "rg1 = " + str(rg1);
puts;

rg2 = rg1.intersectRing(e);
puts "rg2 = " + str(rg2);
puts;

terminate();
#sys.exit();
