/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.gb.GBOptimized;
import edu.jas.gb.GBProxy;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.GroebnerBaseArriSigSeqIter;
import edu.jas.gb.GroebnerBaseF5zSigSeqIter;
import edu.jas.gb.GroebnerBaseGGVSigSeqIter;
import edu.jas.gb.GroebnerBaseParIter;
import edu.jas.gb.GroebnerBaseParallel;
import edu.jas.gb.GroebnerBaseSeqIter;
import edu.jas.gb.OrderedMinPairlist;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.OrderedSyzPairlist;
import edu.jas.gb.PairList;
import edu.jas.gbufd.GBFactory;
import edu.jas.gbufd.GroebnerBaseFGLM;
import edu.jas.gbufd.GroebnerBasePseudoParallel;
import edu.jas.gbufd.GroebnerBaseQuotient;
import edu.jas.gbufd.GroebnerBaseRational;
import edu.jas.gbufd.GroebnerBaseWalk;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.QuotientRing;
import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GBAlgorithmBuilder<C extends GcdRingElem<C>>
implements Serializable {
    private static final Logger logger = LogManager.getLogger(GBAlgorithmBuilder.class);
    private GroebnerBaseAbstract<C> algo;
    public final GenPolynomialRing<C> ring;
    public final PairList<C> strategy;

    protected GBAlgorithmBuilder() {
        throw new IllegalArgumentException("do not use this constructor");
    }

    public GBAlgorithmBuilder(GenPolynomialRing<C> genPolynomialRing) {
        this(genPolynomialRing, null);
    }

    public GBAlgorithmBuilder(GenPolynomialRing<C> genPolynomialRing, GroebnerBaseAbstract<C> groebnerBaseAbstract) {
        this(genPolynomialRing, groebnerBaseAbstract, null);
    }

    public GBAlgorithmBuilder(GenPolynomialRing<C> genPolynomialRing, GroebnerBaseAbstract<C> groebnerBaseAbstract, PairList<C> pairList) {
        if (genPolynomialRing == null) {
            throw new IllegalArgumentException("ring may not be null");
        }
        this.ring = genPolynomialRing;
        if (pairList == null) {
            pairList = new OrderedPairlist();
        } else if (groebnerBaseAbstract == null) {
            groebnerBaseAbstract = GBFactory.getImplementation(genPolynomialRing.coFac, pairList);
        }
        this.algo = groebnerBaseAbstract;
        this.strategy = pairList;
    }

    public GroebnerBaseAbstract<C> build() {
        if (this.algo == null) {
            this.algo = this.strategy == null ? GBFactory.getImplementation(this.ring.coFac) : GBFactory.getImplementation(this.ring.coFac, this.strategy);
        }
        return this.algo;
    }

    public static <C extends GcdRingElem<C>> GBAlgorithmBuilder<C> polynomialRing(GenPolynomialRing<C> genPolynomialRing) {
        return new GBAlgorithmBuilder<C>(genPolynomialRing);
    }

    public GBAlgorithmBuilder<C> syzygyPairlist() {
        return new GBAlgorithmBuilder<C>(this.ring, this.algo, new OrderedSyzPairlist());
    }

    public GBAlgorithmBuilder<C> normalPairlist() {
        return new GBAlgorithmBuilder<C>(this.ring, this.algo, new OrderedPairlist());
    }

    public GBAlgorithmBuilder<C> simplePairlist() {
        return new GBAlgorithmBuilder<C>(this.ring, this.algo, new OrderedMinPairlist());
    }

    public GBAlgorithmBuilder<C> optimize() {
        return this.optimize(true);
    }

    public GBAlgorithmBuilder<C> optimize(boolean bl) {
        if (this.algo == null) {
            this.algo = GBFactory.getImplementation(this.ring.coFac, this.strategy);
        }
        GBOptimized<C> gBOptimized = new GBOptimized<C>(this.algo, bl);
        return new GBAlgorithmBuilder<C>(this.ring, gBOptimized, this.strategy);
    }

    public GBAlgorithmBuilder<C> fractionFree() {
        if (this.algo != null) {
            logger.warn("selected algorithm ignored: " + this.algo + ", use fractionFree before");
        }
        if (this.ring.coFac instanceof BigRational) {
            GroebnerBaseAbstract<BigRational> groebnerBaseAbstract;
            BigRational bigRational = (BigRational)this.ring.coFac;
            PairList<BigRational> pairList = this.strategy;
            GroebnerBaseAbstract<BigRational> groebnerBaseAbstract2 = groebnerBaseAbstract = GBFactory.getImplementation(bigRational, GBFactory.Algo.ffgb, pairList);
            return new GBAlgorithmBuilder<BigRational>(this.ring, groebnerBaseAbstract2, this.strategy);
        }
        if (this.ring.coFac instanceof QuotientRing) {
            GroebnerBaseAbstract groebnerBaseAbstract;
            QuotientRing quotientRing = (QuotientRing)this.ring.coFac;
            PairList pairList = this.strategy;
            GroebnerBaseAbstract groebnerBaseAbstract3 = groebnerBaseAbstract = GBFactory.getImplementation(quotientRing, GBFactory.Algo.ffgb, pairList);
            return new GBAlgorithmBuilder(this.ring, groebnerBaseAbstract3, this.strategy);
        }
        logger.warn("no fraction free algorithm implemented for " + this.ring);
        return this;
    }

    public GBAlgorithmBuilder<C> euclideanDomain() {
        return this.domainAlgorithm(GBFactory.Algo.egb);
    }

    public GBAlgorithmBuilder<C> domainAlgorithm(GBFactory.Algo algo) {
        if (this.strategy != null) {
            logger.warn("strategy " + this.strategy + " ignored for algorithm " + (Object)((Object)algo));
        }
        if (this.ring.coFac instanceof BigInteger) {
            GroebnerBaseAbstract<BigInteger> groebnerBaseAbstract;
            BigInteger bigInteger = (BigInteger)this.ring.coFac;
            GroebnerBaseAbstract<BigInteger> groebnerBaseAbstract2 = groebnerBaseAbstract = GBFactory.getImplementation(bigInteger, algo);
            return new GBAlgorithmBuilder<BigInteger>(this.ring, groebnerBaseAbstract2);
        }
        if (this.ring.coFac instanceof GenPolynomial) {
            GroebnerBaseAbstract groebnerBaseAbstract;
            GenPolynomialRing genPolynomialRing = (GenPolynomialRing)this.ring.coFac;
            GroebnerBaseAbstract groebnerBaseAbstract3 = groebnerBaseAbstract = GBFactory.getImplementation(genPolynomialRing, algo);
            return new GBAlgorithmBuilder(this.ring, groebnerBaseAbstract3);
        }
        logger.warn("no domain algorithm implemented for " + this.ring);
        return this;
    }

    public GBAlgorithmBuilder<C> parallel() {
        return this.parallel(ComputerThreads.N_CPUS);
    }

    public GBAlgorithmBuilder<C> parallel(int n) {
        if (ComputerThreads.NO_THREADS) {
            logger.warn("parallel algorithms disabled");
            return this;
        }
        if (this.algo == null) {
            this.algo = GBFactory.getImplementation(this.ring.coFac, this.strategy);
        }
        if (this.algo instanceof GroebnerBaseSeqIter) {
            GroebnerBaseParIter<C> groebnerBaseParIter = new GroebnerBaseParIter<C>(n, this.strategy);
            GBProxy<C> gBProxy = new GBProxy<C>(this.algo, groebnerBaseParIter);
            return new GBAlgorithmBuilder<C>(this.ring, gBProxy, this.strategy);
        }
        if (this.ring.coFac instanceof BigRational) {
            GroebnerBaseAbstract groebnerBaseAbstract;
            Serializable serializable;
            if (this.algo instanceof GroebnerBaseRational) {
                serializable = this.strategy instanceof OrderedMinPairlist ? new OrderedMinPairlist() : (this.strategy instanceof OrderedSyzPairlist ? new OrderedSyzPairlist() : new OrderedPairlist());
                groebnerBaseAbstract = new GroebnerBaseRational(n, (PairList<BigInteger>)serializable);
            } else {
                groebnerBaseAbstract = new GroebnerBaseParallel<C>(n, this.strategy);
            }
            serializable = new GBProxy<C>(this.algo, groebnerBaseAbstract);
            return new GBAlgorithmBuilder<C>(this.ring, serializable, this.strategy);
        }
        if (this.ring.coFac instanceof QuotientRing) {
            GroebnerBaseAbstract groebnerBaseAbstract;
            Serializable serializable;
            if (this.algo instanceof GroebnerBaseQuotient) {
                serializable = this.strategy instanceof OrderedMinPairlist ? new OrderedMinPairlist() : (this.strategy instanceof OrderedSyzPairlist ? new OrderedSyzPairlist() : new OrderedPairlist());
                QuotientRing quotientRing = (QuotientRing)this.ring.coFac;
                groebnerBaseAbstract = new GroebnerBaseQuotient(n, quotientRing, serializable);
            } else {
                groebnerBaseAbstract = new GroebnerBaseParallel<C>(n, this.strategy);
            }
            serializable = new GBProxy<C>(this.algo, groebnerBaseAbstract);
            return new GBAlgorithmBuilder(this.ring, serializable);
        }
        if (this.ring.coFac.isField()) {
            GroebnerBaseParallel<C> groebnerBaseParallel = new GroebnerBaseParallel<C>(n, this.strategy);
            GBProxy<C> gBProxy = new GBProxy<C>(this.algo, groebnerBaseParallel);
            return new GBAlgorithmBuilder<C>(this.ring, gBProxy, this.strategy);
        }
        if (this.ring.coFac.getONE() instanceof GcdRingElem) {
            GroebnerBasePseudoParallel groebnerBasePseudoParallel = new GroebnerBasePseudoParallel(n, this.ring.coFac, this.strategy);
            GBProxy<C> gBProxy = new GBProxy<C>(this.algo, groebnerBasePseudoParallel);
            return new GBAlgorithmBuilder<C>(this.ring, gBProxy, this.strategy);
        }
        logger.warn("no parallel algorithm implemented for " + this.ring);
        return this;
    }

    public GBAlgorithmBuilder<C> graded() {
        if (this.ring.coFac.isField()) {
            GroebnerBaseFGLM groebnerBaseFGLM = this.algo == null ? new GroebnerBaseFGLM() : new GroebnerBaseFGLM<C>(this.algo);
            return new GBAlgorithmBuilder<C>(this.ring, groebnerBaseFGLM, this.strategy);
        }
        logger.warn("no FGLM algorithm implemented for " + this.ring);
        return this;
    }

    public GBAlgorithmBuilder<C> walk() {
        if (this.ring.coFac.isField()) {
            GroebnerBaseWalk groebnerBaseWalk = this.algo == null ? new GroebnerBaseWalk() : new GroebnerBaseWalk<C>(this.algo);
            return new GBAlgorithmBuilder<C>(this.ring, groebnerBaseWalk, this.strategy);
        }
        logger.warn("no Groebner walk algorithm implemented for " + this.ring);
        return this;
    }

    public GBAlgorithmBuilder<C> iterated() {
        if (this.ring.coFac.isField()) {
            GroebnerBaseSeqIter<C> groebnerBaseSeqIter = new GroebnerBaseSeqIter<C>(this.strategy);
            if (this.algo != null) {
                logger.warn("algorithm " + this.algo + " ignored for " + groebnerBaseSeqIter);
            }
            return new GBAlgorithmBuilder<C>(this.ring, groebnerBaseSeqIter, this.strategy);
        }
        logger.warn("no iterated GB algorithm implemented for " + this.ring);
        return this;
    }

    public GBAlgorithmBuilder<C> F5() {
        if (this.ring.coFac.isField()) {
            GroebnerBaseF5zSigSeqIter groebnerBaseF5zSigSeqIter = new GroebnerBaseF5zSigSeqIter();
            if (this.algo != null) {
                logger.warn("algorithm " + this.algo + " ignored for " + groebnerBaseF5zSigSeqIter);
            }
            if (this.strategy != null) {
                logger.warn("strategy " + this.strategy + " ignored for " + groebnerBaseF5zSigSeqIter);
            }
            return new GBAlgorithmBuilder<C>(this.ring, groebnerBaseF5zSigSeqIter, this.strategy);
        }
        logger.warn("no iterated F5 GB algorithm implemented for " + this.ring);
        return this;
    }

    public GBAlgorithmBuilder<C> GGV() {
        if (this.ring.coFac.isField()) {
            GroebnerBaseGGVSigSeqIter groebnerBaseGGVSigSeqIter = new GroebnerBaseGGVSigSeqIter();
            if (this.algo != null) {
                logger.warn("algorithm " + this.algo + " ignored for " + groebnerBaseGGVSigSeqIter);
            }
            if (this.strategy != null) {
                logger.warn("strategy " + this.strategy + " ignored for " + groebnerBaseGGVSigSeqIter);
            }
            return new GBAlgorithmBuilder<C>(this.ring, groebnerBaseGGVSigSeqIter, this.strategy);
        }
        logger.warn("no iterated GGV GB algorithm implemented for " + this.ring);
        return this;
    }

    public GBAlgorithmBuilder<C> Arri() {
        if (this.ring.coFac.isField()) {
            GroebnerBaseArriSigSeqIter groebnerBaseArriSigSeqIter = new GroebnerBaseArriSigSeqIter();
            if (this.algo != null) {
                logger.warn("algorithm " + this.algo + " ignored for " + groebnerBaseArriSigSeqIter);
            }
            if (this.strategy != null) {
                logger.warn("strategy " + this.strategy + " ignored for " + groebnerBaseArriSigSeqIter);
            }
            return new GBAlgorithmBuilder<C>(this.ring, groebnerBaseArriSigSeqIter, this.strategy);
        }
        logger.warn("no iterated Arri GB algorithm implemented for " + this.ring);
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(" ");
        if (this.algo != null) {
            stringBuffer.append(this.algo.toString());
            stringBuffer.append(" for ");
        }
        stringBuffer.append(this.ring.toString());
        if (this.strategy != null) {
            stringBuffer.append(" strategy=");
            stringBuffer.append(this.strategy.toString());
        }
        return stringBuffer.toString();
    }

    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer(" ");
        if (this.algo != null) {
            stringBuffer.append(this.algo.toString());
            stringBuffer.append(" ");
        }
        stringBuffer.append(this.ring.toScript());
        if (this.strategy != null) {
            stringBuffer.append(",strategy=");
            stringBuffer.append(this.strategy.toString());
        }
        return stringBuffer.toString();
    }
}

