/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.ExamplesGeoTheorems;
import edu.jas.application.GBAlgorithmBuilder;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.gb.DGroebnerBaseSeq;
import edu.jas.gb.EGroebnerBaseSeq;
import edu.jas.gb.GBOptimized;
import edu.jas.gb.GBProxy;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.GroebnerBaseArriSigSeqIter;
import edu.jas.gb.GroebnerBaseF5zSigSeqIter;
import edu.jas.gb.GroebnerBaseGGVSigSeqIter;
import edu.jas.gb.GroebnerBaseParIter;
import edu.jas.gb.GroebnerBaseParallel;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gb.GroebnerBaseSeqIter;
import edu.jas.gb.GroebnerBaseSigSeqIter;
import edu.jas.gbufd.GBFactory;
import edu.jas.gbufd.GroebnerBaseFGLM;
import edu.jas.gbufd.GroebnerBasePseudoSeq;
import edu.jas.gbufd.GroebnerBaseRational;
import edu.jas.gbufd.GroebnerBaseWalk;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomialRing;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GBAlgorithmBuilderTest
extends TestCase {
    GBAlgorithmBuilder builder;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GBAlgorithmBuilderTest.suite());
    }

    public GBAlgorithmBuilderTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GBAlgorithmBuilderTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.builder = null;
    }

    protected void tearDown() {
        this.builder = null;
        ComputerThreads.terminate();
    }

    public void testConstructionRational() {
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"a", "b", "c"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, stringArray);
        GBAlgorithmBuilder<BigRational> gBAlgorithmBuilder = GBAlgorithmBuilder.polynomialRing(genPolynomialRing);
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = gBAlgorithmBuilder.build();
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GroebnerBaseSeq));
    }

    public void testConstructionRationalFGLM() {
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"a", "b", "c"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, stringArray);
        GBAlgorithmBuilder<BigRational> gBAlgorithmBuilder = GBAlgorithmBuilder.polynomialRing(genPolynomialRing);
        gBAlgorithmBuilder = gBAlgorithmBuilder.graded();
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = gBAlgorithmBuilder.build();
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GroebnerBaseFGLM));
    }

    public void testConstructionRationalWalk() {
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"a", "b", "c"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, stringArray);
        GBAlgorithmBuilder<BigRational> gBAlgorithmBuilder = GBAlgorithmBuilder.polynomialRing(genPolynomialRing);
        gBAlgorithmBuilder = gBAlgorithmBuilder.walk();
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = gBAlgorithmBuilder.build();
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GroebnerBaseWalk));
    }

    public void testConstructionRationalParallel() {
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"a", "b", "c"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, stringArray);
        GBAlgorithmBuilder<BigRational> gBAlgorithmBuilder = GBAlgorithmBuilder.polynomialRing(genPolynomialRing);
        gBAlgorithmBuilder = gBAlgorithmBuilder.parallel();
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = gBAlgorithmBuilder.build();
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GBProxy));
        GBProxy gBProxy = (GBProxy)groebnerBaseAbstract;
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + gBProxy.e1), (boolean)(gBProxy.e1 instanceof GroebnerBaseSeq));
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + gBProxy.e2), (boolean)(gBProxy.e2 instanceof GroebnerBaseParallel));
    }

    public void testConstructionRationalFFParallel() {
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"a", "b", "c"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, stringArray);
        GBAlgorithmBuilder<BigRational> gBAlgorithmBuilder = GBAlgorithmBuilder.polynomialRing(genPolynomialRing);
        gBAlgorithmBuilder = gBAlgorithmBuilder.fractionFree();
        gBAlgorithmBuilder = gBAlgorithmBuilder.parallel();
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = gBAlgorithmBuilder.build();
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GBProxy));
        GBProxy gBProxy = (GBProxy)groebnerBaseAbstract;
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + gBProxy.e1), (boolean)(gBProxy.e1 instanceof GroebnerBaseRational));
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + gBProxy.e2), (boolean)(gBProxy.e2 instanceof GroebnerBaseRational));
    }

    public void testConstructionRationalOptimized() {
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"a", "b", "c"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, stringArray);
        GBAlgorithmBuilder<BigRational> gBAlgorithmBuilder = GBAlgorithmBuilder.polynomialRing(genPolynomialRing);
        gBAlgorithmBuilder = gBAlgorithmBuilder.optimize();
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = gBAlgorithmBuilder.build();
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GBOptimized));
    }

    public void testConstructionRationalFF() {
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"a", "b", "c"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, stringArray);
        GBAlgorithmBuilder<BigRational> gBAlgorithmBuilder = GBAlgorithmBuilder.polynomialRing(genPolynomialRing);
        gBAlgorithmBuilder = gBAlgorithmBuilder.fractionFree();
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = gBAlgorithmBuilder.build();
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GroebnerBaseRational));
    }

    public void testConstructionInteger() {
        BigInteger bigInteger = new BigInteger(1L);
        String[] stringArray = new String[]{"a", "b", "c"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, stringArray);
        GBAlgorithmBuilder<BigInteger> gBAlgorithmBuilder = GBAlgorithmBuilder.polynomialRing(genPolynomialRing);
        GroebnerBaseAbstract<BigInteger> groebnerBaseAbstract = gBAlgorithmBuilder.build();
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GroebnerBasePseudoSeq));
    }

    public void testConstructionIntegerDGB() {
        BigInteger bigInteger = new BigInteger(1L);
        String[] stringArray = new String[]{"a", "b", "c"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, stringArray);
        GBAlgorithmBuilder<BigInteger> gBAlgorithmBuilder = GBAlgorithmBuilder.polynomialRing(genPolynomialRing);
        gBAlgorithmBuilder = gBAlgorithmBuilder.domainAlgorithm(GBFactory.Algo.dgb);
        GroebnerBaseAbstract<BigInteger> groebnerBaseAbstract = gBAlgorithmBuilder.build();
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof DGroebnerBaseSeq));
    }

    public void testConstructionIntegerEGB() {
        BigInteger bigInteger = new BigInteger(1L);
        String[] stringArray = new String[]{"a", "b", "c"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, stringArray);
        GBAlgorithmBuilder<BigInteger> gBAlgorithmBuilder = GBAlgorithmBuilder.polynomialRing(genPolynomialRing);
        gBAlgorithmBuilder = gBAlgorithmBuilder.domainAlgorithm(GBFactory.Algo.egb);
        GroebnerBaseAbstract<BigInteger> groebnerBaseAbstract = gBAlgorithmBuilder.build();
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof EGroebnerBaseSeq));
    }

    public void testConstructionRationalMore() {
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"a", "b", "c"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, stringArray);
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = GBAlgorithmBuilder.polynomialRing(genPolynomialRing).fractionFree().optimize().build();
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GBOptimized));
        groebnerBaseAbstract = GBAlgorithmBuilder.polynomialRing(genPolynomialRing).fractionFree().parallel().optimize().build();
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GBOptimized));
        groebnerBaseAbstract = GBAlgorithmBuilder.polynomialRing(genPolynomialRing).fractionFree().graded().parallel().optimize().build();
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GBOptimized));
    }

    public void testConstructionRationalMoreCompute() {
        List list = ExamplesGeoTheorems.getExample();
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        GroebnerBaseAbstract groebnerBaseAbstract = GBAlgorithmBuilder.polynomialRing(genPolynomialRing).optimize().build();
        long l = System.currentTimeMillis();
        List list2 = groebnerBaseAbstract.GB(list);
        l = System.currentTimeMillis() - l;
        l = System.currentTimeMillis();
        list2 = groebnerBaseAbstract.GB(list);
        l = System.currentTimeMillis() - l;
        l = System.currentTimeMillis();
        list2 = groebnerBaseAbstract.GB(list);
        l = System.currentTimeMillis() - l;
        GBAlgorithmBuilderTest.assertTrue((String)"t >= 0: ", (l >= 0L ? 1 : 0) != 0);
        GBAlgorithmBuilderTest.assertTrue((String)"isGB: ", (boolean)groebnerBaseAbstract.isGB(list2));
        groebnerBaseAbstract.terminate();
    }

    public void testConstructionRationalParilistCompute() {
        List list = ExamplesGeoTheorems.getExample();
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        GroebnerBaseAbstract groebnerBaseAbstract = GBAlgorithmBuilder.polynomialRing(genPolynomialRing).normalPairlist().build();
        long l = System.currentTimeMillis();
        List list2 = groebnerBaseAbstract.GB(list);
        l = System.currentTimeMillis() - l;
        GBAlgorithmBuilderTest.assertTrue((String)"isGB: ", (boolean)groebnerBaseAbstract.isGB(list2));
        groebnerBaseAbstract = GBAlgorithmBuilder.polynomialRing(genPolynomialRing).syzygyPairlist().build();
        l = System.currentTimeMillis();
        list2 = groebnerBaseAbstract.GB(list);
        l = System.currentTimeMillis() - l;
        GBAlgorithmBuilderTest.assertTrue((String)"isGB: ", (boolean)groebnerBaseAbstract.isGB(list2));
        groebnerBaseAbstract = GBAlgorithmBuilder.polynomialRing(genPolynomialRing).simplePairlist().build();
        l = System.currentTimeMillis();
        list2 = groebnerBaseAbstract.GB(list);
        l = System.currentTimeMillis() - l;
        GBAlgorithmBuilderTest.assertTrue((String)"isGB: ", (boolean)groebnerBaseAbstract.isGB(list2));
        GBAlgorithmBuilderTest.assertTrue((String)"t >= 0: ", (l >= 0L ? 1 : 0) != 0);
    }

    public void testConstructionRationalIterate() {
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"a", "b", "c"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, stringArray);
        GBAlgorithmBuilder<BigRational> gBAlgorithmBuilder = GBAlgorithmBuilder.polynomialRing(genPolynomialRing);
        gBAlgorithmBuilder = gBAlgorithmBuilder.iterated();
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = gBAlgorithmBuilder.build();
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GroebnerBaseSeqIter));
        gBAlgorithmBuilder = GBAlgorithmBuilder.polynomialRing(genPolynomialRing);
        gBAlgorithmBuilder = gBAlgorithmBuilder.iterated().parallel();
        groebnerBaseAbstract = gBAlgorithmBuilder.build();
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GBProxy));
        GBProxy gBProxy = (GBProxy)groebnerBaseAbstract;
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + gBProxy.e1), (boolean)(gBProxy.e1 instanceof GroebnerBaseSeqIter));
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + gBProxy.e2), (boolean)(gBProxy.e2 instanceof GroebnerBaseParIter));
    }

    public void testConstructionRationalSignatureBased() {
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"a", "b", "c"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, stringArray);
        GBAlgorithmBuilder<BigRational> gBAlgorithmBuilder = GBAlgorithmBuilder.polynomialRing(genPolynomialRing);
        gBAlgorithmBuilder = gBAlgorithmBuilder.F5();
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = gBAlgorithmBuilder.build();
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GroebnerBaseSigSeqIter));
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GroebnerBaseF5zSigSeqIter));
        gBAlgorithmBuilder = GBAlgorithmBuilder.polynomialRing(genPolynomialRing);
        gBAlgorithmBuilder = gBAlgorithmBuilder.GGV();
        groebnerBaseAbstract = gBAlgorithmBuilder.build();
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GroebnerBaseSigSeqIter));
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GroebnerBaseGGVSigSeqIter));
        gBAlgorithmBuilder = GBAlgorithmBuilder.polynomialRing(genPolynomialRing);
        gBAlgorithmBuilder = gBAlgorithmBuilder.Arri();
        groebnerBaseAbstract = gBAlgorithmBuilder.build();
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GroebnerBaseSigSeqIter));
        GBAlgorithmBuilderTest.assertTrue((String)("instance of " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GroebnerBaseArriSigSeqIter));
    }
}

