/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Ideal;
import edu.jas.application.Residue;
import edu.jas.application.ResidueRing;
import edu.jas.arith.BigInteger;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.PrimeList;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.Power;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.HenselMultUtil;
import edu.jas.ufd.NoLiftingException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class HenselMultUtilTest
extends TestCase {
    TermOrder tord = new TermOrder(2);
    GenPolynomialRing<BigInteger> dfac;
    GenPolynomialRing<BigInteger> cfac;
    GenPolynomialRing<GenPolynomial<BigInteger>> rfac;
    BigInteger ai;
    BigInteger bi;
    BigInteger ci;
    BigInteger di;
    BigInteger ei;
    GenPolynomial<BigInteger> a;
    GenPolynomial<BigInteger> b;
    GenPolynomial<BigInteger> c;
    GenPolynomial<BigInteger> d;
    GenPolynomial<BigInteger> e;
    int rl = 2;
    int kl = 5;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)HenselMultUtilTest.suite());
        ComputerThreads.terminate();
    }

    public HenselMultUtilTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(HenselMultUtilTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.tord);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl - 1, this.tord);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.tord);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
        ComputerThreads.terminate();
    }

    protected static java.math.BigInteger getPrime1() {
        return PrimeList.getLongPrime(60, 93);
    }

    protected static java.math.BigInteger getPrime2() {
        return PrimeList.getLongPrime(30, 35);
    }

    public void testDiophantLifting() {
        java.math.BigInteger bigInteger = new java.math.BigInteger("19");
        BigInteger bigInteger2 = new BigInteger(bigInteger);
        ModIntegerRing modIntegerRing = new ModIntegerRing(bigInteger, false);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 3, this.tord, new String[]{"x", "y", "z"});
        BigInteger bigInteger3 = bigInteger2;
        long l = 5L;
        long l2 = 3L;
        java.math.BigInteger bigInteger4 = bigInteger.pow((int)l);
        ModIntegerRing modIntegerRing2 = new ModIntegerRing(bigInteger4, false);
        GenPolynomialRing<ModInteger> genPolynomialRing2 = new GenPolynomialRing<ModInteger>(modIntegerRing2, genPolynomialRing);
        this.dfac = new GenPolynomialRing<BigInteger>(bigInteger3, genPolynomialRing);
        GreatestCommonDivisorAbstract<BigInteger> greatestCommonDivisorAbstract = GCDFactory.getImplementation(bigInteger3);
        ModInteger modInteger = modIntegerRing2.fromInteger(5L);
        ArrayList<ModInteger> arrayList = new ArrayList<ModInteger>(1);
        arrayList.add(modInteger);
        arrayList.add(modIntegerRing2.fromInteger(3L));
        for (int i = 1; i < 2; ++i) {
            this.a = this.dfac.random(this.kl + 7 * i, this.ll, this.el + 3, this.q).abs();
            this.b = this.dfac.random(this.kl + 7 * i, this.ll, this.el + 2, this.q).abs();
            this.c = greatestCommonDivisorAbstract.gcd(this.a, this.b);
            if (!this.c.isUnit()) continue;
            GenPolynomial<ModInteger> genPolynomial = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, this.a);
            GenPolynomial<ModInteger> genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, this.b);
            GenPolynomial<ModInteger> genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, this.c);
            try {
                List<GenPolynomial<ModInteger>> list = HenselMultUtil.liftDiophant(genPolynomial, genPolynomial2, genPolynomial3, arrayList, l2, l);
                GenPolynomial<ModInteger> genPolynomial4 = list.get(0);
                GenPolynomial<ModInteger> genPolynomial5 = list.get(1);
                GenPolynomialRing genPolynomialRing3 = genPolynomial4.ring;
                HenselMultUtilTest.assertEquals((String)("pkfac == qfac: " + genPolynomialRing3), genPolynomialRing2, genPolynomialRing3);
                GenPolynomial<GenPolynomial<GenPolynomial<ModInteger>>> genPolynomial6 = genPolynomial2.multiply((ModInteger)((Object)genPolynomial4)).sum((GenPolynomial<ModInteger>)genPolynomial.multiply((ModInteger)((Object)genPolynomial5)));
                HenselMultUtilTest.assertFalse((String)("rp != null: " + genPolynomial6), (genPolynomial6 == null ? 1 : 0) != 0);
                ModInteger modInteger2 = (ModInteger)genPolynomialRing2.coFac.fromInteger(((ModInteger)arrayList.get(0)).getSymmetricInteger().getVal());
                GenPolynomial<ModInteger> genPolynomial7 = genPolynomialRing2.univariate(1);
                genPolynomial7 = genPolynomial7.subtract(modInteger2);
                genPolynomial7 = Power.power(genPolynomialRing2, genPolynomial7, l2 + 1L);
                ArrayList arrayList2 = new ArrayList();
                arrayList2.add(genPolynomial7);
                modInteger2 = (ModInteger)genPolynomialRing2.coFac.fromInteger(((ModInteger)arrayList.get(1)).getSymmetricInteger().getVal());
                GenPolynomial<ModInteger> genPolynomial8 = genPolynomialRing2.univariate(0);
                genPolynomial8 = genPolynomial8.subtract(modInteger2);
                genPolynomial8 = Power.power(genPolynomialRing2, genPolynomial8, l2 + 1L);
                arrayList2.add(genPolynomial8);
                Ideal<ModInteger> ideal = new Ideal<ModInteger>(genPolynomialRing2, arrayList2);
                ResidueRing<ModInteger> residueRing = new ResidueRing<ModInteger>(ideal);
                Residue<ModInteger> residue = new Residue<ModInteger>(residueRing, genPolynomial);
                Residue<ModInteger> residue2 = new Residue<ModInteger>(residueRing, genPolynomial2);
                Residue<ModInteger> residue3 = new Residue<ModInteger>(residueRing, genPolynomial3);
                Residue<ModInteger> residue4 = new Residue<ModInteger>(residueRing, genPolynomial4);
                Residue<ModInteger> residue5 = new Residue<ModInteger>(residueRing, genPolynomial5);
                Residue<ModInteger> residue6 = residue2.multiply(residue4).sum(residue.multiply(residue5));
                HenselMultUtilTest.assertEquals((String)"ar sr + br tr = cr ", residue3, residue6);
                continue;
            }
            catch (NoLiftingException noLiftingException) {
                System.out.println("e = " + noLiftingException);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void testDiophantLiftingList() {
        java.math.BigInteger bigInteger = new java.math.BigInteger("19");
        BigInteger bigInteger2 = new BigInteger(bigInteger);
        ModIntegerRing modIntegerRing = new ModIntegerRing(bigInteger, false);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 3, this.tord, new String[]{"x", "y", "z"});
        BigInteger bigInteger3 = bigInteger2;
        long l = 5L;
        long l2 = 3L;
        java.math.BigInteger bigInteger4 = bigInteger.pow((int)l);
        ModIntegerRing modIntegerRing2 = new ModIntegerRing(bigInteger4, false);
        GenPolynomialRing<ModInteger> genPolynomialRing2 = new GenPolynomialRing<ModInteger>(modIntegerRing2, genPolynomialRing);
        this.dfac = new GenPolynomialRing<BigInteger>(bigInteger3, genPolynomialRing);
        GreatestCommonDivisorAbstract<BigInteger> greatestCommonDivisorAbstract = GCDFactory.getImplementation(bigInteger3);
        ModInteger modInteger = modIntegerRing2.fromInteger(5L);
        ArrayList<ModInteger> arrayList = new ArrayList<ModInteger>(1);
        arrayList.add(modInteger);
        arrayList.add(modIntegerRing2.fromInteger(3L));
        if (genPolynomialRing2.nvar > 3) {
            arrayList.add(modIntegerRing2.fromInteger(7L));
        }
        List list = new ArrayList();
        for (int i = 1; i < 2; ++i) {
            Iterable<Monomial<Object>> iterable;
            this.a = this.dfac.random(this.kl + 7 * i, this.ll, this.el + 3, this.q).abs();
            this.b = this.dfac.random(this.kl + 7 * i, this.ll, this.el + 2, this.q).abs();
            this.c = this.dfac.random(this.kl + 7 * i, this.ll, this.el + 2, this.q).abs();
            list.add(this.a);
            list.add(this.b);
            list.add(this.c);
            list = greatestCommonDivisorAbstract.coPrime(list);
            if (list.size() == 0) continue;
            ArrayList arrayList3 = new ArrayList(list.size());
            for (GenPolynomial<BigInteger> genPolynomial : list) {
                GenPolynomial<ModInteger> genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, genPolynomial);
                arrayList3.add(genPolynomial2);
            }
            Element element = genPolynomialRing2.parse(" x y z + x y + x ");
            GenPolynomial<GenPolynomial> genPolynomial = genPolynomialRing2.getONE();
            for (GenPolynomial genPolynomial3 : arrayList3) {
                genPolynomial = genPolynomial.multiply(genPolynomial3);
            }
            ArrayList<GenPolynomial<GenPolynomial>> arrayList22 = new ArrayList<GenPolynomial<GenPolynomial>>(list.size());
            for (Iterable iterable2 : arrayList3) {
                iterable = PolyUtil.basePseudoDivide(genPolynomial, iterable2);
                if (((GenPolynomial)iterable).isZERO()) {
                    System.out.println("b == 0");
                    return;
                }
                arrayList22.add((GenPolynomial<GenPolynomial>)iterable);
            }
            try {
                void var31_42;
                Iterable<Monomial<Object>> iterable3;
                Serializable serializable;
                Iterable iterable2;
                List list2 = HenselMultUtil.liftDiophant(arrayList3, element, arrayList, l2, l);
                iterable2 = list2.get((int)0).ring;
                HenselMultUtilTest.assertEquals((String)("pkfac == qfac: " + iterable2), genPolynomialRing2, (Object)iterable2);
                iterable = new ArrayList();
                for (int j = 0; j < arrayList.size(); ++j) {
                    serializable = (ModInteger)genPolynomialRing2.coFac.fromInteger(((ModInteger)arrayList.get(j)).getSymmetricInteger().getVal());
                    iterable3 = genPolynomialRing2.univariate(genPolynomialRing2.nvar - 2 - j);
                    iterable3 = ((GenPolynomial)iterable3).subtract((ModInteger)serializable);
                    iterable.add(iterable3);
                }
                Ideal<ModInteger> ideal = new Ideal<ModInteger>(genPolynomialRing2, (List<GenPolynomial<ModInteger>>)iterable);
                ideal = ideal.power((int)l2 + 1);
                serializable = new ResidueRing<ModInteger>(ideal);
                iterable3 = new ArrayList(list.size());
                for (GenPolynomial genPolynomial4 : arrayList22) {
                    Residue residue = new Residue(serializable, genPolynomial4);
                    iterable3.add(residue);
                }
                ArrayList arrayList2 = new ArrayList(list.size());
                for (GenPolynomial genPolynomial5 : list2) {
                    Residue residue = new Residue(serializable, genPolynomial5);
                    if (residue.isZERO()) {
                        System.out.println("apr == 0: " + genPolynomial5);
                    }
                    arrayList2.add(residue);
                }
                Residue residue = new Residue(serializable, element);
                AbelianGroupElem abelianGroupElem = ((ResidueRing)serializable).getZERO();
                int n = 0;
                for (Residue residue2 : iterable3) {
                    Residue residue3 = var31_42.sum(residue2.multiply((Residue)arrayList2.get(n++)));
                }
                HenselMultUtilTest.assertEquals((String)"sum_i( br sr ) = cr ", residue, (Object)var31_42);
                continue;
            }
            catch (ArithmeticException arithmeticException) {
                continue;
            }
            catch (NoLiftingException noLiftingException) {
                System.out.println("e = " + noLiftingException);
            }
        }
    }
}

