/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Ideal;
import edu.jas.application.IdealWithUniv;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.Rational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IdealWithRealAlgebraicRoots<D extends GcdRingElem<D> & Rational>
extends IdealWithUniv<D> {
    public final List<List<RealAlgebraicNumber<D>>> ran;
    protected List<List<BigDecimal>> droots = null;

    protected IdealWithRealAlgebraicRoots() {
        throw new IllegalArgumentException("do not use this constructor");
    }

    public IdealWithRealAlgebraicRoots(Ideal<D> ideal, List<GenPolynomial<D>> list, List<List<RealAlgebraicNumber<D>>> list2) {
        super(ideal, list);
        this.ran = list2;
    }

    public IdealWithRealAlgebraicRoots(IdealWithUniv<D> idealWithUniv, List<List<RealAlgebraicNumber<D>>> list) {
        super(idealWithUniv.ideal, idealWithUniv.upolys);
        this.ran = list;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString() + "\nreal roots:\n");
        stringBuffer.append("[");
        boolean bl = true;
        for (List<RealAlgebraicNumber<D>> list : this.ran) {
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            stringBuffer.append("[");
            boolean bl2 = true;
            for (RealAlgebraicNumber<D> realAlgebraicNumber : list) {
                if (!bl2) {
                    stringBuffer.append(", ");
                } else {
                    bl2 = false;
                }
                stringBuffer.append(realAlgebraicNumber.ring.toScript());
            }
            stringBuffer.append("]");
        }
        stringBuffer.append("]");
        if (this.droots != null) {
            stringBuffer.append("\ndecimal real root approximation:\n");
            for (List<GcdRingElem<RealAlgebraicNumber<Object>>> list : this.droots) {
                stringBuffer.append(list.toString());
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String toScript() {
        return super.toScript() + ",  " + this.ran.toString();
    }

    public synchronized List<List<BigDecimal>> decimalApproximation() {
        if (this.droots != null) {
            return this.droots;
        }
        ArrayList<List<BigDecimal>> arrayList = new ArrayList<List<BigDecimal>>();
        for (List<RealAlgebraicNumber<D>> list : this.ran) {
            ArrayList<BigDecimal> arrayList2 = new ArrayList<BigDecimal>();
            for (RealAlgebraicNumber<D> realAlgebraicNumber : list) {
                BigDecimal bigDecimal = new BigDecimal(realAlgebraicNumber.magnitude());
                arrayList2.add(bigDecimal);
            }
            arrayList.add(arrayList2);
        }
        this.droots = arrayList;
        return arrayList;
    }

    public void doDecimalApproximation() {
        List<List<BigDecimal>> list = this.decimalApproximation();
        if (list.isEmpty()) {
            System.out.println("unused is empty");
        }
    }

    public synchronized boolean isDecimalApproximation() {
        RingElem<BigDecimal> ringElem;
        this.doDecimalApproximation();
        if (this.droots == null || this.droots.size() == 0) {
            return true;
        }
        if (this.upolys == null || this.upolys.size() == 0) {
            return true;
        }
        BigDecimal bigDecimal = this.droots.get(0).get(0);
        BigDecimal bigDecimal2 = (BigDecimal)new BigDecimal("0.15").power(BigDecimal.DEFAULT_PRECISION / 2);
        ArrayList arrayList = new ArrayList(this.upolys.size());
        for (GenPolynomial iterable2 : this.upolys) {
            GenPolynomialRing genPolynomialRing = iterable2.ring;
            Iterator iterator = new GenPolynomialRing<BigDecimal>(bigDecimal, genPolynomialRing);
            GenPolynomial genPolynomial = PolyUtil.decimalFromRational(iterator, iterable2);
            arrayList.add(genPolynomial);
        }
        for (List list : this.droots) {
            int n = 0;
            for (GenPolynomial genPolynomial : arrayList) {
                BigDecimal bigDecimal3;
                ringElem = (BigDecimal)list.get(n++);
                Object object = PolyUtil.evaluateMain(bigDecimal, genPolynomial, ringElem);
                if (((BigDecimal)(object = ((BigDecimal)object).abs())).compareTo(bigDecimal2) < 0 || ((BigDecimal)object).compareTo(bigDecimal3 = (BigDecimal)new BigDecimal("0.1").power(BigDecimal.DEFAULT_PRECISION / 3)) < 0) continue;
                System.out.println("no root: z = " + object + ", cc = " + bigDecimal3);
                return false;
            }
        }
        GenPolynomialRing genPolynomialRing = this.ideal.list.ring;
        GenPolynomialRing<BigDecimal> genPolynomialRing2 = new GenPolynomialRing<BigDecimal>(bigDecimal, genPolynomialRing);
        List list = this.ideal.list.list;
        bigDecimal2 = (BigDecimal)new BigDecimal("0.15").power(BigDecimal.DEFAULT_PRECISION / 2 - 1);
        for (GenPolynomial genPolynomial : list) {
            ringElem = PolyUtil.decimalFromRational(genPolynomialRing2, genPolynomial);
            for (List list2 : this.droots) {
                BigDecimal bigDecimal4;
                BigDecimal bigDecimal5 = PolyUtil.evaluateAll(bigDecimal, ringElem, list2);
                if ((bigDecimal5 = bigDecimal5.abs()).compareTo(bigDecimal2) < 0 || bigDecimal5.compareTo(bigDecimal4 = (BigDecimal)new BigDecimal("0.1").power(BigDecimal.DEFAULT_PRECISION / 3)) < 0) continue;
                System.out.println("no root: z = " + bigDecimal5 + ", cc = " + bigDecimal4);
                System.out.println("ipd = " + ringElem + ", rr = " + list2);
                return false;
            }
        }
        return true;
    }
}

