/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.SolvableLocalRing;
import edu.jas.fd.FDUtil;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPair;
import edu.jas.structure.RingElem;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SolvableLocal<C extends GcdRingElem<C>>
implements GcdRingElem<SolvableLocal<C>>,
QuotPair<GenPolynomial<C>> {
    private static final Logger logger = LogManager.getLogger(SolvableLocal.class);
    private static final boolean debug = logger.isDebugEnabled();
    public final SolvableLocalRing<C> ring;
    public final GenSolvablePolynomial<C> num;
    public final GenSolvablePolynomial<C> den;
    protected int isunit = -1;

    public SolvableLocal(SolvableLocalRing<C> solvableLocalRing) {
        this(solvableLocalRing, (GenSolvablePolynomial<C>)solvableLocalRing.ring.getZERO());
    }

    public SolvableLocal(SolvableLocalRing<C> solvableLocalRing, GenSolvablePolynomial<C> genSolvablePolynomial) {
        this(solvableLocalRing, genSolvablePolynomial, (GenSolvablePolynomial<C>)solvableLocalRing.ring.getONE(), true);
    }

    public SolvableLocal(SolvableLocalRing<C> solvableLocalRing, GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        this(solvableLocalRing, genSolvablePolynomial, genSolvablePolynomial2, false);
    }

    protected SolvableLocal(SolvableLocalRing<C> solvableLocalRing, GenSolvablePolynomial<C> object, GenSolvablePolynomial<C> object2, boolean bl) {
        GenSolvablePolynomial genSolvablePolynomial;
        if (object2 == null || ((GenPolynomial)object2).isZERO()) {
            throw new IllegalArgumentException("denominator may not be zero");
        }
        this.ring = solvableLocalRing;
        if (((GenPolynomial)object2).signum() < 0) {
            object = (GenSolvablePolynomial)((GenPolynomial)object).negate();
            object2 = (GenSolvablePolynomial)((GenPolynomial)object2).negate();
        }
        if (bl) {
            this.num = object;
            this.den = object2;
            return;
        }
        if (debug) {
            System.out.println("n = " + object + ", d = " + object2);
        }
        if ((genSolvablePolynomial = this.ring.ideal.normalform(object2)) == null || genSolvablePolynomial.isZERO()) {
            throw new IllegalArgumentException("denominator may not be in ideal, d = " + object2);
        }
        GcdRingElem gcdRingElem = (GcdRingElem)((GenPolynomial)object2).leadingBaseCoefficient();
        if (!gcdRingElem.isONE() && gcdRingElem.isUnit()) {
            gcdRingElem = (GcdRingElem)gcdRingElem.inverse();
            object = ((GenSolvablePolynomial)object).multiplyLeft(gcdRingElem);
            object2 = ((GenSolvablePolynomial)object2).multiplyLeft(gcdRingElem);
        }
        if (((GenPolynomial)object).compareTo(object2) == 0) {
            this.num = this.ring.ring.getONE();
            this.den = this.ring.ring.getONE();
            return;
        }
        if (((GenPolynomial)((GenPolynomial)object).negate()).compareTo(object2) == 0) {
            this.num = (GenSolvablePolynomial)this.ring.ring.getONE().negate();
            this.den = this.ring.ring.getONE();
            return;
        }
        if (((GenPolynomial)object).isZERO()) {
            this.num = object;
            this.den = this.ring.ring.getONE();
            return;
        }
        if (((GenPolynomial)object).isONE()) {
            this.num = object;
            this.den = object2;
            return;
        }
        Object[] objectArray = FDUtil.leftGcdCofactors(solvableLocalRing.ring, object, object2);
        if (!objectArray[0].isONE()) {
            logger.info("constructor: gcd = " + Arrays.toString(objectArray));
            object = objectArray[1];
            object2 = objectArray[2];
        }
        if (!((GenPolynomial)(objectArray = FDUtil.rightGcdCofactors(solvableLocalRing.ring, object, object2))[0]).isONE()) {
            logger.info("constructor: gcd = " + Arrays.toString(objectArray));
            object = objectArray[1];
            object2 = objectArray[2];
        }
        Object[] objectArray2 = this.ring.engine.leftSimplifier(object, object2);
        logger.info("simp: " + Arrays.toString(objectArray2) + ", " + object + ", " + object2);
        this.num = objectArray2[0];
        this.den = objectArray2[1];
    }

    @Override
    public SolvableLocalRing<C> factory() {
        return this.ring;
    }

    @Override
    public GenSolvablePolynomial<C> numerator() {
        return this.num;
    }

    @Override
    public GenSolvablePolynomial<C> denominator() {
        return this.den;
    }

    @Override
    public SolvableLocal<C> copy() {
        return new SolvableLocal<C>(this.ring, this.num, this.den, true);
    }

    @Override
    public boolean isZERO() {
        return this.num.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.num.compareTo(this.den) == 0;
    }

    @Override
    public boolean isUnit() {
        if (this.isunit > 0) {
            return true;
        }
        if (this.isunit == 0) {
            return false;
        }
        if (this.num.isZERO()) {
            this.isunit = 0;
            return false;
        }
        GenSolvablePolynomial genSolvablePolynomial = this.ring.ideal.normalform(this.num);
        boolean bl = genSolvablePolynomial != null && !genSolvablePolynomial.isZERO();
        this.isunit = bl ? 1 : 0;
        return bl;
    }

    @Override
    public boolean isConstant() {
        return this.num.isConstant() && this.den.isConstant();
    }

    public String toString() {
        if (PrettyPrint.isTrue()) {
            String string = "{ " + this.num.toString(this.ring.ring.getVars());
            if (this.den.isONE()) {
                return string + " }";
            }
            return string + "| " + this.den.toString(this.ring.ring.getVars()) + " }";
        }
        return "SolvableLocal[ " + this.num.toString() + " | " + this.den.toString() + " ]";
    }

    @Override
    public String toScript() {
        if (this.den.isONE()) {
            return this.num.toScript();
        }
        return this.num.toScript() + " / " + this.den.toScript();
    }

    @Override
    public String toScriptFactory() {
        return ((SolvableLocalRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(SolvableLocal<C> solvableLocal) {
        int n;
        if (solvableLocal == null || solvableLocal.isZERO()) {
            return this.signum();
        }
        if (this.isZERO()) {
            return -solvableLocal.signum();
        }
        int n2 = this.num.signum();
        int n3 = (n2 - (n = solvableLocal.num.signum())) / 2;
        if (n3 != 0) {
            System.out.println("compareTo: t = " + n3);
            return n3;
        }
        if (this.den.compareTo(solvableLocal.den) == 0) {
            return this.num.compareTo(solvableLocal.num);
        }
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray = this.ring.engine.leftOreCond(this.den, solvableLocal.den);
        if (debug) {
            System.out.println("oc[0] den =<>= oc[1] b.den: (" + genSolvablePolynomialArray[0] + ") (" + this.den + ") = (" + genSolvablePolynomialArray[1] + ") (" + solvableLocal.den + ")");
        }
        GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>> genSolvablePolynomial = genSolvablePolynomialArray[0].multiply(this.num);
        GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial2 = genSolvablePolynomialArray[1].multiply(solvableLocal.num);
        return genSolvablePolynomial.compareTo((GenPolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>>)genSolvablePolynomial2);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SolvableLocal)) {
            return false;
        }
        SolvableLocal solvableLocal = null;
        try {
            solvableLocal = (SolvableLocal)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (solvableLocal == null) {
            return false;
        }
        return this.compareTo(solvableLocal) == 0;
    }

    @Override
    public int hashCode() {
        int n = this.ring.hashCode();
        n = 37 * n + this.num.hashCode();
        n = 37 * n + this.den.hashCode();
        return n;
    }

    @Override
    public SolvableLocal<C> abs() {
        return new SolvableLocal<C>(this.ring, (GenSolvablePolynomial)this.num.abs(), this.den, true);
    }

    @Override
    public SolvableLocal<C> sum(SolvableLocal<C> solvableLocal) {
        if (solvableLocal == null || solvableLocal.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return solvableLocal;
        }
        if (this.den.isONE() && solvableLocal.den.isONE()) {
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)this.num.sum(solvableLocal.num);
            return new SolvableLocal<C>(this.ring, genSolvablePolynomial, this.den, true);
        }
        if (this.den.compareTo(solvableLocal.den) == 0) {
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)this.num.sum(solvableLocal.num);
            return new SolvableLocal<C>(this.ring, genSolvablePolynomial, this.den, false);
        }
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray = this.ring.engine.leftOreCond(this.den, solvableLocal.den);
        if (debug) {
            System.out.println("oc[0] den =sum= oc[1] S.den: (" + genSolvablePolynomialArray[0] + ") (" + this.den + ") = (" + genSolvablePolynomialArray[1] + ") (" + solvableLocal.den + ")");
        }
        GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial = genSolvablePolynomialArray[0].multiply(this.den);
        GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>>> genSolvablePolynomial2 = genSolvablePolynomialArray[0].multiply(this.num);
        GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial3 = genSolvablePolynomialArray[1].multiply(solvableLocal.num);
        GenSolvablePolynomial genSolvablePolynomial4 = (GenSolvablePolynomial)genSolvablePolynomial2.sum(genSolvablePolynomial3);
        return new SolvableLocal<GenSolvablePolynomial<C>>(this.ring, genSolvablePolynomial4, genSolvablePolynomial, false);
    }

    @Override
    public SolvableLocal<C> negate() {
        return new SolvableLocal<C>(this.ring, (GenSolvablePolynomial)this.num.negate(), this.den, true);
    }

    @Override
    public int signum() {
        return this.num.signum();
    }

    @Override
    public SolvableLocal<C> subtract(SolvableLocal<C> solvableLocal) {
        return this.sum((SolvableLocal<C>)solvableLocal.negate());
    }

    @Override
    public SolvableLocal<C> divide(SolvableLocal<C> solvableLocal) {
        return this.multiply((C)solvableLocal.inverse());
    }

    @Override
    public SolvableLocal<C> inverse() {
        if (this.isONE()) {
            return this;
        }
        if (this.isUnit()) {
            return new SolvableLocal<C>(this.ring, this.den, this.num, true);
        }
        throw new ArithmeticException("element not invertible " + this);
    }

    @Override
    public SolvableLocal<C> remainder(SolvableLocal<C> solvableLocal) {
        if (solvableLocal.isUnit()) {
            return this.ring.getZERO();
        }
        throw new UnsupportedOperationException("remainder not implemented" + solvableLocal);
    }

    @Override
    public SolvableLocal<C> multiply(SolvableLocal<C> solvableLocal) {
        if (solvableLocal == null || solvableLocal.isZERO()) {
            return solvableLocal;
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (solvableLocal.isONE()) {
            return this;
        }
        if (this.isONE()) {
            return solvableLocal;
        }
        if (this.den.isONE() && solvableLocal.den.isONE()) {
            GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial = this.num.multiply(solvableLocal.num);
            return new SolvableLocal<GenSolvablePolynomial<C>>(this.ring, genSolvablePolynomial, this.den, true);
        }
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray = this.ring.engine.leftOreCond(this.num, solvableLocal.den);
        if (debug) {
            System.out.println("oc[0] num =mult= oc[1] S.den: (" + genSolvablePolynomialArray[0] + ") (" + this.num + ") = (" + genSolvablePolynomialArray[1] + ") (" + solvableLocal.den + ")");
        }
        GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial = genSolvablePolynomialArray[1].multiply(solvableLocal.num);
        GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial2 = genSolvablePolynomialArray[0].multiply(this.den);
        return new SolvableLocal<GenSolvablePolynomial<C>>(this.ring, genSolvablePolynomial, genSolvablePolynomial2, false);
    }

    @Override
    public SolvableLocal<C> multiply(GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (genSolvablePolynomial.isONE()) {
            return this;
        }
        SolvableLocal<C> solvableLocal = new SolvableLocal<C>(this.ring, genSolvablePolynomial);
        return this.multiply((C)solvableLocal);
    }

    @Override
    public SolvableLocal<C> multiply(C c) {
        if (c == null || c.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (c.isONE()) {
            return this;
        }
        GenPolynomial genPolynomial = ((GenSolvablePolynomial)this.ring.ring.getONE()).multiply((RingElem)c);
        return this.multiply((C)genPolynomial);
    }

    @Override
    public SolvableLocal<C> multiply(ExpVector expVector) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        if (this.num.isZERO()) {
            return this;
        }
        GenPolynomial genPolynomial = ((GenSolvablePolynomial)this.ring.ring.getONE()).multiply(expVector);
        return this.multiply((C)genPolynomial);
    }

    public SolvableLocal<C> monic() {
        if (this.num.isZERO()) {
            return this;
        }
        return this;
    }

    @Override
    public SolvableLocal<C> gcd(SolvableLocal<C> solvableLocal) {
        throw new UnsupportedOperationException("gcd not implemented " + this.getClass().getName());
    }

    public SolvableLocal<C>[] egcd(SolvableLocal<C> solvableLocal) {
        throw new UnsupportedOperationException("egcd not implemented " + this.getClass().getName());
    }
}

