/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigIntegerIterator;
import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.kern.StringUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public final class BigInteger
implements GcdRingElem<BigInteger>,
RingFactory<BigInteger>,
Iterable<BigInteger>,
Rational {
    public final java.math.BigInteger val;
    private static final Random random = new Random();
    public static final BigInteger ZERO = new BigInteger(java.math.BigInteger.ZERO);
    public static final BigInteger ONE = new BigInteger(java.math.BigInteger.ONE);
    public static final BigInteger TWO = new BigInteger(2L);
    private boolean nonNegative = true;

    public BigInteger(java.math.BigInteger bigInteger) {
        this.val = bigInteger;
    }

    public BigInteger(long l) {
        this.val = new java.math.BigInteger(String.valueOf(l));
    }

    public BigInteger(String string) {
        this.val = new java.math.BigInteger(string.trim());
    }

    public BigInteger() {
        this.val = java.math.BigInteger.ZERO;
    }

    public java.math.BigInteger getVal() {
        return this.val;
    }

    public long longValue() {
        return this.val.longValue();
    }

    public BigInteger factory() {
        return this;
    }

    @Override
    public List<BigInteger> generators() {
        ArrayList<BigInteger> arrayList = new ArrayList<BigInteger>(1);
        arrayList.add(this.getONE());
        return arrayList;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public BigInteger copy() {
        return new BigInteger(this.val);
    }

    @Override
    public BigInteger copy(BigInteger bigInteger) {
        return new BigInteger(bigInteger.val);
    }

    @Override
    public BigInteger getZERO() {
        return ZERO;
    }

    @Override
    public BigInteger getONE() {
        return ONE;
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public boolean isAssociative() {
        return true;
    }

    @Override
    public boolean isField() {
        return false;
    }

    @Override
    public java.math.BigInteger characteristic() {
        return java.math.BigInteger.ZERO;
    }

    @Override
    public BigInteger fromInteger(java.math.BigInteger bigInteger) {
        return new BigInteger(bigInteger);
    }

    public static BigInteger valueOf(java.math.BigInteger bigInteger) {
        return new BigInteger(bigInteger);
    }

    @Override
    public BigInteger fromInteger(long l) {
        return new BigInteger(l);
    }

    public static BigInteger valueOf(long l) {
        return new BigInteger(l);
    }

    @Override
    public boolean isZERO() {
        return this.val.signum() == 0;
    }

    @Override
    public boolean isONE() {
        return this.val.equals(java.math.BigInteger.ONE);
    }

    @Override
    public boolean isUnit() {
        return this.isONE() || this.negate().isONE();
    }

    public String toString() {
        return this.val.toString();
    }

    @Override
    public String toScript() {
        return this.toString();
    }

    @Override
    public String toScriptFactory() {
        return "ZZ()";
    }

    @Override
    public int compareTo(BigInteger bigInteger) {
        return this.val.compareTo(bigInteger.val);
    }

    public static int ICOMP(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger == null) {
            return -bigInteger2.signum();
        }
        return bigInteger.compareTo(bigInteger2);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof BigInteger)) {
            return false;
        }
        BigInteger bigInteger = (BigInteger)object;
        return this.val.equals(bigInteger.val);
    }

    @Override
    public int hashCode() {
        return this.val.hashCode();
    }

    @Override
    public BigInteger abs() {
        return new BigInteger(this.val.abs());
    }

    public static BigInteger IABS(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("null A not allowed");
        }
        return bigInteger.abs();
    }

    @Override
    public BigInteger negate() {
        return new BigInteger(this.val.negate());
    }

    public static BigInteger INEG(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("null A not allowed");
        }
        return bigInteger.negate();
    }

    @Override
    public int signum() {
        return this.val.signum();
    }

    public static int ISIGN(BigInteger bigInteger) {
        if (bigInteger == null) {
            return 0;
        }
        return bigInteger.signum();
    }

    @Override
    public BigInteger subtract(BigInteger bigInteger) {
        return new BigInteger(this.val.subtract(bigInteger.val));
    }

    public static BigInteger IDIF(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger == null) {
            return bigInteger2.negate();
        }
        return bigInteger.subtract(bigInteger2);
    }

    @Override
    public BigInteger divide(BigInteger bigInteger) {
        return new BigInteger(this.val.divide(bigInteger.val));
    }

    public static BigInteger IQ(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("null A not allowed");
        }
        return bigInteger.divide(bigInteger2);
    }

    @Override
    public BigInteger inverse() {
        if (this.isONE() || this.negate().isONE()) {
            return this;
        }
        throw new NotInvertibleException("element not invertible " + this + " :: BigInteger");
    }

    @Override
    public BigInteger remainder(BigInteger bigInteger) {
        return new BigInteger(this.val.remainder(bigInteger.val));
    }

    public static BigInteger IREM(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("null A not allowed");
        }
        return bigInteger.remainder(bigInteger2);
    }

    public BigInteger[] quotientRemainder(BigInteger bigInteger) {
        BigInteger[] bigIntegerArray = new BigInteger[2];
        java.math.BigInteger[] bigIntegerArray2 = this.val.divideAndRemainder(bigInteger.val);
        bigIntegerArray[0] = new BigInteger(bigIntegerArray2[0]);
        bigIntegerArray[1] = new BigInteger(bigIntegerArray2[1]);
        return bigIntegerArray;
    }

    public static BigInteger[] IQR(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("null A not allowed");
        }
        return bigInteger.quotientRemainder(bigInteger2);
    }

    @Override
    public BigInteger gcd(BigInteger bigInteger) {
        return new BigInteger(this.val.gcd(bigInteger.val));
    }

    public BigInteger[] egcd(BigInteger bigInteger) {
        BigInteger[] bigIntegerArray = new BigInteger[]{null, null, null};
        if (bigInteger == null || bigInteger.isZERO()) {
            bigIntegerArray[0] = this;
            return bigIntegerArray;
        }
        if (this.isZERO()) {
            bigIntegerArray[0] = bigInteger;
            return bigIntegerArray;
        }
        BigInteger bigInteger2 = this;
        BigInteger bigInteger3 = bigInteger;
        BigInteger bigInteger4 = ONE;
        BigInteger bigInteger5 = ZERO;
        BigInteger bigInteger6 = ZERO;
        BigInteger bigInteger7 = ONE;
        while (!bigInteger3.isZERO()) {
            BigInteger[] bigIntegerArray2 = bigInteger2.quotientRemainder(bigInteger3);
            bigInteger2 = bigIntegerArray2[0];
            BigInteger bigInteger8 = bigInteger4.subtract(bigInteger2.multiply(bigInteger5));
            BigInteger bigInteger9 = bigInteger6.subtract(bigInteger2.multiply(bigInteger7));
            bigInteger4 = bigInteger5;
            bigInteger6 = bigInteger7;
            bigInteger5 = bigInteger8;
            bigInteger7 = bigInteger9;
            bigInteger2 = bigInteger3;
            bigInteger3 = bigIntegerArray2[1];
        }
        if (bigInteger2.signum() < 0) {
            bigInteger2 = bigInteger2.negate();
            bigInteger4 = bigInteger4.negate();
            bigInteger6 = bigInteger6.negate();
        }
        bigIntegerArray[0] = bigInteger2;
        bigIntegerArray[1] = bigInteger4;
        bigIntegerArray[2] = bigInteger6;
        return bigIntegerArray;
    }

    public static BigInteger IGCD(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("null A not allowed");
        }
        return bigInteger.gcd(bigInteger2);
    }

    @Override
    public BigInteger random(int n) {
        return this.random(n, random);
    }

    @Override
    public BigInteger random(int n, Random random) {
        java.math.BigInteger bigInteger = new java.math.BigInteger(n, random);
        if (random.nextBoolean()) {
            bigInteger = bigInteger.negate();
        }
        return new BigInteger(bigInteger);
    }

    public static BigInteger IRAND(int n) {
        return ONE.random(n, random);
    }

    @Override
    public BigInteger multiply(BigInteger bigInteger) {
        return new BigInteger(this.val.multiply(bigInteger.val));
    }

    public BigInteger shiftLeft(int n) {
        return new BigInteger(this.val.shiftLeft(n));
    }

    public static BigInteger IPROD(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("null A not allowed");
        }
        return bigInteger.multiply(bigInteger2);
    }

    @Override
    public BigInteger sum(BigInteger bigInteger) {
        return new BigInteger(this.val.add(bigInteger.val));
    }

    public static BigInteger ISUM(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("null A not allowed");
        }
        return bigInteger.sum(bigInteger2);
    }

    @Override
    public BigInteger parse(String string) {
        return new BigInteger(string);
    }

    @Override
    public BigInteger parse(Reader reader) {
        return this.parse(StringUtil.nextString(reader));
    }

    @Override
    public BigRational getRational() {
        return new BigRational(this.val);
    }

    public long bitLength() {
        long l = this.val.bitLength();
        if (this.val.signum() < 0) {
            ++l;
        }
        return ++l;
    }

    public static long bitLength(long l) {
        long l2 = 64 - Long.numberOfLeadingZeros(l);
        return ++l2;
    }

    public void setAllIterator() {
        this.nonNegative = false;
    }

    public void setNonNegativeIterator() {
        this.nonNegative = true;
    }

    @Override
    public Iterator<BigInteger> iterator() {
        return new BigIntegerIterator(this.nonNegative);
    }
}

