/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModInt;
import edu.jas.arith.ModIntIterator;
import edu.jas.arith.ModularRingFactory;
import edu.jas.kern.StringUtil;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public final class ModIntRing
implements ModularRingFactory<ModInt>,
Iterable<ModInt> {
    public final int modul;
    private static final Random random = new Random();
    private int isField = -1;
    public static final java.math.BigInteger MAX_INT = new java.math.BigInteger(String.valueOf(Short.MAX_VALUE));

    public ModIntRing(int n) {
        this.modul = n;
    }

    public ModIntRing(int n, boolean bl) {
        this.modul = n;
        this.isField = bl ? 1 : 0;
    }

    public ModIntRing(Integer n) {
        this((int)n);
    }

    public ModIntRing(Integer n, boolean bl) {
        this((int)n, bl);
    }

    public ModIntRing(java.math.BigInteger bigInteger) {
        this(bigInteger.intValue());
        if (MAX_INT.compareTo(bigInteger) < 0) {
            throw new IllegalArgumentException("modul to large for int " + bigInteger + ", max=" + MAX_INT);
        }
    }

    public ModIntRing(java.math.BigInteger bigInteger, boolean bl) {
        this(bigInteger.intValue(), bl);
        if (MAX_INT.compareTo(bigInteger) < 0) {
            throw new IllegalArgumentException("modul to large for int " + bigInteger + ", max=" + MAX_INT);
        }
    }

    public ModIntRing(String string) {
        this(Integer.valueOf(string.trim()));
    }

    public ModIntRing(String string, boolean bl) {
        this(Integer.valueOf(string.trim()), bl);
    }

    public java.math.BigInteger getModul() {
        return new java.math.BigInteger(Integer.toString(this.modul));
    }

    public int getIntModul() {
        return this.modul;
    }

    @Override
    public BigInteger getIntegerModul() {
        return new BigInteger(this.modul);
    }

    public ModInt create(java.math.BigInteger bigInteger) {
        return new ModInt(this, bigInteger);
    }

    public ModInt create(int n) {
        return new ModInt(this, n);
    }

    public ModInt create(String string) {
        return this.parse(string);
    }

    @Override
    public ModInt copy(ModInt modInt) {
        return new ModInt(this, modInt.val);
    }

    @Override
    public ModInt getZERO() {
        return new ModInt(this, 0);
    }

    @Override
    public ModInt getONE() {
        return new ModInt(this, 1);
    }

    @Override
    public List<ModInt> generators() {
        ArrayList<ModInt> arrayList = new ArrayList<ModInt>(1);
        arrayList.add(this.getONE());
        return arrayList;
    }

    @Override
    public boolean isFinite() {
        return true;
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public boolean isAssociative() {
        return true;
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        java.math.BigInteger bigInteger = new java.math.BigInteger(Integer.toString(this.modul));
        if (bigInteger.isProbablePrime(bigInteger.bitLength())) {
            this.isField = 1;
            return true;
        }
        this.isField = 0;
        return false;
    }

    @Override
    public java.math.BigInteger characteristic() {
        return new java.math.BigInteger(Integer.toString(this.modul));
    }

    @Override
    public ModInt fromInteger(java.math.BigInteger bigInteger) {
        return new ModInt(this, bigInteger);
    }

    public ModInt fromInteger(int n) {
        return new ModInt(this, n);
    }

    @Override
    public ModInt fromInteger(long l) {
        return new ModInt(this, l);
    }

    public String toString() {
        return " mod(" + this.modul + ")";
    }

    @Override
    public String toScript() {
        if (this.isField()) {
            return "GFI(" + this.modul + ")";
        }
        return "ZMI(" + this.modul + ")";
    }

    public boolean equals(Object object) {
        if (!(object instanceof ModIntRing)) {
            return false;
        }
        ModIntRing modIntRing = (ModIntRing)object;
        return this.modul == modIntRing.modul;
    }

    public int hashCode() {
        return this.modul;
    }

    @Override
    public ModInt random(int n) {
        return this.random(n, random);
    }

    @Override
    public ModInt random(int n, Random random) {
        java.math.BigInteger bigInteger = new java.math.BigInteger(n, random);
        return new ModInt(this, bigInteger);
    }

    @Override
    public ModInt parse(String string) {
        return new ModInt(this, string);
    }

    @Override
    public ModInt parse(Reader reader) {
        return this.parse(StringUtil.nextString(reader));
    }

    @Override
    public ModInt chineseRemainder(ModInt modInt, ModInt modInt2, ModInt modInt3) {
        ModInt modInt4 = modInt3.ring.fromInteger(modInt.val);
        ModInt modInt5 = modInt3.subtract(modInt4);
        if (modInt5.isZERO()) {
            return new ModInt(this, modInt.val);
        }
        modInt4 = modInt5.multiply(modInt2);
        int n = modInt.ring.modul * modInt4.val;
        return new ModInt(this, n += modInt.val);
    }

    public static List<ModInt> chineseRemainder(ModInt modInt, ModInt modInt2, List<ModInt> list, List<ModInt> list2) {
        int n = modInt.ring.modul * modInt2.ring.modul;
        ModIntRing modIntRing = new ModIntRing(n);
        ModInt modInt3 = modInt2.ring.fromInteger(modInt.ring.modul);
        ModInt modInt4 = modInt3.inverse();
        ArrayList<ModInt> arrayList = new ArrayList<ModInt>();
        for (ModInt modInt5 : list) {
            for (ModInt modInt6 : list2) {
                ModInt modInt7 = modIntRing.chineseRemainder(modInt5, modInt4, modInt6);
                arrayList.add(modInt7);
            }
        }
        return arrayList;
    }

    @Override
    public Iterator<ModInt> iterator() {
        return new ModIntIterator(this);
    }
}

