/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.Modular;
import edu.jas.arith.ModularNotInvertibleException;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.NotInvertibleException;

public final class ModInteger
implements GcdRingElem<ModInteger>,
Modular {
    public final ModIntegerRing ring;
    public final java.math.BigInteger val;

    public ModInteger(ModIntegerRing modIntegerRing, java.math.BigInteger bigInteger) {
        this.ring = modIntegerRing;
        this.val = bigInteger.mod(this.ring.modul);
    }

    public ModInteger(ModIntegerRing modIntegerRing, long l) {
        this(modIntegerRing, new java.math.BigInteger(String.valueOf(l)));
    }

    public ModInteger(ModIntegerRing modIntegerRing, String string) {
        this(modIntegerRing, new java.math.BigInteger(string.trim()));
    }

    public ModInteger(ModIntegerRing modIntegerRing) {
        this(modIntegerRing, java.math.BigInteger.ZERO);
    }

    public java.math.BigInteger getVal() {
        return this.val;
    }

    public java.math.BigInteger getModul() {
        return this.ring.modul;
    }

    public ModIntegerRing factory() {
        return this.ring;
    }

    public java.math.BigInteger getSymmetricVal() {
        if (this.val.add(this.val).compareTo(this.ring.modul) > 0) {
            return this.val.subtract(this.ring.modul);
        }
        return this.val;
    }

    @Override
    public BigInteger getInteger() {
        return new BigInteger(this.val);
    }

    @Override
    public BigInteger getSymmetricInteger() {
        java.math.BigInteger bigInteger = this.val;
        if (this.val.add(this.val).compareTo(this.ring.modul) > 0) {
            bigInteger = this.val.subtract(this.ring.modul);
        }
        return new BigInteger(bigInteger);
    }

    @Override
    public ModInteger copy() {
        return new ModInteger(this.ring, this.val);
    }

    @Override
    public boolean isZERO() {
        return this.val.signum() == 0;
    }

    @Override
    public boolean isONE() {
        return this.val.equals(java.math.BigInteger.ONE);
    }

    @Override
    public boolean isUnit() {
        if (this.isZERO()) {
            return false;
        }
        if (this.ring.isField()) {
            return true;
        }
        java.math.BigInteger bigInteger = this.ring.modul.gcd(this.val).abs();
        return bigInteger.equals(java.math.BigInteger.ONE);
    }

    public String toString() {
        return this.val.toString();
    }

    @Override
    public String toScript() {
        return this.toString();
    }

    @Override
    public String toScriptFactory() {
        return this.factory().toScript();
    }

    @Override
    public int compareTo(ModInteger modInteger) {
        java.math.BigInteger bigInteger = modInteger.val;
        if (this.ring != modInteger.ring) {
            bigInteger = bigInteger.mod(this.ring.modul);
        }
        return this.val.compareTo(bigInteger);
    }

    public static int MICOMP(ModInteger modInteger, ModInteger modInteger2) {
        if (modInteger == null) {
            return -modInteger2.signum();
        }
        return modInteger.compareTo(modInteger2);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ModInteger)) {
            return false;
        }
        return 0 == this.compareTo((ModInteger)object);
    }

    @Override
    public int hashCode() {
        return this.val.hashCode();
    }

    @Override
    public ModInteger abs() {
        return new ModInteger(this.ring, this.val.abs());
    }

    public static ModInteger MIABS(ModInteger modInteger) {
        if (modInteger == null) {
            return null;
        }
        return modInteger.abs();
    }

    @Override
    public ModInteger negate() {
        return new ModInteger(this.ring, this.val.negate());
    }

    public static ModInteger MINEG(ModInteger modInteger) {
        if (modInteger == null) {
            return null;
        }
        return modInteger.negate();
    }

    @Override
    public int signum() {
        return this.val.signum();
    }

    public static int MISIGN(ModInteger modInteger) {
        if (modInteger == null) {
            return 0;
        }
        return modInteger.signum();
    }

    @Override
    public ModInteger subtract(ModInteger modInteger) {
        return new ModInteger(this.ring, this.val.subtract(modInteger.val));
    }

    public static ModInteger MIDIF(ModInteger modInteger, ModInteger modInteger2) {
        if (modInteger == null) {
            return modInteger2.negate();
        }
        return modInteger.subtract(modInteger2);
    }

    @Override
    public ModInteger divide(ModInteger modInteger) {
        try {
            return this.multiply(modInteger.inverse());
        }
        catch (NotInvertibleException notInvertibleException) {
            try {
                if (this.val.remainder(modInteger.val).equals(java.math.BigInteger.ZERO)) {
                    return new ModInteger(this.ring, this.val.divide(modInteger.val));
                }
                throw new NotInvertibleException(notInvertibleException);
            }
            catch (ArithmeticException arithmeticException) {
                throw new NotInvertibleException(arithmeticException);
            }
        }
    }

    public static ModInteger MIQ(ModInteger modInteger, ModInteger modInteger2) {
        if (modInteger == null) {
            return null;
        }
        return modInteger.divide(modInteger2);
    }

    @Override
    public ModInteger inverse() {
        try {
            return new ModInteger(this.ring, this.val.modInverse(this.ring.modul));
        }
        catch (ArithmeticException arithmeticException) {
            java.math.BigInteger bigInteger = this.val.gcd(this.ring.modul);
            java.math.BigInteger bigInteger2 = this.ring.modul.divide(bigInteger);
            throw new ModularNotInvertibleException(arithmeticException, (GcdRingElem)new BigInteger(this.ring.modul), (GcdRingElem)new BigInteger(bigInteger), (GcdRingElem)new BigInteger(bigInteger2));
        }
    }

    public static ModInteger MIINV(ModInteger modInteger) {
        if (modInteger == null) {
            return null;
        }
        return modInteger.inverse();
    }

    @Override
    public ModInteger remainder(ModInteger modInteger) {
        if (modInteger == null || modInteger.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        if (modInteger.isONE()) {
            return this.ring.getZERO();
        }
        if (modInteger.isUnit()) {
            return this.ring.getZERO();
        }
        return new ModInteger(this.ring, this.val.remainder(modInteger.val));
    }

    public static ModInteger MIREM(ModInteger modInteger, ModInteger modInteger2) {
        if (modInteger == null) {
            return null;
        }
        return modInteger.remainder(modInteger2);
    }

    public ModInteger[] quotientRemainder(ModInteger modInteger) {
        return new ModInteger[]{this.divide(modInteger), this.remainder(modInteger)};
    }

    @Override
    public ModInteger multiply(ModInteger modInteger) {
        return new ModInteger(this.ring, this.val.multiply(modInteger.val));
    }

    public static ModInteger MIPROD(ModInteger modInteger, ModInteger modInteger2) {
        if (modInteger == null) {
            return null;
        }
        return modInteger.multiply(modInteger2);
    }

    @Override
    public ModInteger sum(ModInteger modInteger) {
        return new ModInteger(this.ring, this.val.add(modInteger.val));
    }

    public static ModInteger MISUM(ModInteger modInteger, ModInteger modInteger2) {
        if (modInteger == null) {
            return null;
        }
        return modInteger.sum(modInteger2);
    }

    @Override
    public ModInteger gcd(ModInteger modInteger) {
        if (modInteger.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return modInteger;
        }
        if (this.isUnit() || modInteger.isUnit()) {
            return this.ring.getONE();
        }
        return new ModInteger(this.ring, this.val.gcd(modInteger.val));
    }

    public ModInteger[] hegcd(ModInteger modInteger) {
        ModInteger[] modIntegerArray = new ModInteger[]{null, null};
        if (modInteger == null || modInteger.isZERO()) {
            modIntegerArray[0] = this;
            modIntegerArray[1] = this.ring.getONE();
            return modIntegerArray;
        }
        if (this.isZERO()) {
            modIntegerArray[0] = modInteger;
            return modIntegerArray;
        }
        java.math.BigInteger bigInteger = this.val;
        java.math.BigInteger bigInteger2 = modInteger.val;
        java.math.BigInteger bigInteger3 = BigInteger.ONE.val;
        java.math.BigInteger bigInteger4 = BigInteger.ZERO.val;
        while (!bigInteger2.equals(java.math.BigInteger.ZERO)) {
            java.math.BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(bigInteger2);
            bigInteger = bigIntegerArray[0];
            java.math.BigInteger bigInteger5 = bigInteger3.subtract(bigInteger.multiply(bigInteger4));
            bigInteger3 = bigInteger4;
            bigInteger4 = bigInteger5;
            bigInteger = bigInteger2;
            bigInteger2 = bigIntegerArray[1];
        }
        modIntegerArray[0] = new ModInteger(this.ring, bigInteger);
        modIntegerArray[1] = new ModInteger(this.ring, bigInteger3);
        return modIntegerArray;
    }

    public ModInteger[] egcd(ModInteger modInteger) {
        ModInteger[] modIntegerArray = new ModInteger[]{null, null, null};
        if (modInteger == null || modInteger.isZERO()) {
            modIntegerArray[0] = this;
            return modIntegerArray;
        }
        if (this.isZERO()) {
            modIntegerArray[0] = modInteger;
            return modIntegerArray;
        }
        if (this.isUnit() || modInteger.isUnit()) {
            modIntegerArray[0] = this.ring.getONE();
            if (this.isUnit() && modInteger.isUnit()) {
                modIntegerArray[1] = this.ring.getONE();
                ModInteger modInteger2 = modIntegerArray[0].subtract(modIntegerArray[1].multiply(this));
                modIntegerArray[2] = modInteger2.divide(modInteger);
                return modIntegerArray;
            }
            if (this.isUnit()) {
                modIntegerArray[1] = this.inverse();
                modIntegerArray[2] = this.ring.getZERO();
                return modIntegerArray;
            }
            modIntegerArray[1] = this.ring.getZERO();
            modIntegerArray[2] = modInteger.inverse();
            return modIntegerArray;
        }
        java.math.BigInteger bigInteger = this.val;
        java.math.BigInteger bigInteger2 = modInteger.val;
        java.math.BigInteger bigInteger3 = BigInteger.ONE.val;
        java.math.BigInteger bigInteger4 = BigInteger.ZERO.val;
        java.math.BigInteger bigInteger5 = BigInteger.ZERO.val;
        java.math.BigInteger bigInteger6 = BigInteger.ONE.val;
        while (!bigInteger2.equals(java.math.BigInteger.ZERO)) {
            java.math.BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(bigInteger2);
            bigInteger = bigIntegerArray[0];
            java.math.BigInteger bigInteger7 = bigInteger3.subtract(bigInteger.multiply(bigInteger4));
            java.math.BigInteger bigInteger8 = bigInteger5.subtract(bigInteger.multiply(bigInteger6));
            bigInteger3 = bigInteger4;
            bigInteger5 = bigInteger6;
            bigInteger4 = bigInteger7;
            bigInteger6 = bigInteger8;
            bigInteger = bigInteger2;
            bigInteger2 = bigIntegerArray[1];
        }
        modIntegerArray[0] = new ModInteger(this.ring, bigInteger);
        modIntegerArray[1] = new ModInteger(this.ring, bigInteger3);
        modIntegerArray[2] = new ModInteger(this.ring, bigInteger5);
        return modIntegerArray;
    }

    public long bitLength() {
        long l = this.val.bitLength();
        if (this.val.signum() < 0) {
            ++l;
        }
        return ++l;
    }
}

