/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.PrimeList;
import edu.jas.arith.Roots;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class PrimeInteger {
    private static final Logger logger = LogManager.getLogger(PrimeInteger.class);
    public static final long BETA = PrimeList.getLongPrime(61, 1).longValue();
    static final long IMPDS_MIN = 10000L;
    static final long IMPDS_MAX = 128000L;
    public static final List<Long> SMPRM = PrimeInteger.smallPrimes(2L, 5000);
    public static final List<Long> UZ210 = PrimeInteger.getUZ210();
    static final Random random = new Random();

    /*
     * Unable to fully structure code
     */
    public static List<Long> smallPrimes(long var0, int var2_1) {
        var4_2 = var0;
        if (var4_2 <= 1L) {
            var4_2 = 1L;
        }
        if ((var0 = var4_2) % 2L == 0L) {
            ++var0;
            --var2_1;
        }
        var3_3 = var2_1;
        var6_4 = 2 * (var3_3 - 1);
        var8_5 = var0 + var6_4;
        var10_6 = new BitSet(var3_3);
        var10_6.set(0, var3_3);
        var12_7 = 0;
        var14_8 = 0;
        block6: while (true) {
            switch (var14_8) {
                case 2: {
                    var12_7 += 2;
                    var14_8 = 3;
                    break;
                }
                case 3: {
                    var12_7 += 4;
                    var14_8 = 2;
                    break;
                }
                case 0: {
                    var12_7 = 3;
                    var14_8 = 1;
                    break;
                }
                case 1: {
                    var12_7 = 5;
                    var14_8 = 2;
                    break;
                }
                default: {
                    throw new RuntimeException("this should not happen");
                }
            }
            if ((long)var12_7 > var8_5 / (long)var12_7) break;
            var11_9 = (int)(var0 % (long)var12_7);
            if ((long)var11_9 + var6_4 < (long)var12_7 && var11_9 != 0) continue;
            var13_10 = var11_9 == 0 ? 0 : (var11_9 % 2 == 0 ? var12_7 - var11_9 / 2 : (var12_7 - var11_9) / 2);
            if (var0 <= (long)var12_7) {
                var13_10 += var12_7;
            }
            while (true) {
                if (var13_10 < var3_3) ** break;
                continue block6;
                var10_6.set(var13_10, false);
                var13_10 += var12_7;
            }
            break;
        }
        var15_11 = var10_6.cardinality();
        if (var4_2 <= 2L) {
            ++var15_11;
        }
        var16_12 = new ArrayList<Long>(var15_11);
        if (var15_11 == 0) {
            return var16_12;
        }
        if (var4_2 == 1L) {
            var10_6.set(0, false);
        }
        if (var4_2 <= 2L) {
            var16_12.add(2L);
        }
        var17_13 = var0;
        for (var13_10 = 0; var13_10 < var3_3; ++var13_10) {
            if (var10_6.get(var13_10)) {
                var16_12.add(var17_13);
            }
            var17_13 += 2L;
        }
        return var16_12;
    }

    public static long smallPrimeDivisors(long l, SortedMap<Long, Integer> sortedMap) {
        Integer n;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = l;
        List<Long> list = SMPRM;
        boolean bl = false;
        int n2 = 0;
        do {
            long l5 = list.get(n2);
            l2 = l4 / l5;
            l3 = l4 % l5;
            if (l3 == 0L) {
                n = (Integer)sortedMap.get(l5);
                if (n == null) {
                    n = 1;
                } else {
                    Integer n3 = n;
                    Integer n4 = n = Integer.valueOf(n + 1);
                }
                sortedMap.put(l5, n);
                l4 = l2;
            } else {
                ++n2;
            }
            boolean bl2 = bl = l2 <= l5;
        } while (!bl && n2 < list.size());
        if (bl && l4 != 1L) {
            n = (Integer)sortedMap.get(l4);
            n = n == null ? Integer.valueOf(1) : Integer.valueOf(n + 1);
            sortedMap.put(l4, n);
            l4 = 1L;
        }
        return l4;
    }

    public static java.math.BigInteger smallPrimeDivisors(java.math.BigInteger bigInteger, SortedMap<java.math.BigInteger, Integer> sortedMap) {
        Object object;
        java.math.BigInteger bigInteger2 = java.math.BigInteger.ZERO;
        java.math.BigInteger bigInteger3 = java.math.BigInteger.ZERO;
        java.math.BigInteger bigInteger4 = bigInteger;
        List<Long> list = SMPRM;
        boolean bl = false;
        int n = 0;
        do {
            java.math.BigInteger bigInteger5 = java.math.BigInteger.valueOf(list.get(n));
            object = bigInteger4.divideAndRemainder(bigInteger5);
            bigInteger2 = object[0];
            bigInteger3 = object[1];
            if (bigInteger3.equals(java.math.BigInteger.ZERO)) {
                Integer n2 = (Integer)sortedMap.get(bigInteger5);
                if (n2 == null) {
                    n2 = 1;
                } else {
                    Integer n3 = n2;
                    Integer n4 = n2 = Integer.valueOf(n2 + 1);
                }
                sortedMap.put(bigInteger5, n2);
                bigInteger4 = bigInteger2;
            } else {
                ++n;
            }
            boolean bl2 = bl = bigInteger2.compareTo(bigInteger5) <= 0;
        } while (!bl && n < list.size());
        if (bl && !bigInteger4.equals(java.math.BigInteger.ONE)) {
            object = (Integer)sortedMap.get(bigInteger4);
            object = object == null ? Integer.valueOf(1) : Integer.valueOf((Integer)object + 1);
            sortedMap.put(bigInteger4, (Integer)object);
            bigInteger4 = java.math.BigInteger.ONE;
        }
        return bigInteger4;
    }

    public static boolean isPrime(long l) {
        java.math.BigInteger bigInteger = java.math.BigInteger.valueOf(l);
        if (bigInteger.isProbablePrime(bigInteger.bitLength())) {
            return true;
        }
        SortedMap<Long, Integer> sortedMap = PrimeInteger.factors(l);
        return sortedMap.size() == 1 && sortedMap.values().contains(1);
    }

    public static boolean isPrimeFactorization(long l, SortedMap<Long, Integer> sortedMap) {
        long l2 = 1L;
        for (Map.Entry<Long, Integer> entry : sortedMap.entrySet()) {
            long l3 = entry.getKey();
            if (!PrimeInteger.isPrime(l3)) {
                return false;
            }
            int n = entry.getValue();
            long l4 = java.math.BigInteger.valueOf(l3).pow(n).longValue();
            l2 *= l4;
        }
        return l == l2;
    }

    public static boolean isFactorization(long l, SortedMap<Long, Integer> sortedMap) {
        long l2 = 1L;
        for (Map.Entry<Long, Integer> entry : sortedMap.entrySet()) {
            long l3 = entry.getKey();
            int n = entry.getValue();
            long l4 = java.math.BigInteger.valueOf(l3).pow(n).longValue();
            l2 *= l4;
        }
        return l == l2;
    }

    public static SortedMap<Long, Integer> factors(long l) {
        Integer n;
        long l2;
        long l3;
        Number number;
        long l4;
        if (l > BETA) {
            throw new UnsupportedOperationException("factors(long) only for longs less than BETA: " + BETA);
        }
        TreeMap<Long, Integer> treeMap = new TreeMap<Long, Integer>();
        SortedMap<Long, Integer> sortedMap = null;
        long l5 = PrimeInteger.smallPrimeDivisors(l, treeMap);
        if (l5 == 1L) {
            return treeMap;
        }
        long l6 = 10000L;
        do {
            long l7;
            long l8;
            long l9;
            if ((l9 = ((ModLong)new ModLong(new ModLongRing(l5), 3L).power(l8 = l5 - 1L)).getVal()) == 1L && (l7 = (long)PrimeInteger.primalityTestSelfridge(l5, l8, sortedMap = PrimeInteger.factors(l8))) == 1L) {
                logger.info("primalityTestSelfridge: FP = " + sortedMap);
                number = (Integer)treeMap.get(l5);
                number = number == null ? Integer.valueOf(1) : Integer.valueOf((Integer)number + 1);
                treeMap.put(l5, (Integer)number);
                return treeMap;
            }
            l3 = Roots.sqrtInt(new BigInteger(l5)).getVal().longValue();
            l2 = Math.max(128000L, l3 / 3L);
            if (l6 > l2) {
                l4 = 1L;
                continue;
            }
            logger.info("mediumPrimeDivisorSearch: a = " + l6 + ", b = " + l2);
            l4 = PrimeInteger.mediumPrimeDivisorSearch(l5, l6, l2);
            if (l4 == 1L) continue;
            l6 = l4;
            number = (Integer)treeMap.get(l4);
            number = number == null ? Integer.valueOf(1) : Integer.valueOf((Integer)number + 1);
            treeMap.put(l4, (Integer)number);
            l5 /= l4;
        } while (l4 != 1L);
        number = java.math.BigInteger.valueOf(l5);
        if (((java.math.BigInteger)number).isProbablePrime(((java.math.BigInteger)number).bitLength())) {
            treeMap.put(l5, 1);
            return treeMap;
        }
        l6 = l2;
        l2 = l3;
        logger.info("largePrimeDivisorSearch: a = " + l6 + ", b = " + l2 + ", m = " + l5);
        do {
            if ((l4 = PrimeInteger.largePrimeDivisorSearch(l5, l6, l2)) == 1L) continue;
            n = (Integer)treeMap.get(l4);
            if (n == null) {
                n = 1;
            } else {
                Integer n2 = n;
                Integer n3 = n = Integer.valueOf(n + 1);
            }
            treeMap.put(l4, n);
            l6 = l4;
            l3 = Roots.sqrtInt(BigInteger.valueOf(l5 /= l4)).getVal().longValue();
            l2 = Math.min(l2, l3);
            if (l6 <= l2) continue;
            l4 = 1L;
        } while (l4 != 1L);
        if (l5 != 1L) {
            n = (Integer)treeMap.get(l5);
            n = n == null ? Integer.valueOf(1) : Integer.valueOf(n + 1);
            treeMap.put(l5, n);
        }
        return treeMap;
    }

    public static SortedMap<Long, Integer> factorsPollard(long l) {
        if (l > BETA) {
            throw new UnsupportedOperationException("factors(long) only for longs less than BETA: " + BETA);
        }
        TreeMap<Long, Integer> treeMap = new TreeMap<Long, Integer>();
        PrimeInteger.factorsPollardRho(l, treeMap);
        return treeMap;
    }

    public static long mediumPrimeDivisorSearch(long l, long l2, long l3) {
        long l4;
        long l5;
        long l6 = l2 % 210L;
        List<Long> list = UZ210;
        long l7 = list.size();
        int n = 0;
        while (l6 > list.get(n)) {
            ++n;
        }
        long l8 = list.get(n);
        for (l4 = l2 + (l8 - l6); l4 <= l3; l4 += l5) {
            long l9;
            long l10 = l % l4;
            if (l10 == 0L) {
                return l4;
            }
            if ((long)(++n) >= l7) {
                list = UZ210;
                l9 = l8 - 210L;
                n = 0;
            } else {
                l9 = l8;
            }
            l8 = list.get(n);
            l5 = l8 - l9;
        }
        l4 = 1L;
        return l4;
    }

    public static int primalityTestSelfridge(long l, long l2, SortedMap<Long, Integer> sortedMap) {
        ArrayList<Map.Entry<Long, Integer>> arrayList = new ArrayList<Map.Entry<Long, Integer>>(sortedMap.entrySet());
        long l3 = 1L;
        long l4 = 1L;
        int n = 0;
        while (true) {
            long l5;
            long l6;
            long l7;
            if (n == arrayList.size()) {
                logger.info("SL=1: m = " + l);
                int n2 = 1;
                return n2;
            }
            long l8 = (Long)((Map.Entry)arrayList.get(n)).getKey();
            ++n;
            if (l8 <= l3) continue;
            l3 = l8;
            List<Long> list = SMPRM;
            int n3 = 0;
            do {
                if (n3 == list.size()) {
                    logger.info("SL=0: m = " + l);
                    int n4 = 0;
                    return n4;
                }
                l6 = list.get(n3);
                ++n3;
                if (l6 <= l4) continue;
                l4 = l6;
                long l9 = ((ModLong)new ModLong(new ModLongRing(l), l6).power(l2)).getVal();
                if (l9 == 1L) continue;
                logger.info("SL=-1: m = " + l);
                int n5 = -1;
                return n5;
            } while ((l7 = ((ModLong)new ModLong(new ModLongRing(l), l6).power(l5 = l2 / l8)).getVal()) == 1L);
        }
    }

    public static long largePrimeDivisorSearch(long l, long l2, long l3) {
        int n;
        if (l > BETA) {
            throw new UnsupportedOperationException("largePrimeDivisorSearch only for longs less than BETA: " + BETA);
        }
        List<ModLong> list = null;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = l / l3;
        long l7 = l % l3;
        long l8 = l3 + l6;
        l5 = l8 % 2L;
        l8 /= 2L;
        if (l7 != 0L || l5 != 0L) {
            ++l8;
        }
        l6 = l / l2;
        long l9 = l2 + l6;
        l9 /= 2L;
        list = PrimeInteger.residueListFermat(l);
        if (list.isEmpty()) {
            return l;
        }
        l4 = list.get((int)0).ring.getModul().longValue();
        Collections.sort(list);
        Collections.reverse(list);
        long l10 = l9 % l4;
        List<ModLong> list2 = list;
        for (n = 0; n < list2.size() && l10 < list2.get(n).getVal(); ++n) {
        }
        if (n == list2.size()) {
            n = 0;
            l5 = l4;
        } else {
            l5 = 0L;
        }
        long l11 = list2.get(n).getVal();
        ++n;
        l5 = l5 + l10 - l11;
        long l12 = 0L;
        for (long i = l9 - l5; i >= l8; i -= l5) {
            long l13;
            long l14 = i * i;
            long l15 = l14 - l;
            long l16 = Roots.sqrtInt(BigInteger.valueOf(l15)).getVal().longValue();
            l12 = l15 - l16 * l16;
            if (l12 == 0L) {
                long l17 = i - l16;
                return l17;
            }
            if (n < list2.size()) {
                l13 = list2.get(n).getVal();
                ++n;
                l5 = l11 - l13;
            } else {
                n = 0;
                l13 = list2.get(n).getVal();
                ++n;
                long l18 = l4 + l11;
                l5 = l18 - l13;
            }
            l11 = l13;
        }
        long l19 = 1L;
        return l19;
    }

    public static List<ModLong> residueListFermatSingle(long l, long l2) {
        ModLong modLong;
        int n;
        ModLongRing modLongRing = new ModLongRing(l);
        ModLong modLong2 = modLongRing.fromInteger(l2);
        int n2 = (int)(l / 2L);
        ArrayList<ModLong> arrayList = new ArrayList<ModLong>();
        for (n = 0; n <= n2; ++n) {
            modLong = modLongRing.fromInteger(n);
            modLong = modLong.multiply(modLong);
            arrayList.add(modLong);
        }
        TreeSet<ModLong> treeSet = new TreeSet<ModLong>();
        ArrayList<ModLong> arrayList2 = arrayList;
        for (n = n2; n >= 0; --n) {
            modLong = (ModLong)arrayList2.get(n);
            ModLong modLong3 = modLong.subtract(modLong2);
            int n3 = arrayList.indexOf(modLong3);
            if (n3 < 0) continue;
            modLong3 = modLongRing.fromInteger(n);
            treeSet.add(modLong3);
            ModLong modLong4 = modLong3.negate();
            if (modLong4.equals(modLong3)) continue;
            treeSet.add(modLong4);
        }
        ArrayList<ModLong> arrayList3 = new ArrayList<ModLong>(treeSet);
        return arrayList3;
    }

    public static List<ModLong> residueListFermat(long l) {
        long l2;
        List<Object> list;
        long l3;
        ModLongRing modLongRing;
        long l4;
        long l5;
        long l6;
        long l7 = 0L;
        long l8 = l % 32L;
        long l9 = l8 % 16L;
        long l10 = l9 % 8L;
        long l11 = l10 % 4L;
        if (l11 == 3L) {
            l6 = 4L;
            l7 = l10 == 3L ? 2L : 0L;
        } else if (l10 == 1L) {
            l6 = 8L;
            l7 = l9 == 1L ? 1L : 3L;
        } else {
            l6 = 16L;
            switch ((short)(l8 / 8L)) {
                case 0: {
                    l7 = 3L;
                    break;
                }
                case 1: {
                    l7 = 7L;
                    break;
                }
                case 2: {
                    l7 = 5L;
                    break;
                }
                case 3: {
                    l7 = 1L;
                    break;
                }
                default: {
                    throw new RuntimeException("this should not happen");
                }
            }
        }
        List<ModLong> list2 = new ArrayList<ModLong>();
        ModLongRing modLongRing2 = new ModLongRing(l6);
        if (l6 == 4L) {
            list2.add(modLongRing2.fromInteger(l7));
        } else {
            l5 = l6 - l7;
            list2.add(modLongRing2.fromInteger(l7));
            list2.add(modLongRing2.fromInteger(l5));
        }
        long l12 = list2.size();
        l8 = l % 27L;
        l9 = l8 % 3L;
        if (l9 == 2L) {
            l4 = 3L;
            modLongRing = new ModLongRing(l4);
            l3 = 1L;
            list = new ArrayList();
            list.add(modLongRing.fromInteger(0L));
        } else {
            l4 = 27L;
            modLongRing = new ModLongRing(l4);
            l3 = 4L;
            list = PrimeInteger.residueListFermatSingle(l4, l8);
        }
        list2 = ModLongRing.chineseRemainder(modLongRing2.getONE(), modLongRing.getONE(), list2, list);
        modLongRing2 = new ModLongRing(l6 *= l4);
        l12 *= l3;
        l8 = l % 25L;
        l9 = l8 % 5L;
        if (l9 == 2L || l9 == 3L) {
            l4 = 5L;
            modLongRing = new ModLongRing(l4);
            l5 = l9 - 1L;
            long l13 = 6L - l9;
            list = new ArrayList();
            list.add(modLongRing.fromInteger(l5));
            list.add(modLongRing.fromInteger(l13));
            l3 = 2L;
        } else {
            l4 = 25L;
            modLongRing = new ModLongRing(l4);
            list = PrimeInteger.residueListFermatSingle(l4, l8);
            l3 = 7L;
        }
        if (l4 >= BETA / l6) {
            return list2;
        }
        list2 = ModLongRing.chineseRemainder(modLongRing2.getONE(), modLongRing.getONE(), list2, list);
        modLongRing2 = new ModLongRing(l6 *= l4);
        l12 *= l3;
        list = new ArrayList();
        ArrayList<Long> arrayList = new ArrayList<Long>(3);
        ArrayList<Long> arrayList2 = new ArrayList<Long>(3);
        arrayList.add(7L);
        arrayList.add(11L);
        arrayList.add(13L);
        arrayList2.add(64L);
        arrayList2.add(48L);
        arrayList2.add(0L);
        int n = 0;
        do {
            if ((l4 = ((Long)arrayList.get(n)).longValue()) >= BETA / l6) {
                return list2;
            }
            modLongRing = new ModLongRing(l4);
            l8 = l % l4;
            list = PrimeInteger.residueListFermatSingle(l4, l8);
            l3 = list.size();
            list2 = ModLongRing.chineseRemainder(modLongRing2.getONE(), modLongRing.getONE(), list2, list);
            modLongRing2 = new ModLongRing(l6 *= l4);
            l2 = (Long)arrayList2.get(n);
            ++n;
        } while ((l12 *= l3) <= l2);
        return list2;
    }

    public static List<Long> getUZ210() {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        java.math.BigInteger bigInteger = java.math.BigInteger.valueOf(210L);
        for (long i = 1L; i <= 209L; i += 2L) {
            if (!bigInteger.gcd(java.math.BigInteger.valueOf(i)).equals(java.math.BigInteger.ONE)) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    public static SortedMap<java.math.BigInteger, Integer> factors(java.math.BigInteger bigInteger) {
        java.math.BigInteger bigInteger2 = java.math.BigInteger.valueOf(BETA);
        TreeMap<java.math.BigInteger, Integer> treeMap = new TreeMap<java.math.BigInteger, Integer>();
        if (bigInteger.compareTo(bigInteger2) > 0 && (bigInteger = PrimeInteger.smallPrimeDivisors(bigInteger, treeMap)).compareTo(bigInteger2) > 0) {
            logger.info("run factorsPollardRho on n = " + bigInteger);
            PrimeInteger.factorsPollardRho(bigInteger, treeMap);
            return treeMap;
        }
        long l = bigInteger.longValue();
        SortedMap<Long, Integer> sortedMap = PrimeInteger.factors(l);
        for (Map.Entry<Long, Integer> entry : sortedMap.entrySet()) {
            java.math.BigInteger bigInteger3 = java.math.BigInteger.valueOf(entry.getKey());
            treeMap.put(bigInteger3, entry.getValue());
        }
        return treeMap;
    }

    public static void factorsPollardRho(java.math.BigInteger bigInteger, SortedMap<java.math.BigInteger, Integer> sortedMap) {
        Integer n;
        java.math.BigInteger bigInteger2 = bigInteger;
        int n2 = 0;
        while (!bigInteger2.isProbablePrime(32)) {
            java.math.BigInteger bigInteger3 = PrimeInteger.rho(bigInteger2);
            if (bigInteger3.equals(bigInteger2)) {
                if (n2++ > 4) {
                    break;
                }
            } else {
                n2 = 1;
            }
            if ((n = (Integer)sortedMap.get(bigInteger3)) == null) {
                sortedMap.put(bigInteger3, 1);
            } else {
                sortedMap.put(bigInteger3, n + 1);
            }
            bigInteger2 = bigInteger2.divide(bigInteger3);
        }
        if ((n = (Integer)sortedMap.get(bigInteger2)) == null) {
            sortedMap.put(bigInteger2, 1);
        } else {
            sortedMap.put(bigInteger2, n + 1);
        }
    }

    static java.math.BigInteger rho(java.math.BigInteger bigInteger) {
        java.math.BigInteger bigInteger2;
        java.math.BigInteger bigInteger3;
        java.math.BigInteger bigInteger4 = new java.math.BigInteger(bigInteger.bitLength(), random);
        java.math.BigInteger bigInteger5 = bigInteger3 = new java.math.BigInteger(bigInteger.bitLength(), random);
        do {
            bigInteger3 = bigInteger3.multiply(bigInteger3).mod(bigInteger).add(bigInteger4).mod(bigInteger);
            bigInteger5 = bigInteger5.multiply(bigInteger5).mod(bigInteger).add(bigInteger4).mod(bigInteger);
        } while ((bigInteger2 = bigInteger3.subtract(bigInteger5 = bigInteger5.multiply(bigInteger5).mod(bigInteger).add(bigInteger4).mod(bigInteger)).gcd(bigInteger)).equals(java.math.BigInteger.ONE));
        return bigInteger2;
    }

    public static void factorsPollardRho(long l, SortedMap<Long, Integer> sortedMap) {
        Integer n;
        long l2 = l;
        int n2 = 0;
        while (!java.math.BigInteger.valueOf(l2).isProbablePrime(32)) {
            long l3 = PrimeInteger.rho(l2);
            if (l3 == l2) {
                if (n2++ > 4) {
                    break;
                }
            } else {
                n2 = 1;
            }
            if ((n = (Integer)sortedMap.get(l3)) == null) {
                sortedMap.put(l3, 1);
            } else {
                sortedMap.put(l3, n + 1);
            }
            l2 /= l3;
        }
        if ((n = (Integer)sortedMap.get(l2)) == null) {
            sortedMap.put(l2, 1);
        } else {
            sortedMap.put(l2, n + 1);
        }
    }

    static long rho(long l) {
        long l2;
        ModLong modLong;
        int n = java.math.BigInteger.valueOf(l).bitLength();
        long l3 = new java.math.BigInteger(n, random).longValue();
        long l4 = new java.math.BigInteger(n, random).longValue();
        ModLongRing modLongRing = new ModLongRing(l);
        ModLong modLong2 = new ModLong(modLongRing, l3);
        ModLong modLong3 = modLong = new ModLong(modLongRing, l4);
        do {
            modLong = modLong.multiply(modLong).sum(modLong2);
            modLong3 = modLong3.multiply(modLong3).sum(modLong2);
            modLong3 = modLong3.multiply(modLong3).sum(modLong2);
        } while ((l2 = PrimeInteger.gcd(modLong.getVal() - modLong3.getVal(), l)) == 1L);
        return l2;
    }

    static long gcd(long l, long l2) {
        return BigInteger.valueOf(l).gcd(BigInteger.valueOf(l2)).getVal().longValue();
    }
}

