/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.fd;

import edu.jas.fd.GreatestCommonDivisorAbstract;
import edu.jas.fd.GreatestCommonDivisorFake;
import edu.jas.fd.GreatestCommonDivisorPrimitive;
import edu.jas.fd.GreatestCommonDivisorSimple;
import edu.jas.fd.GreatestCommonDivisorSyzygy;
import edu.jas.fd.SGCDParallelProxy;
import edu.jas.fd.SolvableQuotient;
import edu.jas.fd.SolvableQuotientRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FDUtil {
    private static final Logger logger = LogManager.getLogger(FDUtil.class);
    private static final boolean debug = true;
    private static final boolean info = logger.isInfoEnabled();

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C> leftBaseSparsePseudoRemainder(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        return FDUtil.leftBasePseudoQuotientRemainder(genSolvablePolynomial, genSolvablePolynomial2)[1];
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C> rightBaseSparsePseudoRemainder(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        return FDUtil.rightBasePseudoQuotientRemainder(genSolvablePolynomial, genSolvablePolynomial2)[1];
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C> leftBasePseudoQuotient(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        return FDUtil.leftBasePseudoQuotientRemainder(genSolvablePolynomial, genSolvablePolynomial2)[0];
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C> rightBasePseudoQuotient(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        return FDUtil.rightBasePseudoQuotientRemainder(genSolvablePolynomial, genSolvablePolynomial2)[0];
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C>[] leftBasePseudoQuotientRemainder(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        int n;
        int n2;
        ExpVector expVector;
        Serializable serializable;
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            throw new ArithmeticException(genSolvablePolynomial.toString() + " division by zero " + genSolvablePolynomial2);
        }
        GenSolvablePolynomial[] genSolvablePolynomialArray = new GenSolvablePolynomial[]{null, null};
        if (genSolvablePolynomial.isZERO() || genSolvablePolynomial2.isONE()) {
            genSolvablePolynomialArray[0] = genSolvablePolynomial;
            genSolvablePolynomialArray[1] = genSolvablePolynomial2.ring.getZERO();
            return genSolvablePolynomialArray;
        }
        if (genSolvablePolynomial instanceof RecSolvablePolynomial) {
            serializable = (RecSolvablePolynomial)genSolvablePolynomial;
            if (!serializable.ring.coeffTable.isEmpty()) {
                throw new UnsupportedOperationException("RecSolvablePolynomial with twisted coeffs not supported");
            }
        }
        serializable = new GreatestCommonDivisorFake(genSolvablePolynomial.ring.coFac);
        ExpVector expVector2 = genSolvablePolynomial2.leadingExpVector();
        GenPolynomial genPolynomial = genSolvablePolynomial;
        GenPolynomial genPolynomial2 = ((GenSolvablePolynomial)genSolvablePolynomial2.ring.getZERO()).copy();
        while (!genPolynomial.isZERO() && (expVector = genPolynomial.leadingExpVector()).multipleOf(expVector2)) {
            GcdRingElem gcdRingElem = (GcdRingElem)genPolynomial.leadingBaseCoefficient();
            expVector = expVector.subtract(expVector2);
            GenPolynomial genPolynomial3 = genSolvablePolynomial2.multiplyLeft(expVector);
            GcdRingElem gcdRingElem2 = (GcdRingElem)genPolynomial3.leadingBaseCoefficient();
            GcdRingElem[] gcdRingElemArray = serializable.leftOreCond(gcdRingElem, gcdRingElem2);
            GcdRingElem gcdRingElem3 = gcdRingElemArray[0];
            GcdRingElem gcdRingElem4 = gcdRingElemArray[1];
            genPolynomial = ((GenSolvablePolynomial)genPolynomial).multiplyLeft(gcdRingElem3);
            genPolynomial3 = genPolynomial3.multiplyLeft(gcdRingElem4);
            genPolynomial2 = ((GenSolvablePolynomial)genPolynomial2).multiplyLeft(gcdRingElem3);
            genPolynomial2 = (GenSolvablePolynomial)genPolynomial2.sum(gcdRingElem4, expVector);
            genPolynomial = (GenSolvablePolynomial)genPolynomial.subtract(genPolynomial3);
        }
        int n3 = genSolvablePolynomial.signum();
        if (n3 != (n2 = genSolvablePolynomial2.signum()) * (n = genPolynomial2.signum())) {
            genPolynomial2 = (GenSolvablePolynomial)genPolynomial2.negate();
            genPolynomial = (GenSolvablePolynomial)genPolynomial.negate();
        }
        genSolvablePolynomialArray[0] = genPolynomial2;
        genSolvablePolynomialArray[1] = genPolynomial;
        return genSolvablePolynomialArray;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C>[] rightBasePseudoQuotientRemainder(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        int n;
        int n2;
        ExpVector expVector;
        Serializable serializable;
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            throw new ArithmeticException(genSolvablePolynomial.toString() + " division by zero " + genSolvablePolynomial2);
        }
        GenSolvablePolynomial[] genSolvablePolynomialArray = new GenSolvablePolynomial[]{null, null};
        if (genSolvablePolynomial.isZERO() || genSolvablePolynomial2.isONE()) {
            genSolvablePolynomialArray[0] = genSolvablePolynomial;
            genSolvablePolynomialArray[1] = genSolvablePolynomial2.ring.getZERO();
            return genSolvablePolynomialArray;
        }
        if (genSolvablePolynomial instanceof RecSolvablePolynomial) {
            serializable = (RecSolvablePolynomial)genSolvablePolynomial;
            if (!serializable.ring.coeffTable.isEmpty()) {
                throw new UnsupportedOperationException("RecSolvablePolynomial with twisted coeffs not supported");
            }
        }
        serializable = new GreatestCommonDivisorFake(genSolvablePolynomial.ring.coFac);
        ExpVector expVector2 = genSolvablePolynomial2.leadingExpVector();
        GenPolynomial genPolynomial = genSolvablePolynomial;
        GenPolynomial genPolynomial2 = ((GenSolvablePolynomial)genSolvablePolynomial2.ring.getZERO()).copy();
        while (!genPolynomial.isZERO() && (expVector = genPolynomial.leadingExpVector()).multipleOf(expVector2)) {
            GcdRingElem gcdRingElem = (GcdRingElem)genPolynomial.leadingBaseCoefficient();
            expVector = expVector.subtract(expVector2);
            GenPolynomial genPolynomial3 = genSolvablePolynomial2.multiply(expVector);
            GcdRingElem gcdRingElem2 = (GcdRingElem)genPolynomial3.leadingBaseCoefficient();
            GcdRingElem[] gcdRingElemArray = serializable.rightOreCond(gcdRingElem, gcdRingElem2);
            GcdRingElem gcdRingElem3 = gcdRingElemArray[0];
            GcdRingElem gcdRingElem4 = gcdRingElemArray[1];
            genPolynomial = ((GenSolvablePolynomial)genPolynomial).multiply(gcdRingElem3);
            genPolynomial3 = ((GenSolvablePolynomial)genPolynomial3).multiply(gcdRingElem4);
            genPolynomial2 = ((GenSolvablePolynomial)genPolynomial2).multiply(gcdRingElem3);
            genPolynomial2 = (GenSolvablePolynomial)genPolynomial2.sum(gcdRingElem4, expVector);
            genPolynomial = (GenSolvablePolynomial)genPolynomial.subtract(genPolynomial3);
        }
        int n3 = genSolvablePolynomial.signum();
        if (n3 != (n2 = genSolvablePolynomial2.signum()) * (n = genPolynomial2.signum())) {
            genPolynomial2 = (GenSolvablePolynomial)genPolynomial2.negate();
            genPolynomial = (GenSolvablePolynomial)genPolynomial.negate();
        }
        genSolvablePolynomialArray[0] = genPolynomial2;
        genSolvablePolynomialArray[1] = genPolynomial;
        return genSolvablePolynomialArray;
    }

    public static <C extends GcdRingElem<C>> boolean isRecursivePseudoQuotientRemainder(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial3, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial4) {
        GenPolynomial genPolynomial;
        GenSolvablePolynomial genSolvablePolynomial5 = (GenSolvablePolynomial)genSolvablePolynomial3.multiply((GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>>>>>)genSolvablePolynomial2).sum(genSolvablePolynomial4);
        GenSolvablePolynomial genSolvablePolynomial6 = genSolvablePolynomial;
        GenPolynomial genPolynomial2 = (GenPolynomial)genSolvablePolynomial2.leadingBaseCoefficient();
        long l = genSolvablePolynomial.degree(0) - genSolvablePolynomial2.degree(0) + 1L;
        l = l > 0L ? l : -l + 2L;
        for (long i = 0L; i <= l; ++i) {
            if (genSolvablePolynomial6.equals(genSolvablePolynomial5)) {
                return true;
            }
            genSolvablePolynomial6 = genSolvablePolynomial6.multiply((RingElem)genPolynomial2);
        }
        GenPolynomial genPolynomial3 = genSolvablePolynomial;
        genSolvablePolynomial5 = genSolvablePolynomial3.multiply((GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>>>>>)genSolvablePolynomial2);
        for (long i = 0L; i <= l; ++i) {
            genSolvablePolynomial6 = (GenSolvablePolynomial)genPolynomial3.subtract((GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>)genSolvablePolynomial4);
            if (genSolvablePolynomial6.equals(genSolvablePolynomial5)) {
                return true;
            }
            genPolynomial3 = genPolynomial3.multiply((RingElem)genPolynomial2);
        }
        GenPolynomialRing genPolynomialRing = (GenPolynomialRing)genSolvablePolynomial.ring.coFac;
        GreatestCommonDivisorSimple greatestCommonDivisorSimple = new GreatestCommonDivisorSimple(genPolynomialRing.coFac);
        GenSolvablePolynomial genSolvablePolynomial7 = (GenSolvablePolynomial)genSolvablePolynomial.leadingBaseCoefficient();
        genSolvablePolynomial5 = (GenSolvablePolynomial)genSolvablePolynomial3.multiply((GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>>>>>)genSolvablePolynomial2).sum(genSolvablePolynomial4);
        GenSolvablePolynomial genSolvablePolynomial8 = (GenSolvablePolynomial)genSolvablePolynomial5.leadingBaseCoefficient();
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray = greatestCommonDivisorSimple.leftOreCond(genSolvablePolynomial7, genSolvablePolynomial8);
        GenSolvablePolynomial genSolvablePolynomial9 = genSolvablePolynomialArray[0];
        GenSolvablePolynomial genSolvablePolynomial10 = genSolvablePolynomialArray[1];
        GenPolynomial genPolynomial4 = genSolvablePolynomial.multiplyLeft((RingElem)genSolvablePolynomial9);
        GenSolvablePolynomial genSolvablePolynomial11 = (GenSolvablePolynomial)genPolynomial4.subtract(genPolynomial = genSolvablePolynomial5.multiplyLeft(genSolvablePolynomial10));
        if (genSolvablePolynomial11.isZERO()) {
            return true;
        }
        logger.info("not QR: D = " + genSolvablePolynomial11);
        return false;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveSparsePseudoRemainder(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2) {
        return FDUtil.recursivePseudoQuotientRemainder(genSolvablePolynomial, genSolvablePolynomial2)[1];
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursivePseudoQuotient(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2) {
        return FDUtil.recursivePseudoQuotientRemainder(genSolvablePolynomial, genSolvablePolynomial2)[0];
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>>[] recursivePseudoQuotientRemainder(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2) {
        int n;
        int n2;
        ExpVector expVector;
        ExpVector expVector2;
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            throw new ArithmeticException(genSolvablePolynomial + " division by zero " + genSolvablePolynomial2);
        }
        GenSolvablePolynomial[] genSolvablePolynomialArray = new GenSolvablePolynomial[2];
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            genSolvablePolynomialArray[0] = genSolvablePolynomial2.ring.getZERO();
            genSolvablePolynomialArray[1] = genSolvablePolynomial2.ring.getZERO();
            return genSolvablePolynomialArray;
        }
        if (genSolvablePolynomial2.isONE()) {
            genSolvablePolynomialArray[0] = genSolvablePolynomial;
            genSolvablePolynomialArray[1] = genSolvablePolynomial2.ring.getZERO();
            return genSolvablePolynomialArray;
        }
        GenPolynomialRing genPolynomialRing = (GenPolynomialRing)genSolvablePolynomial.ring.coFac;
        GreatestCommonDivisorSimple greatestCommonDivisorSimple = new GreatestCommonDivisorSimple(genPolynomialRing.coFac);
        ExpVector expVector3 = genSolvablePolynomial2.leadingExpVector();
        GenPolynomial genPolynomial = genSolvablePolynomial;
        GenPolynomial genPolynomial2 = ((GenSolvablePolynomial)genSolvablePolynomial2.ring.getZERO()).copy();
        while (!genPolynomial.isZERO() && (expVector2 = (expVector = genPolynomial.leadingExpVector())).multipleOf(expVector3)) {
            expVector2 = expVector2.subtract(expVector3);
            GenPolynomial genPolynomial3 = genSolvablePolynomial2.multiplyLeft((GenPolynomial<ExpVector>)((Object)expVector2));
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)genPolynomial.leadingBaseCoefficient();
            GenSolvablePolynomial genSolvablePolynomial4 = (GenSolvablePolynomial)genPolynomial3.leadingBaseCoefficient();
            GenSolvablePolynomial<C>[] genSolvablePolynomialArray2 = greatestCommonDivisorSimple.leftOreCond(genSolvablePolynomial3, genSolvablePolynomial4);
            GenSolvablePolynomial genSolvablePolynomial5 = genSolvablePolynomialArray2[0];
            GenSolvablePolynomial genSolvablePolynomial6 = genSolvablePolynomialArray2[1];
            genPolynomial = ((GenSolvablePolynomial)genPolynomial).multiplyLeft(genSolvablePolynomial5);
            genPolynomial3 = genPolynomial3.multiplyLeft(genSolvablePolynomial6);
            genPolynomial2 = ((GenSolvablePolynomial)genPolynomial2).multiplyLeft(genSolvablePolynomial5);
            genPolynomial2 = (GenSolvablePolynomial)genPolynomial2.sum(genSolvablePolynomial6, expVector2);
            if ((genPolynomial = (GenSolvablePolynomial)genPolynomial.subtract(genPolynomial3)).isZERO() || !expVector.equals(genPolynomial.leadingExpVector())) continue;
            throw new RuntimeException("degree not descending: r = " + genPolynomial);
        }
        int n3 = genSolvablePolynomial.signum();
        if (n3 != (n2 = genSolvablePolynomial2.signum()) * (n = genPolynomial2.signum())) {
            genPolynomial2 = (GenSolvablePolynomial)genPolynomial2.negate();
            genPolynomial = (GenSolvablePolynomial)genPolynomial.negate();
        }
        genSolvablePolynomialArray[0] = genPolynomial2;
        genSolvablePolynomialArray[1] = genPolynomial;
        return genSolvablePolynomialArray;
    }

    public static <C extends GcdRingElem<C>> boolean isRecursiveRightPseudoQuotientRemainder(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial3, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial4) {
        RecSolvablePolynomial recSolvablePolynomial;
        GenSolvablePolynomial genSolvablePolynomial5 = (GenSolvablePolynomial)genSolvablePolynomial2.multiply((GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>>>>>)genSolvablePolynomial3).sum(genSolvablePolynomial4);
        GenSolvablePolynomial genSolvablePolynomial6 = genSolvablePolynomial;
        GenPolynomial genPolynomial = (GenPolynomial)genSolvablePolynomial2.leadingBaseCoefficient();
        long l = genSolvablePolynomial.degree(0) - genSolvablePolynomial2.degree(0) + 1L;
        l = l > 0L ? l : -l + 2L;
        for (long i = 0L; i <= l; ++i) {
            if (genSolvablePolynomial6.equals(genSolvablePolynomial5)) {
                return true;
            }
            genSolvablePolynomial6 = genSolvablePolynomial6.multiplyLeft(genPolynomial);
        }
        GenPolynomial genPolynomial2 = genSolvablePolynomial;
        genSolvablePolynomial5 = genSolvablePolynomial2.multiply((GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>>>>>)genSolvablePolynomial3);
        for (long i = 0L; i <= l; ++i) {
            genSolvablePolynomial6 = (GenSolvablePolynomial)genPolynomial2.subtract((GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>)genSolvablePolynomial4);
            if (genSolvablePolynomial6.equals(genSolvablePolynomial5)) {
                return true;
            }
            genPolynomial2 = genPolynomial2.multiplyLeft(genPolynomial);
        }
        GenPolynomialRing genPolynomialRing = (GenPolynomialRing)genSolvablePolynomial.ring.coFac;
        GreatestCommonDivisorSimple greatestCommonDivisorSimple = new GreatestCommonDivisorSimple(genPolynomialRing.coFac);
        RecSolvablePolynomial recSolvablePolynomial2 = (RecSolvablePolynomial)genSolvablePolynomial.rightRecursivePolynomial();
        GenSolvablePolynomial genSolvablePolynomial7 = (GenSolvablePolynomial)recSolvablePolynomial2.leadingBaseCoefficient();
        genSolvablePolynomial5 = (GenSolvablePolynomial)genSolvablePolynomial2.multiply((GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>>>>>)genSolvablePolynomial3).sum(genSolvablePolynomial4);
        RecSolvablePolynomial recSolvablePolynomial3 = (RecSolvablePolynomial)genSolvablePolynomial5.rightRecursivePolynomial();
        GenSolvablePolynomial genSolvablePolynomial8 = (GenSolvablePolynomial)recSolvablePolynomial3.leadingBaseCoefficient();
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray = greatestCommonDivisorSimple.rightOreCond(genSolvablePolynomial7, genSolvablePolynomial8);
        GenSolvablePolynomial genSolvablePolynomial9 = genSolvablePolynomialArray[0];
        GenSolvablePolynomial genSolvablePolynomial10 = genSolvablePolynomialArray[1];
        RecSolvablePolynomial recSolvablePolynomial4 = recSolvablePolynomial2.multiplyRightComm(genSolvablePolynomial9);
        GenSolvablePolynomial genSolvablePolynomial11 = (GenSolvablePolynomial)recSolvablePolynomial4.subtract(recSolvablePolynomial = recSolvablePolynomial3.multiplyRightComm(genSolvablePolynomial10));
        if (genSolvablePolynomial11.isZERO()) {
            return true;
        }
        System.out.println("Pa = " + recSolvablePolynomial4);
        System.out.println("Rb = " + recSolvablePolynomial);
        logger.info("not right QR: Pa-Rb = " + genSolvablePolynomial11);
        return false;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveRightSparsePseudoRemainder(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2) {
        return FDUtil.recursiveRightPseudoQuotientRemainder(genSolvablePolynomial, genSolvablePolynomial2)[1];
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveRightPseudoQuotient(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2) {
        return FDUtil.recursiveRightPseudoQuotientRemainder(genSolvablePolynomial, genSolvablePolynomial2)[0];
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>>[] recursiveRightPseudoQuotientRemainder(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2) {
        int n;
        int n2;
        ExpVector expVector;
        ExpVector expVector2;
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            throw new ArithmeticException(genSolvablePolynomial + " division by zero " + genSolvablePolynomial2);
        }
        GenSolvablePolynomial[] genSolvablePolynomialArray = new GenSolvablePolynomial[2];
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            genSolvablePolynomialArray[0] = genSolvablePolynomial2.ring.getZERO();
            genSolvablePolynomialArray[1] = genSolvablePolynomial2.ring.getZERO();
            return genSolvablePolynomialArray;
        }
        if (genSolvablePolynomial2.isONE()) {
            genSolvablePolynomialArray[0] = genSolvablePolynomial;
            genSolvablePolynomialArray[1] = genSolvablePolynomial2.ring.getZERO();
            return genSolvablePolynomialArray;
        }
        GenPolynomialRing genPolynomialRing = (GenPolynomialRing)genSolvablePolynomial.ring.coFac;
        GreatestCommonDivisorSimple greatestCommonDivisorSimple = new GreatestCommonDivisorSimple(genPolynomialRing.coFac);
        ExpVector expVector3 = genSolvablePolynomial2.leadingExpVector();
        GenSolvablePolynomial genSolvablePolynomial3 = genSolvablePolynomial;
        RecSolvablePolynomial recSolvablePolynomial = (RecSolvablePolynomial)((GenSolvablePolynomial)genSolvablePolynomial2.ring.getZERO()).copy();
        while (!genSolvablePolynomial3.isZERO() && (expVector2 = (expVector = genSolvablePolynomial3.leadingExpVector())).multipleOf(expVector3)) {
            expVector2 = expVector2.subtract(expVector3);
            GenSolvablePolynomial genSolvablePolynomial4 = genSolvablePolynomial2.multiply(expVector2);
            RecSolvablePolynomial recSolvablePolynomial2 = (RecSolvablePolynomial)genSolvablePolynomial4.rightRecursivePolynomial();
            RecSolvablePolynomial recSolvablePolynomial3 = (RecSolvablePolynomial)genSolvablePolynomial3.rightRecursivePolynomial();
            GenSolvablePolynomial genSolvablePolynomial5 = (GenSolvablePolynomial)recSolvablePolynomial3.leadingBaseCoefficient();
            GenSolvablePolynomial genSolvablePolynomial6 = (GenSolvablePolynomial)recSolvablePolynomial2.leadingBaseCoefficient();
            GenSolvablePolynomial<C>[] genSolvablePolynomialArray2 = greatestCommonDivisorSimple.rightOreCond(genSolvablePolynomial5, genSolvablePolynomial6);
            GenSolvablePolynomial genSolvablePolynomial7 = genSolvablePolynomialArray2[0];
            GenSolvablePolynomial genSolvablePolynomial8 = genSolvablePolynomialArray2[1];
            recSolvablePolynomial3 = recSolvablePolynomial3.multiplyRightComm(genSolvablePolynomial7);
            recSolvablePolynomial2 = recSolvablePolynomial2.multiplyRightComm(genSolvablePolynomial8);
            genSolvablePolynomial4 = recSolvablePolynomial2.evalAsRightRecursivePolynomial();
            genSolvablePolynomial3 = recSolvablePolynomial3.evalAsRightRecursivePolynomial();
            genSolvablePolynomial3 = (GenSolvablePolynomial)genSolvablePolynomial3.subtract(genSolvablePolynomial4);
            recSolvablePolynomial = recSolvablePolynomial.multiplyRightComm(genSolvablePolynomial7);
            recSolvablePolynomial = (RecSolvablePolynomial)recSolvablePolynomial.sum(genSolvablePolynomial8, expVector2);
            if (genSolvablePolynomial3.isZERO() || !expVector.equals(genSolvablePolynomial3.leadingExpVector())) continue;
            throw new RuntimeException("something is wrong: g == lc(r), terms not descending " + genSolvablePolynomial3);
        }
        GenSolvablePolynomial genSolvablePolynomial9 = recSolvablePolynomial.evalAsRightRecursivePolynomial();
        int n3 = genSolvablePolynomial.signum();
        if (n3 != (n2 = genSolvablePolynomial2.signum()) * (n = genSolvablePolynomial9.signum())) {
            genSolvablePolynomial9 = (GenSolvablePolynomial)genSolvablePolynomial9.negate();
            genSolvablePolynomial3 = (GenSolvablePolynomial)genSolvablePolynomial3.negate();
        }
        genSolvablePolynomialArray[0] = genSolvablePolynomial9;
        genSolvablePolynomialArray[1] = genSolvablePolynomial3;
        return genSolvablePolynomialArray;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveDivideRightEval(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (genSolvablePolynomial2.isONE()) {
            return genSolvablePolynomial;
        }
        GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial3 = genSolvablePolynomial.rightRecursivePolynomial();
        GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial4 = FDUtil.recursiveLeftDivide(genSolvablePolynomial3, genSolvablePolynomial2);
        GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial5 = genSolvablePolynomial4.evalAsRightRecursivePolynomial();
        if (!((GenSolvablePolynomial)genSolvablePolynomial4.multiplyLeft((RingElem)genSolvablePolynomial2)).equals(genSolvablePolynomial3)) {
            System.out.println("rDivREval: Pr   = " + genSolvablePolynomial3 + ", P = " + genSolvablePolynomial);
            System.out.println("rDivREval: Qr   = " + genSolvablePolynomial4 + ", Q = " + genSolvablePolynomial5);
            System.out.println("rDivREval: s*Qr = " + genSolvablePolynomial4.multiplyLeft((RingElem)genSolvablePolynomial2) + ", s = " + genSolvablePolynomial2);
            System.out.println("rDivREval: Qr*s = " + genSolvablePolynomial4.multiply((RingElem)genSolvablePolynomial2));
            throw new RuntimeException("rDivREval: s*Qr != Pr");
        }
        if (!((GenSolvablePolynomial)genSolvablePolynomial5.multiply((RingElem)genSolvablePolynomial2)).equals(genSolvablePolynomial)) {
            System.out.println("rDivREval: P   = " + genSolvablePolynomial + ", right(P) = " + genSolvablePolynomial3);
            System.out.println("rDivREval: Q   = " + genSolvablePolynomial5 + ", right(Q) = " + genSolvablePolynomial4);
            System.out.println("rDivREval: Q*s = " + genSolvablePolynomial5.multiply((RingElem)genSolvablePolynomial2) + ", s = " + genSolvablePolynomial2);
            System.out.println("rDivREval: s*Q = " + genSolvablePolynomial5.multiplyLeft((RingElem)genSolvablePolynomial2));
            throw new RuntimeException("rDivREval: Q*s != P");
        }
        return genSolvablePolynomial5;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveDivide(GenSolvablePolynomial<GenPolynomial<C>> recSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            throw new ArithmeticException("division by zero " + recSolvablePolynomial + ", " + genSolvablePolynomial);
        }
        if (recSolvablePolynomial.isZERO()) {
            return recSolvablePolynomial;
        }
        if (genSolvablePolynomial.isONE()) {
            return recSolvablePolynomial;
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = ((GenSolvablePolynomial)recSolvablePolynomial).ring;
        GenPolynomial genPolynomial = genSolvablePolynomialRing.getONE();
        GenPolynomial genPolynomial2 = genSolvablePolynomialRing.getZERO();
        RecSolvablePolynomial recSolvablePolynomial2 = recSolvablePolynomial;
        while (!recSolvablePolynomial2.isZERO()) {
            Map.Entry entry = recSolvablePolynomial2.leadingMonomial();
            GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)entry.getValue();
            ExpVector expVector = entry.getKey();
            GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial3 = genSolvablePolynomial2.divide(genSolvablePolynomial);
            if (genSolvablePolynomial3.isZERO()) {
                throw new RuntimeException("something is wrong: c is zero, c1 = " + genSolvablePolynomial2 + ", s = " + genSolvablePolynomial);
            }
            GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>> genSolvablePolynomial4 = ((GenSolvablePolynomial)genPolynomial).multiplyLeft(genSolvablePolynomial3.multiply(genSolvablePolynomial), expVector);
            if (!genSolvablePolynomial2.equals(genSolvablePolynomial4.leadingBaseCoefficient())) {
                System.out.println("recRightDivide: lc(r) = " + genSolvablePolynomial4.leadingBaseCoefficient() + ", c1 = " + genSolvablePolynomial2);
                System.out.println("recRightDivide: lc(r) = " + genSolvablePolynomial3.multiply(genSolvablePolynomial) + ", c = " + genSolvablePolynomial3 + ", s = " + genSolvablePolynomial);
                throw new RuntimeException("something is wrong: lc(r) != c*s");
            }
            if (!(recSolvablePolynomial2 = (RecSolvablePolynomial)recSolvablePolynomial2.subtract(genSolvablePolynomial4)).isZERO() && expVector.compareTo(recSolvablePolynomial2.leadingExpVector()) == 0) {
                System.out.println("recRightDivide: c     = " + genSolvablePolynomial3);
                System.out.println("recRightDivide: lt(p) = " + recSolvablePolynomial2.leadingExpVector() + ", e1 = " + expVector);
                System.out.println("recRightDivide: c1/s  = " + genSolvablePolynomial2.divide(genSolvablePolynomial));
                System.out.println("recRightDivide: s*c   = " + genSolvablePolynomial.multiply(genSolvablePolynomial3));
                System.out.println("recRightDivide: c*s   = " + genSolvablePolynomial3.multiply(genSolvablePolynomial));
                throw new RuntimeException("something is wrong: degree not descending");
            }
            genPolynomial2 = (RecSolvablePolynomial)genPolynomial2.sum(genSolvablePolynomial3, expVector);
        }
        return genPolynomial2;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveRightDivide(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            throw new ArithmeticException("division by zero " + genSolvablePolynomial + ", " + genSolvablePolynomial2);
        }
        if (genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial2.isONE()) {
            return genSolvablePolynomial;
        }
        if (!(genSolvablePolynomial instanceof RecSolvablePolynomial)) {
            // empty if block
        }
        RecSolvablePolynomialRing recSolvablePolynomialRing = (RecSolvablePolynomialRing)genSolvablePolynomial.ring;
        if (recSolvablePolynomialRing.coeffTable.isEmpty()) {
            // empty if block
        }
        GenSolvablePolynomial genSolvablePolynomial3 = recSolvablePolynomialRing.getONE();
        GenSolvablePolynomial genSolvablePolynomial4 = recSolvablePolynomialRing.getZERO();
        RecSolvablePolynomial recSolvablePolynomial = (RecSolvablePolynomial)genSolvablePolynomial;
        while (!recSolvablePolynomial.isZERO()) {
            Map.Entry entry = recSolvablePolynomial.leadingMonomial();
            GenSolvablePolynomial genSolvablePolynomial5 = (GenSolvablePolynomial)entry.getValue();
            ExpVector expVector = entry.getKey();
            GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial6 = genSolvablePolynomial5.rightDivide(genSolvablePolynomial2);
            if (genSolvablePolynomial6.isZERO()) {
                throw new RuntimeException("something is wrong: c is zero, a = " + genSolvablePolynomial5 + ", s = " + genSolvablePolynomial2);
            }
            RecSolvablePolynomial<GenSolvablePolynomial<C>> recSolvablePolynomial2 = ((RecSolvablePolynomial)genSolvablePolynomial3).multiply(genSolvablePolynomial2.multiply((GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>>>>>)genSolvablePolynomial6), expVector);
            if (!genSolvablePolynomial5.equals(recSolvablePolynomial2.leadingBaseCoefficient())) {
                System.out.println("recRightDivide: a   = " + genSolvablePolynomial5 + ", lc(r) = " + recSolvablePolynomial2.leadingBaseCoefficient());
                System.out.println("recRightDivide: c*s = " + genSolvablePolynomial6.multiply(genSolvablePolynomial2) + ", s = " + genSolvablePolynomial2 + ", c = " + genSolvablePolynomial6);
                System.out.println("recRightDivide: s*c = " + genSolvablePolynomial2.multiply((GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>>>>>)genSolvablePolynomial6) + ", a%s = " + genSolvablePolynomial5.rightRemainder(genSolvablePolynomial2));
                throw new RuntimeException("something is wrong: c*s != a: " + recSolvablePolynomialRing.toScript());
            }
            if (!(recSolvablePolynomial = (RecSolvablePolynomial)recSolvablePolynomial.subtract(recSolvablePolynomial2)).isZERO() && expVector.compareTo(recSolvablePolynomial.leadingExpVector()) == 0) {
                System.out.println("recRightDivide: c     = " + genSolvablePolynomial6);
                System.out.println("recRightDivide: lt(p) = " + recSolvablePolynomial.leadingExpVector() + ", f = " + expVector);
                System.out.println("recRightDivide: a/s   = " + genSolvablePolynomial5.divide(genSolvablePolynomial2));
                System.out.println("recRightDivide: s*c   = " + genSolvablePolynomial2.multiply((GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>>>>>)genSolvablePolynomial6));
                System.out.println("recRightDivide: c*s   = " + genSolvablePolynomial6.multiply(genSolvablePolynomial2));
                throw new RuntimeException("something is wrong: degree not descending");
            }
            genSolvablePolynomial4 = (RecSolvablePolynomial)genSolvablePolynomial4.sum(genSolvablePolynomial6, expVector);
        }
        return genSolvablePolynomial4;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveLeftDivide(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        RecSolvablePolynomial recSolvablePolynomial;
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            throw new ArithmeticException("division by zero " + genSolvablePolynomial + ", " + genSolvablePolynomial2);
        }
        if (genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial2.isONE()) {
            return genSolvablePolynomial;
        }
        if (!(genSolvablePolynomial instanceof RecSolvablePolynomial)) {
            // empty if block
        }
        RecSolvablePolynomialRing recSolvablePolynomialRing = (RecSolvablePolynomialRing)genSolvablePolynomial.ring;
        if (recSolvablePolynomialRing.coeffTable.isEmpty()) {
            // empty if block
        }
        GenSolvablePolynomial genSolvablePolynomial3 = recSolvablePolynomialRing.getONE();
        GenSolvablePolynomial genSolvablePolynomial4 = recSolvablePolynomialRing.getZERO();
        RecSolvablePolynomial recSolvablePolynomial2 = recSolvablePolynomial = (RecSolvablePolynomial)genSolvablePolynomial.rightRecursivePolynomial();
        while (!recSolvablePolynomial.isZERO()) {
            ExpVector expVector = recSolvablePolynomial.leadingExpVector();
            GenSolvablePolynomial genSolvablePolynomial5 = (GenSolvablePolynomial)recSolvablePolynomial.leadingBaseCoefficient();
            GenPolynomial genPolynomial = genSolvablePolynomial5.divide(genSolvablePolynomial2);
            if (genPolynomial.isZERO()) {
                throw new RuntimeException("something is wrong: c is zero, a = " + genSolvablePolynomial5 + ", s = " + genSolvablePolynomial2);
            }
            RecSolvablePolynomial<GenSolvablePolynomial<C>> recSolvablePolynomial3 = ((RecSolvablePolynomial)genSolvablePolynomial3).multiplyLeft(((GenSolvablePolynomial)genPolynomial).multiply(genSolvablePolynomial2), expVector);
            if (!genSolvablePolynomial5.equals(recSolvablePolynomial3.leadingBaseCoefficient())) {
                System.out.println("recLeftDivide: a        = " + genSolvablePolynomial5);
                GcdRingElem gcdRingElem = (GcdRingElem)genSolvablePolynomial5.leadingBaseCoefficient();
                GcdRingElem gcdRingElem2 = (GcdRingElem)((GenPolynomial)recSolvablePolynomial3.leadingBaseCoefficient()).leadingBaseCoefficient();
                GcdRingElem gcdRingElem3 = ((GcdRingElem)gcdRingElem2.inverse()).multiply(gcdRingElem);
                System.out.println("recLeftDivide: cc       = " + gcdRingElem3);
                genPolynomial = ((GenSolvablePolynomial)genPolynomial).multiply(gcdRingElem3);
                recSolvablePolynomial3 = ((RecSolvablePolynomial)genSolvablePolynomial3).multiplyLeft(((GenSolvablePolynomial)genPolynomial).multiply(genSolvablePolynomial2), expVector);
                System.out.println("recLeftDivide: lc(r)    = " + recSolvablePolynomial3.leadingBaseCoefficient());
                throw new RuntimeException("something is wrong: c*s != a: " + recSolvablePolynomialRing.toScript());
            }
            if (!(recSolvablePolynomial = (RecSolvablePolynomial)recSolvablePolynomial.subtract(recSolvablePolynomial3)).isZERO() && expVector.compareTo(recSolvablePolynomial.leadingExpVector()) == 0) {
                System.out.println("recLeftDivide: P        = " + genSolvablePolynomial + ", s = " + genSolvablePolynomial2);
                System.out.println("recLeftDivide: right(P) = " + recSolvablePolynomial2);
                System.out.println("recLeftDivide: c        = " + genPolynomial);
                System.out.println("recLeftDivide: lt(p)    = " + recSolvablePolynomial.leadingExpVector() + ", f = " + expVector);
                System.out.println("recLeftDivide: a/s      = " + genSolvablePolynomial5.divide(genSolvablePolynomial2));
                System.out.println("recLeftDivide: a\\s      = " + genSolvablePolynomial5.rightDivide(genSolvablePolynomial2));
                System.out.println("recLeftDivide: s*c      = " + genSolvablePolynomial2.multiply(genPolynomial));
                System.out.println("recLeftDivide: c*s      = " + ((GenSolvablePolynomial)genPolynomial).multiply(genSolvablePolynomial2));
                throw new RuntimeException("something is wrong: degree not descending");
            }
            genSolvablePolynomial4 = (RecSolvablePolynomial)genSolvablePolynomial4.sum(genPolynomial, expVector);
        }
        genSolvablePolynomial4 = (RecSolvablePolynomial)((RecSolvablePolynomial)genSolvablePolynomial4).evalAsRightRecursivePolynomial();
        return genSolvablePolynomial4;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> integralFromQuotientCoefficients(GenSolvablePolynomialRing<GenPolynomial<C>> genSolvablePolynomialRing, GenSolvablePolynomial<SolvableQuotient<C>> genSolvablePolynomial) {
        GenPolynomial genPolynomial = ((GenSolvablePolynomial)genSolvablePolynomialRing.getZERO()).copy();
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genPolynomial;
        }
        GenSolvablePolynomial<Object> genSolvablePolynomial2 = null;
        GenPolynomialRing genPolynomialRing = (GenPolynomialRing)genSolvablePolynomialRing.coFac;
        GreatestCommonDivisorPrimitive greatestCommonDivisorPrimitive = new GreatestCommonDivisorPrimitive(genPolynomialRing.coFac);
        int n = 0;
        SortedMap sortedMap = genSolvablePolynomial.getMap();
        for (SolvableQuotient object : sortedMap.values()) {
            GenSolvablePolynomial genSolvablePolynomial3 = object.den;
            if (genSolvablePolynomial2 == null) {
                genSolvablePolynomial2 = genSolvablePolynomial3;
                n = genSolvablePolynomial3.signum();
                continue;
            }
            GenSolvablePolynomial genSolvablePolynomial4 = greatestCommonDivisorPrimitive.leftGcd(genSolvablePolynomial2, genSolvablePolynomial3);
            GenSolvablePolynomial genSolvablePolynomial5 = genSolvablePolynomial3.divide(genSolvablePolynomial4);
            genSolvablePolynomial2 = genSolvablePolynomial5.multiply(genSolvablePolynomial2);
        }
        if (n < 0) {
            genSolvablePolynomial2 = (GenSolvablePolynomial)genSolvablePolynomial2.negate();
        }
        for (Map.Entry entry : sortedMap.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            SolvableQuotient solvableQuotient = (SolvableQuotient)entry.getValue();
            GenSolvablePolynomial<Object> genSolvablePolynomial3 = genSolvablePolynomial2.divide(solvableQuotient.den);
            GenPolynomial<GenSolvablePolynomial<Object>> genPolynomial2 = ((GenPolynomial)solvableQuotient.num).multiply(genSolvablePolynomial3);
            genPolynomial.doPutToMap(expVector, genPolynomial2);
        }
        return genPolynomial;
    }

    public static <C extends GcdRingElem<C>> List<GenSolvablePolynomial<GenPolynomial<C>>> integralFromQuotientCoefficients(GenSolvablePolynomialRing<GenPolynomial<C>> genSolvablePolynomialRing, Collection<GenSolvablePolynomial<SolvableQuotient<C>>> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<GenSolvablePolynomial<GenPolynomial<C>>> arrayList = new ArrayList<GenSolvablePolynomial<GenPolynomial<C>>>(collection.size());
        for (GenSolvablePolynomial<SolvableQuotient<C>> genSolvablePolynomial : collection) {
            arrayList.add(FDUtil.integralFromQuotientCoefficients(genSolvablePolynomialRing, genSolvablePolynomial));
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<SolvableQuotient<C>> quotientFromIntegralCoefficients(GenSolvablePolynomialRing<SolvableQuotient<C>> genSolvablePolynomialRing, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial) {
        GenPolynomial genPolynomial = ((GenSolvablePolynomial)genSolvablePolynomialRing.getZERO()).copy();
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genPolynomial;
        }
        RingFactory ringFactory = genSolvablePolynomialRing.coFac;
        SolvableQuotientRing solvableQuotientRing = (SolvableQuotientRing)ringFactory;
        for (Map.Entry entry : genSolvablePolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)entry.getValue();
            SolvableQuotient solvableQuotient = new SolvableQuotient(solvableQuotientRing, genSolvablePolynomial2);
            if (solvableQuotient.isZERO()) continue;
            genPolynomial.doPutToMap(expVector, solvableQuotient);
        }
        return genPolynomial;
    }

    public static <C extends GcdRingElem<C>> List<GenSolvablePolynomial<SolvableQuotient<C>>> quotientFromIntegralCoefficients(GenSolvablePolynomialRing<SolvableQuotient<C>> genSolvablePolynomialRing, Collection<GenSolvablePolynomial<GenPolynomial<C>>> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<GenSolvablePolynomial<SolvableQuotient<C>>> arrayList = new ArrayList<GenSolvablePolynomial<SolvableQuotient<C>>>(collection.size());
        for (GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial : collection) {
            arrayList.add(FDUtil.quotientFromIntegralCoefficients(genSolvablePolynomialRing, genSolvablePolynomial));
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C>[] leftGcdCofactors(GenSolvablePolynomialRing<C> genSolvablePolynomialRing, GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray;
        GreatestCommonDivisorPrimitive greatestCommonDivisorPrimitive = new GreatestCommonDivisorPrimitive(genSolvablePolynomialRing.coFac);
        GreatestCommonDivisorSyzygy greatestCommonDivisorSyzygy = new GreatestCommonDivisorSyzygy(genSolvablePolynomialRing.coFac);
        SGCDParallelProxy<C> sGCDParallelProxy = new SGCDParallelProxy<C>(genSolvablePolynomialRing.coFac, greatestCommonDivisorPrimitive, greatestCommonDivisorSyzygy);
        if (info) {
            logger.info("leftGCD_in: " + genSolvablePolynomial + ", " + genSolvablePolynomial2);
        }
        GenSolvablePolynomial[] genSolvablePolynomialArray2 = new GenSolvablePolynomial[]{((GreatestCommonDivisorAbstract)sGCDParallelProxy).leftGcd(genSolvablePolynomial, genSolvablePolynomial2), genSolvablePolynomial, genSolvablePolynomial2};
        if (genSolvablePolynomialArray2[0].isONE()) {
            return genSolvablePolynomialArray2;
        }
        if (info) {
            logger.info("leftGCD_out: " + genSolvablePolynomialArray2[0]);
        }
        if (!(genSolvablePolynomialArray = FDUtil.rightBasePseudoQuotientRemainder(genSolvablePolynomial, genSolvablePolynomialArray2[0]))[1].isZERO()) {
            genSolvablePolynomialArray2[0] = genSolvablePolynomialRing.getONE();
            return genSolvablePolynomialArray2;
        }
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray3 = FDUtil.rightBasePseudoQuotientRemainder(genSolvablePolynomial2, genSolvablePolynomialArray2[0]);
        if (!genSolvablePolynomialArray3[1].isZERO()) {
            genSolvablePolynomialArray2[0] = genSolvablePolynomialRing.getONE();
            return genSolvablePolynomialArray2;
        }
        genSolvablePolynomialArray2[1] = genSolvablePolynomialArray[0];
        genSolvablePolynomialArray2[2] = genSolvablePolynomialArray3[0];
        return genSolvablePolynomialArray2;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C>[] rightGcdCofactors(GenSolvablePolynomialRing<C> genSolvablePolynomialRing, GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray;
        GreatestCommonDivisorFake<C> greatestCommonDivisorFake = new GreatestCommonDivisorFake<C>(genSolvablePolynomialRing.coFac);
        if (info) {
            logger.info("rightGCD_in: " + genSolvablePolynomial + ", " + genSolvablePolynomial2);
        }
        GenSolvablePolynomial[] genSolvablePolynomialArray2 = new GenSolvablePolynomial[]{greatestCommonDivisorFake.rightGcd(genSolvablePolynomial, genSolvablePolynomial2), genSolvablePolynomial, genSolvablePolynomial2};
        if (genSolvablePolynomialArray2[0].isONE()) {
            return genSolvablePolynomialArray2;
        }
        if (info) {
            logger.info("rightGCD_out: " + genSolvablePolynomialArray2[0]);
        }
        if (!(genSolvablePolynomialArray = FDUtil.leftBasePseudoQuotientRemainder(genSolvablePolynomial, genSolvablePolynomialArray2[0]))[1].isZERO()) {
            genSolvablePolynomialArray2[0] = genSolvablePolynomialRing.getONE();
            return genSolvablePolynomialArray2;
        }
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray3 = FDUtil.leftBasePseudoQuotientRemainder(genSolvablePolynomial2, genSolvablePolynomialArray2[0]);
        if (!genSolvablePolynomialArray3[1].isZERO()) {
            genSolvablePolynomialArray2[0] = genSolvablePolynomialRing.getONE();
            return genSolvablePolynomialArray2;
        }
        genSolvablePolynomialArray2[1] = genSolvablePolynomialArray[0];
        genSolvablePolynomialArray2[2] = genSolvablePolynomialArray3[0];
        return genSolvablePolynomialArray2;
    }
}

