/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.fd;

import edu.jas.arith.BigQuaternion;
import edu.jas.arith.BigQuaternionRing;
import edu.jas.fd.FDUtil;
import edu.jas.fd.GCDcoFactors;
import edu.jas.fd.GreatestCommonDivisorLR;
import edu.jas.fd.GreatestCommonDivisorSimple;
import edu.jas.gbufd.SolvableSyzygyAbstract;
import edu.jas.gbufd.SolvableSyzygySeq;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.poly.TermOrderByName;
import edu.jas.poly.WeylRelationsIterated;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GCDLeftRightTest
extends TestCase {
    GreatestCommonDivisorLR<BigQuaternion> fd;
    TermOrder to = TermOrderByName.INVLEX;
    BigQuaternionRing cfac;
    GenSolvablePolynomialRing<BigQuaternion> dfac;
    RecSolvablePolynomialRing<BigQuaternion> rfac;
    GenSolvablePolynomial<BigQuaternion> a;
    GenSolvablePolynomial<BigQuaternion> b;
    GenSolvablePolynomial<BigQuaternion> c;
    GenSolvablePolynomial<BigQuaternion> d;
    GenSolvablePolynomial<BigQuaternion> e;
    GenSolvablePolynomial<BigQuaternion> f;
    GenSolvablePolynomial<BigQuaternion> g;
    GenSolvablePolynomial<BigQuaternion> h;
    GenSolvablePolynomial<BigQuaternion> r;
    GenSolvablePolynomial<BigQuaternion> s;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> ar;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> br;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> cr;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> dr;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> er;
    SolvableSyzygyAbstract<BigQuaternion> syz;
    int rl = 4;
    int kl = 2;
    int ll = 4;
    int el = 3;
    float q = 0.35f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GCDLeftRightTest.suite());
        ComputerThreads.terminate();
    }

    public GCDLeftRightTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GCDLeftRightTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        String[] stringArray = new String[]{"a", "b", "c", "d"};
        this.cfac = new BigQuaternionRing();
        this.syz = new SolvableSyzygySeq<BigQuaternion>(this.cfac);
        this.fd = new GreatestCommonDivisorLR<BigQuaternion>(this.cfac, this.syz);
        this.dfac = new GenSolvablePolynomialRing<BigQuaternion>(this.cfac, this.rl, this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.dfac.addRelations(weylRelationsIterated);
        this.rfac = (RecSolvablePolynomialRing)this.dfac.recursive(1);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.fd = null;
        this.cfac = null;
        this.dfac = null;
        this.rfac = null;
        this.syz = null;
    }

    public void testBaseGcdLeftRight() {
        String[] stringArray = new String[]{"x"};
        this.dfac = new GenSolvablePolynomialRing<BigQuaternion>(this.cfac, 1, this.to, stringArray);
        for (int i = 0; i < 1; ++i) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + i, this.el + 1, this.q);
            this.b = this.dfac.random(this.kl * (i + 1), this.ll + i, this.el + 1, this.q);
            this.c = this.dfac.random(this.kl * (i + 1), this.ll + 1, this.el + 0, this.q);
            this.c = this.c.multiply((BigQuaternion)((Object)this.dfac.univariate(0)));
            BigQuaternion bigQuaternion = this.cfac.random(this.kl);
            if (this.c.isZERO() || bigQuaternion.isZERO()) continue;
            this.a = this.a.multiply((BigQuaternion)((Object)this.c)).multiplyLeft(bigQuaternion);
            this.b = this.b.multiply((BigQuaternion)((Object)this.c)).multiplyLeft(bigQuaternion);
            GCDcoFactors<BigQuaternion> gCDcoFactors = this.fd.leftRightBaseGcd(this.a, this.b);
            GCDLeftRightTest.assertTrue((String)"cont.isGCD() ", (boolean)gCDcoFactors.isGCD());
        }
    }

    public void testBaseGcdRightLeft() {
        String[] stringArray = new String[]{"x"};
        this.dfac = new GenSolvablePolynomialRing<BigQuaternion>(this.cfac, 1, this.to, stringArray);
        for (int i = 0; i < 1; ++i) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + i, this.el + 1, this.q);
            this.b = this.dfac.random(this.kl * (i + 1), this.ll + i, this.el + 1, this.q);
            this.c = this.dfac.random(this.kl * (i + 1), this.ll + 1, this.el + 0, this.q);
            this.c = this.c.multiply((BigQuaternion)((Object)this.dfac.univariate(0)));
            BigQuaternion bigQuaternion = this.cfac.random(this.kl);
            if (this.c.isZERO() || bigQuaternion.isZERO()) continue;
            this.a = ((GenSolvablePolynomial)this.c.multiply((RingElem)bigQuaternion)).multiply(this.a);
            this.b = ((GenSolvablePolynomial)this.c.multiply((RingElem)bigQuaternion)).multiply(this.b);
            GCDcoFactors<BigQuaternion> gCDcoFactors = this.fd.rightLeftBaseGcd(this.a, this.b);
            GCDLeftRightTest.assertTrue((String)"cont.isGCD() ", (boolean)gCDcoFactors.isGCD());
        }
    }

    public void testBaseLeftGcd() {
        String[] stringArray = new String[]{"x"};
        this.dfac = new GenSolvablePolynomialRing<BigQuaternion>(this.cfac, 1, this.to, stringArray);
        for (int i = 0; i < 1; ++i) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + i, this.el + 1, this.q);
            this.b = this.dfac.random(this.kl * (i + 1), this.ll + i, this.el + 1, this.q);
            this.c = this.dfac.random(this.kl * (i + 1), this.ll + 1, this.el + 0, this.q);
            this.c = this.c.multiply((BigQuaternion)((Object)this.dfac.univariate(0)));
            BigQuaternion bigQuaternion = this.cfac.random(this.kl);
            this.c = this.c.multiplyLeft((RingElem)bigQuaternion);
            if (this.c.isZERO() || bigQuaternion.isZERO()) continue;
            this.a = this.c.multiply((BigQuaternion)((Object)this.a));
            this.b = this.c.multiply((BigQuaternion)((Object)this.b));
            this.d = this.fd.leftBaseGcd(this.a, this.b);
            this.e = FDUtil.rightBaseSparsePseudoRemainder(this.a, this.d);
            GCDLeftRightTest.assertTrue((String)"e == 0 ", (boolean)this.e.isZERO());
            this.f = FDUtil.rightBaseSparsePseudoRemainder(this.b, this.d);
            GCDLeftRightTest.assertTrue((String)"f == 0 ", (boolean)this.f.isZERO());
        }
    }

    public void testBaseRightGcd() {
        String[] stringArray = new String[]{"x"};
        this.dfac = new GenSolvablePolynomialRing<BigQuaternion>(this.cfac, 1, this.to, stringArray);
        for (int i = 0; i < 1; ++i) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + i, this.el + 1, this.q);
            this.b = this.dfac.random(this.kl * (i + 1), this.ll + i, this.el + 1, this.q);
            this.c = this.dfac.random(this.kl * (i + 1), this.ll + 1, this.el + 0, this.q);
            this.c = this.c.multiply((BigQuaternion)((Object)this.dfac.univariate(0)));
            BigQuaternion bigQuaternion = this.cfac.random(this.kl);
            this.c = this.c.multiply((RingElem)bigQuaternion);
            if (this.c.isZERO() || bigQuaternion.isZERO()) continue;
            this.a = this.a.multiply((BigQuaternion)((Object)this.c));
            this.b = this.b.multiply((BigQuaternion)((Object)this.c));
            this.d = this.fd.rightBaseGcd(this.a, this.b);
            this.e = FDUtil.leftBaseSparsePseudoRemainder(this.a, this.d);
            GCDLeftRightTest.assertTrue((String)"e == 0 ", (boolean)this.e.isZERO());
            this.f = FDUtil.leftBaseSparsePseudoRemainder(this.b, this.d);
            GCDLeftRightTest.assertTrue((String)"f == 0 ", (boolean)this.f.isZERO());
        }
    }

    public void testBaseIntegerGcdLeftRight() {
        String[] stringArray = new String[]{"x"};
        this.cfac = new BigQuaternionRing(true);
        this.syz = new SolvableSyzygySeq<BigQuaternion>(this.cfac);
        this.dfac = new GenSolvablePolynomialRing<BigQuaternion>(this.cfac, 1, this.to, stringArray);
        this.fd = new GreatestCommonDivisorLR<BigQuaternion>(this.cfac, this.syz);
        for (int i = 0; i < 1; ++i) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + 1, this.el + 2, this.q);
            this.b = this.dfac.random(this.kl * (i + 1), this.ll + 1, this.el + 2, this.q);
            this.c = this.dfac.random(this.kl * (i + 1), this.ll + 1, this.el + 1, this.q);
            this.c = this.c.multiply((BigQuaternion)((Object)this.dfac.univariate(0)));
            this.c = (GenSolvablePolynomial)this.c.abs();
            BigQuaternion bigQuaternion = this.cfac.random(this.kl);
            if (this.c.isZERO() || bigQuaternion.isZERO()) continue;
            this.a = this.a.multiply((BigQuaternion)((Object)this.c)).multiplyLeft(bigQuaternion);
            this.b = this.b.multiply((BigQuaternion)((Object)this.c)).multiplyLeft(bigQuaternion);
            GCDcoFactors<BigQuaternion> gCDcoFactors = this.fd.leftRightBaseGcd(this.a, this.b);
            GCDLeftRightTest.assertTrue((String)"cont.isGCD() ", (boolean)gCDcoFactors.isGCD());
        }
    }

    public void testBaseIntegerGcdRightLeft() {
        String[] stringArray = new String[]{"x"};
        this.cfac = new BigQuaternionRing(true);
        this.syz = new SolvableSyzygySeq<BigQuaternion>(this.cfac);
        this.dfac = new GenSolvablePolynomialRing<BigQuaternion>(this.cfac, 1, this.to, stringArray);
        this.fd = new GreatestCommonDivisorLR<BigQuaternion>(this.cfac, this.syz);
        for (int i = 0; i < 1; ++i) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + 1, this.el + 2, this.q);
            this.b = this.dfac.random(this.kl * (i + 1), this.ll + 1, this.el + 2, this.q);
            this.c = this.dfac.random(this.kl * (i + 1), this.ll + 1, this.el + 1, this.q);
            this.c = this.c.multiply((BigQuaternion)((Object)this.dfac.univariate(0)));
            this.c = (GenSolvablePolynomial)this.c.abs();
            BigQuaternion bigQuaternion = this.cfac.random(this.kl);
            if (this.c.isZERO() || bigQuaternion.isZERO()) continue;
            this.a = this.a.multiply((BigQuaternion)((Object)this.c)).multiplyLeft(bigQuaternion);
            this.b = this.b.multiply((BigQuaternion)((Object)this.c)).multiplyLeft(bigQuaternion);
            GCDcoFactors<BigQuaternion> gCDcoFactors = this.fd.rightLeftBaseGcd(this.a, this.b);
            GCDLeftRightTest.assertTrue((String)"cont.isGCD() ", (boolean)gCDcoFactors.isGCD());
        }
    }

    public void testBaseIntegralLeftGcd() {
        String[] stringArray = new String[]{"x"};
        this.cfac = new BigQuaternionRing(true);
        this.syz = new SolvableSyzygySeq<BigQuaternion>(this.cfac);
        this.dfac = new GenSolvablePolynomialRing<BigQuaternion>(this.cfac, 1, this.to, stringArray);
        this.fd = new GreatestCommonDivisorLR<BigQuaternion>(this.cfac, this.syz);
        for (int i = 0; i < 1; ++i) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + i, this.el + 1, this.q);
            this.b = this.dfac.random(this.kl * (i + 1), this.ll + i, this.el + 1, this.q);
            this.c = this.dfac.random(this.kl * (i + 1), this.ll + 1, this.el + 0, this.q);
            this.c = this.c.multiply((BigQuaternion)((Object)this.dfac.univariate(0)));
            BigQuaternion bigQuaternion = this.cfac.random(this.kl);
            this.c = this.c.multiplyLeft((RingElem)bigQuaternion);
            if (this.c.isZERO() || bigQuaternion.isZERO()) continue;
            this.a = this.c.multiply((BigQuaternion)((Object)this.a));
            this.b = this.c.multiply((BigQuaternion)((Object)this.b));
            this.d = this.fd.leftBaseGcd(this.a, this.b);
            this.e = FDUtil.rightBaseSparsePseudoRemainder(this.a, this.d);
            GCDLeftRightTest.assertTrue((String)"e == 0 ", (boolean)this.e.isZERO());
            this.f = FDUtil.rightBaseSparsePseudoRemainder(this.b, this.d);
            GCDLeftRightTest.assertTrue((String)"f == 0 ", (boolean)this.f.isZERO());
        }
    }

    public void testBaseIntegralRightGcd() {
        String[] stringArray = new String[]{"x"};
        this.cfac = new BigQuaternionRing(true);
        this.syz = new SolvableSyzygySeq<BigQuaternion>(this.cfac);
        this.dfac = new GenSolvablePolynomialRing<BigQuaternion>(this.cfac, 1, this.to, stringArray);
        this.fd = new GreatestCommonDivisorLR<BigQuaternion>(this.cfac, this.syz);
        for (int i = 0; i < 1; ++i) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + i, this.el + 1, this.q);
            this.b = this.dfac.random(this.kl * (i + 1), this.ll + i, this.el + 1, this.q);
            this.c = this.dfac.random(this.kl * (i + 1), this.ll + 1, this.el + 0, this.q);
            this.c = this.c.multiply((BigQuaternion)((Object)this.dfac.univariate(0)));
            BigQuaternion bigQuaternion = this.cfac.random(this.kl);
            this.c = this.c.multiply((RingElem)bigQuaternion);
            if (this.c.isZERO() || bigQuaternion.isZERO()) continue;
            this.a = this.a.multiply((BigQuaternion)((Object)this.c));
            this.b = this.a.multiply((BigQuaternion)((Object)this.c));
            this.d = this.fd.rightBaseGcd(this.a, this.b);
            this.e = FDUtil.leftBaseSparsePseudoRemainder(this.a, this.d);
            GCDLeftRightTest.assertTrue((String)"e == 0 ", (boolean)this.e.isZERO());
            this.f = FDUtil.leftBaseSparsePseudoRemainder(this.b, this.d);
            GCDLeftRightTest.assertTrue((String)"f == 0 ", (boolean)this.f.isZERO());
        }
    }

    public void testBaseQR() {
        String[] stringArray = new String[]{"x"};
        this.cfac = new BigQuaternionRing(true);
        this.syz = new SolvableSyzygySeq<BigQuaternion>(this.cfac);
        this.dfac = new GenSolvablePolynomialRing<BigQuaternion>(this.cfac, 1, this.to, stringArray);
        this.fd = new GreatestCommonDivisorLR<BigQuaternion>(this.cfac, this.syz);
        GreatestCommonDivisorSimple<BigQuaternion> greatestCommonDivisorSimple = new GreatestCommonDivisorSimple<BigQuaternion>(this.cfac);
        for (int i = 0; i < 1; ++i) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + 1, this.el + 2, this.q);
            this.b = this.dfac.random(this.kl * (i + 1), this.ll + 1, this.el + 2, this.q);
            this.c = this.dfac.random(this.kl * (i + 1), this.ll + 1, this.el + 1, this.q);
            this.c = this.c.multiply((BigQuaternion)((Object)this.dfac.univariate(0)));
            this.c = (GenSolvablePolynomial)this.c.abs();
            if (this.c.isZERO()) continue;
            this.a = this.a.multiply((BigQuaternion)((Object)this.c));
            this.b = this.b.multiply((BigQuaternion)((Object)this.c));
            GenSolvablePolynomial<BigQuaternion>[] genSolvablePolynomialArray = FDUtil.leftBasePseudoQuotientRemainder(this.a, this.c);
            GenSolvablePolynomial<BigQuaternion>[] genSolvablePolynomialArray2 = FDUtil.leftBasePseudoQuotientRemainder(this.b, this.c);
            this.d = genSolvablePolynomialArray[0];
            this.e = genSolvablePolynomialArray2[0];
            GCDLeftRightTest.assertTrue((String)"a rem == 0: ", (boolean)genSolvablePolynomialArray[1].isZERO());
            GCDLeftRightTest.assertTrue((String)"b rem == 0: ", (boolean)genSolvablePolynomialArray2[1].isZERO());
            this.f = this.d.multiply((BigQuaternion)((Object)this.c));
            boolean bl = this.f.equals(this.a);
            BigQuaternion bigQuaternion = (BigQuaternion)this.a.leadingBaseCoefficient();
            BigQuaternion bigQuaternion2 = (BigQuaternion)this.f.leadingBaseCoefficient();
            GcdRingElem[] gcdRingElemArray = this.fd.leftOreCond(bigQuaternion, bigQuaternion2);
            BigQuaternion bigQuaternion3 = (BigQuaternion)gcdRingElemArray[0];
            BigQuaternion bigQuaternion4 = (BigQuaternion)gcdRingElemArray[1];
            this.a = this.a.multiplyLeft((RingElem)bigQuaternion3);
            this.f = this.f.multiplyLeft((RingElem)bigQuaternion4);
            bl = this.f.equals(this.a);
            GCDLeftRightTest.assertTrue((String)"d*c == a: ", (boolean)bl);
            this.g = this.e.multiply((BigQuaternion)((Object)this.c));
            bl = this.g.equals(this.b);
            if (!bl) {
                // empty if block
            }
            GCDLeftRightTest.assertTrue((String)"e*c == b: ", (boolean)true);
            this.r = (GenSolvablePolynomial)greatestCommonDivisorSimple.leftBasePrimitivePart(this.b).abs();
            this.s = (GenSolvablePolynomial)greatestCommonDivisorSimple.leftBasePrimitivePart(this.g).abs();
            GCDLeftRightTest.assertEquals((String)"pp(b) == pp(g): ", this.r, this.s);
            bigQuaternion = (BigQuaternion)this.b.leadingBaseCoefficient();
            bigQuaternion2 = (BigQuaternion)this.g.leadingBaseCoefficient();
            gcdRingElemArray = this.fd.leftOreCond(bigQuaternion, bigQuaternion2);
            bigQuaternion3 = (BigQuaternion)gcdRingElemArray[0];
            bigQuaternion4 = (BigQuaternion)gcdRingElemArray[1];
            this.b = this.b.multiplyLeft((RingElem)bigQuaternion3);
            this.g = this.g.multiplyLeft((RingElem)bigQuaternion4);
            bl = this.g.equals(this.b);
            GCDLeftRightTest.assertTrue((String)"e*c == b: ", (boolean)bl);
        }
    }

    public void testBaseIntegralDivision() {
        String[] stringArray = new String[]{"x"};
        this.cfac = new BigQuaternionRing(true);
        this.syz = new SolvableSyzygySeq<BigQuaternion>(this.cfac);
        this.dfac = new GenSolvablePolynomialRing<BigQuaternion>(this.cfac, 1, this.to, stringArray);
        this.fd = new GreatestCommonDivisorLR<BigQuaternion>(this.cfac, this.syz);
        for (int i = 0; i < 1; ++i) {
            Object object;
            BigQuaternion bigQuaternion;
            GcdRingElem[] gcdRingElemArray;
            RingElem ringElem;
            RingElem ringElem2;
            RingElem ringElem3;
            GenSolvablePolynomial<BigQuaternion>[] genSolvablePolynomialArray;
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + i, this.el + 1, this.q);
            this.b = this.dfac.random(this.kl * (i + 1), this.ll + i, this.el + 1, this.q);
            this.c = this.dfac.random(this.kl * (i + 1), this.ll + 1, this.el + 0, this.q);
            this.c = this.c.multiply((BigQuaternion)((Object)this.dfac.univariate(0)));
            BigQuaternion bigQuaternion2 = this.cfac.random(this.kl);
            this.c = this.c.multiplyLeft((RingElem)bigQuaternion2);
            if (this.c.isZERO() || bigQuaternion2.isZERO()) continue;
            this.s = this.b;
            this.r = this.a;
            while (!this.r.isZERO()) {
                genSolvablePolynomialArray = FDUtil.rightBasePseudoQuotientRemainder(this.s, this.r);
                ringElem3 = genSolvablePolynomialArray[0];
                ringElem2 = genSolvablePolynomialArray[1];
                ringElem = (GenSolvablePolynomial)this.r.multiply((BigQuaternion)ringElem3).sum((GenSolvablePolynomial<BigQuaternion>)ringElem2);
                gcdRingElemArray = (GcdRingElem[])ringElem.leadingBaseCoefficient();
                bigQuaternion = (BigQuaternion)this.s.leadingBaseCoefficient();
                object = this.fd.rightOreCond((GcdRingElem)gcdRingElemArray, bigQuaternion);
                ringElem = ringElem.multiply((BigQuaternion)object[0]);
                this.s = this.s.multiply((RingElem)((BigQuaternion)object[1]));
                GCDLeftRightTest.assertEquals((String)"z * oz == s * os: ", (Object)ringElem, this.s);
                this.s = this.r;
                this.r = ringElem2;
            }
            this.g = this.s;
            genSolvablePolynomialArray = FDUtil.rightBasePseudoQuotientRemainder(this.a, this.g);
            this.d = genSolvablePolynomialArray[0];
            this.h = (GenSolvablePolynomial)this.g.multiply((BigQuaternion)((Object)this.d)).sum(genSolvablePolynomialArray[1]);
            ringElem2 = (BigQuaternion)this.h.leadingBaseCoefficient();
            ringElem3 = (BigQuaternion)this.a.leadingBaseCoefficient();
            gcdRingElemArray = this.fd.rightOreCond((GcdRingElem)ringElem2, (GcdRingElem)ringElem3);
            this.h = this.h.multiply((RingElem)((BigQuaternion)gcdRingElemArray[0]));
            this.s = this.a.multiply((RingElem)((BigQuaternion)gcdRingElemArray[1]));
            GCDLeftRightTest.assertEquals((String)"h * oh == a * oa: ", this.h, this.s);
            genSolvablePolynomialArray = FDUtil.rightBasePseudoQuotientRemainder(this.b, this.g);
            this.e = genSolvablePolynomialArray[0];
            this.h = (GenSolvablePolynomial)this.g.multiply((BigQuaternion)((Object)this.e)).sum(genSolvablePolynomialArray[1]);
            ringElem2 = (BigQuaternion)this.h.leadingBaseCoefficient();
            ringElem = (BigQuaternion)this.b.leadingBaseCoefficient();
            gcdRingElemArray = this.fd.rightOreCond((GcdRingElem)ringElem2, (GcdRingElem)ringElem);
            this.h = this.h.multiply((RingElem)((BigQuaternion)gcdRingElemArray[0]));
            this.s = this.b.multiply((RingElem)((BigQuaternion)gcdRingElemArray[1]));
            GCDLeftRightTest.assertEquals((String)"h * oh == a * oa: ", this.h, this.s);
            this.f = this.g.multiply((BigQuaternion)((Object)this.d));
            this.g = this.g.multiply((BigQuaternion)((Object)this.e));
            ringElem3 = (BigQuaternion)this.a.leadingBaseCoefficient();
            ringElem = (BigQuaternion)this.b.leadingBaseCoefficient();
            bigQuaternion = (BigQuaternion)this.f.leadingBaseCoefficient();
            object = (BigQuaternion)this.g.leadingBaseCoefficient();
            gcdRingElemArray = this.fd.rightOreCond((GcdRingElem)ringElem3, bigQuaternion);
            this.r = this.a.multiply((RingElem)((BigQuaternion)gcdRingElemArray[0]));
            this.s = this.f.multiply((RingElem)((BigQuaternion)gcdRingElemArray[1]));
            GCDLeftRightTest.assertEquals((String)"a * oa == f * of: ", this.r, this.s);
            gcdRingElemArray = this.fd.rightOreCond((GcdRingElem)ringElem, (GcdRingElem)object);
            this.r = this.b.multiply((RingElem)((BigQuaternion)gcdRingElemArray[0]));
            this.s = this.g.multiply((RingElem)((BigQuaternion)gcdRingElemArray[1]));
            GCDLeftRightTest.assertEquals((String)"b * ob == g * og: ", this.r, this.s);
        }
    }
}

