/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.fd;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.fd.GreatestCommonDivisorAbstract;
import edu.jas.fd.GreatestCommonDivisorPrimitive;
import edu.jas.fd.GreatestCommonDivisorSimple;
import edu.jas.fd.SGCDFactory;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.poly.TermOrderByName;
import edu.jas.structure.MonoidElem;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SGCDFactoryTest
extends TestCase {
    TermOrder to = TermOrderByName.INVLEX;
    GenSolvablePolynomialRing<BigInteger> dfac;
    GenSolvablePolynomialRing<BigInteger> cfac;
    GenSolvablePolynomialRing<GenPolynomial<BigInteger>> rfac;
    BigInteger ai;
    BigInteger bi;
    BigInteger ci;
    BigInteger di;
    BigInteger ei;
    GenSolvablePolynomial<BigInteger> a;
    GenSolvablePolynomial<BigInteger> b;
    GenSolvablePolynomial<BigInteger> c;
    GenSolvablePolynomial<BigInteger> d;
    GenSolvablePolynomial<BigInteger> e;
    GenSolvablePolynomial<GenPolynomial<BigInteger>> ar;
    GenSolvablePolynomial<GenPolynomial<BigInteger>> br;
    GenSolvablePolynomial<GenPolynomial<BigInteger>> cr;
    GenSolvablePolynomial<GenPolynomial<BigInteger>> dr;
    GenSolvablePolynomial<GenPolynomial<BigInteger>> er;
    int rl = 5;
    int kl = 4;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SGCDFactoryTest.suite());
    }

    public SGCDFactoryTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SGCDFactoryTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.dfac = new GenSolvablePolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to);
        this.cfac = new GenSolvablePolynomialRing<BigInteger>(new BigInteger(1L), this.rl - 1, this.to);
        this.rfac = new GenSolvablePolynomialRing<BigInteger>(this.cfac, 1, this.to);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
    }

    public void testBigInteger() {
        BigInteger bigInteger = new BigInteger();
        GreatestCommonDivisorAbstract<BigInteger> greatestCommonDivisorAbstract = SGCDFactory.getImplementation(bigInteger);
        SGCDFactoryTest.assertTrue((String)("ufd = Primitive " + greatestCommonDivisorAbstract), (boolean)(greatestCommonDivisorAbstract instanceof GreatestCommonDivisorPrimitive));
    }

    public void testModInteger() {
        ModIntegerRing modIntegerRing = new ModIntegerRing(19L, true);
        GreatestCommonDivisorAbstract<ModInteger> greatestCommonDivisorAbstract = SGCDFactory.getImplementation(modIntegerRing);
        SGCDFactoryTest.assertTrue((String)("ufd = Simple " + greatestCommonDivisorAbstract), (boolean)(greatestCommonDivisorAbstract instanceof GreatestCommonDivisorSimple));
        modIntegerRing = new ModIntegerRing(30L);
        greatestCommonDivisorAbstract = SGCDFactory.getImplementation(modIntegerRing);
        SGCDFactoryTest.assertTrue((String)("ufd = Primitive " + greatestCommonDivisorAbstract), (boolean)(greatestCommonDivisorAbstract instanceof GreatestCommonDivisorPrimitive));
    }

    public void testBigRational() {
        BigRational bigRational = new BigRational();
        GreatestCommonDivisorAbstract<BigRational> greatestCommonDivisorAbstract = SGCDFactory.getImplementation(bigRational);
        SGCDFactoryTest.assertTrue((String)("ufd = Primitive " + greatestCommonDivisorAbstract), (boolean)(greatestCommonDivisorAbstract instanceof GreatestCommonDivisorPrimitive));
    }

    public void testBigComplex() {
        BigComplex bigComplex = new BigComplex();
        GreatestCommonDivisorAbstract<BigComplex> greatestCommonDivisorAbstract = SGCDFactory.getImplementation(bigComplex);
        SGCDFactoryTest.assertTrue((String)("ufd = Simple " + greatestCommonDivisorAbstract), (boolean)(greatestCommonDivisorAbstract instanceof GreatestCommonDivisorSimple));
    }

    public void testAlgebraicNumberBigRational() {
        BigRational bigRational = new BigRational();
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 1);
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        while (genPolynomial.isZERO() || genPolynomial.isONE() || genPolynomial.isConstant()) {
            genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        }
        AlgebraicNumberRing<BigRational> algebraicNumberRing = new AlgebraicNumberRing<BigRational>(genPolynomial);
        GreatestCommonDivisorAbstract<BigRational> greatestCommonDivisorAbstract = SGCDFactory.getImplementation(algebraicNumberRing);
        SGCDFactoryTest.assertTrue((String)("ufd = Primitive " + greatestCommonDivisorAbstract), (boolean)(greatestCommonDivisorAbstract instanceof GreatestCommonDivisorPrimitive));
        genPolynomial = genPolynomialRing.univariate(0).subtract((BigRational)genPolynomialRing.getONE());
        algebraicNumberRing = new AlgebraicNumberRing<BigRational>(genPolynomial, true);
        greatestCommonDivisorAbstract = SGCDFactory.getImplementation(algebraicNumberRing);
        SGCDFactoryTest.assertTrue((String)("ufd = Simple " + greatestCommonDivisorAbstract), (boolean)(greatestCommonDivisorAbstract instanceof GreatestCommonDivisorSimple));
    }

    public void testAlgebraicNumberModInteger() {
        ModIntegerRing modIntegerRing = new ModIntegerRing(19L, true);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1);
        GenPolynomial<ModInteger> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        while (genPolynomial.isZERO() || genPolynomial.isONE() || genPolynomial.isConstant()) {
            genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        }
        AlgebraicNumberRing<ModInteger> algebraicNumberRing = new AlgebraicNumberRing<ModInteger>(genPolynomial);
        MonoidElem monoidElem = algebraicNumberRing.getONE();
        SGCDFactoryTest.assertTrue((String)("a == 1 " + monoidElem), (boolean)((AlgebraicNumber)monoidElem).isONE());
        GreatestCommonDivisorAbstract<ModInteger> greatestCommonDivisorAbstract = SGCDFactory.getImplementation(algebraicNumberRing);
        SGCDFactoryTest.assertTrue((String)("ufd = Primitive " + greatestCommonDivisorAbstract), (boolean)(greatestCommonDivisorAbstract instanceof GreatestCommonDivisorPrimitive));
        genPolynomial = genPolynomialRing.univariate(0).subtract((ModInteger)genPolynomialRing.getONE());
        algebraicNumberRing = new AlgebraicNumberRing<ModInteger>(genPolynomial, true);
        greatestCommonDivisorAbstract = SGCDFactory.getImplementation(algebraicNumberRing);
        SGCDFactoryTest.assertTrue((String)("ufd = Simple " + greatestCommonDivisorAbstract), (boolean)(greatestCommonDivisorAbstract instanceof GreatestCommonDivisorSimple));
    }
}

