/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.CriticalPair;
import edu.jas.gb.CriticalPairComparator;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CriticalPairList<C extends RingElem<C>>
extends OrderedPairlist<C> {
    protected final SortedSet<CriticalPair<C>> pairlist;
    protected int recordCount;
    private static final Logger logger = LogManager.getLogger(CriticalPairList.class);

    public CriticalPairList() {
        this.pairlist = null;
    }

    public CriticalPairList(GenPolynomialRing<C> genPolynomialRing) {
        this(0, genPolynomialRing);
    }

    public CriticalPairList(int n, GenPolynomialRing<C> genPolynomialRing) {
        super(n, genPolynomialRing);
        CriticalPairComparator criticalPairComparator = new CriticalPairComparator(this.ring.tord);
        this.pairlist = new TreeSet(criticalPairComparator);
        this.recordCount = 0;
    }

    @Override
    public PairList<C> create(GenPolynomialRing<C> genPolynomialRing) {
        return new CriticalPairList<C>(genPolynomialRing);
    }

    @Override
    public PairList<C> create(int n, GenPolynomialRing<C> genPolynomialRing) {
        return new CriticalPairList<C>(n, genPolynomialRing);
    }

    @Override
    public synchronized int put(GenPolynomial<C> genPolynomial) {
        ++this.putCount;
        if (this.oneInGB) {
            return this.P.size() - 1;
        }
        ExpVector expVector = genPolynomial.leadingExpVector();
        int n = this.P.size();
        for (int i = 0; i < n; ++i) {
            GenPolynomial genPolynomial2 = (GenPolynomial)this.P.get(i);
            ExpVector expVector2 = genPolynomial2.leadingExpVector();
            if (this.moduleVars > 0 && !this.reduction.moduleCriterion(this.moduleVars, expVector, expVector2)) continue;
            ExpVector expVector3 = expVector.lcm(expVector2);
            CriticalPair<C> criticalPair = new CriticalPair<C>(expVector3, genPolynomial2, genPolynomial, i, n);
            this.pairlist.add(criticalPair);
        }
        this.P.add(genPolynomial);
        BitSet bitSet = new BitSet();
        bitSet.set(0, n);
        this.red.add(bitSet);
        if (this.recordCount < n) {
            this.recordCount = n;
        }
        return n;
    }

    @Override
    public synchronized boolean hasNext() {
        return this.pairlist.size() > 0;
    }

    @Override
    public Pair<C> removeNext() {
        CriticalPair<C> criticalPair = this.getNext();
        if (criticalPair == null) {
            return null;
        }
        return new Pair(criticalPair.pi, criticalPair.pj, criticalPair.i, criticalPair.j);
    }

    public synchronized CriticalPair<C> getNext() {
        if (this.oneInGB) {
            return null;
        }
        CriticalPair criticalPair = null;
        Iterator iterator = this.pairlist.iterator();
        boolean bl = false;
        while (!bl && iterator.hasNext()) {
            criticalPair = (CriticalPair)iterator.next();
            if (criticalPair.getInReduction() || criticalPair.getReductum() != null) continue;
            if (logger.isInfoEnabled()) {
                logger.info("" + criticalPair);
            }
            if (bl = this.useCriterion4 ? this.reduction.criterion4(criticalPair.pi, criticalPair.pj, criticalPair.e) : true) {
                bl = this.criterion3(criticalPair.i, criticalPair.j, criticalPair.e);
            }
            ((BitSet)this.red.get(criticalPair.j)).clear(criticalPair.i);
            if (bl) continue;
            criticalPair.setReductum(this.ring.getZERO());
        }
        if (!bl) {
            criticalPair = null;
        } else {
            ++this.remCount;
            criticalPair.setInReduction();
        }
        return criticalPair;
    }

    public int record(CriticalPair<C> criticalPair, GenPolynomial<C> abelianGroupElem) {
        if (abelianGroupElem == null) {
            abelianGroupElem = this.ring.getZERO();
        }
        criticalPair.setReductum((GenPolynomial<C>)abelianGroupElem);
        if (!((GenPolynomial)abelianGroupElem).isZERO() && !((GenPolynomial)abelianGroupElem).isONE()) {
            ++this.recordCount;
            return this.recordCount;
        }
        return -1;
    }

    public int update(CriticalPair<C> criticalPair, GenPolynomial<C> abelianGroupElem) {
        int n;
        if (abelianGroupElem == null) {
            abelianGroupElem = this.ring.getZERO();
        }
        criticalPair.setReductum((GenPolynomial<C>)abelianGroupElem);
        if (!((GenPolynomial)abelianGroupElem).isZERO() && !((GenPolynomial)abelianGroupElem).isONE()) {
            ++this.recordCount;
        }
        if ((n = this.update()) < 0) {
            System.out.println("c < 0");
        }
        if (!((GenPolynomial)abelianGroupElem).isZERO() && !((GenPolynomial)abelianGroupElem).isONE()) {
            return this.recordCount;
        }
        return -1;
    }

    public synchronized int update() {
        CriticalPair<C> criticalPair;
        GenPolynomial<C> genPolynomial;
        int n = 0;
        if (this.oneInGB) {
            return n;
        }
        while (this.pairlist.size() > 0 && (genPolynomial = (criticalPair = this.pairlist.first()).getReductum()) != null) {
            this.pairlist.remove(criticalPair);
            ++n;
            if (genPolynomial.isZERO()) continue;
            if (genPolynomial.isONE()) {
                this.putOne();
                continue;
            }
            this.put(genPolynomial);
        }
        return n;
    }

    public synchronized List<CriticalPair<C>> inWork() {
        ArrayList<CriticalPair<C>> arrayList = new ArrayList<CriticalPair<C>>();
        if (this.oneInGB) {
            return arrayList;
        }
        for (CriticalPair criticalPair : this.pairlist) {
            if (!criticalPair.getInReduction()) continue;
            arrayList.add(criticalPair);
        }
        return arrayList;
    }

    public synchronized int updateMany() {
        CriticalPair criticalPair2;
        int n = 0;
        if (this.oneInGB) {
            return n;
        }
        ArrayList<CriticalPair> arrayList = new ArrayList<CriticalPair>();
        Iterator iterator = this.pairlist.iterator();
        while (iterator.hasNext() && (criticalPair2 = (CriticalPair)iterator.next()).getReductum() != null) {
            arrayList.add(criticalPair2);
            ++n;
        }
        for (CriticalPair criticalPair2 : arrayList) {
            this.pairlist.remove(criticalPair2);
            GenPolynomial genPolynomial = criticalPair2.getReductum();
            if (genPolynomial.isZERO()) continue;
            if (genPolynomial.isONE()) {
                this.putOne();
                continue;
            }
            this.put(genPolynomial);
        }
        return n;
    }

    @Override
    public synchronized int putOne() {
        super.putOne();
        this.pairlist.clear();
        return 0;
    }
}

